/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.sysml.utils.Crc32c;
import org.tensorflow.framework.Summary;
import org.tensorflow.util.Event;

public class TensorboardLogger {
    private static Crc32c crc32 = new Crc32c();

    public static void writeScalar(String logDir, String tag, long step, float value) {
        String filePath = logDir + File.separator + "tfevents.event_systemml_scalar";
        try {
            FileOutputStream outputStream = new FileOutputStream(filePath, true);
            Event event = Event.newBuilder().setWallTime((double)System.currentTimeMillis() / 1000.0).setStep(step).setSummary(Summary.newBuilder().addValue(Summary.Value.newBuilder().setTag(tag).setSimpleValue(value)).build()).build();
            byte[] eventString = event.toByteArray();
            byte[] header = TensorboardLogger.reverse(Longs.toByteArray((long)eventString.length));
            TensorboardLogger.write(outputStream, header);
            TensorboardLogger.write(outputStream, eventString);
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing event in tensorboard directory:" + filePath, e);
        }
    }

    private static void write(FileOutputStream outputStream, byte[] byteString) throws IOException {
        outputStream.write(byteString);
        outputStream.write(TensorboardLogger.reverse(Ints.toByteArray((int)((int)TensorboardLogger.maskedCRC32(byteString)))));
    }

    private static byte[] reverse(byte[] nums) {
        byte[] reversed = new byte[nums.length];
        for (int i = 0; i < nums.length; ++i) {
            reversed[i] = nums[nums.length - 1 - i];
        }
        return reversed;
    }

    private static long maskedCRC32(byte[] data) {
        crc32.reset();
        crc32.update(data, 0, data.length);
        long x = TensorboardLogger.u32(crc32.getValue());
        return TensorboardLogger.u32((x >> 15 | TensorboardLogger.u32(x << 17)) + -1568478504L);
    }

    private static long u32(long x) {
        return x & 0xFFFFFFFFFFFFFFFFL;
    }
}

