/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.ReblockMR;
import org.apache.sysml.runtime.matrix.WriteCSVMR;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.CSVAssignRowIDMapper;
import org.apache.sysml.runtime.matrix.mapred.CSVAssignRowIDReducer;
import org.apache.sysml.runtime.matrix.mapred.CSVReblockMapper;
import org.apache.sysml.runtime.matrix.mapred.CSVReblockReducer;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.MapReduceTool;

public class CSVReblockMR {
    public static final String NUM_ROWS_IN_MATRIX = "num.rows.in.matrix.";
    public static final String NUM_COLS_IN_MATRIX = "num.cols.in.matrix.";
    public static final String ROWID_FILE_NAME = "rowid.file.name";
    public static final String SMALLEST_FILE_NAME_PER_INPUT = "smallest.file.name.per.input";
    public static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    private CSVReblockMR() {
    }

    public static String findSmallestFile(JobConf job, String inputPath) throws FileNotFoundException, IOException {
        String smallestFile = null;
        Path p = new Path(inputPath);
        FileSystem fs = p.getFileSystem((Configuration)job);
        if (!fs.isDirectory(p)) {
            smallestFile = p.makeQualified(fs).toString();
        } else {
            FileStatus[] stats = fs.listStatus(p, hiddenFileFilter);
            if (stats.length == 0) {
                smallestFile = "";
            } else {
                smallestFile = stats[0].getPath().toString();
                for (int j = 1; j < stats.length; ++j) {
                    String f = stats[j].getPath().toString();
                    if (f.compareTo(smallestFile) >= 0) continue;
                    smallestFile = f;
                }
            }
        }
        return smallestFile;
    }

    public static JobReturn runJob(MRJobInstruction inst, String[] inputs, InputInfo[] inputInfos, long[] rlens, long[] clens, int[] brlens, int[] bclens, String reblockInstructions, String otherInstructionsInReducer, int numReducers, int replication, byte[] resultIndexes, String[] outputs, OutputInfo[] outputInfos) throws Exception {
        int i;
        String[] smallestFiles = new String[inputs.length];
        JobConf job = new JobConf();
        for (i = 0; i < inputs.length; ++i) {
            smallestFiles[i] = CSVReblockMR.findSmallestFile(job, inputs[i]);
        }
        for (i = 0; i < inputs.length; ++i) {
            Path p = new Path(inputs[i]);
            FileSystem fs = p.getFileSystem((Configuration)job);
            if (!fs.isDirectory(p)) {
                smallestFiles[i] = p.makeQualified(fs).toString();
                continue;
            }
            FileStatus[] stats = fs.listStatus(p, hiddenFileFilter);
            if (stats.length == 0) {
                smallestFiles[i] = "";
                continue;
            }
            smallestFiles[i] = stats[0].getPath().toString();
            for (int j = 1; j < stats.length; ++j) {
                String f = stats[j].getPath().toString();
                if (f.compareTo(smallestFiles[i]) >= 0) continue;
                smallestFiles[i] = f;
            }
        }
        AssignRowIDMRReturn ret1 = CSVReblockMR.runAssignRowIDMRJob(inputs, inputInfos, brlens, bclens, reblockInstructions, replication, smallestFiles);
        for (int i2 = 0; i2 < rlens.length; ++i2) {
            if ((rlens[i2] <= 0L || rlens[i2] == ret1.rlens[i2]) && (clens[i2] <= 0L || clens[i2] == ret1.clens[i2])) continue;
            throw new RuntimeException("Dimension doesn't mach for input matrix " + i2 + ", expected (" + rlens[i2] + ", " + clens[i2] + ") but real (" + ret1.rlens[i2] + ", " + ret1.clens[i2] + ")");
        }
        JobReturn ret = CSVReblockMR.runCSVReblockJob(null, inputs, inputInfos, ret1.rlens, ret1.clens, brlens, bclens, reblockInstructions, otherInstructionsInReducer, numReducers, replication, resultIndexes, outputs, outputInfos, ret1.counterFile, smallestFiles);
        return ret;
    }

    public static AssignRowIDMRReturn runAssignRowIDMRJob(String[] inputs, InputInfo[] inputInfos, int[] brlens, int[] bclens, String reblockInstructions, int replication, String[] smallestFiles) throws Exception {
        AssignRowIDMRReturn ret = new AssignRowIDMRReturn();
        JobConf job = new JobConf(CSVReblockMR.class);
        job.setJobName("Assign-RowID-MR");
        byte[] realIndexes = new byte[inputs.length];
        for (int b = 0; b < realIndexes.length; b = (int)((byte)(b + 1))) {
            realIndexes[b] = b;
        }
        MRJobConfiguration.setUpMultipleInputs(job, realIndexes, inputs, inputInfos, brlens, bclens, false, MRJobConfiguration.ConvertTarget.CELL);
        job.setStrings(SMALLEST_FILE_NAME_PER_INPUT, smallestFiles);
        MRJobConfiguration.setCSVReblockInstructions(job, reblockInstructions);
        job.setInt("dfs.replication", replication);
        DMLConfig config = ConfigurationManager.getDMLConfig();
        MRJobConfiguration.setupCustomMRConfigurations(job, config);
        job.setNumReduceTasks(1);
        job.setMapperClass(CSVAssignRowIDMapper.class);
        job.setMapOutputKeyClass(ByteWritable.class);
        job.setMapOutputValueClass(OffsetCount.class);
        job.setReducerClass(CSVAssignRowIDReducer.class);
        job.setBoolean("adaptivemr.map.enable", false);
        MRJobConfiguration.setUniqueWorkingDir(job);
        ret.counterFile = new Path(MRJobConfiguration.constructTempOutputFilename());
        job.setOutputFormat(SequenceFileOutputFormat.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)ret.counterFile);
        job.setOutputKeyClass(ByteWritable.class);
        job.setOutputValueClass(OffsetCount.class);
        RunningJob runjob = JobClient.runJob((JobConf)job);
        Counters.Group rgroup = runjob.getCounters().getGroup(NUM_ROWS_IN_MATRIX);
        Counters.Group cgroup = runjob.getCounters().getGroup(NUM_COLS_IN_MATRIX);
        ret.rlens = new long[inputs.length];
        ret.clens = new long[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            ret.rlens[i] = rgroup.getCounter(Integer.toString(i));
            ret.clens[i] = cgroup.getCounter(Integer.toString(i));
        }
        return ret;
    }

    private static JobReturn runCSVReblockJob(MRJobInstruction inst, String[] inputs, InputInfo[] inputInfos, long[] rlens, long[] clens, int[] brlens, int[] bclens, String reblockInstructions, String otherInstructionsInReducer, int numReducers, int replication, byte[] resultIndexes, String[] outputs, OutputInfo[] outputInfos, Path counterFile, String[] smallestFiles) throws Exception {
        JobConf job = new JobConf(ReblockMR.class);
        job.setJobName("CSV-Reblock-MR");
        byte[] realIndexes = new byte[inputs.length];
        for (int b = 0; b < realIndexes.length; b = (int)((byte)(b + 1))) {
            realIndexes[b] = b;
        }
        MRJobConfiguration.setUpMultipleInputs(job, realIndexes, inputs, inputInfos, brlens, bclens, false, MRJobConfiguration.ConvertTarget.CELL);
        job.setStrings(SMALLEST_FILE_NAME_PER_INPUT, smallestFiles);
        MRJobConfiguration.setMatricesDimensions(job, realIndexes, rlens, clens);
        MRJobConfiguration.setBlocksSizes(job, realIndexes, brlens, bclens);
        MRJobConfiguration.setCSVReblockInstructions(job, reblockInstructions);
        MRJobConfiguration.setInstructionsInReducer(job, otherInstructionsInReducer);
        job.setInt("dfs.replication", replication);
        MRJobConfiguration.addBinaryBlockSerializationFramework((Configuration)job);
        DMLConfig config = ConfigurationManager.getDMLConfig();
        MRJobConfiguration.setupCustomMRConfigurations(job, config);
        HashSet<Byte> mapoutputIndexes = MRJobConfiguration.setUpOutputIndexesForMapper(job, realIndexes, null, reblockInstructions, null, otherInstructionsInReducer, resultIndexes);
        MRJobConfiguration.MatrixChar_N_ReducerGroups ret = MRJobConfiguration.computeMatrixCharacteristics(job, realIndexes, null, reblockInstructions, null, null, otherInstructionsInReducer, resultIndexes, mapoutputIndexes, false);
        MatrixCharacteristics[] stats = ret.stats;
        int numRed = WriteCSVMR.determineNumReducers(rlens, clens, config.getIntValue("numreducers"), ret.numReducerGroups);
        job.setNumReduceTasks(numRed);
        byte[] resultDimsUnknown = new byte[resultIndexes.length];
        for (int i = 0; i < resultIndexes.length; ++i) {
            resultDimsUnknown[i] = stats[i].getRows() == -1L || stats[i].getCols() == -1L ? (byte)1 : 0;
        }
        MRJobConfiguration.setUpMultipleOutputs(job, resultIndexes, resultDimsUnknown, outputs, outputInfos, true, true);
        job.setMapperClass(CSVReblockMapper.class);
        job.setMapOutputKeyClass(TaggedFirstSecondIndexes.class);
        job.setMapOutputValueClass(BlockRow.class);
        job.setReducerClass(CSVReblockReducer.class);
        job.setBoolean("adaptivemr.map.enable", false);
        MRJobConfiguration.setUniqueWorkingDir(job);
        Path cachefile = new Path(counterFile, "part-00000");
        DistributedCache.addCacheFile((URI)cachefile.toUri(), (Configuration)job);
        DistributedCache.createSymlink((Configuration)job);
        job.set(ROWID_FILE_NAME, cachefile.toString());
        RunningJob runjob = JobClient.runJob((JobConf)job);
        MapReduceTool.deleteFileIfExistOnHDFS(counterFile, job);
        Counters.Group group = runjob.getCounters().getGroup("nonzeros");
        for (int i = 0; i < resultIndexes.length; ++i) {
            stats[i].setNonZeros(group.getCounter(Integer.toString(i)));
        }
        return new JobReturn(stats, outputInfos, runjob.isSuccessful());
    }

    public static class AssignRowIDMRReturn {
        public Path counterFile = null;
        public long[] rlens = null;
        public long[] clens = null;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.counterFile.toString());
            sb.append("\n");
            for (long rlen : this.rlens) {
                sb.append(rlen);
                sb.append(", ");
            }
            sb.append("\n");
            for (long clen : this.clens) {
                sb.append(clen);
                sb.append(", ");
            }
            return sb.toString();
        }
    }

    public static class BlockRow
    implements Writable {
        public int indexInBlock = 0;
        public MatrixBlock data = null;

        public void readFields(DataInput in) throws IOException {
            this.indexInBlock = in.readInt();
            if (this.data == null) {
                this.data = new MatrixBlock();
            }
            this.data.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.indexInBlock);
            this.data.write(out);
        }
    }

    public static class OffsetCount
    implements WritableComparable {
        public String filename;
        public long fileOffset;
        public long count;

        public OffsetCount() {
            this.filename = "";
            this.fileOffset = 0L;
            this.count = 0L;
        }

        public OffsetCount(String fname, long off, long cnt) {
            this.filename = fname;
            this.fileOffset = off;
            this.count = cnt;
        }

        public OffsetCount(OffsetCount that) {
            this.filename = that.filename;
            this.fileOffset = that.fileOffset;
            this.count = that.count;
        }

        public void readFields(DataInput in) throws IOException {
            this.filename = in.readLine();
            this.fileOffset = in.readLong();
            this.count = in.readLong();
        }

        public void write(DataOutput out) throws IOException {
            out.writeBytes(this.filename + '\n');
            out.writeLong(this.fileOffset);
            out.writeLong(this.count);
        }

        public String toString() {
            return this.filename + ", " + this.fileOffset + ", " + this.count;
        }

        public int compareTo(OffsetCount that) {
            int ret = this.filename.compareTo(that.filename);
            if (ret != 0) {
                return ret;
            }
            if (this.fileOffset < that.fileOffset) {
                return -1;
            }
            if (this.fileOffset > that.fileOffset) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Object o) {
            if (!(o instanceof OffsetCount)) {
                return -1;
            }
            return this.compareTo((OffsetCount)o);
        }

        public boolean equals(Object o) {
            if (!(o instanceof OffsetCount)) {
                return false;
            }
            OffsetCount that = (OffsetCount)o;
            return this.filename.equals(that.filename) && this.fileOffset == that.fileOffset;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode() should never be called on instances of this class.");
        }
    }
}

