/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.FrameReader;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.util.FastStringTokenizer;
import org.apache.sysml.runtime.util.UtilFunctions;

public class FrameReaderTextCell
extends FrameReader {
    @Override
    public final FrameBlock readFrameFromHDFS(String fname, Expression.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        Expression.ValueType[] lschema = FrameReaderTextCell.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderTextCell.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderTextCell.createOutputFrameBlock(lschema, lnames, rlen);
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FrameReaderTextCell.checkValidInputFile(fs, path);
        this.readTextCellFrameFromHDFS(path, job, fs, ret, lschema, lnames, rlen, clen);
        return ret;
    }

    @Override
    public final FrameBlock readFrameFromInputStream(InputStream is, Expression.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        Expression.ValueType[] lschema = FrameReaderTextCell.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderTextCell.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderTextCell.createOutputFrameBlock(lschema, lnames, rlen);
        this.readRawTextCellFrameFromInputStream(is, ret, lschema, lnames, rlen, clen);
        return ret;
    }

    protected void readTextCellFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Expression.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        if (fs.isDirectory(path)) {
            InputSplit[] splits;
            FileInputFormat.addInputPath((JobConf)job, (Path)path);
            TextInputFormat informat = new TextInputFormat();
            informat.configure(job);
            for (InputSplit split : splits = informat.getSplits(job, 1)) {
                this.readTextCellFrameFromInputSplit(split, informat, job, dest);
            }
        } else {
            this.readRawTextCellFrameFromHDFS(path, job, fs, dest, schema, names, rlen, clen);
        }
    }

    protected final void readTextCellFrameFromInputSplit(InputSplit split, TextInputFormat informat, JobConf job, FrameBlock dest) throws IOException {
        Expression.ValueType[] schema = dest.getSchema();
        int rlen = dest.getNumRows();
        int clen = dest.getNumColumns();
        RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
        LongWritable key = new LongWritable();
        Text value = new Text();
        FastStringTokenizer st = new FastStringTokenizer(' ');
        int row = -1;
        int col = -1;
        try {
            while (reader.next((Object)key, (Object)value)) {
                st.reset(value.toString());
                row = st.nextInt() - 1;
                col = st.nextInt() - 1;
                if (row == -3) {
                    dest.getColumnMetadata(col).setMvValue(st.nextToken());
                    continue;
                }
                if (row == -2) {
                    dest.getColumnMetadata(col).setNumDistinct(st.nextLong());
                    continue;
                }
                dest.set(row, col, UtilFunctions.stringToObject(schema[col], st.nextToken()));
            }
        }
        catch (Exception ex) {
            if (row < 0 || row + 1 > rlen || col < 0 || col + 1 > clen) {
                throw new IOException("Frame cell [" + (row + 1) + "," + (col + 1) + "] out of overall frame range [1:" + rlen + ",1:" + clen + "].");
            }
            throw new IOException("Unable to read frame in text cell format.", ex);
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
    }

    protected final void readRawTextCellFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Expression.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        FSDataInputStream inputStream = fs.open(path);
        this.readRawTextCellFrameFromInputStream((InputStream)inputStream, dest, schema, names, rlen, clen);
    }

    protected final void readRawTextCellFrameFromInputStream(InputStream is, FrameBlock dest, Expression.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String value = null;
        FastStringTokenizer st = new FastStringTokenizer(' ');
        int row = -1;
        int col = -1;
        try {
            while ((value = br.readLine()) != null) {
                st.reset(value);
                row = st.nextInt() - 1;
                col = st.nextInt() - 1;
                if (row == -3) {
                    dest.getColumnMetadata(col).setMvValue(st.nextToken());
                    continue;
                }
                if (row == -2) {
                    dest.getColumnMetadata(col).setNumDistinct(st.nextLong());
                    continue;
                }
                dest.set(row, col, UtilFunctions.stringToObject(schema[col], st.nextToken()));
            }
        }
        catch (Exception ex) {
            if (row < 0 || (long)(row + 1) > rlen || col < 0 || (long)(col + 1) > clen) {
                throw new IOException("Frame cell [" + (row + 1) + "," + (col + 1) + "] out of overall frame range [1:" + rlen + ",1:" + clen + "].", ex);
            }
            throw new IOException("Unable to read frame in raw text cell format.", ex);
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }
}

