/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cpfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.util.Cell;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysml.runtime.controlprogram.parfor.util.StagingFileUtils;
import org.apache.sysml.runtime.functionobjects.ParameterizedBuiltin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixWriter;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;
import org.apache.sysml.runtime.util.FastStringTokenizer;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;

public class ParameterizedBuiltinCPFileInstruction
extends ParameterizedBuiltinCPInstruction {
    private ParameterizedBuiltinCPFileInstruction(Operator op, HashMap<String, String> paramsMap, CPOperand out, String opcode, String istr) {
        super(op, paramsMap, out, opcode, istr);
    }

    public static ParameterizedBuiltinCPFileInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand out = new CPOperand(parts[parts.length - 1]);
        HashMap<String, String> paramsMap = ParameterizedBuiltinCPFileInstruction.constructParameterMap(parts);
        ParameterizedBuiltin func = null;
        if (opcode.equalsIgnoreCase("rmempty")) {
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode);
            return new ParameterizedBuiltinCPFileInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        throw new DMLRuntimeException("Unknown opcode (" + opcode + ") for ParameterizedBuiltin Instruction.");
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String opcode = this.getOpcode();
        if (!opcode.equalsIgnoreCase("rmempty")) {
            throw new DMLRuntimeException("Unknown opcode : " + opcode);
        }
        MatrixObject src = ec.getMatrixObject((String)this.params.get("target"));
        MatrixObject out = ec.getMatrixObject(this.output.getName());
        String margin = (String)this.params.get("margin");
        src.exportData();
        RemoveEmpty rm = new RemoveEmpty(margin, src, out);
        out = rm.execute();
        ec.setVariable(this.output.getName(), out);
    }

    public static class RemoveEmpty {
        private String _margin = null;
        private MatrixObject _src = null;
        private MatrixObject _out = null;

        public RemoveEmpty(String margin, MatrixObject src, MatrixObject out) {
            this._margin = margin;
            this._src = src;
            this._out = out;
        }

        public MatrixObject execute() throws DMLRuntimeException {
            String fnameOld = this._src.getFileName();
            String fnameNew = this._out.getFileName();
            InputInfo ii = ((MatrixFormatMetaData)this._src.getMetaData()).getInputInfo();
            MatrixCharacteristics mc = this._src.getMatrixCharacteristics();
            String stagingDir = LocalFileUtils.getUniqueWorkingDir("work");
            LocalFileUtils.createLocalFileIfNotExist(stagingDir);
            long ret = -1L;
            try {
                boolean diagBlocks = false;
                if (ii == InputInfo.TextCellInputInfo) {
                    this.createTextCellStagingFile(fnameOld, stagingDir);
                } else if (ii == InputInfo.BinaryCellInputInfo) {
                    this.createBinaryCellStagingFile(fnameOld, stagingDir);
                } else if (ii == InputInfo.BinaryBlockInputInfo) {
                    diagBlocks = this.createBinaryBlockStagingFile(fnameOld, stagingDir);
                }
                ret = diagBlocks ? this.createKeyMappingDiag(stagingDir, mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), ii) : this.createKeyMapping(stagingDir, mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), ii);
                MapReduceTool.deleteFileIfExistOnHDFS(fnameNew);
                if (ii == InputInfo.TextCellInputInfo || ii == InputInfo.BinaryCellInputInfo) {
                    this.createCellResultFile(fnameNew, stagingDir, mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), ii);
                } else if (ii == InputInfo.BinaryBlockInputInfo) {
                    if (diagBlocks) {
                        this.createBlockResultFileDiag(fnameNew, stagingDir, mc.getRows(), mc.getCols(), ret, mc.getNonZeros(), mc.getRowsPerBlock(), mc.getColsPerBlock(), ii);
                    } else {
                        this.createBlockResultFile(fnameNew, stagingDir, mc.getRows(), mc.getCols(), ret, mc.getNonZeros(), mc.getRowsPerBlock(), mc.getColsPerBlock(), ii);
                    }
                }
            }
            catch (IOException ioe) {
                throw new DMLRuntimeException(ioe);
            }
            LocalFileUtils.cleanupWorkingDirectory(stagingDir);
            if (this._margin.equals("rows")) {
                return this.createNewOutputObject(this._src, this._out, ret, mc.getCols());
            }
            return this.createNewOutputObject(this._src, this._out, mc.getRows(), ret);
        }

        private MatrixObject createNewOutputObject(MatrixObject src, MatrixObject out, long rows, long cols) throws DMLRuntimeException {
            String varName = out.getVarName();
            String fName = out.getFileName();
            Expression.ValueType vt = src.getValueType();
            MatrixFormatMetaData metadata = (MatrixFormatMetaData)src.getMetaData();
            MatrixObject moNew = new MatrixObject(vt, fName);
            moNew.setVarName(varName);
            moNew.setDataType(Expression.DataType.MATRIX);
            if (rows == 0L || cols == 0L) {
                rows = Math.max(rows, 1L);
                cols = Math.max(cols, 1L);
                try {
                    moNew.acquireModify(new MatrixBlock((int)rows, (int)cols, true));
                    moNew.release();
                }
                catch (CacheException e) {
                    throw new DMLRuntimeException(e);
                }
            }
            MatrixCharacteristics mcOld = metadata.getMatrixCharacteristics();
            OutputInfo oiOld = metadata.getOutputInfo();
            InputInfo iiOld = metadata.getInputInfo();
            MatrixCharacteristics mc = new MatrixCharacteristics(rows, cols, mcOld.getRowsPerBlock(), mcOld.getColsPerBlock(), mcOld.getNonZeros());
            MatrixFormatMetaData meta = new MatrixFormatMetaData(mc, oiOld, iiOld);
            moNew.setMetaData(meta);
            return moNew;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createTextCellStagingFile(String fnameOld, String stagingDir) throws IOException, DMLRuntimeException {
            Path path = new Path(fnameOld);
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            if (!fs.exists(path)) {
                throw new IOException("File " + fnameOld + " does not exist on HDFS.");
            }
            FileInputFormat.addInputPath((JobConf)job, (Path)path);
            TextInputFormat informat = new TextInputFormat();
            informat.configure(job);
            InputSplit[] splits = informat.getSplits(job, 1);
            LinkedList<Cell> buffer = new LinkedList<Cell>();
            LongWritable key = new LongWritable();
            Text value = new Text();
            FastStringTokenizer st = new FastStringTokenizer(' ');
            for (InputSplit split : splits) {
                RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
                try {
                    while (reader.next((Object)key, (Object)value)) {
                        st.reset(value.toString());
                        long row = st.nextLong();
                        long col = st.nextLong();
                        double lvalue = st.nextDouble();
                        buffer.add(new Cell(row, col, lvalue));
                        if (buffer.size() <= 100000) continue;
                        this.appendCellBufferToStagingArea(stagingDir, buffer, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
                        buffer.clear();
                    }
                    if (buffer.isEmpty()) continue;
                    this.appendCellBufferToStagingArea(stagingDir, buffer, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
                    buffer.clear();
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createBinaryCellStagingFile(String fnameOld, String stagingDir) throws IOException, DMLRuntimeException {
            Path path = new Path(fnameOld);
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            if (!fs.exists(path)) {
                throw new IOException("File " + fnameOld + " does not exist on HDFS.");
            }
            LinkedList<Cell> buffer = new LinkedList<Cell>();
            MatrixIndexes key = new MatrixIndexes();
            MatrixCell value = new MatrixCell();
            for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
                SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)job);
                try {
                    while (reader.next((Writable)key, (Writable)value)) {
                        long row = key.getRowIndex();
                        long col = key.getColumnIndex();
                        double lvalue = value.getValue();
                        buffer.add(new Cell(row, col, lvalue));
                        if (buffer.size() <= 100000) continue;
                        this.appendCellBufferToStagingArea(stagingDir, buffer, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
                        buffer.clear();
                    }
                    if (buffer.isEmpty()) continue;
                    this.appendCellBufferToStagingArea(stagingDir, buffer, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
                    buffer.clear();
                }
                finally {
                    IOUtilFunctions.closeSilently((Closeable)reader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean createBinaryBlockStagingFile(String fnameOld, String stagingDir) throws IOException, DMLRuntimeException {
            Path path = new Path(fnameOld);
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            if (!fs.exists(path)) {
                throw new IOException("File " + fnameOld + " does not exist on HDFS.");
            }
            MatrixIndexes key = new MatrixIndexes();
            MatrixBlock value = new MatrixBlock();
            boolean diagBlocks = true;
            for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
                SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)job);
                try {
                    while (reader.next((Writable)key, (Writable)value)) {
                        if (value.isEmptyBlock()) continue;
                        String fname = stagingDir + "/" + key.getRowIndex() + "_" + key.getColumnIndex();
                        LocalFileUtils.writeMatrixBlockToLocal(fname, value);
                        diagBlocks &= key.getRowIndex() == key.getColumnIndex();
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently((Closeable)reader);
                }
            }
            return diagBlocks;
        }

        private void appendCellBufferToStagingArea(String dir, LinkedList<Cell> buffer, int brlen, int bclen) throws DMLRuntimeException, IOException {
            HashMap sortedBuffer = new HashMap();
            String key = null;
            for (Cell cell : buffer) {
                key = cell.getRow() / (long)brlen + 1L + "_" + (cell.getCol() / (long)bclen + 1L);
                if (!sortedBuffer.containsKey(key)) {
                    sortedBuffer.put(key, new LinkedList());
                }
                ((LinkedList)sortedBuffer.get(key)).addLast(cell);
            }
            for (Map.Entry entry : sortedBuffer.entrySet()) {
                String pfname = dir + "/" + (String)entry.getKey();
                StagingFileUtils.writeCellListToLocal(pfname, (LinkedList)entry.getValue());
            }
        }

        private long createKeyMapping(String stagingDir, long rlen, long clen, int brlen, int bclen, InputInfo ii) throws FileNotFoundException, IOException, DMLRuntimeException {
            String metaOut = stagingDir + "/meta";
            long len = 0L;
            long lastKey = 0L;
            if (this._margin.equals("rows")) {
                for (int blockRow = 0; blockRow < (int)Math.ceil((double)rlen / (double)brlen); ++blockRow) {
                    boolean[] flags = new boolean[brlen];
                    for (int k = 0; k < brlen; ++k) {
                        flags[k] = true;
                    }
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)clen / (double)bclen); ++blockCol) {
                        Serializable buffer;
                        String fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockCol + 1);
                        if (ii == InputInfo.BinaryBlockInputInfo) {
                            if (!LocalFileUtils.isExisting(fname)) continue;
                            buffer = LocalFileUtils.readMatrixBlockFromLocal(fname);
                            for (int i = 0; i < ((MatrixBlock)buffer).getNumRows(); ++i) {
                                for (int j = 0; j < ((MatrixBlock)buffer).getNumColumns(); ++j) {
                                    double lvalue = ((MatrixBlock)buffer).quickGetValue(i, j);
                                    if (lvalue == 0.0) continue;
                                    flags[i] = false;
                                }
                            }
                            continue;
                        }
                        buffer = StagingFileUtils.readCellListFromLocal(fname);
                        Iterator i = ((AbstractSequentialList)((Object)buffer)).iterator();
                        while (i.hasNext()) {
                            Cell c = (Cell)i.next();
                            flags[(int)c.getRow() - blockRow * brlen - 1] = false;
                        }
                    }
                    LinkedList<long[]> keyMapping = new LinkedList<long[]>();
                    for (int i = 0; i < flags.length; ++i) {
                        if (flags[i]) continue;
                        keyMapping.add(new long[]{blockRow * brlen + i, lastKey++});
                    }
                    len += (long)keyMapping.size();
                    StagingFileUtils.writeKeyMappingToLocal(metaOut, (long[][])keyMapping.toArray((T[])new long[0][0]));
                }
            } else {
                for (int blockCol = 0; blockCol < (int)Math.ceil((double)clen / (double)bclen); ++blockCol) {
                    boolean[] flags = new boolean[bclen];
                    for (int k = 0; k < bclen; ++k) {
                        flags[k] = true;
                    }
                    for (int blockRow = 0; blockRow < (int)Math.ceil((double)rlen / (double)brlen); ++blockRow) {
                        Serializable buffer;
                        String fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockCol + 1);
                        if (ii == InputInfo.BinaryBlockInputInfo) {
                            if (!LocalFileUtils.isExisting(fname)) continue;
                            buffer = LocalFileUtils.readMatrixBlockFromLocal(fname);
                            for (int i = 0; i < ((MatrixBlock)buffer).getNumRows(); ++i) {
                                for (int j = 0; j < ((MatrixBlock)buffer).getNumColumns(); ++j) {
                                    double lvalue = ((MatrixBlock)buffer).quickGetValue(i, j);
                                    if (lvalue == 0.0) continue;
                                    flags[j] = false;
                                }
                            }
                            continue;
                        }
                        buffer = StagingFileUtils.readCellListFromLocal(fname);
                        Iterator iterator = ((AbstractSequentialList)((Object)buffer)).iterator();
                        while (iterator.hasNext()) {
                            Cell c = (Cell)iterator.next();
                            flags[(int)c.getCol() - blockCol * bclen - 1] = false;
                        }
                    }
                    LinkedList<long[]> keyMapping = new LinkedList<long[]>();
                    for (int i = 0; i < flags.length; ++i) {
                        if (flags[i]) continue;
                        keyMapping.add(new long[]{blockCol * bclen + i, lastKey++});
                    }
                    len += (long)keyMapping.size();
                    StagingFileUtils.writeKeyMappingToLocal(metaOut, (long[][])keyMapping.toArray((T[])new long[0][0]));
                }
            }
            if (len <= 0L) {
                throw new DMLRuntimeException("Matrices with dimensions [0,0] not supported.");
            }
            return len;
        }

        private long createKeyMappingDiag(String stagingDir, long rlen, long clen, int brlen, int bclen, InputInfo ii) throws FileNotFoundException, IOException, DMLRuntimeException {
            String metaOut = stagingDir + "/meta";
            long len = 0L;
            long lastKey = 0L;
            if (this._margin.equals("rows")) {
                for (int blockRow = 0; blockRow < (int)Math.ceil((double)rlen / (double)brlen); ++blockRow) {
                    int i2;
                    Serializable buffer;
                    boolean[] flags = new boolean[brlen];
                    for (int k = 0; k < brlen; ++k) {
                        flags[k] = true;
                    }
                    String fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockRow + 1);
                    if (ii == InputInfo.BinaryBlockInputInfo) {
                        if (!LocalFileUtils.isExisting(fname)) continue;
                        buffer = LocalFileUtils.readMatrixBlockFromLocal(fname);
                        for (i2 = 0; i2 < ((MatrixBlock)buffer).getNumRows(); ++i2) {
                            for (int j = 0; j < ((MatrixBlock)buffer).getNumColumns(); ++j) {
                                double lvalue = ((MatrixBlock)buffer).quickGetValue(i2, j);
                                if (lvalue == 0.0) continue;
                                flags[i2] = false;
                            }
                        }
                    } else {
                        buffer = StagingFileUtils.readCellListFromLocal(fname);
                        Iterator i2 = ((AbstractSequentialList)((Object)buffer)).iterator();
                        while (i2.hasNext()) {
                            Cell c = (Cell)i2.next();
                            flags[(int)c.getRow() - blockRow * brlen - 1] = false;
                        }
                    }
                    LinkedList<long[]> keyMapping = new LinkedList<long[]>();
                    for (i2 = 0; i2 < flags.length; ++i2) {
                        if (flags[i2]) continue;
                        keyMapping.add(new long[]{blockRow * brlen + i2, lastKey++});
                    }
                    len += (long)keyMapping.size();
                    StagingFileUtils.writeKeyMappingToLocal(metaOut, (long[][])keyMapping.toArray((T[])new long[0][0]));
                }
            } else {
                for (int blockCol = 0; blockCol < (int)Math.ceil((double)clen / (double)bclen); ++blockCol) {
                    int i3;
                    Serializable buffer;
                    boolean[] flags = new boolean[bclen];
                    for (int k = 0; k < bclen; ++k) {
                        flags[k] = true;
                    }
                    String fname = stagingDir + "/" + (blockCol + 1) + "_" + (blockCol + 1);
                    if (ii == InputInfo.BinaryBlockInputInfo) {
                        if (!LocalFileUtils.isExisting(fname)) continue;
                        buffer = LocalFileUtils.readMatrixBlockFromLocal(fname);
                        for (i3 = 0; i3 < ((MatrixBlock)buffer).getNumRows(); ++i3) {
                            for (int j = 0; j < ((MatrixBlock)buffer).getNumColumns(); ++j) {
                                double lvalue = ((MatrixBlock)buffer).quickGetValue(i3, j);
                                if (lvalue == 0.0) continue;
                                flags[j] = false;
                            }
                        }
                    } else {
                        buffer = StagingFileUtils.readCellListFromLocal(fname);
                        Iterator i3 = ((AbstractSequentialList)((Object)buffer)).iterator();
                        while (i3.hasNext()) {
                            Cell c = (Cell)i3.next();
                            flags[(int)c.getCol() - blockCol * bclen - 1] = false;
                        }
                    }
                    LinkedList<long[]> keyMapping = new LinkedList<long[]>();
                    for (i3 = 0; i3 < flags.length; ++i3) {
                        if (flags[i3]) continue;
                        keyMapping.add(new long[]{blockCol * bclen + i3, lastKey++});
                    }
                    len += (long)keyMapping.size();
                    StagingFileUtils.writeKeyMappingToLocal(metaOut, (long[][])keyMapping.toArray((T[])new long[0][0]));
                }
            }
            if (len <= 0L) {
                throw new DMLRuntimeException("Matrices with dimensions [0,0] not supported.");
            }
            return len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createCellResultFile(String fnameNew, String stagingDir, long rlen, long clen, int brlen, int bclen, InputInfo ii) throws IOException, DMLRuntimeException {
            block18: {
                JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
                Path path = new Path(fnameNew);
                FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
                String metaOut = stagingDir + "/meta";
                BufferedWriter twriter = null;
                SequenceFile.Writer bwriter = null;
                if (ii == InputInfo.TextCellInputInfo) {
                    twriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
                } else if (ii == InputInfo.BinaryCellInputInfo) {
                    bwriter = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixCell.class);
                } else {
                    throw new DMLRuntimeException("Unsupported cell input info: " + InputInfo.inputInfoToString(ii));
                }
                StringBuilder sb = new StringBuilder();
                MatrixIndexes key = new MatrixIndexes();
                MatrixCell value = new MatrixCell();
                HashMap<Integer, HashMap<Long, Long>> keyMap = new HashMap<Integer, HashMap<Long, Long>>();
                BufferedReader fkeyMap = StagingFileUtils.openKeyMap(metaOut);
                try {
                    if (this._margin.equals("rows")) {
                        for (int blockRow = 0; blockRow < (int)Math.ceil((double)rlen / (double)brlen); ++blockRow) {
                            StagingFileUtils.nextKeyMap(fkeyMap, keyMap, blockRow, brlen);
                            for (int blockCol = 0; blockCol < (int)Math.ceil((double)clen / (double)bclen); ++blockCol) {
                                String fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockCol + 1);
                                LinkedList<Cell> buffer = StagingFileUtils.readCellListFromLocal(fname);
                                if (ii == InputInfo.TextCellInputInfo) {
                                    for (Cell c : buffer) {
                                        sb.append(keyMap.get(blockRow).get(c.getRow() - 1L) + 1L);
                                        sb.append(' ');
                                        sb.append(c.getCol());
                                        sb.append(' ');
                                        sb.append(c.getValue());
                                        sb.append('\n');
                                        twriter.write(sb.toString());
                                        sb.setLength(0);
                                    }
                                    continue;
                                }
                                if (ii != InputInfo.BinaryCellInputInfo) continue;
                                for (Cell c : buffer) {
                                    key.setIndexes(keyMap.get(blockRow).get(c.getRow() - 1L) + 1L, c.getCol());
                                    value.setValue(c.getValue());
                                    bwriter.append((Writable)key, (Writable)value);
                                }
                            }
                            keyMap.remove(blockRow);
                        }
                        break block18;
                    }
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)clen / (double)bclen); ++blockCol) {
                        StagingFileUtils.nextKeyMap(fkeyMap, keyMap, blockCol, bclen);
                        for (int blockRow = 0; blockRow < (int)Math.ceil((double)rlen / (double)brlen); ++blockRow) {
                            String fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockCol + 1);
                            LinkedList<Cell> buffer = StagingFileUtils.readCellListFromLocal(fname);
                            if (ii == InputInfo.TextCellInputInfo) {
                                for (Cell c : buffer) {
                                    sb.append(c.getRow());
                                    sb.append(' ');
                                    sb.append(keyMap.get(blockCol).get(c.getCol() - 1L) + 1L);
                                    sb.append(' ');
                                    sb.append(c.getValue());
                                    sb.append('\n');
                                    twriter.write(sb.toString());
                                    sb.setLength(0);
                                }
                                continue;
                            }
                            if (ii != InputInfo.BinaryCellInputInfo) continue;
                            for (Cell c : buffer) {
                                key.setIndexes(c.getRow(), keyMap.get(blockCol).get(c.getCol() - 1L) + 1L);
                                value.setValue(c.getValue());
                                bwriter.append((Writable)key, (Writable)value);
                            }
                        }
                        keyMap.remove(blockCol);
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently(fkeyMap);
                    IOUtilFunctions.closeSilently(twriter);
                    IOUtilFunctions.closeSilently((Closeable)bwriter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createBlockResultFile(String fnameNew, String stagingDir, long rlen, long clen, long newlen, long nnz, int brlen, int bclen, InputInfo ii) throws IOException, DMLRuntimeException {
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            Path path = new Path(fnameNew);
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            String metaOut = stagingDir + "/meta";
            SequenceFile.Writer writer = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
            MatrixIndexes key = new MatrixIndexes();
            try {
                if (this._margin.equals("rows")) {
                    MatrixBlock[] blocks = MatrixWriter.createMatrixBlocksForReuse(newlen, clen, brlen, bclen, MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz), nnz);
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)clen / (double)bclen); ++blockCol) {
                        HashMap<Integer, HashMap<Long, Long>> keyMap = new HashMap<Integer, HashMap<Long, Long>>();
                        BufferedReader fkeyMap = StagingFileUtils.openKeyMap(metaOut);
                        int maxCol = (int)((long)blockCol * (long)bclen + (long)bclen < clen ? (long)bclen : clen - (long)blockCol * (long)bclen);
                        int blockRowOut = 0;
                        int currentSize = -1;
                        while ((currentSize = StagingFileUtils.nextSizedKeyMap(fkeyMap, keyMap, brlen, brlen)) > 0) {
                            int maxRow = currentSize;
                            MatrixBlock block = MatrixWriter.getMatrixBlockForReuse(blocks, maxRow, maxCol, brlen, bclen);
                            block.reset(maxRow, maxCol);
                            int rowPos = 0;
                            for (int blockRow = Collections.min(keyMap.keySet()).intValue(); blockRow < (int)Math.ceil((double)rlen / (double)brlen) && rowPos < brlen; ++blockRow) {
                                if (keyMap.containsKey(blockRow)) {
                                    String fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockCol + 1);
                                    if (LocalFileUtils.isExisting(fname)) {
                                        MatrixBlock tmp = LocalFileUtils.readMatrixBlockFromLocal(fname);
                                        HashMap<Long, Long> lkeyMap = keyMap.get(blockRow);
                                        long row_offset = (long)blockRow * (long)brlen;
                                        for (int i = 0; i < tmp.getNumRows(); ++i) {
                                            if (!lkeyMap.containsKey(row_offset + (long)i)) continue;
                                            for (int j = 0; j < tmp.getNumColumns(); ++j) {
                                                double lvalue = tmp.quickGetValue(i, j);
                                                if (lvalue == 0.0) continue;
                                                block.quickSetValue(rowPos, j, lvalue);
                                            }
                                            ++rowPos;
                                        }
                                    } else {
                                        HashMap<Long, Long> lkeyMap = keyMap.get(blockRow);
                                        rowPos += lkeyMap.size();
                                    }
                                }
                                keyMap.remove(blockRow);
                            }
                            key.setIndexes(blockRowOut + 1, blockCol + 1);
                            writer.append((Writable)key, (Writable)block);
                            ++blockRowOut;
                        }
                        IOUtilFunctions.closeSilently(fkeyMap);
                    }
                } else {
                    MatrixBlock[] blocks = MatrixWriter.createMatrixBlocksForReuse(rlen, newlen, brlen, bclen, MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz), nnz);
                    for (int blockRow = 0; blockRow < (int)Math.ceil((double)rlen / (double)brlen); ++blockRow) {
                        HashMap<Integer, HashMap<Long, Long>> keyMap = new HashMap<Integer, HashMap<Long, Long>>();
                        BufferedReader fkeyMap = StagingFileUtils.openKeyMap(metaOut);
                        int maxRow = (int)((long)blockRow * (long)brlen + (long)brlen < rlen ? (long)brlen : rlen - (long)blockRow * (long)brlen);
                        int blockColOut = 0;
                        int currentSize = -1;
                        while ((currentSize = StagingFileUtils.nextSizedKeyMap(fkeyMap, keyMap, bclen, bclen)) > 0) {
                            int maxCol = currentSize;
                            MatrixBlock block = MatrixWriter.getMatrixBlockForReuse(blocks, maxRow, maxCol, brlen, bclen);
                            block.reset(maxRow, maxCol);
                            int colPos = 0;
                            for (int blockCol = Collections.min(keyMap.keySet()).intValue(); blockCol < (int)Math.ceil((double)clen / (double)bclen) && colPos < bclen; ++blockCol) {
                                if (keyMap.containsKey(blockCol)) {
                                    String fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockCol + 1);
                                    if (LocalFileUtils.isExisting(fname)) {
                                        MatrixBlock tmp = LocalFileUtils.readMatrixBlockFromLocal(fname);
                                        HashMap<Long, Long> lkeyMap = keyMap.get(blockCol);
                                        long col_offset = blockCol * bclen;
                                        for (int j = 0; j < tmp.getNumColumns(); ++j) {
                                            if (!lkeyMap.containsKey(col_offset + (long)j)) continue;
                                            for (int i = 0; i < tmp.getNumRows(); ++i) {
                                                double lvalue = tmp.quickGetValue(i, j);
                                                if (lvalue == 0.0) continue;
                                                block.quickSetValue(i, colPos, lvalue);
                                            }
                                            ++colPos;
                                        }
                                    } else {
                                        HashMap<Long, Long> lkeyMap = keyMap.get(blockCol);
                                        colPos += lkeyMap.size();
                                    }
                                }
                                keyMap.remove(blockCol);
                            }
                            key.setIndexes(blockRow + 1, blockColOut + 1);
                            writer.append((Writable)key, (Writable)block);
                            ++blockColOut;
                        }
                        IOUtilFunctions.closeSilently(fkeyMap);
                    }
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)writer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createBlockResultFileDiag(String fnameNew, String stagingDir, long rlen, long clen, long newlen, long nnz, int brlen, int bclen, InputInfo ii) throws IOException, DMLRuntimeException {
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            Path path = new Path(fnameNew);
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            String metaOut = stagingDir + "/meta";
            SequenceFile.Writer writer = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
            MatrixIndexes key = new MatrixIndexes();
            HashSet<Long> writtenBlocks = new HashSet<Long>();
            try {
                int maxRow;
                double lvalue;
                HashMap<Long, Long> lkeyMap;
                MatrixBlock tmp;
                String fname;
                MatrixBlock block;
                int currentSize;
                BufferedReader fkeyMap;
                HashMap<Integer, HashMap<Long, Long>> keyMap;
                MatrixBlock[] blocks;
                if (this._margin.equals("rows")) {
                    blocks = MatrixWriter.createMatrixBlocksForReuse(newlen, clen, brlen, bclen, MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz), nnz);
                    keyMap = new HashMap<Integer, HashMap<Long, Long>>();
                    fkeyMap = StagingFileUtils.openKeyMap(metaOut);
                    currentSize = -1;
                    int blockRowOut = 0;
                    block3: while ((currentSize = StagingFileUtils.nextSizedKeyMap(fkeyMap, keyMap, brlen, brlen)) > 0) {
                        int rowPos = 0;
                        int maxRow2 = currentSize;
                        for (int blockRow = Collections.min(keyMap.keySet()).intValue(); blockRow < (int)Math.ceil((double)rlen / (double)brlen); ++blockRow) {
                            int blockCol = blockRow;
                            int maxCol = (int)((long)blockCol * (long)bclen + (long)bclen < clen ? (long)bclen : clen - (long)blockCol * (long)bclen);
                            block = MatrixWriter.getMatrixBlockForReuse(blocks, maxRow2, maxCol, brlen, bclen);
                            block.reset(maxRow2, maxCol);
                            if (keyMap.containsKey(blockRow)) {
                                fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockCol + 1);
                                tmp = LocalFileUtils.readMatrixBlockFromLocal(fname);
                                lkeyMap = keyMap.get(blockRow);
                                long row_offset = blockRow * brlen;
                                for (int i = 0; i < tmp.getNumRows(); ++i) {
                                    if (!lkeyMap.containsKey(row_offset + (long)i)) continue;
                                    for (int j = 0; j < tmp.getNumColumns(); ++j) {
                                        lvalue = tmp.quickGetValue(i, j);
                                        if (lvalue == 0.0) continue;
                                        block.quickSetValue(rowPos, j, lvalue);
                                    }
                                    ++rowPos;
                                }
                            }
                            key.setIndexes(blockRowOut + 1, blockCol + 1);
                            writer.append((Writable)key, (Writable)block);
                            writtenBlocks.add(IDHandler.concatIntIDsToLong(blockRowOut + 1, blockCol + 1));
                            if (rowPos != maxRow2) continue;
                            keyMap.remove(blockRow);
                            ++blockRowOut;
                            continue block3;
                        }
                    }
                    IOUtilFunctions.closeSilently(fkeyMap);
                } else {
                    blocks = MatrixWriter.createMatrixBlocksForReuse(rlen, newlen, brlen, bclen, MatrixBlock.evalSparseFormatInMemory(rlen, clen, nnz), nnz);
                    keyMap = new HashMap();
                    fkeyMap = StagingFileUtils.openKeyMap(metaOut);
                    currentSize = -1;
                    int blockColOut = 0;
                    block7: while ((currentSize = StagingFileUtils.nextSizedKeyMap(fkeyMap, keyMap, bclen, bclen)) > 0) {
                        int colPos = 0;
                        int maxCol = currentSize;
                        for (int blockCol = Collections.min(keyMap.keySet()).intValue(); blockCol < (int)Math.ceil((double)clen / (double)bclen); ++blockCol) {
                            int blockRow = blockCol;
                            maxRow = (int)((long)(blockRow * brlen + brlen) < rlen ? (long)brlen : rlen - (long)(blockRow * brlen));
                            block = MatrixWriter.getMatrixBlockForReuse(blocks, maxRow, maxCol, brlen, bclen);
                            block.reset(maxRow, maxCol);
                            if (keyMap.containsKey(blockCol)) {
                                fname = stagingDir + "/" + (blockRow + 1) + "_" + (blockCol + 1);
                                tmp = LocalFileUtils.readMatrixBlockFromLocal(fname);
                                lkeyMap = keyMap.get(blockCol);
                                long col_offset = blockCol * bclen;
                                for (int j = 0; j < tmp.getNumColumns(); ++j) {
                                    if (!lkeyMap.containsKey(col_offset + (long)j)) continue;
                                    for (int i = 0; i < tmp.getNumRows(); ++i) {
                                        lvalue = tmp.quickGetValue(i, j);
                                        if (lvalue == 0.0) continue;
                                        block.quickSetValue(i, colPos, lvalue);
                                    }
                                    ++colPos;
                                }
                            }
                            key.setIndexes(blockRow + 1, blockColOut + 1);
                            writer.append((Writable)key, (Writable)block);
                            writtenBlocks.add(IDHandler.concatIntIDsToLong(blockRow + 1, blockColOut + 1));
                            if (colPos != maxCol) continue;
                            keyMap.remove(blockCol);
                            ++blockColOut;
                            continue block7;
                        }
                    }
                    IOUtilFunctions.closeSilently(fkeyMap);
                }
                MatrixBlock empty = new MatrixBlock(1, 1, true);
                long rows = this._margin.equals("rows") ? newlen : rlen;
                long cols = this._margin.equals("cols") ? newlen : clen;
                int countBlk1 = (int)Math.ceil((double)rows / (double)brlen) * (int)Math.ceil((double)cols / (double)bclen);
                int countBlk2 = writtenBlocks.size();
                for (int i = 0; i < (int)Math.ceil((double)rows / (double)brlen); ++i) {
                    for (int j = 0; j < (int)Math.ceil((double)cols / (double)bclen); ++j) {
                        if (writtenBlocks.contains(IDHandler.concatIntIDsToLong(i + 1, j + 1))) continue;
                        maxRow = (int)((long)(i * brlen + brlen) < rows ? (long)brlen : rows - (long)(i * brlen));
                        int maxCol = (int)((long)(j * bclen + bclen) < cols ? (long)bclen : cols - (long)(j * bclen));
                        empty.reset(maxRow, maxCol);
                        key.setIndexes(i + 1, j + 1);
                        writer.append((Writable)key, (Writable)empty);
                        ++countBlk2;
                    }
                }
                if (countBlk1 != countBlk2) {
                    throw new DMLRuntimeException("Wrong number of written result blocks: " + countBlk1 + " vs " + countBlk2 + ".");
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)writer);
            }
        }
    }
}

