/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import java.util.HashMap;
import org.apache.sysml.lops.BinaryM;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendInstruction;
import org.apache.sysml.runtime.instructions.mr.BinUaggChainInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMInstruction;
import org.apache.sysml.runtime.instructions.mr.CM_N_COVInstruction;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.CSVWriteInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineTernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeOffsetInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeSplitInstruction;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.DataPartitionMRInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateMInstruction;
import org.apache.sysml.runtime.instructions.mr.MMTSJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.MapMultChainInstruction;
import org.apache.sysml.runtime.instructions.mr.MatrixReshapeMRInstruction;
import org.apache.sysml.runtime.instructions.mr.PMMJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ParameterizedBuiltinMRInstruction;
import org.apache.sysml.runtime.instructions.mr.PickByCountInstruction;
import org.apache.sysml.runtime.instructions.mr.PlusMultInstruction;
import org.apache.sysml.runtime.instructions.mr.QuaternaryInstruction;
import org.apache.sysml.runtime.instructions.mr.RandInstruction;
import org.apache.sysml.runtime.instructions.mr.RangeBasedReIndexInstruction;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.RemoveEmptyMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ReorgInstruction;
import org.apache.sysml.runtime.instructions.mr.ReplicateInstruction;
import org.apache.sysml.runtime.instructions.mr.ScalarInstruction;
import org.apache.sysml.runtime.instructions.mr.SeqInstruction;
import org.apache.sysml.runtime.instructions.mr.TernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.UaggOuterChainInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.ZeroOutInstruction;
import org.apache.sysml.runtime.matrix.SortMR;

public class MRInstructionParser
extends InstructionParser {
    public static HashMap<String, MRInstruction.MRINSTRUCTION_TYPE> String2MRInstructionType = new HashMap();

    public static MRInstruction parseSingleInstruction(String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        MRInstruction.MRINSTRUCTION_TYPE mrtype = InstructionUtils.getMRType(str);
        return MRInstructionParser.parseSingleInstruction(mrtype, str);
    }

    public static MRInstruction parseSingleInstruction(MRInstruction.MRINSTRUCTION_TYPE mrtype, String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (mrtype) {
            case Aggregate: {
                return AggregateInstruction.parseInstruction(str);
            }
            case ArithmeticBinary: {
                String opcode = InstructionUtils.getOpCode(str);
                String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
                String dt1 = parts[1].split("\u00b7")[1].split("\u00b7")[0];
                String dt2 = parts[2].split("\u00b7")[1].split("\u00b7")[0];
                if (dt1.equalsIgnoreCase("SCALAR") || dt2.equalsIgnoreCase("SCALAR")) {
                    return ScalarInstruction.parseInstruction(str);
                }
                if (BinaryM.isOpcode(opcode)) {
                    return BinaryMInstruction.parseInstruction(str);
                }
                return BinaryInstruction.parseInstruction(str);
            }
            case ArithmeticBinary2: {
                return PlusMultInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryInstruction.parseInstruction(str);
            }
            case AggregateUnary: {
                return AggregateUnaryInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernaryInstruction.parseInstruction(str);
            }
            case Quaternary: {
                return QuaternaryInstruction.parseInstruction(str);
            }
            case Rand: {
                return RandInstruction.parseInstruction(str);
            }
            case Seq: {
                return SeqInstruction.parseInstruction(str);
            }
            case Reblock: {
                return ReblockInstruction.parseInstruction(str);
            }
            case Append: {
                return AppendInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgInstruction.parseInstruction(str);
            }
            case Replicate: {
                return ReplicateInstruction.parseInstruction(str);
            }
            case Unary: {
                String opcode = InstructionUtils.getOpCode(str);
                String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
                if (parts.length == 4 && (opcode.equalsIgnoreCase("log") || opcode.equalsIgnoreCase("log_nz"))) {
                    return ScalarInstruction.parseInstruction(str);
                }
                return UnaryInstruction.parseInstruction(str);
            }
            case MMTSJ: {
                return MMTSJMRInstruction.parseInstruction(str);
            }
            case PMMJ: {
                return PMMJMRInstruction.parseInstruction(str);
            }
            case MapMultChain: {
                return MapMultChainInstruction.parseInstruction(str);
            }
            case BinUaggChain: {
                return BinUaggChainInstruction.parseInstruction(str);
            }
            case UaggOuterChain: {
                return UaggOuterChainInstruction.parseInstruction(str);
            }
            case CombineTernary: {
                return CombineTernaryInstruction.parseInstruction(str);
            }
            case CombineBinary: {
                return CombineBinaryInstruction.parseInstruction(str);
            }
            case CombineUnary: {
                return CombineUnaryInstruction.parseInstruction(str);
            }
            case PickByCount: {
                return PickByCountInstruction.parseInstruction(str);
            }
            case CM_N_COV: {
                return CM_N_COVInstruction.parseInstruction(str);
            }
            case GroupedAggregate: {
                return GroupedAggregateInstruction.parseInstruction(str);
            }
            case MapGroupedAggregate: {
                return GroupedAggregateMInstruction.parseInstruction(str);
            }
            case RangeReIndex: {
                return RangeBasedReIndexInstruction.parseInstruction(str);
            }
            case ZeroOut: {
                return ZeroOutInstruction.parseInstruction(str);
            }
            case MatrixReshape: {
                return MatrixReshapeMRInstruction.parseInstruction(str);
            }
            case Sort: {
                return SortMR.parseSortInstruction(str);
            }
            case CSVReblock: {
                return CSVReblockInstruction.parseInstruction(str);
            }
            case CSVWrite: {
                return CSVWriteInstruction.parseInstruction(str);
            }
            case ParameterizedBuiltin: {
                return ParameterizedBuiltinMRInstruction.parseInstruction(str);
            }
            case RemoveEmpty: {
                return RemoveEmptyMRInstruction.parseInstruction(str);
            }
            case Partition: {
                return DataPartitionMRInstruction.parseInstruction(str);
            }
            case CumsumAggregate: {
                return CumulativeAggregateInstruction.parseInstruction(str);
            }
            case CumsumSplit: {
                return CumulativeSplitInstruction.parseInstruction(str);
            }
            case CumsumOffset: {
                return CumulativeOffsetInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid MR Instruction Type: " + (Object)((Object)mrtype));
    }

    public static MRInstruction[] parseMixedInstructions(String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        Instruction[] inst = InstructionParser.parseMixedInstructions(str);
        MRInstruction[] mrinst = new MRInstruction[inst.length];
        for (int i = 0; i < inst.length; ++i) {
            mrinst[i] = (MRInstruction)inst[i];
        }
        return mrinst;
    }

    public static AggregateInstruction[] parseAggregateInstructions(String str) throws DMLRuntimeException {
        AggregateInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new AggregateInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = AggregateInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static ReblockInstruction[] parseReblockInstructions(String str) throws DMLRuntimeException {
        ReblockInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new ReblockInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = ReblockInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static CSVReblockInstruction[] parseCSVReblockInstructions(String str) throws DMLRuntimeException {
        CSVReblockInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new CSVReblockInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = CSVReblockInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static CSVWriteInstruction[] parseCSVWriteInstructions(String str) throws DMLRuntimeException {
        CSVWriteInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new CSVWriteInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = CSVWriteInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static AggregateBinaryInstruction[] parseAggregateBinaryInstructions(String str) throws DMLRuntimeException {
        AggregateBinaryInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new AggregateBinaryInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = AggregateBinaryInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static DataGenMRInstruction[] parseDataGenInstructions(String str) throws DMLRuntimeException {
        DataGenMRInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new DataGenMRInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = (DataGenMRInstruction)InstructionParser.parseSingleInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static MRInstruction[] parseCombineInstructions(String str) throws DMLRuntimeException {
        MRInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new MRInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                MRInstruction.MRINSTRUCTION_TYPE type = InstructionUtils.getMRType(strlist[i]);
                if (type == MRInstruction.MRINSTRUCTION_TYPE.CombineBinary) {
                    inst[i] = CombineBinaryInstruction.parseInstruction(strlist[i]);
                    continue;
                }
                if (type == MRInstruction.MRINSTRUCTION_TYPE.CombineTernary) {
                    inst[i] = CombineTernaryInstruction.parseInstruction(strlist[i]);
                    continue;
                }
                throw new DMLRuntimeException("unknown combine instruction: " + strlist[i]);
            }
        }
        return inst;
    }

    public static CM_N_COVInstruction[] parseCM_N_COVInstructions(String str) throws DMLRuntimeException {
        CM_N_COVInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new CM_N_COVInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = CM_N_COVInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static GroupedAggregateInstruction[] parseGroupedAggInstructions(String str) throws DMLRuntimeException {
        GroupedAggregateInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new GroupedAggregateInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = GroupedAggregateInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    static {
        String2MRInstructionType.put("a+", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("ak+", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("asqk+", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("a*", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("amax", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("amin", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("amean", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("avar", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("arimax", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("arimin", MRInstruction.MRINSTRUCTION_TYPE.Aggregate);
        String2MRInstructionType.put("cpmm", MRInstruction.MRINSTRUCTION_TYPE.AggregateBinary);
        String2MRInstructionType.put("rmm", MRInstruction.MRINSTRUCTION_TYPE.AggregateBinary);
        String2MRInstructionType.put("mapmm", MRInstruction.MRINSTRUCTION_TYPE.AggregateBinary);
        String2MRInstructionType.put("ua+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uar+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uac+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uak+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uark+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uack+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uasqk+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uarsqk+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uacsqk+", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uamean", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uarmean", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uacmean", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uavar", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uarvar", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uacvar", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("ua*", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uamax", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uamin", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uatrace", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uaktrace", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uarmax", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uarimax", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uacmax", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uarmin", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uarimin", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("uacmin", MRInstruction.MRINSTRUCTION_TYPE.AggregateUnary);
        String2MRInstructionType.put("abs", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("sin", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("cos", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("tan", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("asin", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("acos", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("atan", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("sign", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("sqrt", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("exp", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("log", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("log_nz", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("slog", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("pow", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("round", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("ceil", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("floor", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("sprop", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("sigmoid", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("sel+", MRInstruction.MRINSTRUCTION_TYPE.Unary);
        String2MRInstructionType.put("tsmm", MRInstruction.MRINSTRUCTION_TYPE.MMTSJ);
        String2MRInstructionType.put("pmm", MRInstruction.MRINSTRUCTION_TYPE.PMMJ);
        String2MRInstructionType.put("mapmmchain", MRInstruction.MRINSTRUCTION_TYPE.MapMultChain);
        String2MRInstructionType.put("binuaggchain", MRInstruction.MRINSTRUCTION_TYPE.BinUaggChain);
        String2MRInstructionType.put("+", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("-", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("s-r", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("*", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("/", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("%%", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("%/%", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("1-*", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("so", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("^", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("max", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("min", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put(">", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put(">=", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("<", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("<=", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("==", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("!=", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("^", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("^2", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("*2", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("-nz", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("+*", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary2);
        String2MRInstructionType.put("-*", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary2);
        String2MRInstructionType.put("map+", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map-", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map*", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map/", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map%%", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map%/%", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map1-*", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map^", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("mapmax", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("mapmin", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map>", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map>=", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map<", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map<=", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map==", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("map!=", MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary);
        String2MRInstructionType.put("uaggouterchain", MRInstruction.MRINSTRUCTION_TYPE.UaggOuterChain);
        String2MRInstructionType.put("r'", MRInstruction.MRINSTRUCTION_TYPE.Reorg);
        String2MRInstructionType.put("rev", MRInstruction.MRINSTRUCTION_TYPE.Reorg);
        String2MRInstructionType.put("rdiag", MRInstruction.MRINSTRUCTION_TYPE.Reorg);
        String2MRInstructionType.put("rep", MRInstruction.MRINSTRUCTION_TYPE.Replicate);
        String2MRInstructionType.put("rand", MRInstruction.MRINSTRUCTION_TYPE.Rand);
        String2MRInstructionType.put("seq", MRInstruction.MRINSTRUCTION_TYPE.Seq);
        String2MRInstructionType.put("rblk", MRInstruction.MRINSTRUCTION_TYPE.Reblock);
        String2MRInstructionType.put("csvrblk", MRInstruction.MRINSTRUCTION_TYPE.CSVReblock);
        String2MRInstructionType.put("ctabletransform", MRInstruction.MRINSTRUCTION_TYPE.Ternary);
        String2MRInstructionType.put("ctabletransformscalarweight", MRInstruction.MRINSTRUCTION_TYPE.Ternary);
        String2MRInstructionType.put("ctableexpandscalarweight", MRInstruction.MRINSTRUCTION_TYPE.Ternary);
        String2MRInstructionType.put("ctabletransformhistogram", MRInstruction.MRINSTRUCTION_TYPE.Ternary);
        String2MRInstructionType.put("ctabletransformweightedhistogram", MRInstruction.MRINSTRUCTION_TYPE.Ternary);
        String2MRInstructionType.put("mapwsloss", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("redwsloss", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("mapwsigmoid", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("redwsigmoid", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("mapwdivmm", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("redwdivmm", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("mapwcemm", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("redwcemm", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("mapwumm", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("redwumm", MRInstruction.MRINSTRUCTION_TYPE.Quaternary);
        String2MRInstructionType.put("combinebinary", MRInstruction.MRINSTRUCTION_TYPE.CombineBinary);
        String2MRInstructionType.put("combineunary", MRInstruction.MRINSTRUCTION_TYPE.CombineUnary);
        String2MRInstructionType.put("combineternary", MRInstruction.MRINSTRUCTION_TYPE.CombineTernary);
        String2MRInstructionType.put("valuepick", MRInstruction.MRINSTRUCTION_TYPE.PickByCount);
        String2MRInstructionType.put("rangepick", MRInstruction.MRINSTRUCTION_TYPE.PickByCount);
        String2MRInstructionType.put("cm", MRInstruction.MRINSTRUCTION_TYPE.CM_N_COV);
        String2MRInstructionType.put("cov", MRInstruction.MRINSTRUCTION_TYPE.CM_N_COV);
        String2MRInstructionType.put("mean", MRInstruction.MRINSTRUCTION_TYPE.CM_N_COV);
        String2MRInstructionType.put("groupedagg", MRInstruction.MRINSTRUCTION_TYPE.GroupedAggregate);
        String2MRInstructionType.put("mapgroupedagg", MRInstruction.MRINSTRUCTION_TYPE.MapGroupedAggregate);
        String2MRInstructionType.put("rangeReIndex", MRInstruction.MRINSTRUCTION_TYPE.RangeReIndex);
        String2MRInstructionType.put("rangeReIndexForLeft", MRInstruction.MRINSTRUCTION_TYPE.RangeReIndex);
        String2MRInstructionType.put("zeroOut", MRInstruction.MRINSTRUCTION_TYPE.ZeroOut);
        String2MRInstructionType.put("mappend", MRInstruction.MRINSTRUCTION_TYPE.Append);
        String2MRInstructionType.put("rappend", MRInstruction.MRINSTRUCTION_TYPE.Append);
        String2MRInstructionType.put("gappend", MRInstruction.MRINSTRUCTION_TYPE.Append);
        String2MRInstructionType.put("rshape", MRInstruction.MRINSTRUCTION_TYPE.MatrixReshape);
        String2MRInstructionType.put("partition", MRInstruction.MRINSTRUCTION_TYPE.Partition);
        String2MRInstructionType.put("ucumack+", MRInstruction.MRINSTRUCTION_TYPE.CumsumAggregate);
        String2MRInstructionType.put("ucumac*", MRInstruction.MRINSTRUCTION_TYPE.CumsumAggregate);
        String2MRInstructionType.put("ucumacmin", MRInstruction.MRINSTRUCTION_TYPE.CumsumAggregate);
        String2MRInstructionType.put("ucumacmax", MRInstruction.MRINSTRUCTION_TYPE.CumsumAggregate);
        String2MRInstructionType.put("ucumsplit", MRInstruction.MRINSTRUCTION_TYPE.CumsumSplit);
        String2MRInstructionType.put("bcumoffk+", MRInstruction.MRINSTRUCTION_TYPE.CumsumOffset);
        String2MRInstructionType.put("bcumoff*", MRInstruction.MRINSTRUCTION_TYPE.CumsumOffset);
        String2MRInstructionType.put("bcumoffmin", MRInstruction.MRINSTRUCTION_TYPE.CumsumOffset);
        String2MRInstructionType.put("bcumoffmax", MRInstruction.MRINSTRUCTION_TYPE.CumsumOffset);
        String2MRInstructionType.put("sort", MRInstruction.MRINSTRUCTION_TYPE.Sort);
        String2MRInstructionType.put("csvwrite", MRInstruction.MRINSTRUCTION_TYPE.CSVWrite);
        String2MRInstructionType.put("replace", MRInstruction.MRINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2MRInstructionType.put("rexpand", MRInstruction.MRINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2MRInstructionType.put("rmempty", MRInstruction.MRINSTRUCTION_TYPE.RemoveEmpty);
    }
}

