/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.udf.BinaryObject;
import org.apache.sysml.udf.ExternalFunctionInvocationInstruction;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;
import org.apache.sysml.udf.Scalar;

public class ExternalFunctionProgramBlock
extends FunctionProgramBlock {
    protected static final IDSequence _idSeq = new IDSequence();
    protected String _baseDir = null;
    ArrayList<Instruction> block2CellInst;
    ArrayList<Instruction> cell2BlockInst;
    protected HashMap<String, String> _otherParams;
    protected HashMap<String, String> _unblockedFileNames;
    protected HashMap<String, String> _blockedFileNames;
    protected long _runID = -1L;
    private Collection<String> _skipInReblock = new HashSet<String>();
    private Collection<String> _skipOutReblock = new HashSet<String>();

    protected ExternalFunctionProgramBlock(Program prog, ArrayList<DataIdentifier> inputParams, ArrayList<DataIdentifier> outputParams, String baseDir) throws DMLRuntimeException {
        super(prog, inputParams, outputParams);
        this._baseDir = baseDir;
    }

    public ExternalFunctionProgramBlock(Program prog, ArrayList<DataIdentifier> inputParams, ArrayList<DataIdentifier> outputParams, HashMap<String, String> otherParams, String baseDir) throws DMLRuntimeException {
        super(prog, inputParams, outputParams);
        this._baseDir = baseDir;
        this._otherParams = new HashMap();
        this._otherParams.putAll(otherParams);
        this._unblockedFileNames = new HashMap();
        this._blockedFileNames = new HashMap();
        this.createInstructions();
    }

    private void changeTmpInput(long id, ExecutionContext ec) {
        ArrayList<DataIdentifier> inputParams = this.getInputParams();
        this.block2CellInst = this.getBlock2CellInstructions(inputParams, this._unblockedFileNames);
        for (String var : this._skipInReblock) {
            Data dat = ec.getVariable(var);
            if (!(dat instanceof MatrixObject)) continue;
            this._unblockedFileNames.put(var, ((MatrixObject)dat).getFileName());
        }
    }

    private void changeTmpOutput(long id) {
        ArrayList<DataIdentifier> outputParams = this.getOutputParams();
        this.cell2BlockInst = this.getCell2BlockInstructions(outputParams, this._blockedFileNames);
    }

    public String getBaseDir() {
        return this._baseDir;
    }

    @Override
    public void execute(ExecutionContext ec) throws DMLRuntimeException {
        this._runID = _idSeq.getNextID();
        this.changeTmpInput(this._runID, ec);
        this.changeTmpOutput(this._runID);
        ArrayList<DataIdentifier> inputParams = null;
        try {
            inputParams = this.getInputParams();
            for (DataIdentifier di : inputParams) {
                Data d = ec.getVariable(di.getName());
                if (d.getDataType() != Expression.DataType.MATRIX) continue;
                MatrixObject inputObj = (MatrixObject)d;
                inputObj.exportData();
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error exporting input variables to HDFS", e);
        }
        if (this.block2CellInst != null) {
            ArrayList<Instruction> tempInst = new ArrayList<Instruction>();
            tempInst.addAll(this.block2CellInst);
            try {
                this.executeInstructions(tempInst, ec);
            }
            catch (Exception e) {
                throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error executing " + tempInst.toString(), e);
            }
        }
        for (int i = 0; i < this._inst.size(); ++i) {
            try {
                if (!(this._inst.get(i) instanceof ExternalFunctionInvocationInstruction)) continue;
                this.executeInstruction(ec, (ExternalFunctionInvocationInstruction)this._inst.get(i));
                continue;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(this.printBlockErrorLocation() + "Failed to execute instruction " + ((Instruction)this._inst.get(i)).toString(), e);
            }
        }
        if (this.cell2BlockInst != null) {
            ArrayList<Instruction> tempInst = new ArrayList<Instruction>();
            try {
                tempInst.clear();
                tempInst.addAll(this.cell2BlockInst);
                this.executeInstructions(tempInst, ec);
            }
            catch (Exception e) {
                throw new DMLRuntimeException(this.printBlockErrorLocation() + "Failed to execute instruction " + this.cell2BlockInst.toString(), e);
            }
        }
        this.checkOutputParameters(ec.getVariables());
    }

    protected String getParameterString(ArrayList<DataIdentifier> params) {
        String parameterString = "";
        for (int i = 0; i < params.size(); ++i) {
            String s;
            DataIdentifier param;
            if (i != 0) {
                parameterString = parameterString + ",";
            }
            if ((param = params.get(i)).getDataType() == Expression.DataType.MATRIX) {
                s = this.getDataTypeString(Expression.DataType.MATRIX) + ":";
                s = s + "" + param.getName() + ":";
                s = s + this.getValueTypeString(param.getValueType());
                parameterString = parameterString + s;
                continue;
            }
            if (param.getDataType() == Expression.DataType.SCALAR) {
                s = this.getDataTypeString(Expression.DataType.SCALAR) + ":";
                s = s + "" + param.getName() + ":";
                s = s + this.getValueTypeString(param.getValueType());
                parameterString = parameterString + s;
                continue;
            }
            if (param.getDataType() != Expression.DataType.OBJECT) continue;
            s = this.getDataTypeString(Expression.DataType.OBJECT) + ":";
            s = s + "" + param.getName() + ":";
            parameterString = parameterString + s;
        }
        return parameterString;
    }

    protected void createInstructions() {
        this._inst = new ArrayList();
        this.block2CellInst = this.getBlock2CellInstructions(this.getInputParams(), this._unblockedFileNames);
        String className = this._otherParams.get("classname");
        String configFile = this._otherParams.get("configfile");
        if (className == null) {
            throw new RuntimeException(this.printBlockErrorLocation() + "classname" + " not provided!");
        }
        String inputParameterString = this.getParameterString(this.getInputParams());
        String outputParameterString = this.getParameterString(this.getOutputParams());
        ExternalFunctionInvocationInstruction einst = new ExternalFunctionInvocationInstruction(className, configFile, inputParameterString, outputParameterString);
        if (this.getInputParams().size() > 0) {
            einst.setLocation(this.getInputParams().get(0));
        } else if (this.getOutputParams().size() > 0) {
            einst.setLocation(this.getOutputParams().get(0));
        } else {
            einst.setLocation(this.getFilename(), this._beginLine, this._endLine, this._beginColumn, this._endColumn);
        }
        this._inst.add(einst);
        this.cell2BlockInst = this.getCell2BlockInstructions(this.getOutputParams(), this._blockedFileNames);
    }

    private ArrayList<Instruction> getCell2BlockInstructions(ArrayList<DataIdentifier> outputParams, HashMap<String, String> blockedFileNames) {
        ArrayList<Instruction> c2binst = null;
        ArrayList<DataIdentifier> matrices = new ArrayList<DataIdentifier>();
        ArrayList<DataIdentifier> matricesNoReblock = new ArrayList<DataIdentifier>();
        for (int i = 0; i < outputParams.size(); ++i) {
            if (outputParams.get(i).getDataType() != Expression.DataType.MATRIX) continue;
            if (this._skipOutReblock.contains(outputParams.get(i).getName())) {
                matricesNoReblock.add(outputParams.get(i));
                continue;
            }
            matrices.add(outputParams.get(i));
        }
        if (!matrices.isEmpty()) {
            c2binst = new ArrayList<Instruction>();
            MRJobInstruction reblkInst = new MRJobInstruction(JobType.REBLOCK);
            TreeMap MRJobLineNumbers = null;
            if (DMLScript.ENABLE_DEBUG_MODE) {
                MRJobLineNumbers = new TreeMap();
            }
            ArrayList<String> inLabels = new ArrayList<String>();
            ArrayList<String> outLabels = new ArrayList<String>();
            String[] outputs = new String[matrices.size()];
            byte[] resultIndex = new byte[matrices.size()];
            String reblock = "";
            String reblockStr = "";
            String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
            try {
                for (int i = 0; i < matrices.size(); ++i) {
                    inLabels.add(((DataIdentifier)matrices.get(i)).getName());
                    outLabels.add(((DataIdentifier)matrices.get(i)).getName() + "_extFnOutput");
                    outputs[i] = scratchSpaceLoc + "/" + "_p" + DMLScript.getUUID() + "/" + this._otherParams.get("classname") + this._runID + "_" + i + "Output";
                    blockedFileNames.put(((DataIdentifier)matrices.get(i)).getName(), outputs[i]);
                    resultIndex[i] = (byte)i;
                    if (i > 0) {
                        reblock = reblock + "\u2021";
                    }
                    reblock = reblock + "MR\u00b0rblk\u00b0" + i + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i)).getDataType()) + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i)).getValueType()) + "\u00b0" + i + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i)).getDataType()) + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i)).getValueType()) + "\u00b0" + ConfigurationManager.getBlocksize() + "\u00b0" + ConfigurationManager.getBlocksize() + "\u00b0" + "true";
                    if (DMLScript.ENABLE_DEBUG_MODE) {
                        reblockStr = "MR\u00b0rblk\u00b0" + i + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i)).getDataType()) + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i)).getValueType()) + "\u00b0" + i + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i)).getDataType()) + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i)).getValueType()) + "\u00b0" + ConfigurationManager.getBlocksize() + "\u00b0" + ConfigurationManager.getBlocksize() + "\u00b0" + "true";
                        if (!MRJobLineNumbers.containsKey(((DataIdentifier)matrices.get(i)).getBeginLine())) {
                            MRJobLineNumbers.put(((DataIdentifier)matrices.get(i)).getBeginLine(), new ArrayList());
                        }
                        ((ArrayList)MRJobLineNumbers.get(((DataIdentifier)matrices.get(i)).getBeginLine())).add(reblockStr);
                    }
                    Instruction createInst = VariableCPInstruction.prepareCreateMatrixVariableInstruction((String)outLabels.get(i), outputs[i], false, OutputInfo.outputInfoToString(OutputInfo.BinaryBlockOutputInfo));
                    createInst.setLocation((DataIdentifier)matrices.get(i));
                    c2binst.add(createInst);
                }
                reblkInst.setReBlockInstructions(inLabels.toArray(new String[inLabels.size()]), "", reblock, "", outLabels.toArray(new String[inLabels.size()]), resultIndex, 1, 1);
                c2binst.add(reblkInst);
                Instruction cpInst = null;
                Instruction rmInst = null;
                for (int i = 0; i < matrices.size(); ++i) {
                    cpInst = VariableCPInstruction.prepareCopyInstruction((String)outLabels.get(i), ((DataIdentifier)matrices.get(i)).getName());
                    rmInst = VariableCPInstruction.prepareRemoveInstruction((String)outLabels.get(i));
                    cpInst.setLocation((DataIdentifier)matrices.get(i));
                    rmInst.setLocation((DataIdentifier)matrices.get(i));
                    c2binst.add(cpInst);
                    c2binst.add(rmInst);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(this.printBlockErrorLocation() + "error generating instructions", e);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"\n--- Cell-2-Block Instructions ---");
                for (Instruction i : c2binst) {
                    LOG.trace((Object)i.toString());
                }
                LOG.trace((Object)"----------------------------------");
            }
        }
        return c2binst;
    }

    private ArrayList<Instruction> getBlock2CellInstructions(ArrayList<DataIdentifier> inputParams, HashMap<String, String> unBlockedFileNames) {
        int i;
        ArrayList<Instruction> b2cinst = null;
        ArrayList<DataIdentifier> matrices = new ArrayList<DataIdentifier>();
        ArrayList<DataIdentifier> matricesNoReblock = new ArrayList<DataIdentifier>();
        for (i = 0; i < inputParams.size(); ++i) {
            if (inputParams.get(i).getDataType() != Expression.DataType.MATRIX) continue;
            if (this._skipInReblock.contains(inputParams.get(i).getName())) {
                matricesNoReblock.add(inputParams.get(i));
                continue;
            }
            matrices.add(inputParams.get(i));
        }
        if (!matrices.isEmpty()) {
            b2cinst = new ArrayList<Instruction>();
            MRJobInstruction gmrInst = new MRJobInstruction(JobType.GMR);
            TreeMap MRJobLineNumbers = null;
            if (DMLScript.ENABLE_DEBUG_MODE) {
                MRJobLineNumbers = new TreeMap();
            }
            String gmrStr = "";
            ArrayList<String> inLabels = new ArrayList<String>();
            ArrayList<String> outLabels = new ArrayList<String>();
            String[] outputs = new String[matrices.size()];
            byte[] resultIndex = new byte[matrices.size()];
            String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
            try {
                for (int i2 = 0; i2 < matrices.size(); ++i2) {
                    inLabels.add(((DataIdentifier)matrices.get(i2)).getName());
                    outLabels.add(((DataIdentifier)matrices.get(i2)).getName() + "_extFnInput");
                    resultIndex[i2] = (byte)i2;
                    outputs[i2] = scratchSpaceLoc + "/" + "_p" + DMLScript.getUUID() + "/" + this._otherParams.get("classname") + this._runID + "_" + i2 + "Input";
                    unBlockedFileNames.put(((DataIdentifier)matrices.get(i2)).getName(), outputs[i2]);
                    if (DMLScript.ENABLE_DEBUG_MODE) {
                        gmrStr = "MR\u00b0gmr\u00b0" + i2 + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i2)).getDataType()) + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i2)).getValueType()) + "\u00b0" + i2 + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i2)).getDataType()) + "\u00b7" + (Object)((Object)((DataIdentifier)matrices.get(i2)).getValueType()) + "\u00b0" + ConfigurationManager.getBlocksize() + "\u00b0" + ConfigurationManager.getBlocksize();
                        if (!MRJobLineNumbers.containsKey(((DataIdentifier)matrices.get(i2)).getBeginLine())) {
                            MRJobLineNumbers.put(((DataIdentifier)matrices.get(i2)).getBeginLine(), new ArrayList());
                        }
                        ((ArrayList)MRJobLineNumbers.get(((DataIdentifier)matrices.get(i2)).getBeginLine())).add(gmrStr);
                    }
                    Instruction createInst = VariableCPInstruction.prepareCreateMatrixVariableInstruction((String)outLabels.get(i2), outputs[i2], false, OutputInfo.outputInfoToString(OutputInfo.TextCellOutputInfo));
                    createInst.setLocation((DataIdentifier)matrices.get(i2));
                    b2cinst.add(createInst);
                }
                gmrInst.setGMRInstructions(inLabels.toArray(new String[inLabels.size()]), "", "", "", "", outLabels.toArray(new String[outLabels.size()]), resultIndex, 0, 1);
                b2cinst.add(gmrInst);
                Instruction cpInst = null;
                Instruction rmInst = null;
                for (int i3 = 0; i3 < matrices.size(); ++i3) {
                    cpInst = VariableCPInstruction.prepareCopyInstruction((String)outLabels.get(i3), ((DataIdentifier)matrices.get(i3)).getName());
                    rmInst = VariableCPInstruction.prepareRemoveInstruction((String)outLabels.get(i3));
                    cpInst.setLocation((DataIdentifier)matrices.get(i3));
                    rmInst.setLocation((DataIdentifier)matrices.get(i3));
                    b2cinst.add(cpInst);
                    b2cinst.add(rmInst);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"\n--- Block-2-Cell Instructions ---");
                for (Instruction i4 : b2cinst) {
                    LOG.trace((Object)i4.toString());
                }
                LOG.trace((Object)"----------------------------------");
            }
        }
        if (!matricesNoReblock.isEmpty()) {
            for (i = 0; i < matricesNoReblock.size(); ++i) {
                String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
                String filename = scratchSpaceLoc + "/" + "_p" + DMLScript.getUUID() + "/" + this._otherParams.get("classname") + this._runID + "_" + i + "Input";
                unBlockedFileNames.put(((DataIdentifier)matricesNoReblock.get(i)).getName(), filename);
            }
        }
        return b2cinst;
    }

    public void executeInstruction(ExecutionContext ec, ExternalFunctionInvocationInstruction inst) throws DMLRuntimeException {
        Object o;
        String className = inst.getClassName();
        String configFile = inst.getConfigFile();
        if (className == null) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Class name can't be null");
        }
        try {
            Class<?> cla = Class.forName(className);
            o = cla.newInstance();
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error generating package function object ", e);
        }
        if (!(o instanceof PackageFunction)) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Class is not of type PackageFunction");
        }
        PackageFunction func = (PackageFunction)o;
        this.setupInputs(func, inst.getInputParams(), ec.getVariables());
        func.setConfiguration(configFile);
        func.setBaseDir(this._baseDir);
        func.execute();
        this.verifyAndAttachOutputs(ec, func, inst.getOutputParams());
    }

    protected void verifyAndAttachOutputs(ExecutionContext ec, PackageFunction returnFunc, String outputParams) throws DMLRuntimeException {
        ArrayList<String> outputs = this.getParameters(outputParams);
        if (outputs.size() != returnFunc.getNumFunctionOutputs()) {
            throw new DMLRuntimeException("Number of function outputs (" + returnFunc.getNumFunctionOutputs() + ") does not match with declaration (" + outputs.size() + ").");
        }
        for (int i = 0; i < outputs.size(); ++i) {
            StringTokenizer tk = new StringTokenizer(outputs.get(i), ":");
            ArrayList<String> tokens = new ArrayList<String>();
            while (tk.hasMoreTokens()) {
                tokens.add(tk.nextToken());
            }
            if (returnFunc.getFunctionOutput(i).getType() == FunctionParameter.FunctionParameterType.Matrix) {
                Matrix m = (Matrix)returnFunc.getFunctionOutput(i);
                if (!((String)tokens.get(0)).equals(this.getFunctionParameterDataTypeString(FunctionParameter.FunctionParameterType.Matrix)) || !((String)tokens.get(2)).equals(this.getMatrixValueTypeString(m.getValueType()))) {
                    throw new DMLRuntimeException("Function output '" + outputs.get(i) + "' does not match with declaration.");
                }
                String varName = (String)tokens.get(1);
                MatrixObject newVar = this.createOutputMatrixObject(m);
                newVar.setVarName(varName);
                ec.setVariable(varName, newVar);
                continue;
            }
            if (returnFunc.getFunctionOutput(i).getType() == FunctionParameter.FunctionParameterType.Scalar) {
                Scalar s = (Scalar)returnFunc.getFunctionOutput(i);
                if (!((String)tokens.get(0)).equals(this.getFunctionParameterDataTypeString(FunctionParameter.FunctionParameterType.Scalar)) || !((String)tokens.get(2)).equals(this.getScalarValueTypeString(s.getScalarType()))) {
                    throw new DMLRuntimeException("Function output '" + outputs.get(i) + "' does not match with declaration.");
                }
                ScalarObject scalarObject = null;
                Scalar.ScalarValueType type = s.getScalarType();
                switch (type) {
                    case Integer: {
                        scalarObject = new IntObject((String)tokens.get(1), Long.parseLong(s.getValue()));
                        break;
                    }
                    case Double: {
                        scalarObject = new DoubleObject((String)tokens.get(1), Double.parseDouble(s.getValue()));
                        break;
                    }
                    case Boolean: {
                        scalarObject = new BooleanObject((String)tokens.get(1), Boolean.parseBoolean(s.getValue()));
                        break;
                    }
                    case Text: {
                        scalarObject = new StringObject((String)tokens.get(1), s.getValue());
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unknown scalar value type '" + (Object)((Object)type) + "' of output '" + outputs.get(i) + "'.");
                    }
                }
                ec.setVariable((String)tokens.get(1), scalarObject);
                continue;
            }
            if (returnFunc.getFunctionOutput(i).getType() == FunctionParameter.FunctionParameterType.Object) {
                if (!((String)tokens.get(0)).equals(this.getFunctionParameterDataTypeString(FunctionParameter.FunctionParameterType.Object))) {
                    throw new DMLRuntimeException("Function output '" + outputs.get(i) + "' does not match with declaration.");
                }
                throw new DMLRuntimeException("Object types not yet supported");
            }
            throw new DMLRuntimeException("Unknown data type '" + (Object)((Object)returnFunc.getFunctionOutput(i).getType()) + "' of output '" + outputs.get(i) + "'.");
        }
    }

    protected MatrixObject createOutputMatrixObject(Matrix m) throws CacheException {
        MatrixCharacteristics mc = new MatrixCharacteristics(m.getNumRows(), m.getNumCols(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
        MatrixFormatMetaData mfmd = new MatrixFormatMetaData(mc, OutputInfo.TextCellOutputInfo, InputInfo.TextCellInputInfo);
        return new MatrixObject(Expression.ValueType.DOUBLE, m.getFilePath(), mfmd);
    }

    protected String getScalarValueTypeString(Scalar.ScalarValueType scalarType) {
        if (scalarType.equals((Object)Scalar.ScalarValueType.Text)) {
            return "String";
        }
        return scalarType.toString();
    }

    protected void setupInputs(PackageFunction func, String inputParams, LocalVariableMap variableMapping) {
        ArrayList<String> inputs = this.getParameters(inputParams);
        ArrayList<FunctionParameter> inputObjects = this.getInputObjects(inputs, variableMapping);
        func.setNumFunctionInputs(inputObjects.size());
        for (int i = 0; i < inputObjects.size(); ++i) {
            func.setInput(inputObjects.get(i), i);
        }
    }

    protected ArrayList<FunctionParameter> getInputObjects(ArrayList<String> inputs, LocalVariableMap variableMapping) {
        ArrayList<FunctionParameter> inputObjects = new ArrayList<FunctionParameter>();
        for (int i = 0; i < inputs.size(); ++i) {
            String varName;
            ArrayList<String> tokens = new ArrayList<String>();
            StringTokenizer tk = new StringTokenizer(inputs.get(i), ":");
            while (tk.hasMoreTokens()) {
                tokens.add(tk.nextToken());
            }
            if (((String)tokens.get(0)).equals("Matrix")) {
                varName = (String)tokens.get(1);
                MatrixObject mobj = (MatrixObject)variableMapping.get(varName);
                MatrixCharacteristics mc = mobj.getMatrixCharacteristics();
                Matrix m = new Matrix(mobj.getFileName(), mc.getRows(), mc.getCols(), this.getMatrixValueType((String)tokens.get(2)));
                this.modifyInputMatrix(m, mobj);
                inputObjects.add(m);
            }
            if (((String)tokens.get(0)).equals("Scalar")) {
                varName = (String)tokens.get(1);
                ScalarObject so = (ScalarObject)variableMapping.get(varName);
                Scalar s = new Scalar(this.getScalarValueType((String)tokens.get(2)), so.getStringValue());
                inputObjects.add(s);
            }
            if (!((String)tokens.get(0)).equals("Object")) continue;
            varName = (String)tokens.get(1);
            Data o = variableMapping.get(varName);
            BinaryObject obj = new BinaryObject(o);
            inputObjects.add(obj);
        }
        return inputObjects;
    }

    protected void modifyInputMatrix(Matrix m, MatrixObject mobj) {
    }

    protected Scalar.ScalarValueType getScalarValueType(String string) {
        if (string.equals("String")) {
            return Scalar.ScalarValueType.Text;
        }
        return Scalar.ScalarValueType.valueOf(string);
    }

    protected String getMatrixValueTypeString(Matrix.ValueType t) {
        return t.toString();
    }

    protected Matrix.ValueType getMatrixValueType(String string) {
        return Matrix.ValueType.valueOf(string);
    }

    protected ArrayList<String> getParameters(String inputParams) {
        ArrayList<String> inputs = new ArrayList<String>();
        StringTokenizer tk = new StringTokenizer(inputParams, ",");
        while (tk.hasMoreTokens()) {
            inputs.add(tk.nextToken());
        }
        return inputs;
    }

    protected String getDataTypeString(Expression.DataType d) {
        if (d.equals((Object)Expression.DataType.MATRIX)) {
            return "Matrix";
        }
        if (d.equals((Object)Expression.DataType.SCALAR)) {
            return "Scalar";
        }
        if (d.equals((Object)Expression.DataType.OBJECT)) {
            return "Object";
        }
        throw new RuntimeException("Should never come here");
    }

    protected String getFunctionParameterDataTypeString(FunctionParameter.FunctionParameterType t) {
        return t.toString();
    }

    protected String getValueTypeString(Expression.ValueType v) {
        if (v.equals((Object)Expression.ValueType.DOUBLE)) {
            return "Double";
        }
        if (v.equals((Object)Expression.ValueType.INT)) {
            return "Integer";
        }
        if (v.equals((Object)Expression.ValueType.BOOLEAN)) {
            return "Boolean";
        }
        if (v.equals((Object)Expression.ValueType.STRING)) {
            return "String";
        }
        throw new RuntimeException("Should never come here");
    }

    public HashMap<String, String> getOtherParams() {
        return this._otherParams;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in external function program block generated from external function statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }

    @Override
    public ArrayList<Instruction> getInstructions() {
        ArrayList<Instruction> tmp = new ArrayList<Instruction>();
        if (this.cell2BlockInst != null) {
            tmp.addAll(this.cell2BlockInst);
        }
        if (this.block2CellInst != null) {
            tmp.addAll(this.block2CellInst);
        }
        return tmp;
    }
}

