/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.estim;

import org.apache.sysml.runtime.compress.BitmapEncoder;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysml.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class CompressedSizeEstimatorExact
extends CompressedSizeEstimator {
    public CompressedSizeEstimatorExact(MatrixBlock data) {
        super(data);
    }

    @Override
    public CompressedSizeInfo estimateCompressedColGroupSize(int[] colIndexes) {
        return this.estimateCompressedColGroupSize(BitmapEncoder.extractBitmap(colIndexes, this._data));
    }

    @Override
    public CompressedSizeInfo estimateCompressedColGroupSize(UncompressedBitmap ubm) {
        CompressedSizeEstimator.SizeEstimationFactors fact = this.computeSizeEstimationFactors(ubm, true);
        return new CompressedSizeInfo(fact.numVals, fact.numOffs, CompressedSizeEstimatorExact.getRLESize(fact.numVals, fact.numRuns, ubm.getNumColumns()), CompressedSizeEstimatorExact.getOLESize(fact.numVals, fact.numOffs, fact.numSegs, ubm.getNumColumns()), CompressedSizeEstimatorExact.getDDCSize(fact.numVals, this._numRows, ubm.getNumColumns()));
    }
}

