/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.StatementBlock;

public class DMLProgram {
    private ArrayList<StatementBlock> _blocks = new ArrayList();
    private HashMap<String, FunctionStatementBlock> _functionBlocks = new HashMap();
    private HashMap<String, DMLProgram> _namespaces = new HashMap();
    public static final String DEFAULT_NAMESPACE = ".defaultNS";
    public static final String INTERNAL_NAMESPACE = "_internal";
    private static final Log LOG = LogFactory.getLog((String)DMLProgram.class.getName());

    public HashMap<String, DMLProgram> getNamespaces() {
        return this._namespaces;
    }

    public void addStatementBlock(StatementBlock b) {
        this._blocks.add(b);
    }

    public int getNumStatementBlocks() {
        return this._blocks.size();
    }

    public FunctionStatementBlock getFunctionStatementBlock(String fkey) {
        String[] tmp = DMLProgram.splitFunctionKey(fkey);
        return this.getFunctionStatementBlock(tmp[0], tmp[1]);
    }

    public FunctionStatementBlock getFunctionStatementBlock(String namespaceKey, String functionName) {
        DMLProgram namespaceProgram = this.getNamespaces().get(namespaceKey);
        if (namespaceProgram == null) {
            return null;
        }
        FunctionStatementBlock retVal = namespaceProgram._functionBlocks.get(functionName);
        return retVal;
    }

    public HashMap<String, FunctionStatementBlock> getFunctionStatementBlocks(String namespaceKey) throws LanguageException {
        DMLProgram namespaceProgram = this.getNamespaces().get(namespaceKey);
        if (namespaceProgram == null) {
            LOG.error((Object)("ERROR: namespace " + namespaceKey + " is undefined"));
            throw new LanguageException("ERROR: namespace " + namespaceKey + " is undefined");
        }
        return namespaceProgram._functionBlocks;
    }

    public boolean hasFunctionStatementBlocks() {
        boolean ret = false;
        for (DMLProgram nsProg : this._namespaces.values()) {
            ret |= !nsProg._functionBlocks.isEmpty();
        }
        return ret;
    }

    public ArrayList<FunctionStatementBlock> getFunctionStatementBlocks() throws LanguageException {
        ArrayList<FunctionStatementBlock> ret = new ArrayList<FunctionStatementBlock>();
        for (DMLProgram nsProg : this._namespaces.values()) {
            ret.addAll(nsProg._functionBlocks.values());
        }
        return ret;
    }

    public void addFunctionStatementBlock(String namespace, String fname, FunctionStatementBlock fsb) throws LanguageException {
        DMLProgram namespaceProgram = this.getNamespaces().get(namespace);
        if (namespaceProgram == null) {
            throw new LanguageException("Namespace does not exist.");
        }
        namespaceProgram._functionBlocks.put(fname, fsb);
    }

    public ArrayList<StatementBlock> getStatementBlocks() {
        return this._blocks;
    }

    public void setStatementBlocks(ArrayList<StatementBlock> passed) {
        this._blocks = passed;
    }

    public StatementBlock getStatementBlock(int i) {
        return this._blocks.get(i);
    }

    public void mergeStatementBlocks() {
        this._blocks = StatementBlock.mergeStatementBlocks(this._blocks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String namespaceKey : this.getNamespaces().keySet()) {
            sb.append("NAMESPACE = " + namespaceKey + "\n");
            DMLProgram namespaceProg = this.getNamespaces().get(namespaceKey);
            sb.append("FUNCTIONS = ");
            for (FunctionStatementBlock fsb : namespaceProg._functionBlocks.values()) {
                sb.append(fsb);
                sb.append(", ");
            }
            sb.append("\n");
            sb.append("********************************** \n");
        }
        sb.append("******** MAIN SCRIPT BODY ******** \n");
        for (StatementBlock b : this._blocks) {
            sb.append(b);
            sb.append("\n");
        }
        sb.append("********************************** \n");
        return sb.toString();
    }

    public static String constructFunctionKey(String fnamespace, String fname) {
        return fnamespace + "::" + fname;
    }

    public static String[] splitFunctionKey(String fkey) {
        return fkey.split("::");
    }
}

