/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops.runtime;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.mqo.RuntimePiggybacking;
import org.apache.sysml.runtime.instructions.MRInstructionParser;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.RandInstruction;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.SeqInstruction;
import org.apache.sysml.runtime.io.MatrixWriter;
import org.apache.sysml.runtime.io.MatrixWriterFactory;
import org.apache.sysml.runtime.matrix.CMCOVMR;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.CombineMR;
import org.apache.sysml.runtime.matrix.DataGenMR;
import org.apache.sysml.runtime.matrix.DataPartitionMR;
import org.apache.sysml.runtime.matrix.GMR;
import org.apache.sysml.runtime.matrix.GroupedAggMR;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MMCJMR;
import org.apache.sysml.runtime.matrix.MMRJMR;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixDimensionsMetaData;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.ReblockMR;
import org.apache.sysml.runtime.matrix.SortMR;
import org.apache.sysml.runtime.matrix.WriteCSVMR;
import org.apache.sysml.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.utils.Statistics;

public class RunMRJobs {
    public static JobReturn prepareAndSubmitJob(MRJobInstruction inst, ExecutionContext ec) throws DMLRuntimeException {
        MatrixObject[] inputMatrices = inst.extractInputMatrices(ec);
        if (inst.getJobType() != JobType.REBLOCK) {
            for (MatrixObject m : inputMatrices) {
                if (!m.isDirty() && m.getRDDHandle() == null) continue;
                m.exportData();
            }
            RunMRJobs.checkEmptyInputs(inst, inputMatrices);
        }
        inst.extractOutputMatrices(ec);
        String rdInst = inst.getIv_randInstructions();
        String rrInst = inst.getIv_recordReaderInstructions();
        String mapInst = inst.getIv_instructionsInMapper();
        String shuffleInst = inst.getIv_shuffleInstructions();
        String aggInst = inst.getIv_aggInstructions();
        String otherInst = inst.getIv_otherInstructions();
        inst.setIv_randInstructions(RunMRJobs.updateLabels(rdInst, ec.getVariables()));
        inst.setIv_recordReaderInstructions(RunMRJobs.updateLabels(rrInst, ec.getVariables()));
        inst.setIv_instructionsInMapper(RunMRJobs.updateLabels(mapInst, ec.getVariables()));
        inst.setIv_shuffleInstructions(RunMRJobs.updateLabels(shuffleInst, ec.getVariables()));
        inst.setIv_aggInstructions(RunMRJobs.updateLabels(aggInst, ec.getVariables()));
        inst.setIv_otherInstructions(RunMRJobs.updateLabels(otherInst, ec.getVariables()));
        JobReturn ret = null;
        ret = OptimizerUtils.ALLOW_RUNTIME_PIGGYBACKING && RuntimePiggybacking.isActive() && RuntimePiggybacking.isSupportedJobType(inst.getJobType()) ? RuntimePiggybacking.submitJob(inst) : RunMRJobs.submitJob(inst);
        inst.setIv_randInstructions(rdInst);
        inst.setIv_recordReaderInstructions(rrInst);
        inst.setIv_instructionsInMapper(mapInst);
        inst.setIv_shuffleInstructions(shuffleInst);
        inst.setIv_aggInstructions(aggInst);
        inst.setIv_otherInstructions(otherInst);
        return ret;
    }

    public static JobReturn submitJob(MRJobInstruction inst) throws DMLRuntimeException {
        JobReturn ret = new JobReturn();
        MatrixObject[] inputMatrices = inst.getInputMatrices();
        MatrixObject[] outputMatrices = inst.getOutputMatrices();
        boolean execCP = false;
        try {
            String rdInst = inst.getIv_randInstructions();
            String rrInst = inst.getIv_recordReaderInstructions();
            String mapInst = inst.getIv_instructionsInMapper();
            String shuffleInst = inst.getIv_shuffleInstructions();
            String aggInst = inst.getIv_aggInstructions();
            String otherInst = inst.getIv_otherInstructions();
            boolean jvmReuse = ConfigurationManager.getDMLConfig().getBooleanValue("jvmreuse");
            switch (inst.getJobType()) {
                case GMR: 
                case GMRCELL: {
                    ret = GMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBrlens(), inst.getBclens(), inst.getPartitioned(), inst.getPformats(), inst.getPsizes(), rrInst, mapInst, aggInst, otherInst, inst.getIv_numReducers(), inst.getIv_replication(), jvmReuse, inst.getIv_resultIndices(), inst.getDimsUnknownFilePrefix(), inst.getOutputs(), inst.getOutputInfos());
                    break;
                }
                case DATAGEN: {
                    if (ConfigurationManager.isDynamicRecompilation() && OptimizerUtils.ALLOW_RAND_JOB_RECOMPILE && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.HADOOP && Recompiler.checkCPDataGen(inst, rdInst)) {
                        ret = RunMRJobs.executeInMemoryDataGenOperations(inst, rdInst, outputMatrices);
                        Statistics.decrementNoOfExecutedMRJobs();
                        execCP = true;
                        break;
                    }
                    ret = DataGenMR.runJob(inst, rdInst.split("\u2021"), mapInst, aggInst, otherInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getIv_resultIndices(), inst.getDimsUnknownFilePrefix(), inst.getOutputs(), inst.getOutputInfos());
                    break;
                }
                case CM_COV: {
                    ret = CMCOVMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBrlens(), inst.getBclens(), mapInst, shuffleInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getIv_resultIndices(), inst.getOutputs(), inst.getOutputInfos());
                    break;
                }
                case GROUPED_AGG: {
                    ret = GroupedAggMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBrlens(), inst.getBclens(), shuffleInst, otherInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getIv_resultIndices(), inst.getDimsUnknownFilePrefix(), inst.getOutputs(), inst.getOutputInfos());
                    break;
                }
                case REBLOCK: 
                case CSV_REBLOCK: {
                    if (ConfigurationManager.isDynamicRecompilation() && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.HADOOP && Recompiler.checkCPReblock(inst, inputMatrices)) {
                        ret = RunMRJobs.executeInMemoryReblockOperations(inst, shuffleInst, inputMatrices, outputMatrices);
                        Statistics.decrementNoOfExecutedMRJobs();
                        execCP = true;
                        break;
                    }
                    for (MatrixObject m : inputMatrices) {
                        if (!m.isDirty()) continue;
                        m.exportData();
                    }
                    RunMRJobs.checkEmptyInputs(inst, inputMatrices);
                    if (inst.getJobType() == JobType.REBLOCK) {
                        ret = ReblockMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBrlens(), inst.getBclens(), RunMRJobs.getNNZ(inputMatrices), mapInst, shuffleInst, otherInst, inst.getIv_numReducers(), inst.getIv_replication(), jvmReuse, inst.getIv_resultIndices(), inst.getOutputs(), inst.getOutputInfos());
                        break;
                    }
                    if (inst.getJobType() == JobType.CSV_REBLOCK) {
                        ret = CSVReblockMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBrlens(), inst.getBclens(), shuffleInst, otherInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getIv_resultIndices(), inst.getOutputs(), inst.getOutputInfos());
                    }
                    break;
                }
                case CSV_WRITE: {
                    ret = WriteCSVMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBclens(), inst.getBclens(), shuffleInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getIv_resultIndices(), inst.getOutputs());
                    break;
                }
                case MMCJ: {
                    ret = MMCJMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBrlens(), inst.getBclens(), mapInst, aggInst, shuffleInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getOutputs()[0], inst.getOutputInfos()[0]);
                    break;
                }
                case MMRJ: {
                    ret = MMRJMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBrlens(), inst.getBclens(), mapInst, aggInst, shuffleInst, otherInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getIv_resultIndices(), inst.getOutputs(), inst.getOutputInfos());
                    break;
                }
                case SORT: {
                    boolean weightsflag = true;
                    if (!mapInst.equalsIgnoreCase("")) {
                        weightsflag = false;
                    }
                    ret = SortMR.runJob(inst, inst.getInputs()[0], inst.getInputInfos()[0], inst.getRlens()[0], inst.getClens()[0], inst.getBrlens()[0], inst.getBclens()[0], mapInst, shuffleInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getOutputs()[0], inst.getOutputInfos()[0], weightsflag);
                    break;
                }
                case COMBINE: {
                    ret = CombineMR.runJob(inst, inst.getInputs(), inst.getInputInfos(), inst.getRlens(), inst.getClens(), inst.getBrlens(), inst.getBclens(), shuffleInst, inst.getIv_numReducers(), inst.getIv_replication(), inst.getIv_resultIndices(), inst.getOutputs(), inst.getOutputInfos());
                    break;
                }
                case DATA_PARTITION: {
                    ret = DataPartitionMR.runJob(inst, inputMatrices, shuffleInst, inst.getIv_resultIndices(), outputMatrices, inst.getIv_numReducers(), inst.getIv_replication());
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Invalid jobtype: " + (Object)((Object)inst.getJobType()));
                }
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
        if (ret.checkReturnStatus()) {
            try {
                if (!execCP) {
                    for (int i = 0; i < outputMatrices.length; ++i) {
                        MatrixFormatMetaData meta = (MatrixFormatMetaData)outputMatrices[i].getMetaData();
                        MatrixCharacteristics mc = meta.getMatrixCharacteristics();
                        OutputInfo outinfo = meta.getOutputInfo();
                        String fname = outputMatrices[i].getFileName();
                        if (MapReduceTool.isHDFSFileEmpty(fname)) {
                            Path filepath = new Path(fname, "0-m-00000");
                            MatrixWriter writer = MatrixWriterFactory.createMatrixWriter(outinfo);
                            writer.writeEmptyMatrixToHDFS(filepath.toString(), mc.getRows(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock());
                        }
                        outputMatrices[i].setHDFSFileExists(true);
                        if (inst.getJobType() == JobType.CSV_WRITE) continue;
                        MapReduceTool.writeMetaDataFile(fname + ".mtd", Expression.ValueType.DOUBLE, ((MatrixDimensionsMetaData)ret.getMetaData(i)).getMatrixCharacteristics(), outinfo);
                    }
                }
                return ret;
            }
            catch (IOException e) {
                throw new DMLRuntimeException(e);
            }
        }
        throw new DMLRuntimeException("Unexpected Job Type: " + (Object)((Object)inst.getJobType()));
    }

    private static void checkEmptyInputs(MRJobInstruction inst, MatrixObject[] inputMatrices) throws DMLRuntimeException {
        if (!inst.getJobType().areEmptyInputsAllowed()) {
            for (int i = 0; i < inputMatrices.length; ++i) {
                try {
                    if (!MapReduceTool.isHDFSFileEmpty(inputMatrices[i].getFileName())) continue;
                    throw new DMLRuntimeException("Can not operate on an empty file: " + inputMatrices[i].getFileName());
                }
                catch (IOException e) {
                    throw new DMLRuntimeException("runtime error occurred -- ", e);
                }
            }
        }
    }

    private static String getVarNameReplacement(String inst, String varName, LocalVariableMap map) throws DMLRuntimeException {
        Data val = map.get(varName);
        if (val != null) {
            String replacement = null;
            if (val.getDataType() == Expression.DataType.MATRIX) {
                replacement = ((MatrixObject)val).getFileName();
            }
            if (val.getDataType() == Expression.DataType.SCALAR) {
                replacement = "" + ((ScalarObject)val).getStringValue();
            }
            return replacement;
        }
        throw new DMLRuntimeException("Variable (" + varName + ") in Instruction (" + inst + ") is not found in the variablemap.");
    }

    private static String updateInstLabels(String inst, LocalVariableMap map) throws DMLRuntimeException {
        if (inst.contains("\u00b6")) {
            int skip = "\u00b6".toString().length();
            while (inst.contains("\u00b6")) {
                int startLoc = inst.indexOf("\u00b6") + skip;
                String varName = inst.substring(startLoc, inst.indexOf("\u00b6", startLoc));
                String replacement = RunMRJobs.getVarNameReplacement(inst, varName, map);
                inst = inst.replaceAll("\u00b6" + varName + "\u00b6", replacement);
            }
        }
        return inst;
    }

    public static String updateLabels(String instList, LocalVariableMap labelValueMapping) throws DMLRuntimeException {
        if (!instList.contains("\u00b6")) {
            return instList;
        }
        StringBuilder updateInstList = new StringBuilder();
        String[] ilist = instList.split("\u2021");
        for (int i = 0; i < ilist.length; ++i) {
            if (i > 0) {
                updateInstList.append("\u2021");
            }
            updateInstList.append(RunMRJobs.updateInstLabels(ilist[i], labelValueMapping));
        }
        return updateInstList.toString();
    }

    private static long[] getNNZ(MatrixObject[] inputMatrices) throws DMLRuntimeException {
        int len = inputMatrices.length;
        long[] ret = new long[len];
        for (int i = 0; i < len; ++i) {
            MatrixObject mo = inputMatrices[i];
            ret[i] = mo != null ? mo.getNnz() : -1L;
        }
        return ret;
    }

    private static JobReturn executeInMemoryReblockOperations(MRJobInstruction inst, String shuffleInst, MatrixObject[] inputMatrices, MatrixObject[] outputMatrices) throws DMLRuntimeException {
        MatrixCharacteristics[] mc = new MatrixCharacteristics[outputMatrices.length];
        ReblockInstruction[] rblkSet = MRInstructionParser.parseReblockInstructions(shuffleInst);
        byte[] results = inst.getIv_resultIndices();
        for (ReblockInstruction rblk : rblkSet) {
            MatrixBlock mb = (MatrixBlock)inputMatrices[rblk.input].acquireRead();
            for (int i = 0; i < results.length; ++i) {
                if (rblk.output != results[i]) continue;
                outputMatrices[i].acquireModify(mb);
                outputMatrices[i].release();
                mc[i] = new MatrixCharacteristics(mb.getNumRows(), mb.getNumColumns(), rblk.brlen, rblk.bclen, mb.getNonZeros());
            }
            inputMatrices[rblk.input].release();
        }
        return new JobReturn(mc, inst.getOutputInfos(), true);
    }

    private static JobReturn executeInMemoryDataGenOperations(MRJobInstruction inst, String randInst, MatrixObject[] outputMatrices) throws DMLRuntimeException {
        MatrixCharacteristics[] mc = new MatrixCharacteristics[outputMatrices.length];
        DataGenMRInstruction[] dgSet = MRInstructionParser.parseDataGenInstructions(randInst);
        byte[] results = inst.getIv_resultIndices();
        for (DataGenMRInstruction ldgInst : dgSet) {
            if (ldgInst instanceof RandInstruction) {
                RandInstruction lrand = (RandInstruction)ldgInst;
                RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(lrand.getProbabilityDensityFunction(), (int)lrand.getRows(), (int)lrand.getCols(), lrand.getRowsInBlock(), lrand.getColsInBlock(), lrand.getSparsity(), lrand.getMinValue(), lrand.getMaxValue(), lrand.getPdfParams());
                MatrixBlock mb = MatrixBlock.randOperations(rgen, lrand.getSeed());
                for (int i = 0; i < results.length; ++i) {
                    if (lrand.output != results[i]) continue;
                    outputMatrices[i].acquireModify(mb);
                    outputMatrices[i].release();
                    mc[i] = new MatrixCharacteristics(mb.getNumRows(), mb.getNumColumns(), lrand.getRowsInBlock(), lrand.getColsInBlock(), mb.getNonZeros());
                }
                continue;
            }
            if (!(ldgInst instanceof SeqInstruction)) continue;
            SeqInstruction lseq = (SeqInstruction)ldgInst;
            MatrixBlock mb = MatrixBlock.seqOperations(lseq.fromValue, lseq.toValue, lseq.incrValue);
            for (int i = 0; i < results.length; ++i) {
                if (lseq.output != results[i]) continue;
                outputMatrices[i].acquireModify(mb);
                outputMatrices[i].release();
                mc[i] = new MatrixCharacteristics(mb.getNumRows(), mb.getNumColumns(), lseq.getRowsInBlock(), lseq.getColsInBlock(), mb.getNonZeros());
            }
        }
        return new JobReturn(mc, inst.getOutputInfos(), true);
    }
}

