/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Compression
extends Lop {
    public static final String OPCODE = "compress";

    public Compression(Lop input, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.Checkpoint, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Compress";
    }

    @Override
    public String getInstructions(String input1, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }
}

