/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.opt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.codegen.opt.PlanSelection;
import org.apache.sysml.hops.codegen.template.CPlanMemoTable;
import org.apache.sysml.hops.codegen.template.TemplateBase;

public class PlanSelectionFuseNoRedundancy
extends PlanSelection {
    @Override
    public void selectPlans(CPlanMemoTable memo, ArrayList<Hop> roots) {
        for (Hop hop : roots) {
            this.rSelectPlans(memo, hop, null);
        }
        for (Map.Entry entry : this.getBestPlans().entrySet()) {
            memo.setDistinct((Long)entry.getKey(), (List)entry.getValue());
        }
    }

    private void rSelectPlans(CPlanMemoTable memo, Hop current, TemplateBase.TemplateType currentType) {
        List<CPlanMemoTable.MemoTableEntry> hopP;
        HashSet<CPlanMemoTable.MemoTableEntry> rmSet;
        if (this.isVisited(current.getHopID(), currentType)) {
            return;
        }
        if (memo.contains(current.getHopID())) {
            rmSet = new HashSet<CPlanMemoTable.MemoTableEntry>();
            hopP = memo.get(current.getHopID());
            for (CPlanMemoTable.MemoTableEntry e1 : hopP) {
                for (int i = 0; i < 3; ++i) {
                    if (!e1.isPlanRef(i) || current.getInput().get(i).getParent().size() <= 1) continue;
                    rmSet.add(e1);
                }
            }
            memo.remove(current, rmSet);
        }
        if (memo.contains(current.getHopID())) {
            rmSet = new HashSet();
            hopP = memo.get(current.getHopID());
            for (CPlanMemoTable.MemoTableEntry e1 : hopP) {
                for (CPlanMemoTable.MemoTableEntry e2 : hopP) {
                    if (e1 == e2 || !e1.subsumes(e2)) continue;
                    rmSet.add(e2);
                }
            }
            memo.remove(current, rmSet);
        }
        CPlanMemoTable.MemoTableEntry best = null;
        if (memo.contains(current.getHopID())) {
            best = currentType == null ? (CPlanMemoTable.MemoTableEntry)memo.get(current.getHopID()).stream().filter(p -> PlanSelectionFuseNoRedundancy.isValid(p, current)).min(new PlanSelection.BasicPlanComparator()).orElse(null) : (CPlanMemoTable.MemoTableEntry)memo.get(current.getHopID()).stream().filter(p -> p.type == currentType || p.type == TemplateBase.TemplateType.CELL).min(Comparator.comparing(p -> 7 - (p.type == currentType ? 4 : 0) - p.countPlanRefs())).orElse(null);
            this.addBestPlan(current.getHopID(), best);
        }
        for (int i = 0; i < current.getInput().size(); ++i) {
            TemplateBase.TemplateType pref = best != null && best.isPlanRef(i) ? best.type : null;
            this.rSelectPlans(memo, current.getInput().get(i), pref);
        }
        this.setVisited(current.getHopID(), currentType);
    }
}

