/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.opt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.codegen.template.CPlanMemoTable;
import org.apache.sysml.hops.codegen.template.TemplateBase;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class PlanSelection {
    private final HashMap<Long, List<CPlanMemoTable.MemoTableEntry>> _bestPlans = new HashMap();
    private final HashSet<VisitMark> _visited = new HashSet();

    public abstract void selectPlans(CPlanMemoTable var1, ArrayList<Hop> var2);

    public static boolean isValid(CPlanMemoTable.MemoTableEntry me, Hop hop) {
        return me.type != TemplateBase.TemplateType.OUTER || me.closed || HopRewriteUtils.isBinaryMatrixMatrixOperation(hop);
    }

    protected void addBestPlan(long hopID, CPlanMemoTable.MemoTableEntry me) {
        if (me == null) {
            return;
        }
        if (!this._bestPlans.containsKey(hopID)) {
            this._bestPlans.put(hopID, new ArrayList());
        }
        this._bestPlans.get(hopID).add(me);
    }

    protected HashMap<Long, List<CPlanMemoTable.MemoTableEntry>> getBestPlans() {
        return this._bestPlans;
    }

    protected boolean isVisited(long hopID, TemplateBase.TemplateType type) {
        return this._visited.contains(new VisitMark(hopID, type));
    }

    protected void setVisited(long hopID, TemplateBase.TemplateType type) {
        this._visited.add(new VisitMark(hopID, type));
    }

    public static class VisitMarkCost {
        private final long _hopID;
        private final long _costID;

        public VisitMarkCost(long hopID, long costID) {
            this._hopID = hopID;
            this._costID = costID;
        }

        public int hashCode() {
            return UtilFunctions.longHashCode(this._hopID, this._costID);
        }

        public boolean equals(Object o) {
            return o instanceof VisitMarkCost && this._hopID == ((VisitMarkCost)o)._hopID && this._costID == ((VisitMarkCost)o)._costID;
        }
    }

    protected static class VisitMark {
        private final long _hopID;
        private final TemplateBase.TemplateType _type;

        public VisitMark(long hopID, TemplateBase.TemplateType type) {
            this._hopID = hopID;
            this._type = type;
        }

        public int hashCode() {
            return UtilFunctions.longHashCode(this._hopID, this._type != null ? (long)this._type.hashCode() : 0L);
        }

        public boolean equals(Object o) {
            return o instanceof VisitMark && this._hopID == ((VisitMark)o)._hopID && this._type == ((VisitMark)o)._type;
        }
    }

    protected static class TypedPlanComparator
    implements Comparator<CPlanMemoTable.MemoTableEntry> {
        private TemplateBase.TemplateType _type;

        protected TypedPlanComparator() {
        }

        public void setType(TemplateBase.TemplateType type) {
            this._type = type;
        }

        @Override
        public int compare(CPlanMemoTable.MemoTableEntry o1, CPlanMemoTable.MemoTableEntry o2) {
            return TypedPlanComparator.icompare(o1, o2, this._type);
        }

        public static int icompare(CPlanMemoTable.MemoTableEntry o1, CPlanMemoTable.MemoTableEntry o2, TemplateBase.TemplateType type) {
            if (o2 == null) {
                return -1;
            }
            int score1 = 7 - (o1.type == type ? 4 : 0) - o1.countPlanRefs();
            int score2 = 7 - (o2.type == type ? 4 : 0) - o2.countPlanRefs();
            return Integer.compare(score1, score2);
        }
    }

    protected static class BasicPlanComparator
    implements Comparator<CPlanMemoTable.MemoTableEntry> {
        protected BasicPlanComparator() {
        }

        @Override
        public int compare(CPlanMemoTable.MemoTableEntry o1, CPlanMemoTable.MemoTableEntry o2) {
            return BasicPlanComparator.icompare(o1, o2);
        }

        public static int icompare(CPlanMemoTable.MemoTableEntry o1, CPlanMemoTable.MemoTableEntry o2) {
            if (o2 == null) {
                return -1;
            }
            if (o1.type != o2.type) {
                return Integer.compare(o1.type.getRank(), o2.type.getRank());
            }
            return Integer.compare(-o1.countPlanRefs(), -o2.countPlanRefs());
        }
    }
}

