/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.conf;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DMLConfig {
    public static final String DEFAULT_SYSTEMML_CONFIG_FILEPATH = "./SystemML-config.xml";
    private static final Log LOG = LogFactory.getLog((String)DMLConfig.class.getName());
    public static final String LOCAL_TMP_DIR = "localtmpdir";
    public static final String SCRATCH_SPACE = "scratch";
    public static final String OPTIMIZATION_LEVEL = "optlevel";
    public static final String NUM_REDUCERS = "numreducers";
    public static final String JVM_REUSE = "jvmreuse";
    public static final String DEFAULT_BLOCK_SIZE = "defaultblocksize";
    public static final String YARN_APPMASTER = "dml.yarn.appmaster";
    public static final String YARN_APPMASTERMEM = "dml.yarn.appmaster.mem";
    public static final String YARN_MAPREDUCEMEM = "dml.yarn.mapreduce.mem";
    public static final String YARN_APPQUEUE = "dml.yarn.app.queue";
    public static final String CP_PARALLEL_OPS = "cp.parallel.ops";
    public static final String CP_PARALLEL_IO = "cp.parallel.io";
    public static final String COMPRESSED_LINALG = "compressed.linalg";
    public static final String NATIVE_BLAS = "native.blas";
    public static final String CODEGEN = "codegen.enabled";
    public static final String CODEGEN_PLANCACHE = "codegen.plancache";
    public static final String CODEGEN_LITERALS = "codegen.literals";
    public static final String EXTRA_FINEGRAINED_STATS = "systemml.stats.finegrained";
    public static final String STATS_MAX_WRAP_LEN = "systemml.stats.maxWrapLength";
    public static final String EXTRA_GPU_STATS = "systemml.stats.extraGPU";
    public static final String EXTRA_DNN_STATS = "systemml.stats.extraDNN";
    public static final String AVAILABLE_GPUS = "systemml.gpu.availableGPUs";
    public static final String GPU_MEMORY_UTILIZATION_FACTOR = "gpu.memory.util.factor";
    public static final String PREFIX_MAPRED = "mapred";
    public static final String PREFIX_MAPREDUCE = "mapreduce";
    public static final String DEFAULT_SHARED_DIR_PERMISSION = "777";
    public static String LOCAL_MR_MODE_STAGING_DIR = null;
    private static HashMap<String, String> _defaultVals = null;
    private String _fileName = null;
    private Element _xmlRoot = null;
    private DocumentBuilder _documentBuilder = null;
    private Document _document = null;

    public DMLConfig() {
    }

    public DMLConfig(String fileName) throws ParseException, FileNotFoundException {
        this(fileName, false);
    }

    public DMLConfig(String fileName, boolean silent) throws ParseException, FileNotFoundException {
        this._fileName = fileName;
        try {
            this.parseConfig();
        }
        catch (FileNotFoundException fnfe) {
            LOCAL_MR_MODE_STAGING_DIR = this.getTextValue(LOCAL_TMP_DIR) + "/hadoop/mapred/staging";
            throw fnfe;
        }
        catch (Exception e) {
            if (!silent) {
                LOG.error((Object)"Failed to parse DML config file ", (Throwable)e);
            }
            throw new ParseException("ERROR: error parsing DMLConfig file " + fileName);
        }
        LOCAL_MR_MODE_STAGING_DIR = this.getTextValue(LOCAL_TMP_DIR) + "/hadoop/mapred/staging";
    }

    public DMLConfig(Element root) {
        this._xmlRoot = root;
    }

    private void parseConfig() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.getDocumentBuilder();
        this._document = null;
        if (this._fileName.startsWith("hdfs:") || this._fileName.startsWith("gpfs:") || IOUtilFunctions.isObjectStoreFileScheme(new Path(this._fileName))) {
            Path configFilePath = new Path(this._fileName);
            FileSystem DFS = IOUtilFunctions.getFileSystem(configFilePath);
            this._document = builder.parse((InputStream)DFS.open(configFilePath));
        } else {
            this._document = builder.parse(this._fileName);
        }
        this._xmlRoot = this._document.getDocumentElement();
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this._documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            this._documentBuilder = factory.newDocumentBuilder();
        }
        return this._documentBuilder;
    }

    public String getTextValue(String tagName) {
        String retVal;
        String string = retVal = this._xmlRoot != null ? DMLConfig.getTextValue(this._xmlRoot, tagName) : null;
        if (retVal == null) {
            if (_defaultVals.containsKey(tagName)) {
                retVal = _defaultVals.get(tagName);
            } else {
                LOG.error((Object)("Error: requested dml configuration property '" + tagName + "' is invalid."));
            }
        }
        return retVal;
    }

    public int getIntValue(String tagName) {
        return Integer.parseInt(this.getTextValue(tagName));
    }

    public boolean getBooleanValue(String tagName) {
        return Boolean.parseBoolean(this.getTextValue(tagName));
    }

    public double getDoubleValue(String tagName) {
        return Double.parseDouble(this.getTextValue(tagName));
    }

    private static String getTextValue(Element element, String tagName) {
        String textVal = null;
        NodeList list = element.getElementsByTagName(tagName);
        if (list != null && list.getLength() > 0) {
            Element elem = (Element)list.item(0);
            textVal = elem.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    public void setTextValue(String paramName, String paramValue) throws DMLRuntimeException {
        if (this._xmlRoot != null) {
            NodeList list = this._xmlRoot.getElementsByTagName(paramName);
            if (list != null && list.getLength() > 0) {
                Element elem = (Element)list.item(0);
                elem.getFirstChild().setNodeValue(paramValue);
            } else {
                Text value = this._document.createTextNode(paramValue);
                Element element = this._document.createElement(paramName);
                element.appendChild(value);
                this._xmlRoot.appendChild(element);
            }
        } else {
            try {
                DocumentBuilder builder = this.getDocumentBuilder();
                String configString = "<root><" + paramName + ">" + paramValue + "</" + paramName + "></root>";
                this._document = builder.parse(new ByteArrayInputStream(configString.getBytes("UTF-8")));
                this._xmlRoot = this._document.getDocumentElement();
            }
            catch (Exception e) {
                throw new DMLRuntimeException("Unable to set config value", e);
            }
        }
    }

    public Map<String, String> getCustomMRConfig() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this._xmlRoot == null) {
            return ret;
        }
        NodeList list = this._xmlRoot.getElementsByTagName("*");
        for (int i = 0; list != null && i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element) || !((Element)list.item(i)).getNodeName().startsWith(PREFIX_MAPRED) && !((Element)list.item(i)).getNodeName().startsWith(PREFIX_MAPREDUCE)) continue;
            Element elem = (Element)list.item(i);
            ret.put(elem.getNodeName(), elem.getFirstChild().getNodeValue());
        }
        return ret;
    }

    public synchronized String serializeDMLConfig() throws DMLRuntimeException {
        String ret = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(this._xmlRoot);
            transformer.transform(source, result);
            ret = result.getWriter().toString();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to serialize DML config.", ex);
        }
        return ret;
    }

    public static DMLConfig parseDMLConfig(String content) throws DMLRuntimeException {
        DMLConfig ret = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document domTree = null;
            domTree = builder.parse(new ByteArrayInputStream(content.getBytes("utf-8")));
            Element root = domTree.getDocumentElement();
            ret = new DMLConfig(root);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to parse DML config.", ex);
        }
        return ret;
    }

    public static DMLConfig readConfigurationFile(String configPath) throws ParseException, FileNotFoundException {
        DMLConfig config = new DMLConfig();
        if (configPath != null) {
            try {
                config = new DMLConfig(configPath, false);
            }
            catch (FileNotFoundException fnfe) {
                LOG.error((Object)("Custom config file " + configPath + " not found."));
                throw fnfe;
            }
            catch (ParseException e) {
                throw e;
            }
        }
        try {
            config = new DMLConfig(DEFAULT_SYSTEMML_CONFIG_FILEPATH, false);
        }
        catch (FileNotFoundException fnfe) {
            LOG.info((Object)"Using internal default configuration settings.  If you wish to customize any settings, please supply a `SystemML-config.xml` file.");
            config = new DMLConfig();
        }
        catch (ParseException e) {
            throw e;
        }
        return config;
    }

    public String getConfigInfo() {
        String[] tmpConfig = new String[]{LOCAL_TMP_DIR, SCRATCH_SPACE, OPTIMIZATION_LEVEL, NUM_REDUCERS, DEFAULT_BLOCK_SIZE, YARN_APPMASTER, YARN_APPMASTERMEM, YARN_MAPREDUCEMEM, CP_PARALLEL_OPS, CP_PARALLEL_IO, NATIVE_BLAS, COMPRESSED_LINALG, CODEGEN, CODEGEN_LITERALS, CODEGEN_PLANCACHE, EXTRA_GPU_STATS, EXTRA_DNN_STATS, EXTRA_FINEGRAINED_STATS, STATS_MAX_WRAP_LEN, AVAILABLE_GPUS};
        StringBuilder sb = new StringBuilder();
        for (String tmp : tmpConfig) {
            sb.append("INFO: ");
            sb.append(tmp);
            sb.append(": ");
            sb.append(this.getTextValue(tmp));
            sb.append("\n");
        }
        return sb.toString();
    }

    public void updateYarnMemorySettings(String amMem, String mrMem) {
        NodeList list2;
        NodeList list1 = this._xmlRoot.getElementsByTagName(YARN_APPMASTERMEM);
        if (list1 != null && list1.getLength() > 0) {
            Element elem = (Element)list1.item(0);
            elem.getFirstChild().setNodeValue(String.valueOf(amMem));
        }
        if ((list2 = this._xmlRoot.getElementsByTagName(YARN_MAPREDUCEMEM)) != null && list2.getLength() > 0) {
            Element elem = (Element)list2.item(0);
            elem.getFirstChild().setNodeValue(String.valueOf(mrMem));
        }
    }

    public static String getDefaultTextValue(String key) {
        return _defaultVals.get(key);
    }

    public DMLConfig clone() {
        DMLConfig conf = new DMLConfig();
        conf._fileName = this._fileName;
        conf._xmlRoot = (Element)this._xmlRoot.cloneNode(true);
        return conf;
    }

    static {
        _defaultVals = new HashMap();
        _defaultVals.put(LOCAL_TMP_DIR, "/tmp/systemml");
        _defaultVals.put(SCRATCH_SPACE, "scratch_space");
        _defaultVals.put(OPTIMIZATION_LEVEL, String.valueOf(OptimizerUtils.DEFAULT_OPTLEVEL.ordinal()));
        _defaultVals.put(NUM_REDUCERS, "10");
        _defaultVals.put(JVM_REUSE, "false");
        _defaultVals.put(DEFAULT_BLOCK_SIZE, String.valueOf(1000));
        _defaultVals.put(YARN_APPMASTER, "false");
        _defaultVals.put(YARN_APPMASTERMEM, "2048");
        _defaultVals.put(YARN_MAPREDUCEMEM, "-1");
        _defaultVals.put(YARN_APPQUEUE, "default");
        _defaultVals.put(CP_PARALLEL_OPS, "true");
        _defaultVals.put(CP_PARALLEL_IO, "true");
        _defaultVals.put(COMPRESSED_LINALG, "false");
        _defaultVals.put(CODEGEN, "false");
        _defaultVals.put(CODEGEN_PLANCACHE, "true");
        _defaultVals.put(CODEGEN_LITERALS, "1");
        _defaultVals.put(NATIVE_BLAS, "none");
        _defaultVals.put(EXTRA_FINEGRAINED_STATS, "false");
        _defaultVals.put(STATS_MAX_WRAP_LEN, "30");
        _defaultVals.put(EXTRA_GPU_STATS, "false");
        _defaultVals.put(EXTRA_DNN_STATS, "false");
        _defaultVals.put(GPU_MEMORY_UTILIZATION_FACTOR, "0.9");
        _defaultVals.put(AVAILABLE_GPUS, "-1");
    }
}

