/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.OptimizerUtils;

public class NativeHelper {
    private static boolean isSystemMLLoaded = false;
    private static final Log LOG = LogFactory.getLog((String)NativeHelper.class.getName());
    private static HashMap<String, String> supportedArchitectures = new HashMap();
    public static String blasType;
    private static int maxNumThreads;
    private static boolean setMaxNumThreads;
    private static boolean attemptedLoading;
    private static String hintOnFailures;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        String userSpecifiedBLAS;
        if (!SystemUtils.IS_OS_LINUX) {
            return;
        }
        if (attemptedLoading) return;
        DMLConfig dmlConfig = ConfigurationManager.getDMLConfig();
        String string = userSpecifiedBLAS = dmlConfig == null ? "auto" : dmlConfig.getTextValue("native.blas").trim().toLowerCase();
        if (userSpecifiedBLAS.equals("auto") || userSpecifiedBLAS.equals("mkl") || userSpecifiedBLAS.equals("openblas")) {
            long start = System.nanoTime();
            if (!supportedArchitectures.containsKey(SystemUtils.OS_ARCH)) {
                LOG.info((Object)("Unsupported architecture for native BLAS:" + SystemUtils.OS_ARCH));
                return;
            }
            Class<NativeHelper> clazz = NativeHelper.class;
            synchronized (NativeHelper.class) {
                if (!attemptedLoading) {
                    if (userSpecifiedBLAS.equals("auto")) {
                        String string2 = NativeHelper.isMKLAvailable() ? "mkl" : (blasType = NativeHelper.isOpenBLASAvailable() ? "openblas" : null);
                        if (blasType == null) {
                            LOG.info((Object)("Unable to load either MKL or OpenBLAS due to " + hintOnFailures));
                        }
                    } else if (userSpecifiedBLAS.equals("mkl")) {
                        String string3 = blasType = NativeHelper.isMKLAvailable() ? "mkl" : null;
                        if (blasType == null) {
                            LOG.info((Object)("Unable to load MKL due to " + hintOnFailures));
                        }
                    } else {
                        if (!userSpecifiedBLAS.equals("openblas")) throw new RuntimeException("Unsupported BLAS:" + userSpecifiedBLAS);
                        String string4 = blasType = NativeHelper.isOpenBLASAvailable() ? "openblas" : null;
                        if (blasType == null) {
                            LOG.info((Object)("Unable to load OpenBLAS due to " + hintOnFailures));
                        }
                    }
                    if (blasType != null && NativeHelper.loadLibraryHelper("libsystemml_" + blasType + "-Linux-x86_64.so")) {
                        String blasPathAndHint = "";
                        if (LOG.isDebugEnabled()) {
                            try {
                                Field loadedLibraryNamesField = ClassLoader.class.getDeclaredField("loadedLibraryNames");
                                loadedLibraryNamesField.setAccessible(true);
                                Vector libraries = (Vector)loadedLibraryNamesField.get(ClassLoader.getSystemClassLoader());
                                LOG.debug((Object)("List of native libraries loaded:" + libraries));
                                for (String library : libraries) {
                                    if (!library.contains("libmkl_rt") && !library.contains("libopenblas")) continue;
                                    blasPathAndHint = " from the path " + library;
                                    break;
                                }
                            }
                            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                                LOG.debug((Object)("Error while finding list of native libraries:" + e.getMessage()));
                            }
                        }
                        LOG.info((Object)("Using native blas: " + blasType + blasPathAndHint));
                        isSystemMLLoaded = true;
                    }
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                double timeToLoadInMilliseconds = (double)(System.nanoTime() - start) * 1.0E-6;
                if (timeToLoadInMilliseconds > 1000.0) {
                    LOG.warn((Object)("Time to load native blas: " + timeToLoadInMilliseconds + " milliseconds."));
                }
            }
        } else {
            LOG.debug((Object)("Using internal Java BLAS as native BLAS support the configuration 'native.blas'=" + userSpecifiedBLAS + "."));
        }
        {
            attemptedLoading = true;
            return;
        }
    }

    public static boolean isNativeLibraryLoaded() {
        NativeHelper.init();
        if (maxNumThreads == -1) {
            maxNumThreads = OptimizerUtils.getConstrainedNumThreads(-1);
        }
        if (isSystemMLLoaded && !setMaxNumThreads && maxNumThreads != -1) {
            NativeHelper.setMaxNumThreads(maxNumThreads);
            setMaxNumThreads = true;
        }
        return isSystemMLLoaded;
    }

    public static int getMaxNumThreads() {
        if (maxNumThreads == -1) {
            maxNumThreads = OptimizerUtils.getConstrainedNumThreads(-1);
        }
        return maxNumThreads;
    }

    private static boolean isMKLAvailable() {
        return NativeHelper.loadBLAS("mkl_rt", null);
    }

    private static boolean isOpenBLASAvailable() {
        if (!NativeHelper.loadBLAS("gomp", "gomp required for loading OpenBLAS-enabled SystemML library")) {
            return false;
        }
        return NativeHelper.loadBLAS("openblas", null);
    }

    private static boolean loadBLAS(String blas, String optionalMsg) {
        try {
            System.loadLibrary(blas);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            if (!hintOnFailures.contains(blas)) {
                hintOnFailures = hintOnFailures + blas + " ";
            }
            if (optionalMsg != null) {
                LOG.debug((Object)("Unable to load " + blas + "(" + optionalMsg + "):" + e.getMessage()));
            } else {
                LOG.debug((Object)("Unable to load " + blas + ":" + e.getMessage()));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLibraryHelper(String path) {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = NativeHelper.class.getResourceAsStream("/lib/" + path);
            if (in != null) {
                File temp = File.createTempFile(path, "");
                temp.deleteOnExit();
                out = FileUtils.openOutputStream((File)temp);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                in.close();
                in = null;
                out.close();
                out = null;
                System.load(temp.getAbsolutePath());
                boolean bl = true;
                return bl;
            }
            LOG.warn((Object)("No lib available in the jar:" + path));
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to load library " + path + " from resource:" + e.getMessage()));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static native boolean matrixMultDenseDense(double[] var0, double[] var1, double[] var2, int var3, int var4, int var5, int var6);

    private static native boolean tsmm(double[] var0, double[] var1, int var2, int var3, boolean var4, int var5);

    public static native int conv2dDense(double[] var0, double[] var1, double[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static native int conv2dBiasAddDense(double[] var0, double[] var1, double[] var2, double[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    public static native int conv2dBackwardFilterDense(double[] var0, double[] var1, double[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static native int conv2dBackwardDataDense(double[] var0, double[] var1, double[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static native boolean conv2dBackwardFilterSparseDense(int var0, int var1, int[] var2, double[] var3, double[] var4, double[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19);

    public static native boolean conv2dSparse(int var0, int var1, int[] var2, double[] var3, double[] var4, double[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19);

    private static native void setMaxNumThreads(int var0);

    static {
        maxNumThreads = -1;
        setMaxNumThreads = false;
        supportedArchitectures.put("x86_64", "x86_64");
        supportedArchitectures.put("amd64", "x86_64");
        attemptedLoading = false;
        hintOnFailures = "";
    }
}

