/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.dropout.Forward_output;

public class Dropout
extends Script {
    public Dropout() {
        String string = "scripts/nn/layers/dropout.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Forward_output forward(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/dropout.dml') as mlcontextns;[out, mask] = mlcontextns::forward(X, p, seed);";
        Script script = new Script(string);
        script.in("X", object).in("p", object2).in("seed", object3).out("out").out("mask");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        Matrix matrix2 = mLResults.getMatrix("mask");
        Forward_output forward_output = new Forward_output(matrix, matrix2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, double p, int seed)\n    return (matrix[double] out, matrix[double] mask) {\n  /*\n   * Computes the forward pass for an inverted dropout layer.\n   *\n   * Drops the inputs element-wise with a probability p, and divides\n   * by p to maintain the expected values of those inputs (which are\n   * the outputs of neurons) at test time.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - p: Probability of keeping a neuron output.\n   *  - seed: [Optional: -1] Random number generator seed to allow for\n   *      deterministic evaluation.  Set to -1 for a random seed.\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as `X`.\n   *  - mask: Dropout mask used to compute the output.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, double p, int seed)\n    return (matrix[double] out, matrix[double] mask) {\n  /*\n   * Computes the forward pass for an inverted dropout layer.\n   *\n   * Drops the inputs element-wise with a probability p, and divides\n   * by p to maintain the expected values of those inputs (which are\n   * the outputs of neurons) at test time.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - p: Probability of keeping a neuron output.\n   *  - seed: [Optional: -1] Random number generator seed to allow for\n   *      deterministic evaluation.  Set to -1 for a random seed.\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as `X`.\n   *  - mask: Dropout mask used to compute the output.\n   */\n  # Normally, we might use something like\n  #    `mask = rand(rows=nrow(X), cols=ncol(X), min=0, max=1, seed=seed) <= p`\n  # to create a dropout mask.  Fortunately, SystemML has a `sparsity` parameter on\n  # the `rand` function that allows use to create a mask directly.\n  if (seed == -1) {\n    mask = rand(rows=nrow(X), cols=ncol(X), min=1, max=1, sparsity=p)\n  } else {\n    mask = rand(rows=nrow(X), cols=ncol(X), min=1, max=1, sparsity=p, seed=seed)\n  }\n  out = X * mask / p\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/nn/layers/dropout.dml') as mlcontextns;dX = mlcontextns::backward(dout, X, p, mask);";
        Script script = new Script(string);
        script.in("dout", object).in("X", object2).in("p", object3).in("mask", object4).out("dX");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] X, double p, matrix[double] mask)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for an inverted dropout layer.\n   *\n   * Applies the mask to the upstream gradient, and divides by p to\n   * maintain the expected values at test time.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out`, of same shape as `X`.\n   *  - X: Inputs, of shape (any, any).\n   *  - p: Probability of keeping a neuron output.\n   *  - mask: Dropout mask used to compute the output.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] X, double p, matrix[double] mask)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for an inverted dropout layer.\n   *\n   * Applies the mask to the upstream gradient, and divides by p to\n   * maintain the expected values at test time.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out`, of same shape as `X`.\n   *  - X: Inputs, of shape (any, any).\n   *  - p: Probability of keeping a neuron output.\n   *  - mask: Dropout mask used to compute the output.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n  dX = mask / p * dout\n}\n";
        return string;
    }
}

