/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public class UnaryInstruction
extends UnaryMRInstructionBase {
    public UnaryInstruction(Operator op, byte in, byte out, String istr) {
        super(op, in, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.Unary;
        this.instString = istr;
    }

    public static UnaryInstruction parseInstruction(String str) throws DMLRuntimeException {
        String opcode = InstructionUtils.getOpCode(str);
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionParts(str);
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        if (InstructionUtils.isBuiltinFunction(opcode)) {
            UnaryOperator unary = new UnaryOperator(Builtin.getBuiltinFnObject(opcode));
            return new UnaryInstruction(unary, in, out, str);
        }
        return new UnaryInstruction(null, in, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue in : blkList) {
                if (in == null) continue;
                IndexedMatrixValue out = this.input == this.output ? tempValue : cachedValues.holdPlace(this.output, valueClass);
                out.getIndexes().setIndexes(in.getIndexes());
                OperationsOnMatrixValues.performUnaryIgnoreIndexes(in.getValue(), out.getValue(), (UnaryOperator)this.optr);
                if (out != tempValue) continue;
                cachedValues.add(this.output, out);
            }
        }
    }
}

