/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.opt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.TernaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.codegen.opt.InterestingPoint;
import org.apache.sysml.hops.codegen.opt.PlanAnalyzer;
import org.apache.sysml.hops.codegen.opt.PlanPartition;
import org.apache.sysml.hops.codegen.opt.PlanSelection;
import org.apache.sysml.hops.codegen.opt.ReachabilityGraph;
import org.apache.sysml.hops.codegen.template.CPlanMemoTable;
import org.apache.sysml.hops.codegen.template.TemplateBase;
import org.apache.sysml.hops.codegen.template.TemplateOuterProduct;
import org.apache.sysml.hops.codegen.template.TemplateRow;
import org.apache.sysml.hops.codegen.template.TemplateUtils;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.runtime.codegen.LibSpoofPrimitives;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.Statistics;

public class PlanSelectionFuseCostBasedV2
extends PlanSelection {
    private static final Log LOG = LogFactory.getLog((String)PlanSelectionFuseCostBasedV2.class.getName());
    private static final double WRITE_BANDWIDTH = 2.147483648E9;
    private static final double READ_BANDWIDTH = 3.4359738368E10;
    private static final double COMPUTE_BANDWIDTH = 2.147483648E9 * (double)InfrastructureAnalyzer.getLocalParallelism();
    private static final double SPARSE_SAFE_SPARSITY_EST = 0.1;
    private static final boolean USE_COST_PRUNING = true;
    private static final boolean USE_STRUCTURAL_PRUNING = true;
    private static final IDSequence COST_ID = new IDSequence();
    private static final TemplateRow ROW_TPL = new TemplateRow();
    private static final PlanSelection.BasicPlanComparator BASE_COMPARE = new PlanSelection.BasicPlanComparator();
    private final PlanSelection.TypedPlanComparator _typedCompare = new PlanSelection.TypedPlanComparator();

    @Override
    public void selectPlans(CPlanMemoTable memo, ArrayList<Hop> roots) {
        Collection<PlanPartition> parts = PlanAnalyzer.analyzePlanPartitions(memo, roots, true);
        for (PlanPartition planPartition : parts) {
            PlanSelectionFuseCostBasedV2.createAndAddMultiAggPlans(memo, planPartition.getPartition(), planPartition.getRoots());
            this.selectPlans(memo, planPartition);
        }
        this.createAndAddMultiAggPlans(memo, roots);
        for (Map.Entry entry : this.getBestPlans().entrySet()) {
            memo.setDistinct((Long)entry.getKey(), (List)entry.getValue());
        }
    }

    private void selectPlans(CPlanMemoTable memo, PlanPartition part) {
        PlanSelectionFuseCostBasedV2.pruneInvalidAndSpecialCasePlans(memo, part);
        if (part.getMatPointsExt() == null || part.getMatPointsExt().length == 0) {
            for (Long hopID : part.getRoots()) {
                this.rSelectPlansFuseAll(memo, memo.getHopRefs().get(hopID), null, part.getPartition());
            }
        } else {
            HashMap<Long, Double> computeCosts = new HashMap<Long, Double>();
            for (Long hopID : part.getPartition()) {
                PlanSelectionFuseCostBasedV2.getComputeCosts(memo.getHopRefs().get(hopID), computeCosts);
            }
            StaticCosts costs = new StaticCosts(computeCosts, PlanSelectionFuseCostBasedV2.getComputeCost(computeCosts, memo), PlanSelectionFuseCostBasedV2.getReadCost(part, memo), PlanSelectionFuseCostBasedV2.getWriteCost(part.getRoots(), memo));
            ReachabilityGraph rgraph = new ReachabilityGraph(part, memo);
            part.setMatPointsExt(rgraph.getSortedSearchSpace());
            for (Long hopID : part.getPartition()) {
                memo.pruneRedundant(hopID, true, part.getMatPointsExt());
            }
            boolean[] bestPlan = PlanSelectionFuseCostBasedV2.enumPlans(memo, part, costs, rgraph, part.getMatPointsExt(), 0, Double.MAX_VALUE);
            HashSet<Long> visited = new HashSet<Long>();
            for (Long hopID : part.getRoots()) {
                PlanSelectionFuseCostBasedV2.rPruneSuboptimalPlans(memo, memo.getHopRefs().get(hopID), visited, part, part.getMatPointsExt(), bestPlan);
            }
            HashSet<Long> visited2 = new HashSet<Long>();
            for (Long hopID : part.getRoots()) {
                PlanSelectionFuseCostBasedV2.rPruneInvalidPlans(memo, memo.getHopRefs().get(hopID), visited2, part, bestPlan);
            }
            for (Long hopID : part.getRoots()) {
                this.rSelectPlansFuseAll(memo, memo.getHopRefs().get(hopID), null, part.getPartition());
            }
        }
    }

    private static boolean[] enumPlans(CPlanMemoTable memo, PlanPartition part, StaticCosts costs, ReachabilityGraph rgraph, InterestingPoint[] matPoints, int off, double bestC) {
        long len = UtilFunctions.pow(2, matPoints.length - off);
        boolean[] bestPlan = null;
        long numEvalPlans = 0L;
        long numEvalPartPlans = 0L;
        for (long i = 0L; i < len; ++i) {
            boolean[] plan = PlanSelectionFuseCostBasedV2.createAssignment(matPoints.length - off, off, i);
            long pskip = 0L;
            if (rgraph != null && rgraph.isCutSet(plan)) {
                pskip = rgraph.getNumSkipPlans(plan);
                ReachabilityGraph.SubProblem[] prob = rgraph.getSubproblems(plan);
                for (int j = 0; j < prob.length; ++j) {
                    boolean[] bestTmp = PlanSelectionFuseCostBasedV2.enumPlans(memo, part, costs, null, prob[j].freeMat, prob[j].offset, bestC);
                    LibSpoofPrimitives.vectWrite(bestTmp, plan, prob[j].freePos);
                }
            } else {
                double lbC = Math.max(costs._read, costs._compute) + costs._write + PlanSelectionFuseCostBasedV2.getMaterializationCost(part, matPoints, memo, plan);
                if (lbC >= bestC) {
                    long skip = PlanSelectionFuseCostBasedV2.getNumSkipPlans(plan);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Enum: Skip " + skip + " plans (by cost)."));
                    }
                    i += skip - 1L;
                    continue;
                }
            }
            double C = PlanSelectionFuseCostBasedV2.getPlanCost(memo, part, matPoints, plan, costs._computeCosts, bestC);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Enum: " + Arrays.toString(plan) + " -> " + C));
            }
            numEvalPartPlans += C == Double.POSITIVE_INFINITY ? 1L : 0L;
            ++numEvalPlans;
            if (bestPlan == null || C < bestC) {
                bestC = C;
                bestPlan = plan;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"Enum: Found new best plan.");
                }
            }
            i += pskip;
            if (pskip == 0L || !LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Enum: Skip " + pskip + " plans (by structure)."));
        }
        if (DMLScript.STATISTICS) {
            Statistics.incrementCodegenEnumAll(rgraph != null ? len : 0L);
            Statistics.incrementCodegenEnumEval(numEvalPlans);
            Statistics.incrementCodegenEnumEvalP(numEvalPartPlans);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Enum: Optimal plan: " + Arrays.toString(bestPlan)));
        }
        return bestPlan == null ? new boolean[matPoints.length - off] : Arrays.copyOfRange(bestPlan, off, bestPlan.length);
    }

    private static boolean[] createAssignment(int len, int off, long pos) {
        boolean[] ret = new boolean[off + len];
        Arrays.fill(ret, 0, off, true);
        long tmp = pos;
        for (int i = 0; i < len; ++i) {
            long mask = UtilFunctions.pow(2, len - i - 1);
            ret[off + i] = tmp >= mask;
            tmp %= mask;
        }
        return ret;
    }

    private static long getNumSkipPlans(boolean[] plan) {
        int pos = ArrayUtils.lastIndexOf((boolean[])plan, (boolean)true);
        return UtilFunctions.pow(2, plan.length - pos - 1);
    }

    private static double getMaterializationCost(PlanPartition part, InterestingPoint[] M, CPlanMemoTable memo, boolean[] plan) {
        double costs = 0.0;
        HashSet<Long> matTargets = new HashSet<Long>();
        for (int i = 0; i < plan.length; ++i) {
            long hopID = M[i].getToHopID();
            if (!plan[i] || matTargets.contains(hopID)) continue;
            matTargets.add(hopID);
            Hop hop = memo.getHopRefs().get(hopID);
            long size = PlanSelectionFuseCostBasedV2.getSize(hop);
            costs += (double)(size * 8L) / 2.147483648E9 + (double)(size * 8L) / 3.4359738368E10;
        }
        for (Long hopID : part.getExtConsumed()) {
            if (matTargets.contains(hopID)) continue;
            matTargets.add(hopID);
            Hop hop = memo.getHopRefs().get(hopID);
            costs += (double)(PlanSelectionFuseCostBasedV2.getSize(hop) * 8L) / 2.147483648E9;
        }
        return costs;
    }

    private static double getReadCost(PlanPartition part, CPlanMemoTable memo) {
        double costs = 0.0;
        for (Long hopID : part.getInputs()) {
            Hop hop = memo.getHopRefs().get(hopID);
            costs += (double)(PlanSelectionFuseCostBasedV2.getSize(hop) * 8L) / 3.4359738368E10;
        }
        return costs;
    }

    private static double getWriteCost(Collection<Long> R, CPlanMemoTable memo) {
        double costs = 0.0;
        for (Long hopID : R) {
            Hop hop = memo.getHopRefs().get(hopID);
            costs += (double)(PlanSelectionFuseCostBasedV2.getSize(hop) * 8L) / 2.147483648E9;
        }
        return costs;
    }

    private static double getComputeCost(HashMap<Long, Double> computeCosts, CPlanMemoTable memo) {
        double costs = 0.0;
        for (Map.Entry<Long, Double> e : computeCosts.entrySet()) {
            Hop mainInput = memo.getHopRefs().get(e.getKey()).getInput().get(0);
            costs += (double)PlanSelectionFuseCostBasedV2.getSize(mainInput) * e.getValue() / COMPUTE_BANDWIDTH;
        }
        return costs;
    }

    private static long getSize(Hop hop) {
        return Math.max(hop.getDim1(), 1L) * Math.max(hop.getDim2(), 1L);
    }

    private static void createAndAddMultiAggPlans(CPlanMemoTable memo, HashSet<Long> partition, HashSet<Long> R) {
        HashSet<Long> refHops = new HashSet<Long>();
        for (Map.Entry<Long, List<CPlanMemoTable.MemoTableEntry>> e : memo.getPlans().entrySet()) {
            if (e.getValue().isEmpty()) continue;
            Hop hop = memo.getHopRefs().get(e.getKey());
            for (Hop c : hop.getInput()) {
                refHops.add(c.getHopID());
            }
        }
        ArrayList<Long> fullAggs = new ArrayList<Long>();
        for (Long hopID : R) {
            Hop root = memo.getHopRefs().get(hopID);
            if (refHops.contains(hopID) || !PlanSelectionFuseCostBasedV2.isMultiAggregateRoot(root)) continue;
            fullAggs.add(hopID);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found within-partition ua(RC) aggregations: " + Arrays.toString((Object[])fullAggs.toArray(new Long[0]))));
        }
        for (int i = 0; i < fullAggs.size(); i += 3) {
            int ito = Math.min(i + 3, fullAggs.size());
            if (ito - i < 2) continue;
            CPlanMemoTable.MemoTableEntry me = new CPlanMemoTable.MemoTableEntry(TemplateBase.TemplateType.MAGG, (Long)fullAggs.get(i), (Long)fullAggs.get(i + 1), ito - i == 3 ? (Long)fullAggs.get(i + 2) : -1L, ito - i);
            if (PlanSelectionFuseCostBasedV2.isValidMultiAggregate(memo, me)) {
                for (int j = i; j < ito; ++j) {
                    memo.add(memo.getHopRefs().get(fullAggs.get(j)), me);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Added multiagg plan: " + fullAggs.get(j) + " " + me));
                }
                continue;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Removed invalid multiagg plan: " + me));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createAndAddMultiAggPlans(CPlanMemoTable memo, ArrayList<Hop> roots) {
        boolean bl;
        HashSet<Long> fullAggs = new HashSet<Long>();
        Hop.resetVisitStatus(roots);
        for (Hop hop : roots) {
            PlanSelectionFuseCostBasedV2.rCollectFullAggregates(hop, fullAggs);
        }
        Hop.resetVisitStatus(roots);
        fullAggs.removeIf(p -> memo.contains((long)p, TemplateBase.TemplateType.MAGG));
        if (fullAggs.size() <= 1) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found across-partition ua(RC) aggregations: " + Arrays.toString((Object[])fullAggs.toArray(new Long[0]))));
        }
        List<Object> aggInfos = new ArrayList();
        for (Long l : fullAggs) {
            Hop hop = memo.getHopRefs().get(l);
            AggregateInfo tmp = new AggregateInfo(hop);
            for (int i = 0; i < hop.getInput().size(); ++i) {
                Hop c = HopRewriteUtils.isMatrixMultiply(hop) && i == 0 ? hop.getInput().get(0).getInput().get(0) : hop.getInput().get(i);
                PlanSelectionFuseCostBasedV2.rExtractAggregateInfo(memo, c, tmp, TemplateBase.TemplateType.CELL);
            }
            if (tmp._fusedInputs.isEmpty()) {
                if (HopRewriteUtils.isMatrixMultiply(hop)) {
                    tmp.addFusedInput(hop.getInput().get(0).getInput().get(0).getHopID());
                    tmp.addFusedInput(hop.getInput().get(1).getHopID());
                } else {
                    tmp.addFusedInput(hop.getInput().get(0).getHopID());
                }
            }
            aggInfos.add(tmp);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Extracted across-partition ua(RC) aggregation info: ");
            for (AggregateInfo aggregateInfo : aggInfos) {
                LOG.trace((Object)aggregateInfo);
            }
        }
        aggInfos = aggInfos.stream().sorted(Comparator.comparing(a -> a._inputAggs.size())).collect(Collectors.toList());
        boolean bl2 = false;
        while (!bl) {
            void var6_16;
            Object var6_15 = null;
            for (int i = 0; i < aggInfos.size(); ++i) {
                AggregateInfo current = (AggregateInfo)aggInfos.get(i);
                for (int j = i + 1; j < aggInfos.size(); ++j) {
                    AggregateInfo that = (AggregateInfo)aggInfos.get(j);
                    if (!current.isMergable(that)) continue;
                    AggregateInfo aggregateInfo = current.merge(that);
                    aggInfos.remove(j);
                    --j;
                }
            }
            bl = var6_16 == null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Merged across-partition ua(RC) aggregation info: ");
            for (AggregateInfo aggregateInfo : aggInfos) {
                LOG.trace((Object)aggregateInfo);
            }
        }
        for (AggregateInfo aggregateInfo : aggInfos) {
            if (aggregateInfo._aggregates.size() <= 1) continue;
            Long[] aggs = aggregateInfo._aggregates.keySet().toArray(new Long[0]);
            CPlanMemoTable.MemoTableEntry me = new CPlanMemoTable.MemoTableEntry(TemplateBase.TemplateType.MAGG, aggs[0], aggs[1], aggs.length > 2 ? aggs[2] : -1L, aggs.length);
            for (int i = 0; i < aggs.length; ++i) {
                memo.add(memo.getHopRefs().get(aggs[i]), me);
                this.addBestPlan(aggs[i], me);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Added multiagg* plan: " + aggs[i] + " " + me));
            }
        }
    }

    private static boolean isMultiAggregateRoot(Hop root) {
        return HopRewriteUtils.isAggUnaryOp(root, Hop.AggOp.SUM, Hop.AggOp.SUM_SQ, Hop.AggOp.MIN, Hop.AggOp.MAX) && ((AggUnaryOp)root).getDirection() == Hop.Direction.RowCol || root instanceof AggBinaryOp && root.getDim1() == 1L && root.getDim2() == 1L && HopRewriteUtils.isTransposeOperation(root.getInput().get(0));
    }

    private static boolean isValidMultiAggregate(CPlanMemoTable memo, CPlanMemoTable.MemoTableEntry me) {
        int i;
        boolean ret = true;
        Hop refSize = memo.getHopRefs().get(me.input1).getInput().get(0);
        for (i = 1; ret && i < 3; ++i) {
            if (!me.isPlanRef(i)) continue;
            ret &= HopRewriteUtils.isEqualSize(refSize, memo.getHopRefs().get(me.input(i)).getInput().get(0));
        }
        for (i = 0; ret && i < 3; ++i) {
            if (!me.isPlanRef(i)) continue;
            HashSet<Long> probe = new HashSet<Long>();
            for (int j = 0; j < 3; ++j) {
                if (i == j) continue;
                probe.add(me.input(j));
            }
            ret &= PlanSelectionFuseCostBasedV2.rCheckMultiAggregate(memo.getHopRefs().get(me.input(i)), probe);
        }
        return ret;
    }

    private static boolean rCheckMultiAggregate(Hop current, HashSet<Long> probe) {
        boolean ret = true;
        for (Hop c : current.getInput()) {
            ret &= PlanSelectionFuseCostBasedV2.rCheckMultiAggregate(c, probe);
        }
        return ret &= !probe.contains(current.getHopID());
    }

    private static void rCollectFullAggregates(Hop current, HashSet<Long> aggs) {
        if (current.isVisited()) {
            return;
        }
        if (PlanSelectionFuseCostBasedV2.isMultiAggregateRoot(current)) {
            aggs.add(current.getHopID());
        }
        for (Hop c : current.getInput()) {
            PlanSelectionFuseCostBasedV2.rCollectFullAggregates(c, aggs);
        }
        current.setVisited();
    }

    private static void rExtractAggregateInfo(CPlanMemoTable memo, Hop current, AggregateInfo aggInfo, TemplateBase.TemplateType type) {
        if (PlanSelectionFuseCostBasedV2.isMultiAggregateRoot(current)) {
            aggInfo.addInputAggregate(current.getHopID());
        }
        CPlanMemoTable.MemoTableEntry me = type != null ? memo.getBest(current.getHopID()) : null;
        for (int i = 0; i < current.getInput().size(); ++i) {
            Hop c = current.getInput().get(i);
            if (me != null && me.isPlanRef(i)) {
                PlanSelectionFuseCostBasedV2.rExtractAggregateInfo(memo, c, aggInfo, type);
                continue;
            }
            if (type != null && c.getDataType().isMatrix()) {
                aggInfo.addFusedInput(c.getHopID());
            }
            PlanSelectionFuseCostBasedV2.rExtractAggregateInfo(memo, c, aggInfo, null);
        }
    }

    private static boolean isRowTemplateWithoutAgg(CPlanMemoTable memo, Hop current, HashSet<Long> visited) {
        CPlanMemoTable.MemoTableEntry me = memo.getBest(current.getHopID(), TemplateBase.TemplateType.ROW);
        boolean ret = true;
        for (int i = 0; i < 3; ++i) {
            if (!me.isPlanRef(i)) continue;
            ret &= PlanSelectionFuseCostBasedV2.rIsRowTemplateWithoutAgg(memo, current.getInput().get(i), visited);
        }
        return ret;
    }

    private static boolean rIsRowTemplateWithoutAgg(CPlanMemoTable memo, Hop current, HashSet<Long> visited) {
        if (visited.contains(current.getHopID())) {
            return true;
        }
        boolean ret = true;
        CPlanMemoTable.MemoTableEntry me = memo.getBest(current.getHopID(), TemplateBase.TemplateType.ROW);
        for (int i = 0; i < 3; ++i) {
            if (me == null || !me.isPlanRef(i)) continue;
            ret &= PlanSelectionFuseCostBasedV2.rIsRowTemplateWithoutAgg(memo, current.getInput().get(i), visited);
        }
        boolean bl = !(current instanceof AggUnaryOp) && !(current instanceof AggBinaryOp);
        visited.add(current.getHopID());
        return ret &= bl;
    }

    private static void pruneInvalidAndSpecialCasePlans(CPlanMemoTable memo, PlanPartition part) {
        if (OptimizerUtils.isSparkExecutionMode()) {
            for (Long hopID : part.getPartition()) {
                if (!memo.contains(hopID, TemplateBase.TemplateType.ROW)) continue;
                Hop hop = memo.getHopRefs().get(hopID);
                boolean isSpark = DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SPARK || OptimizerUtils.getTotalMemEstimate(hop.getInput().toArray(new Hop[0]), hop) > OptimizerUtils.getLocalMemBudget();
                boolean validNcol = true;
                for (Hop in : hop.getInput()) {
                    validNcol &= in.getDataType().isScalar() || in.getDim2() <= in.getColsInBlock() || hop instanceof AggBinaryOp && in.getDim1() <= in.getRowsInBlock() && HopRewriteUtils.isTransposeOperation(in);
                }
                if (!isSpark || validNcol) continue;
                List<CPlanMemoTable.MemoTableEntry> blacklist = memo.get(hopID, TemplateBase.TemplateType.ROW);
                memo.remove(memo.getHopRefs().get(hopID), new HashSet<CPlanMemoTable.MemoTableEntry>(blacklist));
                if (!memo.contains(hopID)) {
                    memo.removeAllRefTo(hopID);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Removed row memo table entries w/ violated blocksize constraint (" + hopID + "): " + Arrays.toString(blacklist.toArray(new CPlanMemoTable.MemoTableEntry[0]))));
            }
        }
        for (Long hopID : part.getPartition()) {
            CPlanMemoTable.MemoTableEntry me = memo.getBest(hopID, TemplateBase.TemplateType.ROW);
            if (me == null || me.type != TemplateBase.TemplateType.ROW || !memo.contains(hopID, TemplateBase.TemplateType.CELL) || !PlanSelectionFuseCostBasedV2.isRowTemplateWithoutAgg(memo, memo.getHopRefs().get(hopID), new HashSet<Long>())) continue;
            List<CPlanMemoTable.MemoTableEntry> blacklist = memo.get(hopID, TemplateBase.TemplateType.ROW);
            memo.remove(memo.getHopRefs().get(hopID), new HashSet<CPlanMemoTable.MemoTableEntry>(blacklist));
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Removed row memo table entries w/o aggregation: " + Arrays.toString(blacklist.toArray(new CPlanMemoTable.MemoTableEntry[0]))));
        }
        for (Long hopID : part.getPartition()) {
            CPlanMemoTable.MemoTableEntry me2;
            List<CPlanMemoTable.MemoTableEntry> entries;
            CPlanMemoTable.MemoTableEntry me1;
            CPlanMemoTable.MemoTableEntry rmEntry;
            if (memo.countEntries(hopID, TemplateBase.TemplateType.OUTER) != 2 || (rmEntry = TemplateOuterProduct.dropAlternativePlan(memo, me1 = (entries = memo.get(hopID, TemplateBase.TemplateType.OUTER)).get(0), me2 = entries.get(1))) == null) continue;
            memo.remove(memo.getHopRefs().get(hopID), Collections.singleton(rmEntry));
            memo.getPlansBlacklisted().remove(rmEntry.input(rmEntry.getPlanRefIndex()));
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Removed dominated outer product memo table entry: " + rmEntry));
        }
    }

    private static void rPruneSuboptimalPlans(CPlanMemoTable memo, Hop current, HashSet<Long> visited, PlanPartition part, InterestingPoint[] matPoints, boolean[] plan) {
        if (visited.contains(current.getHopID())) {
            return;
        }
        long hopID = current.getHopID();
        if (part.getPartition().contains(hopID) && memo.contains(hopID)) {
            Iterator<CPlanMemoTable.MemoTableEntry> iter = memo.get(hopID).iterator();
            while (iter.hasNext()) {
                CPlanMemoTable.MemoTableEntry me = iter.next();
                if (PlanSelectionFuseCostBasedV2.hasNoRefToMatPoint(hopID, me, matPoints, plan) || me.type == TemplateBase.TemplateType.OUTER) continue;
                iter.remove();
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Removed memo table entry: " + me));
            }
        }
        for (Hop c : current.getInput()) {
            PlanSelectionFuseCostBasedV2.rPruneSuboptimalPlans(memo, c, visited, part, matPoints, plan);
        }
        visited.add(current.getHopID());
    }

    private static void rPruneInvalidPlans(CPlanMemoTable memo, Hop current, HashSet<Long> visited, PlanPartition part, boolean[] plan) {
        if (visited.contains(current.getHopID())) {
            return;
        }
        for (Hop c : current.getInput()) {
            PlanSelectionFuseCostBasedV2.rPruneInvalidPlans(memo, c, visited, part, plan);
        }
        long hopID = current.getHopID();
        if (part.getPartition().contains(hopID) && memo.contains(hopID, TemplateBase.TemplateType.ROW)) {
            for (CPlanMemoTable.MemoTableEntry me : memo.get(hopID)) {
                if (me.type != TemplateBase.TemplateType.ROW) continue;
                if (!me.hasPlanRef() && !TemplateUtils.hasMatrixInput(current)) {
                    me.type = TemplateBase.TemplateType.CELL;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Converted leaf memo table entry from row to cell: " + me));
                    }
                }
                if (!me.hasPlanRef() || ROW_TPL.open(current)) continue;
                boolean hasRowInput = false;
                for (int i = 0; i < 3; ++i) {
                    if (!me.isPlanRef(i)) continue;
                    hasRowInput |= memo.contains(me.input(i), TemplateBase.TemplateType.ROW);
                }
                if (hasRowInput) continue;
                me.type = TemplateBase.TemplateType.CELL;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Converted inner memo table entry from row to cell: " + me));
            }
        }
        visited.add(current.getHopID());
    }

    private void rSelectPlansFuseAll(CPlanMemoTable memo, Hop current, TemplateBase.TemplateType currentType, HashSet<Long> partition) {
        if (this.isVisited(current.getHopID(), currentType) || !partition.contains(current.getHopID())) {
            return;
        }
        if (memo.contains(current.getHopID())) {
            HashSet<CPlanMemoTable.MemoTableEntry> rmSet = new HashSet<CPlanMemoTable.MemoTableEntry>();
            List<CPlanMemoTable.MemoTableEntry> hopP = memo.get(current.getHopID());
            for (CPlanMemoTable.MemoTableEntry e1 : hopP) {
                for (CPlanMemoTable.MemoTableEntry e2 : hopP) {
                    if (e1 == e2 || !e1.subsumes(e2)) continue;
                    rmSet.add(e2);
                }
            }
            memo.remove(current, rmSet);
        }
        CPlanMemoTable.MemoTableEntry best = null;
        if (memo.contains(current.getHopID())) {
            if (currentType == null) {
                best = memo.get(current.getHopID()).stream().filter(p -> PlanSelectionFuseCostBasedV2.isValid(p, current)).min(BASE_COMPARE).orElse(null);
            } else {
                this._typedCompare.setType(currentType);
                best = memo.get(current.getHopID()).stream().filter(p -> p.type == currentType || p.type == TemplateBase.TemplateType.CELL).min(this._typedCompare).orElse(null);
            }
            this.addBestPlan(current.getHopID(), best);
        }
        for (int i = 0; i < current.getInput().size(); ++i) {
            TemplateBase.TemplateType pref = best != null && best.isPlanRef(i) ? best.type : null;
            this.rSelectPlansFuseAll(memo, current.getInput().get(i), pref, partition);
        }
        this.setVisited(current.getHopID(), currentType);
    }

    private static double getPlanCost(CPlanMemoTable memo, PlanPartition part, InterestingPoint[] matPoints, boolean[] plan, HashMap<Long, Double> computeCosts, double costBound) {
        HashSet<PlanSelection.VisitMarkCost> visited = new HashSet<PlanSelection.VisitMarkCost>();
        double costs = 0.0;
        int rem = part.getRoots().size();
        for (Long hopID : part.getRoots()) {
            if (!((costs += PlanSelectionFuseCostBasedV2.rGetPlanCosts(memo, memo.getHopRefs().get(hopID), visited, part, matPoints, plan, computeCosts, null, null, costBound - costs)) >= costBound) || --rem <= 0) continue;
            return Double.POSITIVE_INFINITY;
        }
        return costs;
    }

    private static double rGetPlanCosts(CPlanMemoTable memo, Hop current, HashSet<PlanSelection.VisitMarkCost> visited, PlanPartition part, InterestingPoint[] matPoints, boolean[] plan, HashMap<Long, Double> computeCosts, CostVector costsCurrent, TemplateBase.TemplateType currentType, double costBound) {
        int i;
        boolean opened;
        long currentHopId = current.getHopID();
        if (!visited.add(new PlanSelection.VisitMarkCost(currentHopId, costsCurrent == null || currentType == TemplateBase.TemplateType.MAGG ? 0L : costsCurrent.ID))) {
            return 0.0;
        }
        CPlanMemoTable.MemoTableEntry best = null;
        boolean bl = opened = currentType == null;
        if (memo.contains(currentHopId)) {
            if (currentType == null) {
                for (CPlanMemoTable.MemoTableEntry me : memo.get(currentHopId)) {
                    best = PlanSelectionFuseCostBasedV2.isValid(me, current) && PlanSelectionFuseCostBasedV2.hasNoRefToMatPoint(currentHopId, me, matPoints, plan) && PlanSelection.BasicPlanComparator.icompare(me, best) < 0 ? me : best;
                }
                opened = true;
            } else {
                for (CPlanMemoTable.MemoTableEntry me : memo.get(currentHopId)) {
                    best = (me.type == currentType || me.type == TemplateBase.TemplateType.CELL) && PlanSelectionFuseCostBasedV2.hasNoRefToMatPoint(currentHopId, me, matPoints, plan) && PlanSelection.TypedPlanComparator.icompare(me, best, currentType) < 0 ? me : best;
                }
            }
        }
        CostVector costVect = !opened ? costsCurrent : new CostVector(PlanSelectionFuseCostBasedV2.getSize(current));
        double costs = 0.0;
        if (opened && best != null && best.type == TemplateBase.TemplateType.MAGG) {
            if (best.input1 == currentHopId) {
                for (i = 1; i < 3; ++i) {
                    if (!best.isPlanRef(i) || !((costs += PlanSelectionFuseCostBasedV2.rGetPlanCosts(memo, memo.getHopRefs().get(best.input(i)), visited, part, matPoints, plan, computeCosts, costVect, TemplateBase.TemplateType.MAGG, costBound - costs)) >= costBound)) continue;
                    return Double.POSITIVE_INFINITY;
                }
            } else {
                return 0.0;
            }
        }
        costVect.computeCosts += computeCosts.get(currentHopId).doubleValue();
        for (i = 0; i < current.getInput().size(); ++i) {
            Hop c = current.getInput().get(i);
            if (best != null && best.isPlanRef(i)) {
                costs += PlanSelectionFuseCostBasedV2.rGetPlanCosts(memo, c, visited, part, matPoints, plan, computeCosts, costVect, best.type, costBound - costs);
            } else if (best != null && PlanSelectionFuseCostBasedV2.isImplicitlyFused(current, i, best.type)) {
                costVect.addInputSize(c.getInput().get(0).getHopID(), PlanSelectionFuseCostBasedV2.getSize(c));
            } else {
                if (part.getPartition().contains(c.getHopID())) {
                    costs += PlanSelectionFuseCostBasedV2.rGetPlanCosts(memo, c, visited, part, matPoints, plan, computeCosts, null, null, costBound - costs);
                }
                if (costVect != null && c.getDataType().isMatrix()) {
                    costVect.addInputSize(c.getHopID(), PlanSelectionFuseCostBasedV2.getSize(c));
                }
            }
            if (!(costs >= costBound)) continue;
            return Double.POSITIVE_INFINITY;
        }
        if (opened) {
            if (LOG.isTraceEnabled()) {
                String type = best != null ? best.type.name() : "HOP";
                LOG.trace((Object)("Cost vector (" + type + " " + currentHopId + "): " + costVect));
            }
            double tmpCosts = costVect.outSize * 8.0 / 2.147483648E9 + Math.max(costVect.getSumInputSizes() * 8.0 / 3.4359738368E10, costVect.computeCosts * costVect.getMaxInputSize() / COMPUTE_BANDWIDTH);
            if (best != null && best.type == TemplateBase.TemplateType.OUTER) {
                Hop driver = memo.getHopRefs().get(costVect.getMaxInputSizeHopID());
                tmpCosts *= driver.dimsKnown(true) ? driver.getSparsity() : 0.1;
            }
            costs += tmpCosts;
        } else if (part.getExtConsumed().contains(current.getHopID())) {
            costs += PlanSelectionFuseCostBasedV2.rGetPlanCosts(memo, current, visited, part, matPoints, plan, computeCosts, null, null, costBound - costs);
        }
        if (costs < 0.0 || Double.isNaN(costs) || Double.isInfinite(costs)) {
            throw new RuntimeException("Wrong cost estimate: " + costs);
        }
        return costs;
    }

    private static void getComputeCosts(Hop current, HashMap<Long, Double> computeCosts) {
        double costs = 1.0;
        if (current instanceof UnaryOp) {
            switch (((UnaryOp)current).getOp()) {
                case ABS: 
                case ROUND: 
                case CEIL: 
                case FLOOR: 
                case SIGN: 
                case SELP: {
                    costs = 1.0;
                    break;
                }
                case SPROP: 
                case SQRT: {
                    costs = 2.0;
                    break;
                }
                case EXP: {
                    costs = 18.0;
                    break;
                }
                case SIGMOID: {
                    costs = 21.0;
                    break;
                }
                case LOG: 
                case LOG_NZ: {
                    costs = 32.0;
                    break;
                }
                case NCOL: 
                case NROW: 
                case PRINT: 
                case CAST_AS_BOOLEAN: 
                case CAST_AS_DOUBLE: 
                case CAST_AS_INT: 
                case CAST_AS_MATRIX: 
                case CAST_AS_SCALAR: {
                    costs = 1.0;
                    break;
                }
                case SIN: {
                    costs = 18.0;
                    break;
                }
                case COS: {
                    costs = 22.0;
                    break;
                }
                case TAN: {
                    costs = 42.0;
                    break;
                }
                case ASIN: {
                    costs = 93.0;
                    break;
                }
                case ACOS: {
                    costs = 103.0;
                    break;
                }
                case ATAN: {
                    costs = 40.0;
                    break;
                }
                case CUMSUM: 
                case CUMMIN: 
                case CUMMAX: 
                case CUMPROD: {
                    costs = 1.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((UnaryOp)current).getOp())));
                    break;
                }
            }
        } else if (current instanceof BinaryOp) {
            block15 : switch (((BinaryOp)current).getOp()) {
                case MULT: 
                case PLUS: 
                case MINUS: 
                case MIN: 
                case MAX: 
                case AND: 
                case OR: 
                case EQUAL: 
                case NOTEQUAL: 
                case LESS: 
                case LESSEQUAL: 
                case GREATER: 
                case GREATEREQUAL: 
                case CBIND: 
                case RBIND: {
                    costs = 1.0;
                    break;
                }
                case INTDIV: {
                    costs = 6.0;
                    break;
                }
                case MODULUS: {
                    costs = 8.0;
                    break;
                }
                case DIV: {
                    costs = 22.0;
                    break;
                }
                case LOG: 
                case LOG_NZ: {
                    costs = 32.0;
                    break;
                }
                case POW: {
                    costs = HopRewriteUtils.isLiteralOfValue(current.getInput().get(1), 2.0) ? 1 : 16;
                    break;
                }
                case MINUS_NZ: 
                case MINUS1_MULT: {
                    costs = 2.0;
                    break;
                }
                case CENTRALMOMENT: {
                    int type = (int)(current.getInput().get(1) instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)current.getInput().get(1)) : 2L);
                    switch (type) {
                        case 0: {
                            costs = 1.0;
                            break block15;
                        }
                        case 1: {
                            costs = 8.0;
                            break block15;
                        }
                        case 2: {
                            costs = 16.0;
                            break block15;
                        }
                        case 3: {
                            costs = 31.0;
                            break block15;
                        }
                        case 4: {
                            costs = 51.0;
                            break block15;
                        }
                        case 5: {
                            costs = 16.0;
                        }
                    }
                    break;
                }
                case COVARIANCE: {
                    costs = 23.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((BinaryOp)current).getOp())));
                    break;
                }
            }
        } else if (current instanceof TernaryOp) {
            block34 : switch (((TernaryOp)current).getOp()) {
                case PLUS_MULT: 
                case MINUS_MULT: {
                    costs = 2.0;
                    break;
                }
                case CTABLE: {
                    costs = 3.0;
                    break;
                }
                case CENTRALMOMENT: {
                    int type = (int)(current.getInput().get(1) instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)current.getInput().get(1)) : 2L);
                    switch (type) {
                        case 0: {
                            costs = 2.0;
                            break block34;
                        }
                        case 1: {
                            costs = 9.0;
                            break block34;
                        }
                        case 2: {
                            costs = 17.0;
                            break block34;
                        }
                        case 3: {
                            costs = 32.0;
                            break block34;
                        }
                        case 4: {
                            costs = 52.0;
                            break block34;
                        }
                        case 5: {
                            costs = 17.0;
                        }
                    }
                    break;
                }
                case COVARIANCE: {
                    costs = 23.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((TernaryOp)current).getOp())));
                    break;
                }
            }
        } else if (current instanceof ParameterizedBuiltinOp) {
            costs = 1.0;
        } else if (current instanceof IndexingOp) {
            costs = 1.0;
        } else if (current instanceof ReorgOp) {
            costs = 1.0;
        } else if (current instanceof AggBinaryOp) {
            costs = HopRewriteUtils.isOuterProductLikeMM(current) ? (double)(2L * current.getInput().get(0).getDim2()) : (double)(2L * current.getDim2());
        } else if (current instanceof AggUnaryOp) {
            switch (((AggUnaryOp)current).getOp()) {
                case SUM: {
                    costs = 4.0;
                    break;
                }
                case SUM_SQ: {
                    costs = 5.0;
                    break;
                }
                case MIN: 
                case MAX: {
                    costs = 1.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((AggUnaryOp)current).getOp())));
                }
            }
        }
        computeCosts.put(current.getHopID(), costs);
    }

    private static boolean hasNoRefToMatPoint(long hopID, CPlanMemoTable.MemoTableEntry me, InterestingPoint[] M, boolean[] plan) {
        return !InterestingPoint.isMatPoint(M, hopID, me, plan);
    }

    private static boolean isImplicitlyFused(Hop hop, int index, TemplateBase.TemplateType type) {
        return type == TemplateBase.TemplateType.ROW && HopRewriteUtils.isMatrixMultiply(hop) && index == 0 && HopRewriteUtils.isTransposeOperation(hop.getInput().get(index));
    }

    private static class AggregateInfo {
        public final HashMap<Long, Hop> _aggregates;
        public final HashSet<Long> _inputAggs = new HashSet();
        public final HashSet<Long> _fusedInputs = new HashSet();

        public AggregateInfo(Hop aggregate) {
            this._aggregates = new HashMap();
            this._aggregates.put(aggregate.getHopID(), aggregate);
        }

        public void addInputAggregate(long hopID) {
            this._inputAggs.add(hopID);
        }

        public void addFusedInput(long hopID) {
            this._fusedInputs.add(hopID);
        }

        public boolean isMergable(AggregateInfo that) {
            boolean ret = this._aggregates.size() < 3 && this._aggregates.size() + that._aggregates.size() <= 3;
            for (Long hopID : that._aggregates.keySet()) {
                ret &= !this._inputAggs.contains(hopID);
            }
            for (Long hopID : this._aggregates.keySet()) {
                ret &= !that._inputAggs.contains(hopID);
            }
            boolean bl = !CollectionUtils.intersection(this._fusedInputs, that._fusedInputs).isEmpty();
            Hop in1 = this._aggregates.values().iterator().next();
            Hop in2 = that._aggregates.values().iterator().next();
            return (ret &= bl) && HopRewriteUtils.isEqualSize(in1.getInput().get(HopRewriteUtils.isMatrixMultiply(in1) ? 1 : 0), in2.getInput().get(HopRewriteUtils.isMatrixMultiply(in2) ? 1 : 0));
        }

        public AggregateInfo merge(AggregateInfo that) {
            this._aggregates.putAll(that._aggregates);
            this._inputAggs.addAll(that._inputAggs);
            this._fusedInputs.addAll(that._fusedInputs);
            return this;
        }

        public String toString() {
            return "[" + Arrays.toString((Object[])this._aggregates.keySet().toArray(new Long[0])) + ": {" + Arrays.toString((Object[])this._inputAggs.toArray(new Long[0])) + "},{" + Arrays.toString((Object[])this._fusedInputs.toArray(new Long[0])) + "}]";
        }
    }

    private static class StaticCosts {
        public final HashMap<Long, Double> _computeCosts;
        public final double _compute;
        public final double _read;
        public final double _write;

        public StaticCosts(HashMap<Long, Double> allComputeCosts, double computeCost, double readCost, double writeCost) {
            this._computeCosts = allComputeCosts;
            this._compute = computeCost;
            this._read = readCost;
            this._write = writeCost;
        }
    }

    private static class CostVector {
        public final long ID;
        public final double outSize;
        public double computeCosts = 0.0;
        public final HashMap<Long, Double> inSizes = new HashMap();

        public CostVector(double outputSize) {
            this.ID = COST_ID.getNextID();
            this.outSize = outputSize;
        }

        public void addInputSize(long hopID, double inputSize) {
            this.inSizes.put(hopID, inputSize);
        }

        public double getSumInputSizes() {
            return this.inSizes.values().stream().mapToDouble(d -> d).sum();
        }

        public double getMaxInputSize() {
            return this.inSizes.values().stream().mapToDouble(d -> d).max().orElse(0.0);
        }

        public long getMaxInputSizeHopID() {
            long id = -1L;
            double max = 0.0;
            for (Map.Entry<Long, Double> e : this.inSizes.entrySet()) {
                if (!(max < e.getValue())) continue;
                id = e.getKey();
                max = e.getValue();
            }
            return id;
        }

        public String toString() {
            return "[" + this.outSize + ", " + this.computeCosts + ", {" + Arrays.toString((Object[])this.inSizes.keySet().toArray(new Long[0])) + ", " + Arrays.toString((Object[])this.inSizes.values().toArray(new Double[0])) + "}]";
        }
    }
}

