/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.persistence.neo4j.entity;

import org.apache.syncope.core.persistence.api.entity.Application;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.common.validation.PrivilegeCheck;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.Relationship;

@Node(Neo4jPrivilege.NODE)
@PrivilegeCheck
public class Neo4jPrivilege extends AbstractProvidedKeyNode implements Privilege {

    private static final long serialVersionUID = -6479069294944858456L;

    public static final String NODE = "Privilege";

    @Relationship(type = Neo4jApplication.APPLICATION_PRIVILEGE_REL, direction = Relationship.Direction.OUTGOING)
    private Neo4jApplication application;

    private String description;

    private String spec;

    @Override
    public Application getApplication() {
        return application;
    }

    @Override
    public void setApplication(final Application application) {
        checkType(application, Neo4jApplication.class);
        this.application = (Neo4jApplication) application;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(final String description) {
        this.description = description;
    }

    @Override
    public String getSpec() {
        return spec;
    }

    @Override
    public void setSpec(final String spec) {
        this.spec = spec;
    }
}
