/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.persist.PersistUtils;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientRequestValue;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.logs.AuditLogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONObjectReader;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class AuditLogMessage
implements Serializable {
    @NotNull
    private static final Pattern STARTS_WITH_TIMESTAMP_PATTERN = Pattern.compile("^# \\d\\d\\/\\w\\w\\w\\/\\d\\d\\d\\d:\\d\\d:\\d\\d:\\d\\d.*$");
    @NotNull
    private static final String TIMESTAMP_SEC_FORMAT = "dd/MMM/yyyy:HH:mm:ss Z";
    @NotNull
    private static final String TIMESTAMP_MS_FORMAT = "dd/MMM/yyyy:HH:mm:ss.SSS Z";
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_SEC_FORMAT_PARSERS = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_MS_FORMAT_PARSERS = new ThreadLocal();
    private static final long serialVersionUID = 1817887018590767411L;
    @Nullable
    private final Boolean usingAdminSessionWorkerThread;
    @NotNull
    private final Date timestamp;
    @Nullable
    private final IntermediateClientRequestControl intermediateClientRequestControl;
    @NotNull
    private final List<String> logMessageLines;
    @Nullable
    private final List<String> requestControlOIDs;
    @Nullable
    private final Long connectionID;
    @Nullable
    private final Long operationID;
    @Nullable
    private final Long threadID;
    @Nullable
    private final Long triggeredByConnectionID;
    @Nullable
    private final Long triggeredByOperationID;
    @NotNull
    private final Map<String, String> namedValues;
    @Nullable
    private final OperationPurposeRequestControl operationPurposeRequestControl;
    @Nullable
    private final String alternateAuthorizationDN;
    @NotNull
    private final String commentedHeaderLine;
    @Nullable
    private final String instanceName;
    @Nullable
    private final String origin;
    @Nullable
    private final String replicationChangeID;
    @Nullable
    private final String requesterDN;
    @Nullable
    private final String requesterIP;
    @Nullable
    private final String productName;
    @Nullable
    private final String startupID;
    @Nullable
    private final String transactionID;
    @NotNull
    private final String uncommentedHeaderLine;

    protected AuditLogMessage(@NotNull List<String> logMessageLines) throws AuditLogException {
        if (logMessageLines == null) {
            throw new AuditLogException(Collections.emptyList(), LogMessages.ERR_AUDIT_LOG_MESSAGE_LIST_NULL.get());
        }
        if (logMessageLines.isEmpty()) {
            throw new AuditLogException(Collections.emptyList(), LogMessages.ERR_AUDIT_LOG_MESSAGE_LIST_EMPTY.get());
        }
        for (String line : logMessageLines) {
            if (line != null && !line.isEmpty()) continue;
            throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_LIST_CONTAINS_EMPTY_LINE.get());
        }
        this.logMessageLines = Collections.unmodifiableList(new ArrayList<String>(logMessageLines));
        String headerLine = null;
        for (String line : logMessageLines) {
            if (!STARTS_WITH_TIMESTAMP_PATTERN.matcher(line).matches()) continue;
            headerLine = line;
            break;
        }
        if (headerLine == null) {
            throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_LIST_DOES_NOT_START_WITH_COMMENT.get());
        }
        this.commentedHeaderLine = headerLine;
        this.uncommentedHeaderLine = this.commentedHeaderLine.substring(2);
        LinkedHashMap<String, String> nameValuePairs = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(10));
        this.timestamp = AuditLogMessage.parseHeaderLine(logMessageLines, this.uncommentedHeaderLine, nameValuePairs);
        this.namedValues = Collections.unmodifiableMap(nameValuePairs);
        this.connectionID = AuditLogMessage.getNamedValueAsLong("conn", this.namedValues);
        this.operationID = AuditLogMessage.getNamedValueAsLong("op", this.namedValues);
        this.threadID = AuditLogMessage.getNamedValueAsLong("threadID", this.namedValues);
        this.triggeredByConnectionID = AuditLogMessage.getNamedValueAsLong("triggeredByConn", this.namedValues);
        this.triggeredByOperationID = AuditLogMessage.getNamedValueAsLong("triggeredByOp", this.namedValues);
        this.alternateAuthorizationDN = this.namedValues.get("authzDN");
        this.instanceName = this.namedValues.get("instanceName");
        this.origin = this.namedValues.get("origin");
        this.replicationChangeID = this.namedValues.get("replicationChangeID");
        this.requesterDN = this.namedValues.get("requesterDN");
        this.requesterIP = this.namedValues.get("clientIP");
        this.productName = this.namedValues.get("productName");
        this.startupID = this.namedValues.get("startupID");
        this.transactionID = this.namedValues.get("txnID");
        this.usingAdminSessionWorkerThread = AuditLogMessage.getNamedValueAsBoolean("usingAdminSessionWorkerThread", this.namedValues);
        this.operationPurposeRequestControl = AuditLogMessage.decodeOperationPurposeRequestControl(this.namedValues);
        this.intermediateClientRequestControl = AuditLogMessage.decodeIntermediateClientRequestControl(this.namedValues);
        String oidsString = this.namedValues.get("requestControlOIDs");
        if (oidsString == null) {
            this.requestControlOIDs = null;
        } else {
            ArrayList<String> oidList = new ArrayList<String>(10);
            StringTokenizer tokenizer = new StringTokenizer(oidsString, ",");
            while (tokenizer.hasMoreTokens()) {
                oidList.add(tokenizer.nextToken());
            }
            this.requestControlOIDs = Collections.unmodifiableList(oidList);
        }
    }

    @NotNull
    private static Date parseHeaderLine(@NotNull List<String> logMessageLines, @NotNull String uncommentedHeaderLine, @NotNull Map<String, String> nameValuePairs) throws AuditLogException {
        byte[] uncommentedHeaderBytes = StaticUtils.getBytes(uncommentedHeaderLine);
        ByteStringBuffer buffer = new ByteStringBuffer(uncommentedHeaderBytes.length);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(uncommentedHeaderBytes);
        Date timestamp = AuditLogMessage.readTimestamp(logMessageLines, inputStream, buffer);
        while (AuditLogMessage.readNameValuePair(logMessageLines, inputStream, nameValuePairs, buffer)) {
        }
        return timestamp;
    }

    @NotNull
    private static Date readTimestamp(@NotNull List<String> logMessageLines, @NotNull ByteArrayInputStream inputStream, @NotNull ByteStringBuffer buffer) throws AuditLogException {
        SimpleDateFormat parser;
        int intRead;
        while ((intRead = inputStream.read()) >= 0 && intRead != 59) {
            buffer.append((byte)(intRead & 0xFF));
        }
        String timestampString = buffer.toString().trim();
        if (timestampString.length() == 30) {
            parser = TIMESTAMP_MS_FORMAT_PARSERS.get();
            if (parser == null) {
                parser = new SimpleDateFormat(TIMESTAMP_MS_FORMAT);
                parser.setLenient(false);
                TIMESTAMP_MS_FORMAT_PARSERS.set(parser);
            }
        } else if (timestampString.length() == 26) {
            parser = TIMESTAMP_SEC_FORMAT_PARSERS.get();
            if (parser == null) {
                parser = new SimpleDateFormat(TIMESTAMP_SEC_FORMAT);
                parser.setLenient(false);
                TIMESTAMP_SEC_FORMAT_PARSERS.set(parser);
            }
        } else {
            throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_HEADER_MALFORMED_TIMESTAMP.get());
        }
        try {
            return parser.parse(timestampString);
        }
        catch (ParseException e) {
            Debug.debugException(e);
            throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_HEADER_MALFORMED_TIMESTAMP.get(), e);
        }
    }

    private static boolean readNameValuePair(@NotNull List<String> logMessageLines, @NotNull ByteArrayInputStream inputStream, @NotNull Map<String, String> nameValuePairs, @NotNull ByteStringBuffer buffer) throws AuditLogException {
        String valueString;
        String name;
        block11: {
            int intRead;
            buffer.clear();
            while (true) {
                int intRead2;
                if ((intRead2 = inputStream.read()) < 0) {
                    if (buffer.isEmpty()) {
                        return false;
                    }
                    throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_HEADER_ENDS_WITH_PROPERTY_NAME.get(buffer.toString()));
                }
                if (intRead2 == 61) break;
                if (intRead2 == 32) continue;
                buffer.append((byte)(intRead2 & 0xFF));
            }
            name = buffer.toString();
            if (name.isEmpty()) {
                throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_HEADER_EMPTY_PROPERTY_NAME.get());
            }
            do {
                inputStream.mark(1);
                intRead = inputStream.read();
                if (intRead >= 0) continue;
                valueString = "";
                break block11;
            } while (intRead == 32);
            if (intRead == 123) {
                inputStream.reset();
                JSONObject jsonObject = AuditLogMessage.readJSONObject(logMessageLines, name, inputStream);
                valueString = jsonObject.toString();
            } else if (intRead == 34) {
                valueString = AuditLogMessage.readString(logMessageLines, name, true, inputStream, buffer);
            } else if (intRead == 59) {
                valueString = "";
            } else {
                inputStream.reset();
                valueString = AuditLogMessage.readString(logMessageLines, name, false, inputStream, buffer);
            }
        }
        nameValuePairs.put(name, valueString);
        return true;
    }

    @NotNull
    private static JSONObject readJSONObject(@NotNull List<String> logMessageLines, @NotNull String propertyName, @NotNull ByteArrayInputStream inputStream) throws AuditLogException {
        JSONObject jsonObject;
        try {
            JSONObjectReader reader = new JSONObjectReader(inputStream, false);
            jsonObject = reader.readObject();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_ERROR_READING_JSON_OBJECT.get(propertyName, StaticUtils.getExceptionMessage(e)), e);
        }
        AuditLogMessage.readSpacesAndSemicolon(logMessageLines, propertyName, inputStream);
        return jsonObject;
    }

    @NotNull
    private static String readString(@NotNull List<String> logMessageLines, @NotNull String propertyName, boolean isQuoted, @NotNull ByteArrayInputStream inputStream, @NotNull ByteStringBuffer buffer) throws AuditLogException {
        buffer.clear();
        block7: while (true) {
            inputStream.mark(1);
            int intRead = inputStream.read();
            if (intRead < 0) {
                if (isQuoted) {
                    throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_END_BEFORE_CLOSING_QUOTE.get(propertyName));
                }
                return buffer.toString();
            }
            switch (intRead) {
                case 92: {
                    int literalCharacter = inputStream.read();
                    if (literalCharacter < 0) {
                        throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_END_BEFORE_ESCAPED.get(propertyName));
                    }
                    buffer.append((byte)(literalCharacter & 0xFF));
                    continue block7;
                }
                case 35: {
                    int hexByte = AuditLogMessage.readHexDigit(logMessageLines, propertyName, inputStream);
                    hexByte = hexByte << 4 | AuditLogMessage.readHexDigit(logMessageLines, propertyName, inputStream);
                    buffer.append((byte)(hexByte & 0xFF));
                    continue block7;
                }
                case 34: {
                    if (isQuoted) break block7;
                    buffer.append('\"');
                    continue block7;
                }
                case 32: {
                    if (!isQuoted) break block7;
                    buffer.append(' ');
                    continue block7;
                }
                case 59: {
                    if (!isQuoted) {
                        inputStream.reset();
                        break block7;
                    }
                    buffer.append(';');
                    continue block7;
                }
                default: {
                    buffer.append((byte)(intRead & 0xFF));
                    continue block7;
                }
            }
            break;
        }
        AuditLogMessage.readSpacesAndSemicolon(logMessageLines, propertyName, inputStream);
        return buffer.toString();
    }

    private static int readHexDigit(@NotNull List<String> logMessageLines, @NotNull String propertyName, @NotNull ByteArrayInputStream inputStream) throws AuditLogException {
        int byteRead = inputStream.read();
        if (byteRead < 0) {
            throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_END_BEFORE_HEX.get(propertyName));
        }
        switch (byteRead) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_INVALID_HEX_DIGIT.get(propertyName));
    }

    private static void readSpacesAndSemicolon(@NotNull List<String> logMessageLines, @NotNull String propertyName, @NotNull ByteArrayInputStream inputStream) throws AuditLogException {
        int intRead;
        do {
            if ((intRead = inputStream.read()) >= 0 && intRead != 59) continue;
            return;
        } while (intRead == 32);
        throw new AuditLogException(logMessageLines, LogMessages.ERR_AUDIT_LOG_MESSAGE_UNEXPECTED_CHAR_AFTER_PROPERTY.get(String.valueOf((char)intRead), propertyName));
    }

    @Nullable
    protected static Boolean getNamedValueAsBoolean(@NotNull String name, @NotNull Map<String, String> nameValuePairs) {
        String valueString = nameValuePairs.get(name);
        if (valueString == null) {
            return null;
        }
        String lowerValueString = StaticUtils.toLowerCase(valueString);
        if (lowerValueString.equals("true") || lowerValueString.equals("t") || lowerValueString.equals("yes") || lowerValueString.equals("y") || lowerValueString.equals("on") || lowerValueString.equals("1")) {
            return Boolean.TRUE;
        }
        if (lowerValueString.equals("false") || lowerValueString.equals("f") || lowerValueString.equals("no") || lowerValueString.equals("n") || lowerValueString.equals("off") || lowerValueString.equals("0")) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Nullable
    protected static Long getNamedValueAsLong(@NotNull String name, @NotNull Map<String, String> nameValuePairs) {
        String valueString = nameValuePairs.get(name);
        if (valueString == null) {
            return null;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    protected static ReadOnlyEntry decodeCommentedEntry(@NotNull String header, @NotNull List<String> logMessageLines, @Nullable String entryDN) {
        ArrayList<String> ldifLines = null;
        StringBuilder invalidLDAPNameReason = null;
        for (String line : logMessageLines) {
            String potentialAttributeName;
            if (!line.startsWith("# ")) break;
            String uncommentedLine = line.substring(2);
            if (ldifLines == null) {
                if (!uncommentedLine.equalsIgnoreCase(header)) continue;
                ldifLines = new ArrayList<String>(logMessageLines.size());
                if (entryDN == null) continue;
                ldifLines.add("dn: " + entryDN);
                continue;
            }
            int colonPos = uncommentedLine.indexOf(58);
            if (colonPos <= 0) break;
            if (invalidLDAPNameReason == null) {
                invalidLDAPNameReason = new StringBuilder();
            }
            if (!PersistUtils.isValidLDAPName(potentialAttributeName = uncommentedLine.substring(0, colonPos), invalidLDAPNameReason)) break;
            ldifLines.add(uncommentedLine);
        }
        if (ldifLines == null) {
            return null;
        }
        try {
            String[] ldifLineArray = ldifLines.toArray(StaticUtils.NO_STRINGS);
            Entry ldifEntry = LDIFReader.decodeEntry(ldifLineArray);
            return new ReadOnlyEntry(ldifEntry);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    private static OperationPurposeRequestControl decodeOperationPurposeRequestControl(@NotNull Map<String, String> nameValuePairs) {
        String valueString = nameValuePairs.get("operationPurpose");
        if (valueString == null) {
            return null;
        }
        try {
            JSONObject o = new JSONObject(valueString);
            String applicationName = o.getFieldAsString("applicationName");
            String applicationVersion = o.getFieldAsString("applicationVersion");
            String codeLocation = o.getFieldAsString("codeLocation");
            String requestPurpose = o.getFieldAsString("requestPurpose");
            return new OperationPurposeRequestControl(false, applicationName, applicationVersion, codeLocation, requestPurpose);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    private static IntermediateClientRequestControl decodeIntermediateClientRequestControl(@NotNull Map<String, String> nameValuePairs) {
        String valueString = nameValuePairs.get("intermediateClientRequestControl");
        if (valueString == null) {
            return null;
        }
        try {
            JSONObject o = new JSONObject(valueString);
            return new IntermediateClientRequestControl(AuditLogMessage.decodeIntermediateClientRequestValue(o));
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Nullable
    private static IntermediateClientRequestValue decodeIntermediateClientRequestValue(@Nullable JSONObject o) {
        if (o == null) {
            return null;
        }
        String clientIdentity = o.getFieldAsString("clientIdentity");
        String downstreamClientAddress = o.getFieldAsString("downstreamClientAddress");
        Boolean downstreamClientSecure = o.getFieldAsBoolean("downstreamClientSecure");
        String clientName = o.getFieldAsString("clientName");
        String clientSessionID = o.getFieldAsString("clientSessionID");
        String clientRequestID = o.getFieldAsString("clientRequestID");
        IntermediateClientRequestValue downstreamRequest = AuditLogMessage.decodeIntermediateClientRequestValue(o.getFieldAsObject("downstreamRequest"));
        return new IntermediateClientRequestValue(downstreamRequest, downstreamClientAddress, downstreamClientSecure, clientIdentity, clientName, clientSessionID, clientRequestID);
    }

    @NotNull
    public final List<String> getLogMessageLines() {
        return this.logMessageLines;
    }

    @NotNull
    public final String getCommentedHeaderLine() {
        return this.commentedHeaderLine;
    }

    @NotNull
    public final String getUncommentedHeaderLine() {
        return this.uncommentedHeaderLine;
    }

    @NotNull
    public final Date getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final Map<String, String> getHeaderNamedValues() {
        return this.namedValues;
    }

    @Nullable
    public final String getProductName() {
        return this.productName;
    }

    @Nullable
    public final String getInstanceName() {
        return this.instanceName;
    }

    @Nullable
    public final String getStartupID() {
        return this.startupID;
    }

    @Nullable
    public final Long getThreadID() {
        return this.threadID;
    }

    @Nullable
    public final String getRequesterDN() {
        return this.requesterDN;
    }

    @Nullable
    public final String getRequesterIPAddress() {
        return this.requesterIP;
    }

    @Nullable
    public final Long getConnectionID() {
        return this.connectionID;
    }

    @Nullable
    public final Long getOperationID() {
        return this.operationID;
    }

    @Nullable
    public final Long getTriggeredByConnectionID() {
        return this.triggeredByConnectionID;
    }

    @Nullable
    public final Long getTriggeredByOperationID() {
        return this.triggeredByOperationID;
    }

    @Nullable
    public final String getReplicationChangeID() {
        return this.replicationChangeID;
    }

    @Nullable
    public final String getAlternateAuthorizationDN() {
        return this.alternateAuthorizationDN;
    }

    @Nullable
    public final String getTransactionID() {
        return this.transactionID;
    }

    @Nullable
    public final String getOrigin() {
        return this.origin;
    }

    @Nullable
    public final Boolean getUsingAdminSessionWorkerThread() {
        return this.usingAdminSessionWorkerThread;
    }

    @Nullable
    public final List<String> getRequestControlOIDs() {
        return this.requestControlOIDs;
    }

    @Nullable
    public final OperationPurposeRequestControl getOperationPurposeRequestControl() {
        return this.operationPurposeRequestControl;
    }

    @Nullable
    public final IntermediateClientRequestControl getIntermediateClientRequestControl() {
        return this.intermediateClientRequestControl;
    }

    @NotNull
    public abstract String getDN();

    @NotNull
    public abstract ChangeType getChangeType();

    @NotNull
    public abstract LDIFChangeRecord getChangeRecord();

    public abstract boolean isRevertible();

    @NotNull
    public abstract List<LDIFChangeRecord> getRevertChangeRecords() throws AuditLogException;

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(@NotNull StringBuilder var1);

    @NotNull
    public final String toMultiLineString() {
        return StaticUtils.concatenateStrings(null, null, StaticUtils.EOL, null, null, this.logMessageLines);
    }
}

