/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.x.discovery.DownInstancePolicy;
import org.apache.curator.x.discovery.InstanceFilter;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.ServiceProviderBuilder;
import org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;
import org.apache.curator.x.discovery.details.ServiceProviderImpl;

class ServiceProviderBuilderImpl<T>
implements ServiceProviderBuilder<T> {
    private ServiceDiscoveryImpl<T> discovery;
    private String serviceName;
    private ProviderStrategy<T> providerStrategy;
    private ThreadFactory threadFactory;
    private ExecutorService executorService;
    private List<InstanceFilter<T>> filters = Lists.newArrayList();
    private DownInstancePolicy downInstancePolicy = new DownInstancePolicy();

    @Override
    public ServiceProvider<T> build() {
        return new ServiceProviderImpl<T>(this.discovery, this.serviceName, this.providerStrategy, this.threadFactory, this.executorService, this.filters, this.downInstancePolicy);
    }

    ServiceProviderBuilderImpl(ServiceDiscoveryImpl<T> discovery) {
        this.discovery = discovery;
    }

    @Override
    public ServiceProviderBuilder<T> serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public ServiceProviderBuilder<T> providerStrategy(ProviderStrategy<T> providerStrategy) {
        this.providerStrategy = providerStrategy;
        return this;
    }

    @Override
    @Deprecated
    public ServiceProviderBuilder<T> threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.executorService = null;
        return this;
    }

    @Override
    public ServiceProviderBuilder<T> downInstancePolicy(DownInstancePolicy downInstancePolicy) {
        this.downInstancePolicy = downInstancePolicy;
        return this;
    }

    @Override
    public ServiceProviderBuilder<T> additionalFilter(InstanceFilter<T> filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public ServiceProviderBuilder<T> executorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.threadFactory = null;
        return this;
    }
}

