/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.giffing.wicket.spring.boot.starter.app.WicketBootSecuredWebApplication;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.SingleThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.syncope.client.enduser.EnduserProperties;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Dashboard;
import org.apache.syncope.client.enduser.pages.Login;
import org.apache.syncope.client.enduser.pages.MustChangePassword;
import org.apache.syncope.client.enduser.pages.SelfConfirmPasswordReset;
import org.apache.syncope.client.enduser.panels.Sidebar;
import org.apache.syncope.client.lib.SyncopeAnonymousClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.ui.commons.SyncopeUIRequestCycleListener;
import org.apache.syncope.client.ui.commons.annotations.Resource;
import org.apache.syncope.client.ui.commons.themes.AdminLTE;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.IResourceIsolationPolicy;
import org.apache.wicket.protocol.http.ResourceIsolationRequestCycleListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.XForwardedRequestWrapperFactory;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.io.ResourceLoader;

public class SyncopeWebApplication
extends WicketBootSecuredWebApplication {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeWebApplication.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final ResourceLoader resourceLoader;
    protected final EnduserProperties props;
    protected final ClassPathScanImplementationLookup lookup;
    protected final ServiceOps serviceOps;
    protected final List<IResource> resources;
    protected UserFormLayoutInfo customFormLayout;

    public static SyncopeWebApplication get() {
        return (SyncopeWebApplication)WebApplication.get();
    }

    public SyncopeWebApplication(ResourceLoader resourceLoader, EnduserProperties props, ClassPathScanImplementationLookup lookup, ServiceOps serviceOps, List<IResource> resources) {
        this.resourceLoader = resourceLoader;
        this.props = props;
        this.lookup = lookup;
        this.serviceOps = serviceOps;
        this.resources = resources;
    }

    protected SyncopeUIRequestCycleListener buildSyncopeUIRequestCycleListener() {
        return new SyncopeUIRequestCycleListener(){

            protected boolean isSignedIn() {
                return SyncopeEnduserSession.get().isAuthenticated();
            }

            protected void invalidateSession() {
                SyncopeEnduserSession.get().invalidate();
            }

            protected IRequestablePage getErrorPage(PageParameters errorParameters) {
                return new Login(errorParameters);
            }
        };
    }

    protected void initSecurity() {
        if (this.props.isxForward()) {
            XForwardedRequestWrapperFactory.Config config = new XForwardedRequestWrapperFactory.Config();
            config.setProtocolHeader(this.props.getxForwardProtocolHeader());
            config.setHttpServerPort(this.props.getxForwardHttpPort());
            config.setHttpsServerPort(this.props.getxForwardHttpsPort());
            XForwardedRequestWrapperFactory factory = new XForwardedRequestWrapperFactory();
            factory.setConfig(config);
            this.getFilterFactoryManager().add((AbstractRequestWrapperFactory)factory);
        }
        if (this.props.isCsrf()) {
            this.getRequestCycleListeners().add((Object)new ResourceIsolationRequestCycleListener(new IResourceIsolationPolicy[0]));
        }
        this.getCspSettings().blocking().unsafeInline();
        this.getRequestCycleListeners().add((Object)new IRequestCycleListener(){

            public void onEndRequest(RequestCycle cycle) {
                if (cycle.getResponse() instanceof WebResponse) {
                    SyncopeWebApplication.this.props.getSecurityHeaders().forEach((name, value) -> ((WebResponse)cycle.getResponse()).setHeader(name, value));
                }
            }
        });
    }

    protected void init() {
        super.init();
        BootstrapSettings settings = new BootstrapSettings();
        settings.setThemeProvider((ThemeProvider)new SingleThemeProvider((ITheme)new AdminLTE()));
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        this.getResourceSettings().setUseMinifiedResources(true);
        this.getResourceSettings().setUseDefaultOnMissingResource(true);
        this.getResourceSettings().setThrowExceptionOnMissingResource(false);
        this.getSecuritySettings().setAuthorizationStrategy(this.getAuthorizationStrategy());
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setCompressWhitespace(true);
        this.getRequestCycleListeners().add((Object)this.buildSyncopeUIRequestCycleListener());
        this.initSecurity();
        this.mountPage("/confirmpasswordreset", SelfConfirmPasswordReset.class);
        for (final IResource resource : this.resources) {
            Class resourceClass = AopUtils.getTargetClass((Object)resource);
            Resource annotation = resourceClass.getAnnotation(Resource.class);
            if (annotation == null) {
                LOG.error("No @Resource annotation found, ignoring {}", (Object)resourceClass.getName());
                continue;
            }
            LOG.debug("Mounting {} under {}", (Object)resourceClass.getName(), (Object)annotation.path());
            this.mountResource(annotation.path(), new ResourceReference(annotation.key()){
                private static final long serialVersionUID = -128426276529456602L;

                public IResource getResource() {
                    return resource;
                }
            });
        }
        try (InputStream is = this.resourceLoader.getResource(this.props.getCustomFormLayout()).getInputStream();){
            this.customFormLayout = (UserFormLayoutInfo)((Object)MAPPER.readValue(is, (TypeReference)new TypeReference<UserFormLayoutInfo>(){}));
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Could not read " + this.props.getCustomFormLayout(), (Throwable)e);
        }
        if (this.getDebugSettings().isAjaxDebugModeEnabled()) {
            this.getDebugSettings().setComponentPathAttributeName("syncope-path");
        }
    }

    protected IAuthorizationStrategy getAuthorizationStrategy() {
        return new IAuthorizationStrategy.AllowAllAuthorizationStrategy(){

            public <T extends IRequestableComponent> boolean isInstantiationAuthorized(Class<T> componentClass) {
                if (BasePage.class.isAssignableFrom(componentClass)) {
                    return SyncopeWebApplication.this.props.getPage().entrySet().stream().filter(entry -> componentClass.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().map(k -> SyncopeEnduserSession.get().isAuthenticated()).orElse(true);
                }
                return true;
            }
        };
    }

    public Class<? extends Page> getHomePage() {
        return SyncopeEnduserSession.get().isAuthenticated() && SyncopeEnduserSession.get().isMustChangePassword() ? MustChangePassword.class : (SyncopeEnduserSession.get().isAuthenticated() ? this.getPageClass("profile", Dashboard.class) : this.getSignInPageClass());
    }

    public ClassPathScanImplementationLookup getLookup() {
        return this.lookup;
    }

    public UserFormLayoutInfo getCustomFormLayout() {
        return this.customFormLayout;
    }

    public Class<? extends Sidebar> getSidebar() {
        return this.props.getSidebar();
    }

    public Session newSession(Request request, Response response) {
        return new SyncopeEnduserSession(request);
    }

    public SyncopeAnonymousClient newAnonymousClient(String domain) {
        return this.newClientFactory().setDomain(domain).createAnonymous(this.props.getAnonymousUser(), this.props.getAnonymousKey());
    }

    public SyncopeClientFactoryBean newClientFactory() {
        return new SyncopeClientFactoryBean().setAddress(this.serviceOps.get(NetworkService.Type.CORE).getAddress()).setUseCompression(this.props.isUseGZIPCompression());
    }

    public Class<? extends BasePage> getPageClass(String name) {
        return this.props.getPage().get(name);
    }

    public Class<? extends BasePage> getPageClass(String name, Class<? extends BasePage> defaultValue) {
        return this.props.getPage().getOrDefault(name, defaultValue);
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return SyncopeEnduserSession.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return Login.class;
    }

    public String getAdminUser() {
        return this.props.getAdminUser();
    }

    public String getAnonymousUser() {
        return this.props.getAnonymousUser();
    }

    public boolean isCaptchaEnabled() {
        return this.props.isCaptcha();
    }

    public boolean isReportPropagationErrors() {
        return this.props.isReportPropagationErrors();
    }

    public boolean isReportPropagationErrorDetails() {
        return this.props.isReportPropagationErrorDetails();
    }

    public long getMaxWaitTimeInSeconds() {
        return this.props.getMaxWaitTimeOnApplyChanges();
    }

    public Integer getMaxUploadFileSizeMB() {
        return this.props.getMaxUploadFileSizeMB();
    }
}

