/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.apache.syncope.core.spring.security.jws.AccessTokenJWSVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class SyncopeJWTSSOProvider
implements JWTSSOProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeJWTSSOProvider.class);
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    protected final SecurityProperties securityProperties;
    protected final AccessTokenJWSVerifier delegate;
    protected final UserDAO userDAO;
    protected final AccessTokenDAO accessTokenDAO;

    public SyncopeJWTSSOProvider(SecurityProperties securityProperties, AccessTokenJWSVerifier delegate, UserDAO userDAO, AccessTokenDAO accessTokenDAO) {
        this.securityProperties = securityProperties;
        this.delegate = delegate;
        this.userDAO = userDAO;
        this.accessTokenDAO = accessTokenDAO;
    }

    @Override
    public String getIssuer() {
        return this.securityProperties.getJwtIssuer();
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return this.delegate.supportedJWSAlgorithms();
    }

    public JCAContext getJCAContext() {
        return this.delegate.getJCAContext();
    }

    public boolean verify(JWSHeader header, byte[] signingInput, Base64URL signature) throws JOSEException {
        return this.delegate.verify(header, signingInput, signature);
    }

    @Override
    @Transactional(readOnly=true)
    public Pair<User, Set<SyncopeGrantedAuthority>> resolve(JWTClaimsSet jwtClaims) {
        AccessToken accessToken;
        User user = this.userDAO.findByUsername(jwtClaims.getSubject());
        Set authorities = Set.of();
        if (user != null && (accessToken = this.accessTokenDAO.find(jwtClaims.getJWTID())) != null && accessToken.getAuthorities() != null) {
            try {
                authorities = (Set)POJOHelper.deserialize((String)ENCRYPTOR.decode(new String(accessToken.getAuthorities()), CipherAlgorithm.AES), (TypeReference)new TypeReference<Set<SyncopeGrantedAuthority>>(){});
            }
            catch (Throwable t) {
                LOG.error("Could not read stored authorities", t);
            }
        }
        return Pair.of((Object)user, authorities);
    }
}

