/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.KeyLengthException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.rules.RuleEnforcer;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.policy.DefaultRuleEnforcer;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.DefaultPasswordGenerator;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeJWTSSOProvider;
import org.apache.syncope.core.spring.security.jws.AccessTokenJWSSigner;
import org.apache.syncope.core.spring.security.jws.AccessTokenJWSVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.config.core.GrantedAuthorityDefaults;

@EnableConfigurationProperties(value={SecurityProperties.class})
@Configuration(proxyBeanMethods=false)
public class SecurityContext {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityContext.class);

    @Role(value=2)
    @Bean
    public static GrantedAuthorityDefaults grantedAuthorityDefaults() {
        return new GrantedAuthorityDefaults("");
    }

    protected static String jwsKey(JWSAlgorithm jwsAlgorithm, SecurityProperties props) {
        String jwsKey = props.getJwsKey();
        if (jwsKey == null) {
            throw new IllegalArgumentException("No JWS key provided");
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm)) {
            int minLength;
            int n = jwsAlgorithm.equals((Object)JWSAlgorithm.HS256) ? 32 : (minLength = jwsAlgorithm.equals((Object)JWSAlgorithm.HS384) ? 48 : 64);
            if (jwsKey.length() < minLength) {
                jwsKey = SecureRandomUtils.generateRandomPassword(minLength);
                props.setJwsKey(jwsKey);
                LOG.warn("The configured key for {} must be at least {} bits, generating random: {}", new Object[]{jwsAlgorithm, minLength * 8, jwsKey});
            }
        }
        return jwsKey;
    }

    @Bean
    public CipherAlgorithm adminPasswordAlgorithm(SecurityProperties props) {
        return props.getAdminPasswordAlgorithm();
    }

    @Bean
    public JWSAlgorithm jwsAlgorithm(SecurityProperties props) {
        return JWSAlgorithm.parse((String)props.getJwsAlgorithm().toUpperCase());
    }

    @ConditionalOnMissingBean
    @Bean
    public DefaultCredentialChecker credentialChecker(SecurityProperties props, JWSAlgorithm jwsAlgorithm) {
        return new DefaultCredentialChecker(SecurityContext.jwsKey(jwsAlgorithm, props), props.getAdminPassword(), props.getAnonymousKey());
    }

    @ConditionalOnMissingBean
    @Bean
    public AccessTokenJWSVerifier accessTokenJWSVerifier(JWSAlgorithm jwsAlgorithm, SecurityProperties props) throws JOSEException, NoSuchAlgorithmException, InvalidKeySpecException {
        return new AccessTokenJWSVerifier(jwsAlgorithm, SecurityContext.jwsKey(jwsAlgorithm, props));
    }

    @ConditionalOnMissingBean
    @Bean
    public AccessTokenJWSSigner accessTokenJWSSigner(JWSAlgorithm jwsAlgorithm, SecurityProperties props) throws KeyLengthException, NoSuchAlgorithmException, InvalidKeySpecException {
        return new AccessTokenJWSSigner(jwsAlgorithm, SecurityContext.jwsKey(jwsAlgorithm, props));
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeJWTSSOProvider syncopeJWTSSOProvider(SecurityProperties props, AccessTokenJWSVerifier accessTokenJWSVerifier, UserDAO userDAO, AccessTokenDAO accessTokenDAO) {
        return new SyncopeJWTSSOProvider(props, accessTokenJWSVerifier, userDAO, accessTokenDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public PasswordGenerator passwordGenerator() {
        return new DefaultPasswordGenerator();
    }

    @ConditionalOnMissingBean
    @Bean
    public RuleEnforcer ruleEnforcer(RealmDAO realmDAO) {
        return new DefaultRuleEnforcer(realmDAO);
    }

    @Bean
    public ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }
}

