/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.util.encoding.UrlDecoder;
import org.apache.wicket.util.encoding.UrlEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;

public class Url
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> segments;
    private final List<QueryParameter> parameters;
    private String charsetName;
    private transient Charset _charset;
    private String protocol;
    private Integer port;
    private String host;
    private String fragment;
    private boolean contextRelative;
    private boolean shouldRenderAsFull;

    public boolean shouldRenderAsFull() {
        return this.shouldRenderAsFull;
    }

    public Url() {
        this.segments = Generics.newArrayList();
        this.parameters = Generics.newArrayList();
    }

    public Url(Charset charset) {
        this();
        this.setCharset(charset);
    }

    public Url(Url url) {
        Args.notNull((Object)url, (String)"url");
        this.protocol = url.protocol;
        this.host = url.host;
        this.port = url.port;
        this.segments = new ArrayList<String>(url.segments);
        this.parameters = new ArrayList<QueryParameter>(url.parameters);
        this.charsetName = url.charsetName;
        this._charset = url._charset;
        this.shouldRenderAsFull = url.shouldRenderAsFull;
    }

    public Url(List<String> segments, List<QueryParameter> parameters) {
        this(segments, parameters, null);
    }

    public Url(List<String> segments, Charset charset) {
        this(segments, Collections.emptyList(), charset);
    }

    public Url(List<String> segments, List<QueryParameter> parameters, Charset charset) {
        Args.notNull(segments, (String)"segments");
        Args.notNull(parameters, (String)"parameters");
        this.segments = new ArrayList<String>(segments);
        this.parameters = new ArrayList<QueryParameter>(parameters);
        this.setCharset(charset);
    }

    public static Url parse(CharSequence url) {
        return Url.parse(url, null);
    }

    public static Url parse(CharSequence _url, Charset charset) {
        return Url.parse(_url, charset, true);
    }

    public static Url parse(CharSequence _url, Charset charset, boolean isFullHint) {
        int closeSqrBracketAt;
        Object relativeUrl;
        boolean isFull;
        String absoluteUrl;
        String queryString;
        int queryAt;
        Args.notNull((Object)_url, (String)"_url");
        Url result = new Url(charset);
        charset = result.getCharset();
        String url = _url.toString();
        int fragmentAt = url.indexOf(35);
        if (fragmentAt > -1 && url.length() > fragmentAt + 1 && url.charAt(fragmentAt + 1) != '{') {
            result.fragment = url.substring(fragmentAt + 1);
            url = url.substring(0, fragmentAt);
        }
        if ((queryAt = url.indexOf(63)) == -1) {
            queryString = "";
            absoluteUrl = url;
        } else {
            absoluteUrl = url.substring(0, queryAt);
            queryString = url.substring(queryAt + 1);
        }
        int idxOfFirstSlash = absoluteUrl.indexOf(47);
        int protocolAt = absoluteUrl.indexOf("://");
        boolean protocolLess = absoluteUrl.startsWith("//");
        boolean bl = isFull = protocolAt > 1 && protocolAt < idxOfFirstSlash || protocolLess;
        if (isFull && isFullHint) {
            String hostAndPort;
            String afterProto;
            int relativeAt;
            result.shouldRenderAsFull = true;
            if (!protocolLess) {
                result.protocol = absoluteUrl.substring(0, protocolAt).toLowerCase(Locale.US);
            }
            if ((relativeAt = (afterProto = absoluteUrl.substring(protocolAt + 3)).indexOf(47)) == -1) {
                relativeAt = afterProto.indexOf(59);
            }
            if (relativeAt == -1) {
                relativeUrl = "";
                hostAndPort = afterProto;
            } else {
                relativeUrl = afterProto.substring(relativeAt);
                hostAndPort = afterProto.substring(0, relativeAt);
            }
            int credentialsAt = hostAndPort.lastIndexOf(64) + 1;
            closeSqrBracketAt = hostAndPort.lastIndexOf(93) + 1;
            int portAt = hostAndPort.substring(credentialsAt).substring(closeSqrBracketAt).lastIndexOf(58);
            if (portAt == -1) {
                result.host = hostAndPort;
                result.port = Url.getDefaultPortForProtocol(result.protocol);
            } else {
                int portOffset = portAt + credentialsAt + closeSqrBracketAt;
                result.host = hostAndPort.substring(0, portOffset);
                result.port = Integer.parseInt(hostAndPort.substring(portOffset + 1));
            }
            if (relativeAt < 0) {
                relativeUrl = "/";
            }
        } else {
            relativeUrl = absoluteUrl;
        }
        if (((String)relativeUrl).length() > 0) {
            boolean removeLast = false;
            if (((String)relativeUrl).endsWith("/")) {
                relativeUrl = (String)relativeUrl + "/x";
                removeLast = true;
            }
            String[] segmentArray = Strings.split((String)relativeUrl, (char)'/');
            if (removeLast) {
                segmentArray[segmentArray.length - 1] = null;
            }
            String[] stringArray = segmentArray;
            int n = stringArray.length;
            for (closeSqrBracketAt = 0; closeSqrBracketAt < n; ++closeSqrBracketAt) {
                String s = stringArray[closeSqrBracketAt];
                if (s == null) continue;
                result.segments.add(Url.decodeSegment(s, charset));
            }
        }
        if (queryString.length() > 0) {
            String[] queryArray;
            for (String s : queryArray = Strings.split((String)queryString, (char)'&')) {
                if (Strings.isEmpty((String)s)) continue;
                result.parameters.add(Url.parseQueryParameter(s, charset));
            }
        }
        return result;
    }

    private static QueryParameter parseQueryParameter(String qp, Charset charset) {
        int idxOfEquals = qp.indexOf(61);
        if (idxOfEquals == -1) {
            return new QueryParameter(Url.decodeParameter(qp, charset), "");
        }
        String parameterName = qp.substring(0, idxOfEquals);
        String parameterValue = qp.substring(idxOfEquals + 1);
        return new QueryParameter(Url.decodeParameter(parameterName, charset), Url.decodeParameter(parameterValue, charset));
    }

    private static Integer getDefaultPortForProtocol(String protocol) {
        if ("http".equals(protocol)) {
            return 80;
        }
        if ("https".equals(protocol)) {
            return 443;
        }
        if ("ftp".equals(protocol)) {
            return 21;
        }
        return null;
    }

    public Charset getCharset() {
        if (this._charset == null) {
            this._charset = Strings.isEmpty((String)this.charsetName) ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }
        return this._charset;
    }

    private void setCharset(Charset charset) {
        if (charset == null) {
            this.charsetName = null;
            this._charset = null;
        } else {
            this.charsetName = charset.name();
            this._charset = charset;
        }
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public List<QueryParameter> getQueryParameters() {
        return this.parameters;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public boolean isContextAbsolute() {
        return !this.contextRelative && !this.isFull() && !this.getSegments().isEmpty() && Strings.isEmpty((String)this.getSegments().get(0));
    }

    public boolean isDataUrl() {
        return this.getProtocol() != null && this.getProtocol().equals("data") || !this.getSegments().isEmpty() && this.getSegments().get(0).startsWith("data");
    }

    public boolean isFull() {
        return !this.contextRelative && this.getHost() != null;
    }

    public void removeQueryParameters(String name) {
        Iterator<QueryParameter> i = this.getQueryParameters().iterator();
        while (i.hasNext()) {
            QueryParameter param = i.next();
            if (!Objects.equal((Object)name, (Object)param.getName())) continue;
            i.remove();
        }
    }

    public void removeLeadingSegments(int count) {
        Args.withinRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.segments.size()), (Comparable)Integer.valueOf(count), (String)"count");
        for (int i = 0; i < count; ++i) {
            this.segments.remove(0);
        }
    }

    public void prependLeadingSegments(List<String> newSegments) {
        Args.notNull(newSegments, (String)"segments");
        this.segments.addAll(0, newSegments);
    }

    public void setQueryParameter(String name, Object value) {
        this.removeQueryParameters(name);
        this.addQueryParameter(name, value);
    }

    public void addQueryParameter(String name, Object value) {
        if (value != null) {
            QueryParameter parameter = new QueryParameter(name, value.toString());
            this.getQueryParameters().add(parameter);
        }
    }

    public QueryParameter getQueryParameter(String name) {
        for (QueryParameter parameter : this.parameters) {
            if (!Objects.equal((Object)name, (Object)parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public StringValue getQueryParameterValue(String name) {
        QueryParameter parameter = this.getQueryParameter(name);
        if (parameter == null) {
            return StringValue.valueOf((String)null);
        }
        return StringValue.valueOf((String)parameter.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Url)) {
            return false;
        }
        Url rhs = (Url)obj;
        return this.getSegments().equals(rhs.getSegments()) && this.getQueryParameters().equals(rhs.getQueryParameters()) && Objects.isEqual((Object)this.getFragment(), (Object)rhs.getFragment());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSegments(), this.getQueryParameters(), this.getFragment()});
    }

    private static String encodeSegment(String string, Charset charset) {
        return UrlEncoder.PATH_INSTANCE.encode(string, charset);
    }

    private static String decodeSegment(String string, Charset charset) {
        return UrlDecoder.PATH_INSTANCE.decode(string, charset);
    }

    private static String encodeParameter(String string, Charset charset) {
        return UrlEncoder.QUERY_INSTANCE.encode(string, charset);
    }

    private static String decodeParameter(String string, Charset charset) {
        return UrlDecoder.QUERY_INSTANCE.decode(string, charset);
    }

    public String toString() {
        return this.toString(this.getCharset());
    }

    public String toString(StringMode mode, Charset charset) {
        CharSequence path = this.getPathInternal(charset);
        String queryString = this.getQueryString(charset);
        String _fragment = this.getFragment();
        if (StringMode.FULL != mode && Strings.isEmpty((String)_fragment)) {
            if (queryString == null) {
                return path.toString();
            }
            return path + "?" + queryString;
        }
        StringBuilder result = new StringBuilder(64);
        if (StringMode.FULL == mode) {
            if (Strings.isEmpty((String)this.host)) {
                throw new IllegalStateException("Cannot render this url in " + StringMode.FULL.name() + " mode because it does not have a host set.");
            }
            if (!Strings.isEmpty((String)this.protocol)) {
                result.append(this.protocol);
                result.append("://");
            } else if (Strings.isEmpty((String)this.protocol) && !Strings.isEmpty((String)this.host)) {
                result.append("//");
            }
            result.append(this.host);
            if (this.port != null && !this.port.equals(Url.getDefaultPortForProtocol(this.protocol))) {
                result.append(':');
                result.append(this.port);
            }
            if (this.segments.contains("..")) {
                throw new IllegalStateException("Cannot render this url in " + StringMode.FULL.name() + " mode because it has a `..` segment: " + this.toString());
            }
            if (path.length() != 0 && path.charAt(0) != '/') {
                result.append('/');
            }
        }
        result.append(path);
        if (queryString != null) {
            result.append('?').append(queryString);
        }
        if (!Strings.isEmpty((String)_fragment)) {
            result.append('#').append(_fragment);
        }
        return result.toString();
    }

    public String toString(StringMode mode) {
        return this.toString(mode, this.getCharset());
    }

    public String toString(Charset charset) {
        return this.toString(StringMode.LOCAL, charset);
    }

    private boolean isLastSegmentReal() {
        if (this.segments.isEmpty()) {
            return false;
        }
        String last = this.segments.get(this.segments.size() - 1);
        return last.length() > 0 && !".".equals(last) && !"..".equals(last);
    }

    private boolean isLastSegmentEmpty(List<String> segments) {
        if (segments.isEmpty()) {
            return false;
        }
        String last = segments.get(segments.size() - 1);
        return last.length() == 0;
    }

    private boolean isLastSegmentEmpty() {
        return this.isLastSegmentEmpty(this.segments);
    }

    private boolean isAtLeastOneSegmentReal(List<String> segments) {
        for (String s : segments) {
            if (s.length() <= 0 || ".".equals(s) || "..".equals(s)) continue;
            return true;
        }
        return false;
    }

    public void concatSegments(List<String> segments) {
        boolean checkedLastSegment = false;
        if (!this.isAtLeastOneSegmentReal(segments) && !this.isLastSegmentEmpty(segments)) {
            segments = new ArrayList<String>(segments);
            segments.add("");
        }
        for (String s : segments) {
            if (".".equals(s)) continue;
            if ("..".equals(s) && !this.segments.isEmpty()) {
                this.segments.remove(this.segments.size() - 1);
                continue;
            }
            if (!checkedLastSegment) {
                if (this.isLastSegmentReal() || this.isLastSegmentEmpty()) {
                    this.segments.remove(this.segments.size() - 1);
                }
                checkedLastSegment = true;
            }
            this.segments.add(s);
        }
        if (this.segments.size() == 1 && this.segments.get(0).length() == 0) {
            this.segments.clear();
        }
    }

    public void resolveRelative(Url relative) {
        if (this.getSegments().size() > 0) {
            this.getSegments().remove(this.getSegments().size() - 1);
        }
        List<String> relativeSegments = relative.getSegments();
        while (!relativeSegments.isEmpty()) {
            String firstSegment = relativeSegments.get(0);
            if (".".equals(firstSegment)) {
                relativeSegments.remove(0);
                continue;
            }
            if (firstSegment.isEmpty()) {
                relativeSegments.remove(0);
                continue;
            }
            if (!"..".equals(firstSegment)) break;
            relativeSegments.remove(0);
            if (this.getSegments().isEmpty()) continue;
            this.getSegments().remove(this.getSegments().size() - 1);
        }
        if (!this.getSegments().isEmpty() && relativeSegments.isEmpty()) {
            this.getSegments().add("");
        }
        this.getSegments().addAll(relativeSegments);
        this.parameters.clear();
        this.parameters.addAll(relative.getQueryParameters());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath(Charset charset) {
        return this.getPathInternal(charset).toString();
    }

    private CharSequence getPathInternal(Charset charset) {
        Args.notNull((Object)charset, (String)"charset");
        List<String> segments = this.getSegments();
        if (segments.isEmpty()) {
            return "";
        }
        if (segments.size() == 1) {
            return Url.encodeSegment(segments.get(0), charset);
        }
        int length = 0;
        for (String segment : this.getSegments()) {
            length += segment.length() + 4;
        }
        StringBuilder path = new StringBuilder(length);
        boolean slash = false;
        for (String segment : this.getSegments()) {
            if (slash) {
                path.append('/');
            }
            path.append(Url.encodeSegment(segment, charset));
            slash = true;
        }
        return path;
    }

    public String getPath() {
        return this.getPath(this.getCharset());
    }

    public String getQueryString(Charset charset) {
        Args.notNull((Object)charset, (String)"charset");
        List<QueryParameter> queryParameters = this.getQueryParameters();
        if (queryParameters.isEmpty()) {
            return null;
        }
        if (queryParameters.size() == 1) {
            return queryParameters.get(0).toString(charset);
        }
        StringBuilder query = new StringBuilder(16 * this.parameters.size());
        for (QueryParameter parameter : queryParameters) {
            if (query.length() != 0) {
                query.append('&');
            }
            query.append(parameter.toString(charset));
        }
        return query.toString();
    }

    public String getQueryString() {
        return this.getQueryString(this.getCharset());
    }

    public Url canonical() {
        Url url = new Url(this);
        url.segments.clear();
        for (int i = 0; i < this.segments.size(); ++i) {
            String segment = this.segments.get(i);
            if (".".equals(segment)) continue;
            if ("..".equals(segment) && !url.segments.isEmpty()) {
                url.segments.remove(url.segments.size() - 1);
                continue;
            }
            if (i + 1 < this.segments.size() && "..".equals(this.segments.get(i + 1))) {
                ++i;
                continue;
            }
            url.segments.add(segment);
        }
        return url;
    }

    public static final class QueryParameter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String value;

        public QueryParameter(String name, String value) {
            Args.notNull((Object)name, (String)"name");
            Args.notNull((Object)value, (String)"value");
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof QueryParameter)) {
                return false;
            }
            QueryParameter rhs = (QueryParameter)obj;
            return Objects.equal((Object)this.getName(), (Object)rhs.getName()) && Objects.equal((Object)this.getValue(), (Object)rhs.getValue());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getName(), this.getValue()});
        }

        public String toString() {
            return this.toString(StandardCharsets.UTF_8);
        }

        public String toString(Charset charset) {
            String value = this.getValue();
            if (Strings.isEmpty((String)value)) {
                return Url.encodeParameter(this.getName(), charset);
            }
            return Url.encodeParameter(this.getName(), charset) + "=" + Url.encodeParameter(value, charset);
        }
    }

    public static enum StringMode {
        LOCAL,
        FULL;

    }
}

