/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20CallbackAuthorizeEndpointController
extends BaseOAuth20Controller<OAuth20ConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20CallbackAuthorizeEndpointController.class);

    public OAuth20CallbackAuthorizeEndpointController(OAuth20ConfigurationContext oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @GetMapping(path={"/oauth2.0/callbackAuthorize"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) {
        OAuth20CallbackLogic callback = new OAuth20CallbackLogic();
        JEEContext context = new JEEContext(request, response);
        String defaultUrl = null;
        Optional clientId = context.getRequestParameter("client_id");
        Optional redirectUri = context.getRequestParameter("redirect_uri");
        if (clientId.isPresent() && redirectUri.isPresent()) {
            ServicesManager servicesManager = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getServicesManager();
            OAuthRegisteredService serviceClient = OAuth20Utils.getRegisteredOAuthServiceByClientId(servicesManager, (String)clientId.get());
            OAuthRegisteredService serviceRedirectUri = OAuth20Utils.getRegisteredOAuthServiceByRedirectUri(servicesManager, (String)redirectUri.get());
            if (serviceClient != null && serviceClient.equals((Object)serviceRedirectUri)) {
                defaultUrl = (String)redirectUri.get();
            }
        }
        callback.perform((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore(), ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthConfig(), (object, ctx) -> Boolean.FALSE, defaultUrl, Boolean.FALSE, "CasOAuthClient");
        String url = callback.getRedirectUrl();
        ProfileManager manager = new ProfileManager((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
        LOGGER.trace("OAuth callback URL is [{}]", (Object)url);
        return ((OAuth20ConfigurationContext)this.getConfigurationContext()).getCallbackAuthorizeViewResolver().resolve((WebContext)context, manager, url);
    }

    private static class OAuth20CallbackLogic
    extends DefaultCallbackLogic {
        private String redirectUrl;

        private OAuth20CallbackLogic() {
        }

        protected HttpAction redirectToOriginallyRequestedUrl(WebContext context, SessionStore sessionStore, String defaultUrl) {
            HttpAction result = this.getSavedRequestHandler().restore(context, sessionStore, defaultUrl);
            if (result instanceof WithLocationAction) {
                this.redirectUrl = ((WithLocationAction)WithLocationAction.class.cast(result)).getLocation();
            }
            return result;
        }

        @Generated
        public String getRedirectUrl() {
            return this.redirectUrl;
        }
    }
}

