/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.slo;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.logout.LogoutHttpMessage;
import org.apereo.cas.logout.SingleLogoutExecutionRequest;
import org.apereo.cas.logout.slo.BaseSingleLogoutServiceMessageHandler;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.http.HttpClient;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class OidcSingleLogoutServiceMessageHandler
extends BaseSingleLogoutServiceMessageHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcSingleLogoutServiceMessageHandler.class);
    private final OidcIssuerService issuerService;

    public OidcSingleLogoutServiceMessageHandler(HttpClient httpClient, SingleLogoutMessageCreator logoutMessageBuilder, ServicesManager servicesManager, SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder, boolean asynchronous, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, OidcIssuerService issuerService) {
        super(httpClient, logoutMessageBuilder, servicesManager, singleLogoutServiceLogoutUrlBuilder, asynchronous, authenticationRequestServiceSelectionStrategies);
        this.issuerService = issuerService;
    }

    public int getOrder() {
        return 0;
    }

    protected boolean supportsInternal(WebApplicationService singleLogoutService, RegisteredService registeredService, SingleLogoutExecutionRequest context) {
        return registeredService instanceof OidcRegisteredService;
    }

    protected Collection<SingleLogoutRequestContext> createLogoutRequests(String ticketId, WebApplicationService selectedService, RegisteredService registeredService, Collection<SingleLogoutUrl> logoutUrls, SingleLogoutExecutionRequest context) {
        return logoutUrls.stream().map(url -> {
            SingleLogoutUrl newSloUrl = url;
            RegisteredServiceLogoutType logoutType = url.getLogoutType();
            if (logoutType == RegisteredServiceLogoutType.FRONT_CHANNEL) {
                String newUrl = CommonHelper.addParameter((String)url.getUrl(), (String)"iss", (String)this.issuerService.determineIssuer(Optional.empty()));
                newUrl = CommonHelper.addParameter((String)newUrl, (String)"sid", (String)DigestUtils.sha((String)context.getTicketGrantingTicket().getId()));
                newSloUrl = new SingleLogoutUrl(newUrl, logoutType);
            }
            return this.createLogoutRequest(ticketId, selectedService, registeredService, newSloUrl, context);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendMessageToEndpoint(LogoutHttpMessage msg, SingleLogoutRequestContext request, SingleLogoutMessage logoutMessage) {
        HttpResponse response;
        block2: {
            boolean bl;
            String payload = logoutMessage.getPayload();
            response = null;
            try {
                HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.POST).url(msg.getUrl().toExternalForm()).entity("logout_token=" + payload).headers(CollectionUtils.wrap((String)"Content-Type", (Object)msg.getContentType())).build();
                response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
                if (response == null || Objects.requireNonNull(HttpStatus.resolve((int)response.getStatusLine().getStatusCode())).isError()) break block2;
                LOGGER.trace("Received OK logout response");
                bl = true;
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return bl;
        }
        HttpUtils.close((HttpResponse)response);
        LOGGER.warn("No (successful) logout response received from the url [{}]", (Object)msg.getUrl().toExternalForm());
        return false;
    }
}

