/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.consent;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import lombok.Generated;
import org.apereo.cas.consent.ConsentReminderOptions;

@MappedSuperclass
public class ConsentDecision
implements Serializable {
    private static final long serialVersionUID = -3240292729509593433L;
    @Id
    @Transient
    @JsonSerialize(using=ToStringSerializer.class)
    private long id;
    @Column(nullable=false)
    private String principal;
    @Column(nullable=false)
    private String service;
    @Column(nullable=false)
    private LocalDateTime createdDate = LocalDateTime.now(ZoneId.systemDefault());
    @Column(nullable=false)
    private ConsentReminderOptions options = ConsentReminderOptions.ATTRIBUTE_NAME;
    @Column(nullable=false)
    private Long reminder = 14L;
    @Column(nullable=false)
    private ChronoUnit reminderTimeUnit = ChronoUnit.DAYS;
    @Lob
    @Column(name="attributes", length=0x7FFFFFFF)
    private String attributes;

    public ConsentDecision() {
        this.id = System.currentTimeMillis();
    }

    @Generated
    public String toString() {
        return "ConsentDecision(id=" + this.id + ", principal=" + this.principal + ", service=" + this.service + ", createdDate=" + this.createdDate + ", options=" + this.options + ", reminder=" + this.reminder + ", reminderTimeUnit=" + this.reminderTimeUnit + ", attributes=" + this.attributes + ")";
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public ConsentReminderOptions getOptions() {
        return this.options;
    }

    @Generated
    public Long getReminder() {
        return this.reminder;
    }

    @Generated
    public ChronoUnit getReminderTimeUnit() {
        return this.reminderTimeUnit;
    }

    @Generated
    public String getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Generated
    public void setService(String service) {
        this.service = service;
    }

    @Generated
    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public void setOptions(ConsentReminderOptions options) {
        this.options = options;
    }

    @Generated
    public void setReminder(Long reminder) {
        this.reminder = reminder;
    }

    @Generated
    public void setReminderTimeUnit(ChronoUnit reminderTimeUnit) {
        this.reminderTimeUnit = reminderTimeUnit;
    }

    @Generated
    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }
}

