/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.widgets.AnyByRealmWidget;
import org.apache.syncope.client.console.widgets.CompletenessWidget;
import org.apache.syncope.client.console.widgets.LoadWidget;
import org.apache.syncope.client.console.widgets.NumberWidget;
import org.apache.syncope.client.console.widgets.UsersByStatusWidget;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.ResourceModel;

public class DashboardOverviewPanel
extends Panel {
    private static final long serialVersionUID = 5989039374050260225L;
    private final NumberWidget totalUsers;
    private final NumberWidget totalGroups;
    private final NumberWidget totalAny1OrRoles;
    private final NumberWidget totalAny2OrResources;
    private final UsersByStatusWidget usersByStatus;
    private final CompletenessWidget completeness;
    private final AnyByRealmWidget anyByRealm;
    private final LoadWidget load;

    public DashboardOverviewPanel(String id) {
        super(id);
        NumbersInfo numbers = SyncopeConsoleSession.get().getAnonymousClient().numbers();
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.totalUsers = new NumberWidget("totalUsers", "bg-yellow", numbers.getTotalUsers(), new ResourceModel("users").getObject(), "ion ion-person");
        container.add(new Component[]{this.totalUsers});
        this.totalGroups = new NumberWidget("totalGroups", "bg-red", numbers.getTotalGroups(), new ResourceModel("groups").getObject(), "ion ion-person-stalker");
        container.add(new Component[]{this.totalGroups});
        Triple<Integer, String, String> built = DashboardOverviewPanel.buildTotalAny1OrRoles(numbers);
        this.totalAny1OrRoles = new NumberWidget("totalAny1OrRoles", "bg-green", (Number)built.getLeft(), (String)built.getMiddle(), (String)built.getRight());
        container.add(new Component[]{this.totalAny1OrRoles});
        built = DashboardOverviewPanel.buildTotalAny2OrResources(numbers);
        this.totalAny2OrResources = new NumberWidget("totalAny2OrResources", "bg-info", (Number)built.getLeft(), (String)built.getMiddle(), (String)built.getRight());
        container.add(new Component[]{this.totalAny2OrResources});
        this.usersByStatus = new UsersByStatusWidget("usersByStatus", numbers.getUsersByStatus());
        container.add(new Component[]{this.usersByStatus});
        this.completeness = new CompletenessWidget("completeness", numbers.getConfCompleteness());
        container.add(new Component[]{this.completeness});
        this.anyByRealm = new AnyByRealmWidget("anyByRealm", numbers.getUsersByRealm(), numbers.getGroupsByRealm(), numbers.getAnyType1(), numbers.getAny1ByRealm(), numbers.getAnyType2(), numbers.getAny2ByRealm());
        container.add(new Component[]{this.anyByRealm});
        this.load = new LoadWidget("load", SyncopeConsoleSession.get().getAnonymousClient().system());
        container.add(new Component[]{this.load});
        container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.of(60L, ChronoUnit.SECONDS)){
            private static final long serialVersionUID = -4426283634345968585L;

            protected void onTimer(AjaxRequestTarget target) {
                Triple<Integer, String, String> updatedBuild;
                NumbersInfo numbers = SyncopeConsoleSession.get().getAnonymousClient().numbers();
                if (DashboardOverviewPanel.this.totalUsers.refresh(numbers.getTotalUsers())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.totalUsers});
                }
                if (DashboardOverviewPanel.this.totalGroups.refresh(numbers.getTotalGroups())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.totalGroups});
                }
                if (DashboardOverviewPanel.this.totalAny1OrRoles.refresh((Number)(updatedBuild = DashboardOverviewPanel.buildTotalAny1OrRoles(numbers)).getLeft())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.totalAny1OrRoles});
                }
                if (DashboardOverviewPanel.this.totalAny2OrResources.refresh((Number)(updatedBuild = DashboardOverviewPanel.buildTotalAny2OrResources(numbers)).getLeft())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.totalAny2OrResources});
                }
                if (DashboardOverviewPanel.this.usersByStatus.refresh(numbers.getUsersByStatus())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.usersByStatus});
                }
                if (DashboardOverviewPanel.this.completeness.refresh(numbers.getConfCompleteness())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.completeness});
                }
                if (DashboardOverviewPanel.this.anyByRealm.refresh(numbers.getUsersByRealm(), numbers.getGroupsByRealm(), numbers.getAnyType1(), numbers.getAny1ByRealm(), numbers.getAnyType2(), numbers.getAny2ByRealm())) {
                    target.add(new Component[]{DashboardOverviewPanel.this.anyByRealm});
                }
                DashboardOverviewPanel.this.load.refresh(SyncopeConsoleSession.get().getAnonymousClient().system());
                target.add(new Component[]{DashboardOverviewPanel.this.load});
            }
        }});
    }

    private static Triple<Integer, String, String> buildTotalAny1OrRoles(NumbersInfo numbers) {
        String icon;
        String label;
        int number;
        if (numbers.getAnyType1() == null) {
            number = numbers.getTotalRoles();
            label = new ResourceModel("roles").getObject();
            icon = "fas fa-users";
        } else {
            number = numbers.getTotalAny1();
            label = numbers.getAnyType1();
            icon = "ion ion-gear-a";
        }
        return Triple.of((Object)number, (Object)label, (Object)icon);
    }

    private static Triple<Integer, String, String> buildTotalAny2OrResources(NumbersInfo numbers) {
        String icon;
        String label;
        int number;
        if (numbers.getAnyType2() == null) {
            number = numbers.getTotalResources();
            label = new ResourceModel("resources").getObject();
            icon = "fa fa-database";
        } else {
            number = numbers.getTotalAny2();
            label = numbers.getAnyType2();
            icon = "ion ion-gear-a";
        }
        return Triple.of((Object)number, (Object)label, (Object)icon);
    }
}

