/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class X509WebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public X509WebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getX509().getWebflow().getOrder());
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ActionState actionState = this.createActionState(flow, "startX509Authenticate", new String[]{"x509Check"});
            TransitionSet transitionSet = actionState.getTransitionSet();
            transitionSet.add(this.createTransition("success", "createTicketGrantingTicket"));
            transitionSet.add(this.createTransition("warn", "warn"));
            transitionSet.add(this.createTransition("error", this.getStateIdOnX509Failure(flow)));
            transitionSet.add(this.createTransition("authenticationFailure", "handleAuthenticationFailure"));
            transitionSet.add(this.createTransition("successWithWarnings", "showAuthenticationWarningMessages"));
            actionState.getExitActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
            ActionState initState = (ActionState)this.getState(flow, "afterInitializeLoginForm", ActionState.class);
            this.createTransitionForState((TransitionableState)initState, "success", "startX509Authenticate", true);
        }
    }

    private String getStateIdOnX509Failure(Flow flow) {
        ActionState state = (ActionState)this.getState(flow, "afterInitializeLoginForm", ActionState.class);
        return state.getTransition("success").getTargetStateId();
    }
}

