/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.config;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.mfa.trusteddevice.DeviceFingerprintProperties;
import org.apereo.cas.trusted.util.cipher.CookieDeviceFingerprintComponentCipherExecutor;
import org.apereo.cas.trusted.web.flow.fingerprint.ClientIpDeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.flow.fingerprint.CookieDeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.flow.fingerprint.DefaultDeviceFingerprintStrategy;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintStrategy;
import org.apereo.cas.trusted.web.flow.fingerprint.GeoLocationDeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.flow.fingerprint.UserAgentDeviceFingerprintComponentManager;
import org.apereo.cas.trusted.web.support.TrustedDeviceCookieRetrievingCookieGenerator;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.Base64RandomStringGenerator;
import org.apereo.cas.util.gen.RandomStringGenerator;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.mgmr.EncryptedCookieValueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices)
@AutoConfiguration
public class MultifactorAuthnTrustedDeviceFingerprintConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthnTrustedDeviceFingerprintConfiguration.class);

    @AutoConfigureOrder(value=0x7FFFFFFF)
    @ConditionalOnBean(name={"geoLocationService"})
    @Configuration(value="MultifactorAuthnTrustedDeviceGeoLocationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustedDeviceGeoLocationConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"deviceFingerprintGeoLocationComponentExtractor"})
        public DeviceFingerprintComponentManager deviceFingerprintGeoLocationComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService) {
            return (DeviceFingerprintComponentManager)BeanSupplier.of(DeviceFingerprintComponentManager.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.geolocation.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.GeoLocation properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getGeolocation();
                GeoLocationDeviceFingerprintComponentManager component = new GeoLocationDeviceFingerprintComponentManager((GeoLocationService)geoLocationService.getObject());
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="MultifactorAuthnTrustedDeviceFingerprintCookieConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustedDeviceFingerprintCookieConfiguration {
        @ConditionalOnMissingBean(name={"deviceFingerprintCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder deviceFingerprintCookieGenerator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="deviceFingerprintCookieValueManager") CookieValueManager deviceFingerprintCookieValueManager) {
            return (CasCookieBuilder)BeanSupplier.of(CasCookieBuilder.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.cookie.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.Cookie cookie = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie();
                return new TrustedDeviceCookieRetrievingCookieGenerator(CookieUtils.buildCookieGenerationContext((CookieProperties)cookie), deviceFingerprintCookieValueManager);
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"deviceFingerprintCookieRandomStringGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RandomStringGenerator deviceFingerprintCookieRandomStringGenerator() {
            return new Base64RandomStringGenerator();
        }

        @Bean
        @ConditionalOnMissingBean(name={"deviceFingerprintCookieValueManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CookieValueManager deviceFingerprintCookieValueManager(@Qualifier(value="deviceFingerprintCookieCipherExecutor") CipherExecutor deviceFingerprintCookieCipherExecutor) {
            return new EncryptedCookieValueManager(deviceFingerprintCookieCipherExecutor);
        }

        @ConditionalOnMissingBean(name={"deviceFingerprintCookieCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor deviceFingerprintCookieCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie().getCrypto();
            boolean enabled = crypto.isEnabled();
            if (!enabled && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey())) {
                LOGGER.warn("Token encryption/signing is not enabled explicitly in the configuration, yet signing/encryption keys are defined for operations. CAS will proceed to enable the cookie encryption/signing functionality.");
                enabled = true;
            }
            if (enabled) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, CookieDeviceFingerprintComponentCipherExecutor.class);
            }
            return CipherExecutor.noOp();
        }
    }

    @Configuration(value="MultifactorAuthnTrustedDeviceFingerprintStrategyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustedDeviceFingerprintStrategyConfiguration {
        @ConditionalOnMissingBean(name={"deviceFingerprintStrategy"})
        @Bean(value={"deviceFingerprintStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DeviceFingerprintStrategy deviceFingerprintStrategy(List<DeviceFingerprintComponentManager> extractors, CasConfigurationProperties casProperties) {
            DeviceFingerprintProperties properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint();
            return new DefaultDeviceFingerprintStrategy(extractors, properties.getComponentSeparator());
        }
    }

    @Configuration(value="MultifactorAuthnTrustedDeviceFingerprintComponentConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class MultifactorAuthnTrustedDeviceFingerprintComponentConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"deviceFingerprintUserAgentComponentExtractor"})
        public DeviceFingerprintComponentManager deviceFingerprintUserAgentComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DeviceFingerprintComponentManager)BeanSupplier.of(DeviceFingerprintComponentManager.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.user-agent.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.UserAgent properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getUserAgent();
                UserAgentDeviceFingerprintComponentManager component = new UserAgentDeviceFingerprintComponentManager();
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"deviceFingerprintClientIpComponentExtractor"})
        public DeviceFingerprintComponentManager deviceFingerprintClientIpComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (DeviceFingerprintComponentManager)BeanSupplier.of(DeviceFingerprintComponentManager.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.client-ip.enabled").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.ClientIp properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getClientIp();
                ClientIpDeviceFingerprintComponentManager component = new ClientIpDeviceFingerprintComponentManager();
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"deviceFingerprintCookieComponentExtractor"})
        public DeviceFingerprintComponentManager deviceFingerprintCookieComponentExtractor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="deviceFingerprintCookieGenerator") CasCookieBuilder deviceFingerprintCookieGenerator, @Qualifier(value="deviceFingerprintCookieRandomStringGenerator") RandomStringGenerator deviceFingerprintCookieRandomStringGenerator) {
            return (DeviceFingerprintComponentManager)BeanSupplier.of(DeviceFingerprintComponentManager.class).when(BeanCondition.on((String)"cas.authn.mfa.trusted.device-fingerprint.cookie.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                DeviceFingerprintProperties.Cookie properties = casProperties.getAuthn().getMfa().getTrusted().getDeviceFingerprint().getCookie();
                CookieDeviceFingerprintComponentManager component = new CookieDeviceFingerprintComponentManager(deviceFingerprintCookieGenerator, deviceFingerprintCookieRandomStringGenerator);
                component.setOrder(properties.getOrder());
                return component;
            }).otherwiseProxy().get();
        }
    }
}

