/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.models.AssignedLicense;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.PasswordProfile;
import com.microsoft.graph.models.SubscribedSku;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserAssignLicenseParameterSet;
import com.microsoft.graph.requests.GroupCollectionPage;
import com.microsoft.graph.requests.GroupCollectionRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequestBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.tirasa.connid.bundles.azure.AzureConnectorConfiguration;
import net.tirasa.connid.bundles.azure.AzureFilterTranslator;
import net.tirasa.connid.bundles.azure.service.AzureClient;
import net.tirasa.connid.bundles.azure.utils.AzureAttributes;
import net.tirasa.connid.bundles.azure.utils.AzureFilter;
import net.tirasa.connid.bundles.azure.utils.AzureFilterOp;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="AzureConnector.connector.display", configurationClass=AzureConnectorConfiguration.class)
public class AzureConnector
implements Connector,
CreateOp,
DeleteOp,
SchemaOp,
SearchOp<AzureFilter>,
TestOp,
UpdateOp {
    public static final String SKIP_TOKEN_ID = "$skiptoken=";
    private static final Log LOG = Log.getLog(AzureConnector.class);
    private AzureConnectorConfiguration configuration;
    private Schema schema;
    private AzureClient client;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        LOG.ok("Init", new Object[0]);
        this.configuration = (AzureConnectorConfiguration)configuration;
        this.configuration.validate();
        this.client = new AzureClient(this.configuration);
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public void dispose() {
        LOG.ok("Configuration cleanup", new Object[0]);
        this.configuration = null;
    }

    public void test() {
        LOG.ok("connector TEST", new Object[0]);
        if (this.configuration != null) {
            if (this.client.getAuthenticated() != null) {
                LOG.ok("Test was successful", new Object[0]);
            } else {
                AzureUtils.handleGeneralError("Test error. Problems with client service");
            }
        } else {
            LOG.error("Error with establishing connection while testing. No instance of the configuration class", new Object[0]);
        }
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = AzureAttributes.buildSchema();
        }
        return this.schema;
    }

    public FilterTranslator<AzureFilter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        LOG.ok("check the ObjectClass", new Object[0]);
        if (objectClass == null) {
            throw new IllegalArgumentException("Object class not supported");
        }
        LOG.ok("The ObjectClass is ok", new Object[0]);
        return new AzureFilterTranslator(objectClass);
    }

    public void executeQuery(ObjectClass objectClass, AzureFilter query, ResultsHandler handler, OperationOptions options) {
        LOG.ok("Connector READ", new Object[0]);
        Attribute key = null;
        boolean moreFilters = true;
        if (query != null) {
            Attribute filterAttr = query.getAttribute();
            if (filterAttr instanceof Uid) {
                key = filterAttr;
            } else if (ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
                key = filterAttr;
            }
            if (key == null && !query.getFilters().isEmpty()) {
                moreFilters = false;
            }
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            if (key == null && moreFilters) {
                List users = null;
                int remainingResults = -1;
                int pagesSize = options.getPageSize() != null ? options.getPageSize() : -1;
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        if (StringUtil.isNotBlank((String)cookie)) {
                            UserCollectionPage request = this.client.getAuthenticated().getAllUsersNextPage(pagesSize, cookie);
                            users = request.getCurrentPage();
                            cookie = request.getNextPage() != null ? this.getSkipToken((BaseCollectionRequestBuilder)request.getNextPage()) : null;
                        } else {
                            users = this.client.getAuthenticated().getAllUsers(pagesSize);
                            UserCollectionRequestBuilder nextPageRequest = (UserCollectionRequestBuilder)this.client.getAuthenticated().getAllUsersNextPage(pagesSize, "").getNextPage();
                            cookie = nextPageRequest != null ? this.getSkipToken((BaseCollectionRequestBuilder)nextPageRequest) : null;
                        }
                    } else {
                        users = this.client.getAuthenticated().getAllUsers();
                    }
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Users!", e);
                }
                if (users != null) {
                    users.forEach(user -> handler.handle(this.fromUser((User)user, (Set<String>)attributesToGet)));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else if (AzureFilterOp.EQUALS == query.getFilterOp() && (Uid.NAME.equals(key.getName()) || "objectId".equals(key.getName()))) {
                User result = null;
                try {
                    result = this.client.getAuthenticated().getUser(AttributeUtil.getAsStringValue((Attribute)key));
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting User : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                }
                if (result != null) {
                    handler.handle(this.fromUser(result, attributesToGet));
                }
            } else {
                List<User> result = null;
                try {
                    result = this.client.getAuthenticated().getUsersFilteredBy(query);
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While searching with key : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                }
                if (result != null) {
                    result.forEach(user -> handler.handle(this.fromUser((User)user, (Set<String>)attributesToGet)));
                }
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            if (key == null && moreFilters) {
                List groups = null;
                int remainingResults = -1;
                int pagesSize = options.getPageSize() != null ? options.getPageSize() : -1;
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        if (StringUtil.isNotBlank((String)cookie)) {
                            GroupCollectionPage request = this.client.getAuthenticated().getAllGroupsNextPage(pagesSize, cookie);
                            groups = request.getCurrentPage();
                            cookie = request != null ? this.getSkipToken((BaseCollectionRequestBuilder)request.getNextPage()) : null;
                        } else {
                            groups = this.client.getAuthenticated().getAllGroups(pagesSize);
                            GroupCollectionRequestBuilder nextPageRequest = (GroupCollectionRequestBuilder)this.client.getAuthenticated().getAllGroupsNextPage(pagesSize, "").getNextPage();
                            cookie = nextPageRequest != null ? this.getSkipToken((BaseCollectionRequestBuilder)nextPageRequest) : null;
                        }
                    } else {
                        groups = this.client.getAuthenticated().getAllGroups();
                    }
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Groups!", e);
                }
                if (groups != null) {
                    groups.forEach(group -> handler.handle(this.fromGroup((Group)group, (Set<String>)attributesToGet)));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else if (AzureFilterOp.EQUALS == query.getFilterOp() && (Uid.NAME.equals(key.getName()) || "objectId".equals(key.getName()))) {
                Group result = null;
                try {
                    result = this.client.getAuthenticated().getGroup(AttributeUtil.getAsStringValue((Attribute)key));
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting Group!", e);
                }
                if (result != null) {
                    handler.handle(this.fromGroup(result, attributesToGet));
                }
            } else {
                List<Group> result = null;
                try {
                    result = this.client.getAuthenticated().getGroupsFilteredBy(query);
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While searching with key : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                }
                if (result != null) {
                    result.forEach(group -> handler.handle(this.fromGroup((Group)group, (Set<String>)attributesToGet)));
                }
            }
        } else if (new ObjectClass("azureLicense").equals((Object)objectClass)) {
            if (key == null) {
                List<SubscribedSku> subscribedSkus = null;
                try {
                    subscribedSkus = this.client.getAuthenticated().getCurrentTenantSubscriptions();
                }
                catch (Exception e) {
                    AzureUtils.wrapGeneralError("While getting subscriptions!", e);
                }
                if (subscribedSkus != null) {
                    for (SubscribedSku subscribedSku : subscribedSkus) {
                        handler.handle(this.fromLicense(subscribedSku, attributesToGet));
                    }
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(null, -1));
                }
            }
        } else {
            LOG.warn("Search of type " + objectClass.getObjectClassValue() + " is not supported", new Object[0]);
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        LOG.ok("Connector CREATE", new Object[0]);
        if (CollectionUtil.isEmpty(createAttributes)) {
            AzureUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(createAttributes);
        String id = accessor.findString("objectId");
        if (this.configuration.getRestoreItems() && id != null && this.client.getDeletedDirectoryObject(id) != null) {
            DirectoryObject directoryObject = this.client.restoreDirectoryObject(id);
            return new Uid(directoryObject.id);
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            User user = new User();
            User createdUser = new User();
            String username = accessor.findString("mailNickname");
            if (username == null) {
                username = accessor.findString(Name.NAME);
            }
            GuardedString password = accessor.getPassword();
            String displayName = accessor.findString("displayName");
            boolean status = accessor.getEnabled(true);
            List licenses = accessor.findList("azureLicense");
            try {
                user.displayName = displayName;
                user.mailNickname = username;
                PasswordProfile passwordProfile = new PasswordProfile();
                passwordProfile.password = String.valueOf(password);
                user.passwordProfile = passwordProfile;
                user.accountEnabled = status;
                createAttributes.stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> this.doUserSetAttribute(attribute.getName(), attribute.getValue(), user));
                createdUser = this.client.getAuthenticated().createUser(user);
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not create User : " + username, e);
            }
            List groups = accessor.findList(PredefinedAttributes.GROUPS_NAME);
            if (!CollectionUtil.isEmpty((Collection)groups)) {
                for (Object group : groups) {
                    try {
                        this.client.getAuthenticated().addUserToGroup(createdUser.id, group.toString());
                    }
                    catch (Exception e) {
                        LOG.error("Could not add User {0} to Group {1} ", new Object[]{createdUser.id, group, e});
                    }
                }
            }
            if (!CollectionUtil.isEmpty((Collection)licenses)) {
                for (Object license : licenses) {
                    try {
                        UserAssignLicenseParameterSet userAssignLicenseParameterSet = new UserAssignLicenseParameterSet();
                        AssignedLicense assignedLicense = new AssignedLicense();
                        assignedLicense.skuId = UUID.fromString(license.toString());
                        LinkedList<AssignedLicense> assignedLicenses = new LinkedList<AssignedLicense>();
                        assignedLicenses.add(assignedLicense);
                        ArrayList removedLicenses = new ArrayList();
                        userAssignLicenseParameterSet.addLicenses = assignedLicenses;
                        userAssignLicenseParameterSet.removeLicenses = removedLicenses;
                        this.client.getAuthenticated().assignLicense(createdUser.id, userAssignLicenseParameterSet);
                    }
                    catch (RuntimeException ex) {
                        LOG.error("While assigning license {0} to user {1}", new Object[]{license, createdUser, ex});
                    }
                }
            }
            return new Uid(createdUser.id);
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            String groupName = accessor.findString("mailNickname");
            if (groupName == null) {
                groupName = accessor.findString(Name.NAME);
            }
            String displayName = accessor.findString("displayName");
            Group group = new Group();
            Group createdGroup = new Group();
            try {
                group.displayName = displayName;
                group.mailNickname = groupName;
                createAttributes.stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> this.doGroupSetAttribute(attribute.getName(), attribute.getValue(), group));
                createdGroup = this.client.getAuthenticated().createGroup(group);
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not create Group : " + groupName, e);
            }
            return new Uid(createdGroup.id);
        }
        LOG.warn("Create of type " + objectClass.getObjectClassValue() + " is not supported", new Object[0]);
        throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        LOG.ok("Connector DELETE", new Object[0]);
        if (StringUtil.isBlank((String)uid.getUidValue())) {
            LOG.error("Uid not provided or empty ", new Object[0]);
            throw new InvalidAttributeValueException("Uid value not provided or empty");
        }
        if (objectClass == null) {
            LOG.error("Object value not provided ", new Object[0]);
            throw new InvalidAttributeValueException("Object value not provided");
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            try {
                for (Group group : this.client.getAuthenticated().getAllGroupsForUser(uid.getUidValue())) {
                    this.client.getAuthenticated().deleteUserFromGroup(uid.getUidValue(), group.id);
                }
            }
            catch (Exception e) {
                LOG.error("Could not delete User {0} from Groups", new Object[]{uid.getUidValue()});
            }
            try {
                this.client.getAuthenticated().deleteUser(uid.getUidValue());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not delete User " + uid.getUidValue(), e);
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            try {
                this.client.getAuthenticated().deleteGroup(uid.getUidValue());
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not delete Group " + uid.getUidValue(), e);
            }
        } else {
            LOG.warn("Delete of type " + objectClass.getObjectClassValue() + " is not supported", new Object[0]);
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        LOG.ok("Connector UPDATE", new Object[0]);
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            AzureUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            Uid returnUid = uid;
            String displayName = accessor.findString("displayName");
            Attribute status = accessor.find("accountEnabled");
            List licenses = accessor.findList("azureLicense");
            if (displayName == null) {
                AzureUtils.handleGeneralError("The displayName property cannot be cleared during updates");
            }
            User user = new User();
            user.id = uid.getUidValue();
            if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                LOG.warn("{0} attribute value not correct, can't handle User status update", new Object[]{OperationalAttributes.ENABLE_NAME});
            } else {
                user.accountEnabled = Boolean.valueOf(status.getValue().get(0).toString());
            }
            try {
                replaceAttributes.stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> this.doUserSetAttribute(attribute.getName(), attribute.getValue(), user));
                GuardedString password = accessor.getPassword();
                if (password != null) {
                    try {
                        if (user.passwordProfile != null) {
                            PasswordProfile passwordProfile = new PasswordProfile();
                            passwordProfile.password = String.valueOf(password);
                            user.passwordProfile = passwordProfile;
                        }
                    }
                    catch (Exception e) {
                        AzureUtils.wrapGeneralError("Could not update password for User " + uid.getUidValue(), e);
                    }
                }
                this.client.getAuthenticated().updateUser(user);
                returnUid = new Uid(user.id);
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not update User " + uid.getUidValue() + " from attributes ", e);
            }
            HashSet<String> ownGroups = new HashSet<String>();
            try {
                List<Group> ownGroupsResults = this.client.getAuthenticated().getAllGroupsForUser(returnUid.getUidValue());
                for (Group group : ownGroupsResults) {
                    ownGroups.add(group.id);
                }
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex, "Could not list groups for User {0}", new Object[]{uid.getUidValue()});
            }
            List groups = CollectionUtil.nullAsEmpty((List)accessor.findList(PredefinedAttributes.GROUPS_NAME));
            for (Object object : groups) {
                if (ownGroups.contains(object.toString())) continue;
                try {
                    this.client.getAuthenticated().addUserToGroup(returnUid.getUidValue(), object.toString());
                    LOG.ok("User added to Group: {0} after update", new Object[]{object});
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Could not add User {0} to Group {1} ", new Object[]{returnUid.getUidValue(), object});
                }
            }
            for (String string : ownGroups) {
                if (groups.contains(string)) continue;
                try {
                    this.client.getAuthenticated().deleteUserFromGroup(returnUid.getUidValue(), string);
                    LOG.ok("User removed from group: {0} after update", new Object[]{string});
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Could not remove Group {0} from User {1} ", new Object[]{string, returnUid.getUidValue()});
                }
            }
            User updatedUser = this.client.getAuthenticated().getUser(returnUid.getUidValue());
            if (updatedUser == null) {
                LOG.error("While reading user {0} after update in order to handle licenses update", new Object[]{returnUid.getUidValue()});
            } else {
                ArrayList<UUID> arrayList = new ArrayList<UUID>();
                if (updatedUser.assignedLicenses != null) {
                    for (AssignedLicense assignedLicense : updatedUser.assignedLicenses) {
                        arrayList.add(assignedLicense.skuId);
                    }
                }
                if (CollectionUtil.isEmpty((Collection)licenses)) {
                    if (!arrayList.isEmpty()) {
                        arrayList.forEach(uuid -> {
                            UserAssignLicenseParameterSet userAssignLicenseParameterSet = new UserAssignLicenseParameterSet();
                            LinkedList assignedLicenses = new LinkedList();
                            ArrayList<UUID> removedLicenses = new ArrayList<UUID>();
                            removedLicenses.add((UUID)uuid);
                            userAssignLicenseParameterSet.addLicenses = assignedLicenses;
                            userAssignLicenseParameterSet.removeLicenses = removedLicenses;
                            this.client.getAuthenticated().assignLicense(user.id, userAssignLicenseParameterSet);
                        });
                    }
                } else {
                    ArrayList<UUID> toRemove = new ArrayList<UUID>();
                    ArrayList<UUID> newLicenses = new ArrayList<UUID>();
                    for (Object license : licenses) {
                        newLicenses.add(UUID.fromString(license.toString()));
                    }
                    for (UUID assignedSkuId : arrayList) {
                        if (newLicenses.contains(assignedSkuId)) continue;
                        toRemove.add(assignedSkuId);
                    }
                    for (UUID newLicense : newLicenses) {
                        if (arrayList.contains(newLicense)) continue;
                        try {
                            UserAssignLicenseParameterSet userAssignLicenseParameterSet = new UserAssignLicenseParameterSet();
                            AssignedLicense assignedLicense = new AssignedLicense();
                            assignedLicense.skuId = newLicense;
                            LinkedList<AssignedLicense> assignedLicenses = new LinkedList<AssignedLicense>();
                            assignedLicenses.add(assignedLicense);
                            ArrayList removedLicenses = new ArrayList();
                            userAssignLicenseParameterSet.addLicenses = assignedLicenses;
                            userAssignLicenseParameterSet.removeLicenses = removedLicenses;
                            this.client.getAuthenticated().assignLicense(user.id, userAssignLicenseParameterSet);
                        }
                        catch (RuntimeException ex) {
                            LOG.error((Throwable)ex, "While assigning license {0} to user {1}", new Object[]{newLicense, user});
                        }
                    }
                    if (!toRemove.isEmpty()) {
                        try {
                            UserAssignLicenseParameterSet userAssignLicenseParameterSet = new UserAssignLicenseParameterSet();
                            LinkedList assignedLicenses = new LinkedList();
                            userAssignLicenseParameterSet.removeLicenses = toRemove;
                            userAssignLicenseParameterSet.addLicenses = assignedLicenses;
                            this.client.getAuthenticated().assignLicense(user.id, userAssignLicenseParameterSet);
                        }
                        catch (RuntimeException ex) {
                            LOG.error((Throwable)ex, "While removing licenses from user {1}", new Object[]{user});
                        }
                    }
                }
            }
            return returnUid;
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            Uid returnUid = uid;
            String groupID = accessor.findString("objectId");
            if (groupID == null) {
                groupID = accessor.findString(Name.NAME);
            }
            String mailNickname = accessor.findString("mailNickname");
            String displayName = accessor.findString("displayName");
            Group group = new Group();
            group.id = uid.getUidValue();
            if (!uid.getUidValue().equals(groupID)) {
                LOG.info("Update - uid value different from Group ID", new Object[0]);
                group.mailNickname = mailNickname;
                group.displayName = displayName;
            }
            try {
                replaceAttributes.stream().filter(attribute -> attribute.getValue() != null).forEach(attribute -> this.doGroupSetAttribute(attribute.getName(), attribute.getValue(), group));
                this.client.getAuthenticated().updateGroup(group);
                returnUid = new Uid(group.id);
            }
            catch (Exception e) {
                AzureUtils.wrapGeneralError("Could not update Group " + uid.getUidValue() + " from attributes ", e);
            }
            return returnUid;
        }
        LOG.warn("Update of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public AzureClient getClient() {
        return this.client;
    }

    private ConnectorObject fromUser(User user, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.ACCOUNT);
        builder.setUid(user.id);
        builder.setName(user.userPrincipalName);
        try {
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            Field[] fields = User.class.getDeclaredFields();
            block68: for (Field field : fields) {
                if (field.getAnnotation(JsonIgnore.class) != null) continue;
                field.setAccessible(true);
                if (field.getName().equals("passwordProfile") && user.passwordProfile != null) {
                    attrs.add(AttributeBuilder.build((String)"passwordProfile", (Object[])new Object[]{user.passwordProfile.password == null ? null : new GuardedString(user.passwordProfile.password.toCharArray())}));
                    continue;
                }
                if (field.getName().equals("accountEnabled") && user.accountEnabled != null) {
                    attrs.add(AttributeBuilder.build((String)"accountEnabled", (Object[])new Object[]{user.accountEnabled}));
                    continue;
                }
                switch (field.getName()) {
                    case "displayName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.displayName, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "id": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.id, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "userPrincipalName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.userPrincipalName, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "city": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.city, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "country": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.country, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "department": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.department, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "businessPhones": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.businessPhones, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "givenName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.givenName, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "onPremisesImmutableId": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.onPremisesImmutableId, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "jobTitle": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.jobTitle, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "mail": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.mail, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "mobilePhone": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.mobilePhone, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "preferredLanguage": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.preferredLanguage, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "officeLocation": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.officeLocation, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "postalCode": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.postalCode, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "state": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.state, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "streetAddress": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.streetAddress, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "surname": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.surname, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "usageLocation": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.usageLocation, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "companyName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.companyName, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "creationType": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.creationType, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "employeeId": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.employeeId, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "onPremisesDistinguishedName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.onPremisesDistinguishedName, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "onPremisesSecurityIdentifier": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.onPremisesSecurityIdentifier, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "showInAddressList": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.showInAddressList, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "proxyAddresses": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.proxyAddresses, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "userType": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.userType, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "otherMails": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.otherMails, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "provisionedPlans": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.provisionedPlans, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "assignedLicenses": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.assignedLicenses, field.getName(), field.getType()).build());
                        continue block68;
                    }
                    case "assignedPlans": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(user.assignedPlans, field.getName(), field.getType()).build());
                        continue block68;
                    }
                }
            }
            block69: for (Attribute toAttribute : attrs) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (OperationalAttributes.ENABLE_NAME.equals(attributeToGetName) && "accountEnabled".equals(attributeName)) {
                        builder.addAttribute(OperationalAttributes.ENABLE_NAME, (Collection)toAttribute.getValue());
                        continue block69;
                    }
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block69;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains(PredefinedAttributes.GROUPS_NAME)) {
            ArrayList<String> groupNames = new ArrayList<String>();
            List<Group> groups = this.client.getAuthenticated().getAllGroupsForUser(user.id);
            for (Group group : groups) {
                groupNames.add(group.mailNickname);
            }
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)PredefinedAttributes.GROUPS_NAME, groupNames)});
        }
        return builder.build();
    }

    private ConnectorObject fromGroup(Group group, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        builder.setUid(group.id);
        builder.setName(group.mailNickname);
        try {
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            Field[] fields = Group.class.getDeclaredFields();
            block42: for (Field field : fields) {
                field.setAccessible(true);
                switch (field.getName()) {
                    case "id": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.id, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "mail": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.mail, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "mailEnabled": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.mailEnabled, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "onPremisesSecurityIdentifier": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.onPremisesSecurityIdentifier, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "proxyAddresses": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.proxyAddresses, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "description": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.description, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "securityEnabled": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.securityEnabled, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "classification": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.classification, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "groupTypes": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.groupTypes, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "preferredLanguage": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.preferredLanguage, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "securityIdentifier": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.securityIdentifier, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "theme": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.theme, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "visibility": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.visibility, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "mailNickname": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.mailNickname, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "displayName": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.displayName, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "allowExternalSenders": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.allowExternalSenders, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "autoSubscribeNewMembers": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.autoSubscribeNewMembers, field.getName(), field.getType()).build());
                        continue block42;
                    }
                    case "preferredDataLocation": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(group.preferredDataLocation, field.getName(), field.getType()).build());
                        continue block42;
                    }
                }
            }
            block43: for (Attribute toAttribute : attrs) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block43;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains("objectId")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"objectId", (Object[])new Object[]{group.id})});
        }
        return builder.build();
    }

    private ConnectorObject fromLicense(SubscribedSku subscribedSku, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(new ObjectClass("azureLicense"));
        builder.setUid(subscribedSku.id);
        builder.setName(String.valueOf(subscribedSku.skuId));
        try {
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            Field[] fields = SubscribedSku.class.getDeclaredFields();
            block22: for (Field field : fields) {
                field.setAccessible(true);
                switch (field.getName()) {
                    case "id": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.id, field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "appliesTo": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.appliesTo, field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "capabilityStatus": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.capabilityStatus, field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "consumedUnits": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.consumedUnits, field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "prepaidUnits": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.prepaidUnits, field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "servicePlans": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.servicePlans, field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "skuPartNumber": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.skuPartNumber, field.getName(), field.getType()).build());
                        continue block22;
                    }
                    case "oDataType": {
                        attrs.add(AzureAttributes.doBuildAttributeFromClassField(subscribedSku.oDataType, field.getName(), field.getType()).build());
                        continue block22;
                    }
                }
            }
            block23: for (Attribute toAttribute : attrs) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block23;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        if (attributesToGet.contains("azureLicense")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"azureLicense", (Object[])new Object[]{subscribedSku.id})});
        }
        return builder.build();
    }

    private String getSkipToken(BaseCollectionRequestBuilder request) {
        String token = null;
        if (request != null) {
            token = request.getRequestUrl().substring(request.getRequestUrl().indexOf(SKIP_TOKEN_ID) + SKIP_TOKEN_ID.length());
        }
        return StringUtil.isNotBlank(token) ? token.substring(0, token.indexOf("&")) : null;
    }

    private void doUserSetAttribute(String name, List<Object> values, User user) {
        Object value = values.isEmpty() ? null : values.get(0);
        switch (name) {
            case "displayName": {
                user.displayName = (String)value;
                break;
            }
            case "id": {
                user.id = (String)value;
                break;
            }
            case "city": {
                user.city = (String)value;
                break;
            }
            case "country": {
                user.country = (String)value;
                break;
            }
            case "department": {
                user.department = (String)value;
                break;
            }
            case "businessPhones": {
                user.businessPhones = new ArrayList<Object>(values);
                break;
            }
            case "givenName": {
                user.givenName = (String)value;
                break;
            }
            case "onPremisesImmutableId": {
                user.onPremisesImmutableId = (String)value;
                break;
            }
            case "jobTitle": {
                user.jobTitle = (String)value;
                break;
            }
            case "mail": {
                user.mail = (String)value;
                break;
            }
            case "mobilePhone": {
                user.mobilePhone = (String)value;
                break;
            }
            case "passwordPolicies": {
                user.passwordPolicies = (String)value;
                break;
            }
            case "preferredLanguage": {
                user.preferredLanguage = (String)value;
                break;
            }
            case "officeLocation": {
                user.officeLocation = (String)value;
                break;
            }
            case "postalCode": {
                user.postalCode = (String)value;
                break;
            }
            case "state": {
                user.state = (String)value;
                break;
            }
            case "streetAddress": {
                user.streetAddress = (String)value;
                break;
            }
            case "surname": {
                user.surname = (String)value;
                break;
            }
            case "usageLocation": {
                user.usageLocation = (String)value;
                break;
            }
            case "userPrincipalName": {
                user.userPrincipalName = (String)value;
                break;
            }
            case "companyName": {
                user.companyName = (String)value;
                break;
            }
            case "creationType": {
                user.creationType = (String)value;
                break;
            }
            case "employeeId": {
                user.employeeId = (String)value;
                break;
            }
            case "onPremisesDistinguishedName": {
                user.onPremisesDistinguishedName = (String)value;
                break;
            }
            case "onPremisesSecurityIdentifier": {
                user.onPremisesSecurityIdentifier = (String)value;
                break;
            }
            case "showInAddressList": {
                user.showInAddressList = (Boolean)value;
                break;
            }
            case "proxyAddresses": {
                user.proxyAddresses = new ArrayList<Object>(values);
                break;
            }
            case "userType": {
                user.userType = (String)value;
                break;
            }
            case "otherMails": {
                user.otherMails = new ArrayList<Object>(values);
                break;
            }
            case "provisionedPlans": {
                user.provisionedPlans = new ArrayList<Object>(values);
                break;
            }
            case "assignedLicenses": {
                user.assignedLicenses = new ArrayList<Object>(values);
                break;
            }
            case "assignedPlans": {
                user.assignedPlans = new ArrayList<Object>(values);
                break;
            }
        }
    }

    private void doGroupSetAttribute(String name, List<Object> values, Group group) {
        Object value = values.isEmpty() ? null : values.get(0);
        switch (name) {
            case "id": {
                group.id = (String)value;
                break;
            }
            case "mail": {
                group.mail = (String)value;
                break;
            }
            case "mailEnabled": {
                group.mailEnabled = (Boolean)value;
                break;
            }
            case "onPremisesSecurityIdentifier": {
                group.onPremisesSecurityIdentifier = (String)value;
                break;
            }
            case "proxyAddresses": {
                group.proxyAddresses = new ArrayList<Object>(values);
                break;
            }
            case "description": {
                group.description = (String)value;
                break;
            }
            case "securityEnabled": {
                group.securityEnabled = (Boolean)value;
                break;
            }
            case "classification": {
                group.classification = (String)value;
                break;
            }
            case "groupTypes": {
                group.groupTypes = new ArrayList<Object>(values);
                break;
            }
            case "preferredLanguage": {
                group.preferredLanguage = (String)value;
                break;
            }
            case "securityIdentifier": {
                group.securityIdentifier = (String)value;
                break;
            }
            case "theme": {
                group.theme = (String)value;
                break;
            }
            case "visibility": {
                group.visibility = (String)value;
                break;
            }
            case "mailNickname": {
                group.mailNickname = (String)value;
                break;
            }
            case "displayName": {
                group.displayName = (String)value;
                break;
            }
            case "allowExternalSenders": {
                group.allowExternalSenders = (Boolean)value;
                break;
            }
            case "autoSubscribeNewMembers": {
                group.autoSubscribeNewMembers = (Boolean)value;
                break;
            }
            case "preferredDataLocation": {
                group.preferredDataLocation = (String)value;
                break;
            }
        }
    }
}

