/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.audit.EventCategory;
import org.apache.syncope.common.lib.types.AuditElements;

public class AuditLoggerName
implements BaseBean {
    private static final long serialVersionUID = -647989486671786839L;
    public static final String AUDIT_PREFIX = "syncope.audit";
    private final AuditElements.EventCategoryType type;
    private final String category;
    private final String subcategory;
    private final String event;
    private final AuditElements.Result result;

    public static String getAuditLoggerName(String domain) {
        return "syncope.audit." + domain;
    }

    public static String getAuditEventLoggerName(String domain, String loggerName) {
        return domain + "." + loggerName;
    }

    public static AuditLoggerName fromAuditKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        if (!key.startsWith(AUDIT_PREFIX)) {
            throw new IllegalArgumentException("Audit logger name must start with syncope.audit");
        }
        Pair<EventCategory, AuditElements.Result> eventCategory = AuditLoggerName.parseEventCategory(key.replace("syncope.audit.", ""));
        return new AuditLoggerName(((EventCategory)eventCategory.getKey()).getType(), ((EventCategory)eventCategory.getKey()).getCategory(), ((EventCategory)eventCategory.getKey()).getSubcategory(), ((EventCategory)eventCategory.getKey()).getEvents().isEmpty() ? "" : ((EventCategory)eventCategory.getKey()).getEvents().iterator().next(), (AuditElements.Result)((Object)eventCategory.getValue()));
    }

    public static Pair<EventCategory, AuditElements.Result> parseEventCategory(String event) {
        EventCategory eventCategory = new EventCategory();
        AuditElements.Result condition = null;
        if (StringUtils.isNotEmpty((CharSequence)event)) {
            String[] elements = event.substring(1, event.length() - 1).split("\\]:\\[");
            if (elements.length == 1) {
                eventCategory.setType(AuditElements.EventCategoryType.CUSTOM);
                condition = AuditElements.Result.SUCCESS;
                eventCategory.getEvents().add(event);
            } else {
                eventCategory.setType(AuditElements.EventCategoryType.valueOf(elements[0]));
                eventCategory.setCategory(StringUtils.isNotEmpty((CharSequence)elements[1]) ? elements[1] : null);
                eventCategory.setSubcategory(StringUtils.isNotEmpty((CharSequence)elements[2]) ? elements[2] : null);
                if (elements.length > 3 && StringUtils.isNotEmpty((CharSequence)elements[3])) {
                    eventCategory.getEvents().add(elements[3]);
                }
                if (elements.length > 4) {
                    condition = AuditElements.Result.valueOf(elements[4].toUpperCase());
                }
            }
        }
        return Pair.of((Object)eventCategory, condition);
    }

    public static String buildEvent(AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result result) {
        StringBuilder eventBuilder = new StringBuilder();
        eventBuilder.append('[');
        if (type != null) {
            eventBuilder.append(type.name());
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)category)) {
            eventBuilder.append(category);
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)subcategory)) {
            eventBuilder.append(subcategory);
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)event)) {
            eventBuilder.append(event);
        }
        eventBuilder.append(']');
        if (result != null) {
            eventBuilder.append(":[").append((Object)result).append(']');
        }
        return eventBuilder.toString();
    }

    @JsonCreator
    public AuditLoggerName(@JsonProperty(value="type") AuditElements.EventCategoryType type, @JsonProperty(value="category") String category, @JsonProperty(value="subcategory") String subcategory, @JsonProperty(value="event") String event, @JsonProperty(value="result") AuditElements.Result result) {
        this.type = Optional.ofNullable(type).orElse(AuditElements.EventCategoryType.CUSTOM);
        this.category = category;
        this.subcategory = subcategory;
        this.event = event;
        this.result = Optional.ofNullable(result).orElse(AuditElements.Result.SUCCESS);
    }

    public AuditElements.EventCategoryType getType() {
        return this.type;
    }

    public String getEvent() {
        return this.event;
    }

    public String getCategory() {
        return this.category;
    }

    public AuditElements.Result getResult() {
        return this.result;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append((Object)this.category).append((Object)this.subcategory).append((Object)this.event).append((Object)this.result).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditLoggerName other = (AuditLoggerName)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.category, (Object)other.category).append((Object)this.subcategory, (Object)other.subcategory).append((Object)this.event, (Object)other.event).append((Object)this.result, (Object)other.result).build();
    }

    public String toString() {
        return AuditLoggerName.buildEvent(this.type, this.category, this.subcategory, this.event, this.result);
    }

    public String toAuditKey() {
        return "syncope.audit." + this.toString();
    }
}

