/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.dto.AbstractSCIMComplex;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import org.identityconnectors.common.StringUtil;

public class SCIMGenericComplex<T extends Serializable>
extends AbstractSCIMComplex {
    private static final long serialVersionUID = -5982485563252126677L;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String display;
    @JsonProperty
    private T type;
    @JsonProperty
    private Boolean primary;
    @JsonProperty
    private String operation;

    public String getDisplay() {
        return this.display;
    }

    public T getType() {
        return this.type;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setType(T type) {
        this.type = type;
    }

    public Boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    protected List<Field> getDeclaredFields() {
        return SCIMUtils.getAllFieldsList(this.getClass()).stream().filter(f -> !"LOG".equals(f.getName()) && !"serialVersionUID".equals(f.getName())).collect(Collectors.toList());
    }

    @Override
    protected String getAttributeName(String id, Field field, SCIMConnectorConfiguration configuration) {
        return id.concat(".").concat(this.type == null ? (StringUtil.isBlank((String)configuration.getGenericComplexType()) ? "" : configuration.getGenericComplexType().concat(".")) : this.type.toString().concat(".")).concat(field.getName());
    }

    public String toString() {
        return "SCIMGenericComplex{display=" + this.display + ", type=" + this.type + ", primary=" + this.primary + ", operation=" + this.operation + ", value=" + this.value + '}';
    }

    public static final class Builder<T extends Serializable> {
        private final SCIMGenericComplex<T> instance = new SCIMGenericComplex();

        public Builder<T> value(String value) {
            this.instance.setValue(value);
            return this;
        }

        public Builder<T> display(String display) {
            this.instance.setDisplay(display);
            return this;
        }

        public Builder<T> type(T type) {
            this.instance.setType(type);
            return this;
        }

        public Builder<T> primary(Boolean primary) {
            this.instance.setPrimary(primary);
            return this;
        }

        public Builder<T> operation(String operation) {
            this.instance.setOperation(operation);
            return this;
        }

        public SCIMGenericComplex<T> build() {
            return this.instance;
        }
    }
}

