/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.validation;

import com.google.common.base.Strings;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ErrorLevelFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.util.lang.Args;

class FeedbackMessageBehavior
extends Behavior {
    private static final long serialVersionUID = 3116618186507530804L;
    private String attributeName;

    FeedbackMessageBehavior(String attribute) {
        Args.notNull((Object)attribute, (String)"attribute");
        this.attributeName = attribute;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        FeedbackMessages messages = component.getFeedbackMessages();
        if (messages != null && messages.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (FeedbackMessage message : messages.messages(ErrorLevelFeedbackMessageFilter.ALL)) {
                String msg;
                if (message.isRendered() || Strings.isNullOrEmpty((String)(msg = message.getMessage().toString()))) continue;
                sb.append(msg);
            }
            String messageString = sb.toString();
            if (!Strings.isNullOrEmpty((String)messageString)) {
                tag.getAttributes().put((Object)this.attributeName, (Object)messageString);
            }
        }
    }
}

