/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.Upsert;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpsertValidator
extends AbstractValidator<Upsert> {
    @Override
    public void validate(Upsert upsert) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.upsert);
        }
        this.validateOptionalFromItem(upsert.getTable());
        this.validateOptionalExpressions(upsert.getColumns());
        this.validateOptionalItemsList(upsert.getItemsList());
        this.validateOptionalSelect(upsert.getSelect());
        if (upsert.isUseDuplicate()) {
            this.validateDuplicate(upsert);
        }
    }

    private void validateOptionalSelect(Select select) {
        if (select != null) {
            SelectValidator selectValidator = this.getValidator(SelectValidator.class);
            if (this.isNotEmpty(select.getWithItemsList())) {
                select.getWithItemsList().forEach(withItem -> withItem.accept(selectValidator));
            }
            select.getSelectBody().accept(selectValidator);
        }
    }

    private void validateDuplicate(Upsert upsert) {
        this.validateOptionalExpressions(upsert.getDuplicateUpdateColumns());
        this.validateOptionalExpressions(upsert.getDuplicateUpdateExpressionList());
    }
}

