/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.entity.am.CASSPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.am.OIDCRPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPClientApp;
import org.apache.syncope.core.provisioning.api.data.wa.WAClientAppDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class WAClientAppLogic {
    protected final WAClientAppDataBinder binder;
    protected final CASSPClientAppDAO casSPClientAppDAO;
    protected final OIDCRPClientAppDAO oidcRPClientAppDAO;
    protected final SAML2SPClientAppDAO saml2SPClientAppDAO;

    public WAClientAppLogic(WAClientAppDataBinder binder, CASSPClientAppDAO casSPClientAppDAO, OIDCRPClientAppDAO oidcRPClientAppDAO, SAML2SPClientAppDAO saml2SPClientAppDAO) {
        this.binder = binder;
        this.casSPClientAppDAO = casSPClientAppDAO;
        this.oidcRPClientAppDAO = oidcRPClientAppDAO;
        this.saml2SPClientAppDAO = saml2SPClientAppDAO;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<WAClientApp> list() {
        ArrayList<WAClientApp> clientApps = new ArrayList<WAClientApp>();
        Stream.of(ClientAppType.values()).forEach(type -> {
            switch (type) {
                case OIDCRP: {
                    clientApps.addAll(this.oidcRPClientAppDAO.findAll().stream().map(arg_0 -> ((WAClientAppDataBinder)this.binder).getWAClientApp(arg_0)).collect(Collectors.toList()));
                    break;
                }
                case SAML2SP: {
                    clientApps.addAll(this.saml2SPClientAppDAO.findAll().stream().map(arg_0 -> ((WAClientAppDataBinder)this.binder).getWAClientApp(arg_0)).collect(Collectors.toList()));
                    break;
                }
                default: {
                    clientApps.addAll(this.casSPClientAppDAO.findAll().stream().map(arg_0 -> ((WAClientAppDataBinder)this.binder).getWAClientApp(arg_0)).collect(Collectors.toList()));
                }
            }
        });
        return clientApps;
    }

    protected WAClientApp doRead(Long clientAppId, ClientAppType type) {
        WAClientApp clientApp = null;
        switch (type) {
            case OIDCRP: {
                OIDCRPClientApp oidcrp = this.oidcRPClientAppDAO.findByClientAppId(clientAppId);
                if (oidcrp == null) break;
                clientApp = this.binder.getWAClientApp((ClientApp)oidcrp);
                break;
            }
            case SAML2SP: {
                SAML2SPClientApp saml2sp = this.saml2SPClientAppDAO.findByClientAppId(clientAppId);
                if (saml2sp == null) break;
                clientApp = this.binder.getWAClientApp((ClientApp)saml2sp);
                break;
            }
            case CASSP: {
                CASSPClientApp cassp = this.casSPClientAppDAO.findByClientAppId(clientAppId);
                if (cassp == null) break;
                clientApp = this.binder.getWAClientApp((ClientApp)cassp);
                break;
            }
        }
        return clientApp;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public WAClientApp read(Long clientAppId, ClientAppType type) {
        WAClientApp clientApp = null;
        if (type == null) {
            for (int i = 0; i < ClientAppType.values().length && clientApp == null; ++i) {
                clientApp = this.doRead(clientAppId, ClientAppType.values()[i]);
            }
        } else {
            clientApp = this.doRead(clientAppId, type);
        }
        if (clientApp == null) {
            throw new NotFoundException("Client app with clientApp ID " + clientAppId + " and type " + type + " not found");
        }
        return clientApp;
    }

    protected WAClientApp doRead(String name, ClientAppType type) {
        WAClientApp clientApp = null;
        switch (type) {
            case OIDCRP: {
                OIDCRPClientApp oidcrp = this.oidcRPClientAppDAO.findByName(name);
                if (oidcrp == null) break;
                clientApp = this.binder.getWAClientApp((ClientApp)oidcrp);
                break;
            }
            case SAML2SP: {
                SAML2SPClientApp saml2sp = this.saml2SPClientAppDAO.findByName(name);
                if (saml2sp == null) break;
                clientApp = this.binder.getWAClientApp((ClientApp)saml2sp);
                break;
            }
            case CASSP: {
                CASSPClientApp cassp = this.casSPClientAppDAO.findByName(name);
                if (cassp == null) break;
                clientApp = this.binder.getWAClientApp((ClientApp)cassp);
                break;
            }
        }
        return clientApp;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public WAClientApp read(String name, ClientAppType type) {
        WAClientApp clientApp = null;
        if (type == null) {
            for (int i = 0; i < ClientAppType.values().length && clientApp == null; ++i) {
                clientApp = this.doRead(name, ClientAppType.values()[i]);
            }
        } else {
            clientApp = this.doRead(name, type);
        }
        if (clientApp == null) {
            throw new NotFoundException("Client app with name " + name + " with type " + type + " not found");
        }
        return clientApp;
    }
}

