/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class RealmLogic
extends AbstractTransactionalLogic<RealmTO> {
    protected final RealmDAO realmDAO;
    protected final AnySearchDAO searchDAO;
    protected final TaskDAO taskDAO;
    protected final CASSPClientAppDAO casSPClientAppDAO;
    protected final OIDCRPClientAppDAO oidcRPClientAppDAO;
    protected final SAML2SPClientAppDAO saml2SPClientAppDAO;
    protected final RealmDataBinder binder;
    protected final PropagationManager propagationManager;
    protected final PropagationTaskExecutor taskExecutor;

    public RealmLogic(RealmDAO realmDAO, AnySearchDAO searchDAO, TaskDAO taskDAO, CASSPClientAppDAO casSPClientAppDAO, OIDCRPClientAppDAO oidcRPClientAppDAO, SAML2SPClientAppDAO saml2SPClientAppDAO, RealmDataBinder binder, PropagationManager propagationManager, PropagationTaskExecutor taskExecutor) {
        this.realmDAO = realmDAO;
        this.searchDAO = searchDAO;
        this.taskDAO = taskDAO;
        this.casSPClientAppDAO = casSPClientAppDAO;
        this.oidcRPClientAppDAO = oidcRPClientAppDAO;
        this.saml2SPClientAppDAO = saml2SPClientAppDAO;
        this.binder = binder;
        this.propagationManager = propagationManager;
        this.taskExecutor = taskExecutor;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public Pair<Integer, List<RealmTO>> search(String keyword, String base, int page, int size) {
        Realm baseRealm = Optional.ofNullable(base == null ? this.realmDAO.getRoot() : this.realmDAO.findByFullPath(base)).orElseThrow(() -> new NotFoundException(base));
        int count = this.realmDAO.countDescendants(baseRealm.getFullPath(), keyword);
        List result = this.realmDAO.findDescendants(baseRealm.getFullPath(), keyword, page, size);
        return Pair.of((Object)count, result.stream().map(realm -> this.binder.getRealmTO(realm, ((Set)AuthContextUtils.getAuthorizations().get("REALM_SEARCH")).stream().anyMatch(auth -> realm.getFullPath().startsWith((String)auth)))).sorted(Comparator.comparing(RealmTO::getFullPath)).collect(Collectors.toList()));
    }

    @PreAuthorize(value="hasRole('REALM_CREATE')")
    public ProvisioningResult<RealmTO> create(String parentPath, RealmTO realmTO) {
        Realm parent;
        if (StringUtils.isBlank((CharSequence)realmTO.getParent())) {
            parent = Optional.ofNullable(this.realmDAO.findByFullPath(parentPath)).orElseThrow(() -> new NotFoundException(parentPath));
            realmTO.setParent(parent.getFullPath());
        } else {
            parent = Optional.ofNullable(this.realmDAO.find(realmTO.getParent())).orElseThrow(() -> new NotFoundException(realmTO.getParent()));
            if (!parent.getFullPath().equals(parentPath)) {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPath);
                sce.getElements().add("Mismatching parent realm: " + parentPath + " Vs " + parent.getFullPath());
                throw sce;
            }
        }
        String fullPath = StringUtils.appendIfMissing((String)parent.getFullPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + realmTO.getName();
        if (this.realmDAO.findByFullPath(fullPath) != null) {
            throw new DuplicateException(fullPath);
        }
        Realm realm = this.realmDAO.save(this.binder.create(parent, realmTO));
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.CREATE, (Collection)realm.getResourceKeys());
        List taskInfos = this.propagationManager.createTasks(realm, propByRes, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, false, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        return result;
    }

    @PreAuthorize(value="hasRole('REALM_UPDATE')")
    public ProvisioningResult<RealmTO> update(RealmTO realmTO) {
        Realm realm = Optional.ofNullable(this.realmDAO.findByFullPath(realmTO.getFullPath())).orElseThrow(() -> new NotFoundException(realmTO.getFullPath()));
        Map beforeAttrs = this.propagationManager.prepareAttrs(realm);
        PropagationByResource propByRes = this.binder.update(realm, realmTO);
        realm = this.realmDAO.save(realm);
        List taskInfos = this.propagationManager.setAttributeDeltas(this.propagationManager.createTasks(realm, propByRes, null), beforeAttrs);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, false, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        return result;
    }

    @PreAuthorize(value="hasRole('REALM_DELETE')")
    public ProvisioningResult<RealmTO> delete(String fullPath) {
        Realm realm = Optional.ofNullable(this.realmDAO.findByFullPath(fullPath)).orElseThrow(() -> new NotFoundException(fullPath));
        if (!this.realmDAO.findChildren(realm).isEmpty()) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RealmContains);
        }
        Set<String> adminRealms = Set.of(realm.getFullPath());
        AnyCond keyCond = new AnyCond(AttrCond.Type.ISNOTNULL);
        keyCond.setSchema("key");
        SearchCond allMatchingCond = SearchCond.getLeaf((AbstractSearchCond)keyCond);
        int users = this.searchDAO.count(realm, true, adminRealms, allMatchingCond, AnyTypeKind.USER);
        int groups = this.searchDAO.count(realm, true, adminRealms, allMatchingCond, AnyTypeKind.GROUP);
        int anyObjects = this.searchDAO.count(realm, true, adminRealms, allMatchingCond, AnyTypeKind.ANY_OBJECT);
        int macroTasks = this.taskDAO.findByRealm(realm).size();
        int clientApps = this.casSPClientAppDAO.findByRealm(realm).size() + this.saml2SPClientAppDAO.findByRealm(realm).size() + this.oidcRPClientAppDAO.findByRealm(realm).size();
        if (users + groups + anyObjects + macroTasks + clientApps > 0) {
            SyncopeClientException realmContains = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RealmContains);
            realmContains.getElements().add(users + " user(s)");
            realmContains.getElements().add(groups + " group(s)");
            realmContains.getElements().add(anyObjects + " anyObject(s)");
            realmContains.getElements().add(macroTasks + " command task(s)");
            realmContains.getElements().add(clientApps + " client app(s)");
            throw realmContains;
        }
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.addAll(ResourceOperation.DELETE, (Collection)realm.getResourceKeys());
        List taskInfos = this.propagationManager.createTasks(realm, propByRes, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)taskInfos, false, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        this.realmDAO.delete(realm);
        return result;
    }

    @Override
    protected RealmTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String fullPath = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; fullPath == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    fullPath = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof RealmTO)) continue;
                fullPath = ((RealmTO)args[i]).getFullPath();
            }
        }
        if (fullPath != null) {
            try {
                return this.binder.getRealmTO(this.realmDAO.findByFullPath(fullPath), true);
            }
            catch (Throwable e) {
                LOG.debug("Unresolved reference", e);
                throw new UnresolvedReferenceException(e);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

