/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.wicket.model.IModel;

public final class DateOps {
    public static final ZoneOffset DEFAULT_OFFSET = OffsetDateTime.now().getOffset();
    public static final ZoneId DEFAULT_ZONE = ZonedDateTime.now().getZone();

    public static Date convert(OffsetDateTime date) {
        return Optional.ofNullable(date).map(v -> new Date(v.toInstant().toEpochMilli())).orElse(null);
    }

    public static Date convert(ZonedDateTime date) {
        return Optional.ofNullable(date).map(v -> new Date(v.toInstant().toEpochMilli())).orElse(null);
    }

    public static OffsetDateTime toOffsetDateTime(Date date) {
        return Optional.ofNullable(date).map(v -> v.toInstant().atOffset(DEFAULT_OFFSET)).orElse(null);
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        return Optional.ofNullable(date).map(v -> ZonedDateTime.ofInstant(v.toInstant(), DEFAULT_ZONE)).orElse(null);
    }

    private DateOps() {
    }

    public static final class WrappedDateModel
    implements IModel<Date>,
    Serializable {
        private static final long serialVersionUID = 31027882183172L;
        private IModel<OffsetDateTime> offset;
        private IModel<ZonedDateTime> zoned;

        public static WrappedDateModel ofOffset(IModel<OffsetDateTime> offset) {
            WrappedDateModel instance = new WrappedDateModel();
            instance.offset = offset;
            return instance;
        }

        public static WrappedDateModel ofZoned(IModel<ZonedDateTime> zoned) {
            WrappedDateModel instance = new WrappedDateModel();
            instance.zoned = zoned;
            return instance;
        }

        private WrappedDateModel() {
        }

        public Date getObject() {
            return this.offset == null ? DateOps.convert((ZonedDateTime)this.zoned.getObject()) : DateOps.convert((OffsetDateTime)this.offset.getObject());
        }

        public void setObject(Date object) {
            if (this.offset == null) {
                this.zoned.setObject((Object)DateOps.toZonedDateTime(object));
            } else {
                this.offset.setObject((Object)DateOps.toOffsetDateTime(object));
            }
        }
    }

    public static class Format
    implements Serializable {
        private static final long serialVersionUID = 27103019852866L;
        private final FastDateFormat fdf;

        public Format(FastDateFormat fdf) {
            this.fdf = fdf;
        }

        public String format(Date date) {
            return Optional.ofNullable(date).map(arg_0 -> ((FastDateFormat)this.fdf).format(arg_0)).orElse("");
        }

        public String format(OffsetDateTime date) {
            return Optional.ofNullable(date).map(v -> this.fdf.format(DateOps.convert(date))).orElse("");
        }

        public String format(ZonedDateTime date) {
            return Optional.ofNullable(date).map(v -> this.fdf.format(DateOps.convert(date))).orElse("");
        }
    }
}

