/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.SCIMProvider;
import net.tirasa.connid.bundles.scim.common.dto.BaseResourceReference;
import net.tirasa.connid.bundles.scim.common.dto.PagedResults;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseMeta;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBasePatch;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseResource;
import net.tirasa.connid.bundles.scim.common.dto.SCIMEnterpriseUser;
import net.tirasa.connid.bundles.scim.common.dto.SCIMGroup;
import net.tirasa.connid.bundles.scim.common.dto.SCIMSchema;
import net.tirasa.connid.bundles.scim.common.dto.SCIMUser;
import net.tirasa.connid.bundles.scim.common.service.SCIMService;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

public abstract class AbstractSCIMConnector<UT extends SCIMUser<? extends SCIMBaseMeta, ? extends SCIMEnterpriseUser<?>>, GT extends SCIMGroup<? extends SCIMBaseMeta>, ERT extends SCIMBaseResource<? extends SCIMBaseMeta>, P extends SCIMBasePatch, ST extends SCIMService<UT, GT, ERT, P>>
implements Connector,
CreateOp,
DeleteOp,
SchemaOp,
SearchOp<Filter>,
TestOp,
UpdateOp {
    protected static final Log LOG = Log.getLog(AbstractSCIMConnector.class);
    protected SCIMConnectorConfiguration configuration;
    protected SCIMProvider provider;
    protected ST client;

    public void init(Configuration configuration) {
        LOG.ok("Init", new Object[0]);
        this.configuration = (SCIMConnectorConfiguration)configuration;
        this.configuration.validate();
        this.provider = SCIMProvider.valueOf(this.configuration.getScimProvider().toUpperCase());
        this.client = this.buildSCIMClient((SCIMConnectorConfiguration)((Object)SCIMConnectorConfiguration.class.cast(configuration)));
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public void dispose() {
        LOG.ok("Configuration cleanup", new Object[0]);
        this.configuration = null;
    }

    public void executeQuery(ObjectClass objectClass, Filter query, ResultsHandler handler, OperationOptions options) {
        LOG.ok("Connector READ", new Object[0]);
        Attribute key = null;
        if (query instanceof EqualsFilter || query instanceof EqualsIgnoreCaseFilter) {
            Attribute filterAttr;
            Attribute attribute = filterAttr = query instanceof EqualsFilter ? ((EqualsFilter)query).getAttribute() : ((EqualsIgnoreCaseFilter)query).getAttribute();
            if (filterAttr instanceof Uid || ObjectClass.ACCOUNT.equals((Object)objectClass) || ObjectClass.GROUP.equals((Object)objectClass)) {
                key = filterAttr;
            }
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            if (key == null) {
                List users = null;
                int remainingResults = -1;
                int pagesSize = Optional.ofNullable(options.getPageSize()).orElse(-1);
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        PagedResults pagedResult;
                        cookie = StringUtil.isNotBlank((String)cookie) ? ((users = (pagedResult = this.client.getAllUsers(Integer.valueOf(cookie), pagesSize, attributesToGet)).getResources()).size() >= pagesSize ? String.valueOf(pagedResult.getStartIndex() + users.size()) : null) : ((users = (pagedResult = this.client.getAllUsers(1, pagesSize, attributesToGet)).getResources()).size() >= pagesSize ? String.valueOf(pagedResult.getStartIndex() + users.size()) : null);
                    } else {
                        users = this.client.getAllUsers(attributesToGet);
                    }
                }
                catch (Exception e) {
                    SCIMUtils.wrapGeneralError("While getting Users!", e);
                }
                for (SCIMUser user : users) {
                    handler.handle(this.fromUser(user, attributesToGet));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else {
                SCIMUser result = null;
                if (Uid.NAME.equals(key.getName()) || "id".equals(key.getName())) {
                    result = null;
                    try {
                        result = (SCIMUser)this.client.getUser(AttributeUtil.getAsStringValue((Attribute)key));
                    }
                    catch (Exception e) {
                        SCIMUtils.wrapGeneralError("While getting User : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                    }
                } else {
                    try {
                        List users = this.client.getAllUsers((Name.NAME.equals(key.getName()) ? "username" : key.getName()) + " eq \"" + AttributeUtil.getAsStringValue((Attribute)key) + "\"", attributesToGet);
                        if (!users.isEmpty()) {
                            result = (SCIMUser)users.get(0);
                        }
                    }
                    catch (Exception e) {
                        SCIMUtils.wrapGeneralError("While getting User : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                    }
                }
                if (result != null) {
                    handler.handle(this.fromUser(result, attributesToGet));
                }
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            if (key == null) {
                List groups = null;
                int remainingResults = -1;
                int pagesSize = Optional.ofNullable(options.getPageSize()).orElse(-1);
                String cookie = options.getPagedResultsCookie();
                try {
                    if (pagesSize != -1) {
                        PagedResults pagedResult;
                        cookie = StringUtil.isNotBlank((String)cookie) ? ((groups = (pagedResult = this.client.getAllGroups(Integer.valueOf(cookie), pagesSize)).getResources()).size() >= pagesSize ? String.valueOf(pagedResult.getStartIndex() + groups.size()) : null) : ((groups = (pagedResult = this.client.getAllGroups(1, pagesSize)).getResources()).size() >= pagesSize ? String.valueOf(pagedResult.getStartIndex() + groups.size()) : null);
                    } else {
                        groups = this.client.getAllGroups();
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Could not search for Groups", new Object[0]);
                    SCIMUtils.wrapGeneralError("Could not search for Groups", e);
                }
                for (SCIMGroup group : groups) {
                    handler.handle(this.fromGroup(group, attributesToGet));
                }
                if (handler instanceof SearchResultsHandler) {
                    ((SearchResultsHandler)handler).handleResult(new SearchResult(cookie, remainingResults));
                }
            } else {
                SCIMGroup result = null;
                if (Uid.NAME.equals(key.getName()) || "id".equals(key.getName())) {
                    result = null;
                    try {
                        result = (SCIMGroup)this.client.getGroup(AttributeUtil.getAsStringValue((Attribute)key));
                    }
                    catch (Exception e) {
                        SCIMUtils.wrapGeneralError("While getting Group : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                    }
                } else {
                    try {
                        List groups = this.client.getAllGroups((Name.NAME.equals(key.getName()) ? "displayName" : key.getName()) + " eq \"" + AttributeUtil.getAsStringValue((Attribute)key) + "\"");
                        if (!groups.isEmpty()) {
                            result = (SCIMGroup)groups.get(0);
                        }
                    }
                    catch (Exception e) {
                        SCIMUtils.wrapGeneralError("While getting Group : " + key.getName() + " - " + AttributeUtil.getAsStringValue((Attribute)key), e);
                    }
                }
                if (result != null) {
                    handler.handle(this.fromGroup(result, attributesToGet));
                }
            }
        } else {
            LOG.warn("Search of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        LOG.ok("Connector CREATE", new Object[0]);
        if (createAttributes == null || createAttributes.isEmpty()) {
            SCIMUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(createAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            Object user = this.buildNewUserEntity(SCIMUtils.extractSCIMSchemas(this.configuration.getCustomAttributesJSON(), SCIMv2Attribute.class));
            String username = accessor.findString("userName");
            if (username == null) {
                username = accessor.findString(Name.NAME);
            }
            String externalId = accessor.findString("externalId");
            GuardedString password = accessor.findGuardedString(OperationalAttributes.PASSWORD_NAME);
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            try {
                user.setUserName(username);
                user.setExternalId(externalId != null ? externalId : username);
                List groups = accessor.findStringList("groups");
                LOG.info("Adding groups {0} to user {1}", new Object[]{groups, username});
                List<SCIMGroup> scimGroups = groups == null ? Collections.emptyList() : groups.stream().map(arg_0 -> this.client.getGroup(arg_0)).filter(g -> g != null).collect(Collectors.toList());
                scimGroups.forEach(g -> user.getGroups().add(new BaseResourceReference.Builder().value(g.getId()).ref(this.configuration.getBaseAddress() + "Groups/" + g.getId()).display(g.getDisplayName()).build()));
                if (this.configuration.getManageComplexEntitlements().booleanValue()) {
                    List entitlements = accessor.findStringList("entitlements");
                    LOG.info("Adding entitlements {0} to user {1}", new Object[]{entitlements, username});
                    this.manageEntitlements(user, entitlements);
                }
                if (password == null) {
                    LOG.warn("Missing password attribute", new Object[0]);
                } else {
                    user.setPassword(SecurityUtil.decrypt((GuardedString)password));
                }
                if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                    LOG.warn("{0} attribute value not correct or not found, won't handle User status", new Object[]{OperationalAttributes.ENABLE_NAME});
                } else {
                    user.setActive(Boolean.valueOf(status.getValue().get(0).toString()));
                }
                user.fromAttributes(createAttributes);
                if (StringUtil.isNotBlank((String)this.configuration.getCustomAttributesJSON())) {
                    user.fillSCIMCustomAttributes(createAttributes, this.configuration.getCustomAttributesJSON());
                }
                createAttributes.stream().filter(ca -> ca.getName().contains("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")).findFirst().ifPresent(ca -> {
                    user.getSchemas().add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
                    user.fillEnterpriseUser(createAttributes);
                });
                this.client.createUser(user);
                if (!scimGroups.isEmpty() && this.configuration.getExplicitGroupAddOnCreate().booleanValue()) {
                    LOG.info("Updating groups {0} explicitly adding user {1}", new Object[]{groups, user.getId()});
                    scimGroups.forEach(group -> {
                        group.getMembers().add(SCIMUtils.buildGroupMember(user, this.provider));
                        if ("PATCH".equals(this.configuration.getUpdateGroupMethod())) {
                            this.client.updateGroup(group.getId(), this.buildMembersGroupPatch(Collections.singletonList(user), "add"));
                        } else {
                            this.client.updateGroup((SCIMGroup)group);
                        }
                    });
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Unable to update user {0}", new Object[]{username});
                SCIMUtils.wrapGeneralError("Could not create User : " + username, e);
            }
            return new Uid(user.getId());
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            GT group2 = this.buildNewGroupEntity();
            String displayName = accessor.findString("displayName");
            try {
                group2.setDisplayName(displayName);
                group2.fromAttributes(createAttributes, this.configuration.getReplaceMembersOnUpdate());
                this.client.createGroup(group2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Unable to create Group {0}", new Object[]{displayName});
                SCIMUtils.wrapGeneralError("Could not create Group : " + displayName, e);
            }
            return new Uid(group2.getId());
        }
        LOG.warn("Create of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        LOG.ok("Connector UPDATE object [{0}]", new Object[]{uid});
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            SCIMUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        Uid returnUid = uid;
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            String username = accessor.findString("userName");
            if (username == null) {
                username = accessor.findString(Name.NAME);
            }
            Object user = this.buildNewUserEntity(SCIMUtils.extractSCIMSchemas(this.configuration.getCustomAttributesJSON(), SCIMv2Attribute.class));
            user.setId(uid.getUidValue());
            user.setUserName(username);
            if (status == null || status.getValue() == null || status.getValue().isEmpty()) {
                LOG.warn("{0} attribute value not correct, can't handle User  status update", new Object[]{OperationalAttributes.ENABLE_NAME});
            } else {
                user.setActive(Boolean.valueOf(status.getValue().get(0).toString()));
            }
            if (StringUtil.isNotBlank((String)this.configuration.getCustomAttributesJSON())) {
                user.fillSCIMCustomAttributes(replaceAttributes, this.configuration.getCustomAttributesJSON());
            }
            replaceAttributes.stream().filter(ca -> ca.getName().contains("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")).findFirst().ifPresent(ca -> {
                user.getSchemas().add("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
                user.fillEnterpriseUser(replaceAttributes);
            });
            try {
                GuardedString password;
                List<String> groups;
                user.fromAttributes(replaceAttributes);
                HashMap groupPatches = new HashMap();
                if ("PATCH".equalsIgnoreCase(this.configuration.getUpdateGroupMethod())) {
                    groups = Optional.ofNullable(accessor.findStringList("groups")).orElse(Collections.emptyList());
                    List currentGroups = this.client.getUser(user.getId()).getGroups().stream().map(g -> g.getValue()).collect(Collectors.toList());
                    List<String> groupsToAdd = groups.stream().filter(g -> !currentGroups.contains(g)).collect(Collectors.toList());
                    List<String> groupsToRemove = currentGroups.stream().filter(g -> !groups.contains(g)).collect(Collectors.toList());
                    this.fillGroupPatches(user, groupPatches, groupsToAdd, groupsToRemove);
                } else {
                    groups = accessor.findStringList("groups");
                    if (groups != null && !groups.isEmpty()) {
                        LOG.info("Updating groups {0} of user {1}", new Object[]{groups, user.getId()});
                        groups.forEach(g -> {
                            Object group = this.client.getGroup((String)g);
                            if (group == null) {
                                LOG.error("Unable to add group {0} to the user, group does not exist", new Object[]{g});
                            } else {
                                user.getGroups().add(new BaseResourceReference.Builder().value(group.getId()).ref(this.configuration.getBaseAddress() + "Groups/" + group.getId()).display(group.getDisplayName()).build());
                            }
                        });
                    }
                }
                if (this.configuration.getManageComplexEntitlements().booleanValue()) {
                    List entitlements = accessor.findStringList("entitlements");
                    LOG.info("Adding entitlements {0} on update to user {1}", new Object[]{entitlements, username});
                    this.manageEntitlements(user, entitlements);
                }
                GuardedString guardedString = password = accessor.getPassword() != null ? accessor.getPassword() : accessor.findGuardedString(OperationalAttributes.PASSWORD_NAME);
                if (password == null) {
                    LOG.info("No password to update", new Object[0]);
                } else {
                    String decryptedPassword = SecurityUtil.decrypt((GuardedString)password);
                    user.setPassword(decryptedPassword);
                }
                this.client.updateUser(user);
                groupPatches.entrySet().forEach(patchEntry -> this.client.updateGroup((String)patchEntry.getKey(), (SCIMBasePatch)((SCIMBasePatch)patchEntry.getValue())));
                returnUid = new Uid(user.getId());
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Could not update User {0} from attributes", new Object[]{uid.getUidValue()});
                SCIMUtils.wrapGeneralError("Could not update User " + uid.getUidValue() + " from attributes ", e);
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            String displayName = accessor.findString("displayName");
            if (displayName == null) {
                displayName = accessor.findString(Name.NAME);
            }
            GT group = this.buildNewGroupEntity();
            group.setId(uid.getUidValue());
            group.setDisplayName(displayName);
            try {
                group.fromAttributes(replaceAttributes, this.configuration.getReplaceMembersOnUpdate());
                if ("PATCH".equals(this.configuration.getUpdateGroupMethod())) {
                    List members;
                    this.client.updateGroup(uid.getUidValue(), this.buildPatchFromGroup(group));
                    if (this.configuration.getReplaceMembersOnUpdate().booleanValue() && !CollectionUtil.isEmpty(members = Optional.ofNullable(accessor.findStringList("members")).orElse(Collections.emptyList()))) {
                        LOG.ok("Replacing all group [{0}] members with [{1}] during PATCH update", new Object[]{group.getId(), members});
                        List scimUsers = members.stream().map(arg_0 -> this.client.getUser(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
                        this.client.updateGroup(group.getId(), this.buildMembersGroupPatch(scimUsers, "add"));
                    }
                } else {
                    this.client.updateGroup(group);
                }
                returnUid = new Uid(group.getId());
            }
            catch (Exception e) {
                SCIMUtils.wrapGeneralError("Could not update Group " + uid.getUidValue() + " from attributes ", e);
            }
        } else {
            LOG.warn("Update of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
        }
        return returnUid;
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        LOG.ok("Connector DELETE object [{0}]", new Object[]{uid});
        if (StringUtil.isBlank((String)uid.getUidValue())) {
            LOG.error("Uid not provided or empty ", new Object[0]);
            throw new InvalidAttributeValueException("Uid value not provided or empty");
        }
        if (objectClass == null) {
            LOG.error("Object value not provided {0} ", new Object[]{objectClass});
            throw new InvalidAttributeValueException("Object value not provided");
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            try {
                this.client.deleteUser(uid.getUidValue());
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Could not delete User {0}", new Object[]{uid.getUidValue()});
                SCIMUtils.wrapGeneralError("Could not delete User " + uid.getUidValue(), e);
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            try {
                this.client.deleteGroup(uid.getUidValue());
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Could not delete Group {0}", new Object[]{uid.getUidValue()});
                SCIMUtils.wrapGeneralError("Could not delete Group " + uid.getUidValue(), e);
            }
        } else {
            LOG.warn("Delete of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public FilterTranslator<Filter> createFilterTranslator(ObjectClass objectClass, OperationOptions options) {
        return filter -> Collections.singletonList(filter);
    }

    public void test() {
        LOG.ok("Connector TEST", new Object[0]);
        if (this.configuration != null) {
            if (this.client != null && this.client.testService()) {
                LOG.ok("Test was successful", new Object[0]);
            } else {
                SCIMUtils.handleGeneralError("Test error. Problems with client service");
            }
        } else {
            LOG.error("Test error. No instance of the configuration class", new Object[0]);
        }
    }

    protected ConnectorObject fromUser(UT user, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.ACCOUNT);
        builder.setUid(user.getId());
        builder.setName(user.getUserName());
        try {
            Set<Attribute> userAttributes = user.toAttributes(user.getClass(), this.configuration);
            block2: for (Attribute toAttribute : userAttributes) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block2;
                }
            }
            if (StringUtil.isNotBlank((String)this.configuration.getCustomAttributesJSON())) {
                for (String customAttributeKey : user.getReturnedCustomAttributes().keySet()) {
                    builder.addAttribute(customAttributeKey, (Collection)user.getReturnedCustomAttributes().get(customAttributeKey));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes", new Object[0]);
        }
        return builder.build();
    }

    protected ConnectorObject fromGroup(GT group, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        builder.setUid(group.getId());
        builder.setName(group.getDisplayName());
        try {
            block2: for (Attribute toAttribute : group.toAttributes(group.getClass(), this.configuration)) {
                String attributeName = toAttribute.getName();
                for (String attributeToGetName : attributesToGet) {
                    if (!attributeName.equals(attributeToGetName)) continue;
                    builder.addAttribute(new Attribute[]{toAttribute});
                    continue block2;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.error((Throwable)ex, "While converting to attributes for group", new Object[]{group});
        }
        return builder.build();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected abstract <T extends SCIMBaseAttribute<T>> UT buildNewUserEntity(Optional<SCIMSchema<T>> var1);

    protected abstract GT buildNewGroupEntity();

    protected abstract ST getClient();

    protected abstract ST buildSCIMClient(SCIMConnectorConfiguration var1);

    protected abstract void fillGroupPatches(UT var1, Map<String, P> var2, List<String> var3, List<String> var4);

    protected abstract P buildMembersGroupPatch(List<UT> var1, String var2);

    protected abstract P buildPatchFromGroup(GT var1);

    protected abstract void manageEntitlements(UT var1, List<String> var2);
}

