/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.request.AbstractReplacePatchItem;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.LinkedAccountUR;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.RelationshipUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.StringReplacePatchItem;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnyOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AnyOperations.class);
    private static final List<String> NULL_SINGLETON_LIST = Collections.singletonList(null);

    private AnyOperations() {
    }

    private static <T, K extends AbstractReplacePatchItem<T>> K replacePatchItem(T updated, T original, K proto) {
        if (original == null && updated == null || original != null && original.equals(updated)) {
            return null;
        }
        proto.setValue(updated);
        return proto;
    }

    private static void diff(AnyTO updated, AnyTO original, AnyUR result, boolean incremental) {
        if (updated.getKey() == null && original.getKey() != null || updated.getKey() != null && !updated.getKey().equals(original.getKey())) {
            throw new IllegalArgumentException("AnyTO's key must be the same");
        }
        result.setKey(updated.getKey());
        result.setRealm(AnyOperations.replacePatchItem(updated.getRealm(), original.getRealm(), new StringReplacePatchItem()));
        result.getAuxClasses().clear();
        if (!incremental) {
            original.getAuxClasses().stream().filter(auxClass -> !updated.getAuxClasses().contains(auxClass)).forEach(auxClass -> result.getAuxClasses().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(auxClass)).build()));
        }
        updated.getAuxClasses().stream().filter(auxClass -> !original.getAuxClasses().contains(auxClass)).forEach(auxClass -> result.getAuxClasses().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(auxClass)).build()));
        Map<String, Attr> updatedAttrs = EntityTOUtils.buildAttrMap(updated.getPlainAttrs());
        Map<String, Attr> originalAttrs = EntityTOUtils.buildAttrMap(original.getPlainAttrs());
        result.getPlainAttrs().clear();
        if (!incremental) {
            originalAttrs.keySet().stream().filter(attr -> !updatedAttrs.containsKey(attr)).forEach(schema -> result.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder(new Attr.Builder((String)schema).build()).operation(PatchOperation.DELETE)).build()));
        }
        updatedAttrs.values().forEach(attr -> {
            AttrPatch patch;
            if (AnyOperations.isEmpty(attr)) {
                if (!incremental) {
                    result.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder(new Attr.Builder(attr.getSchema()).build()).operation(PatchOperation.DELETE)).build());
                }
            } else if (!(originalAttrs.containsKey(attr.getSchema()) && ((Attr)originalAttrs.get(attr.getSchema())).getValues().equals(attr.getValues()) || (patch = (AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder((Attr)attr).operation(PatchOperation.ADD_REPLACE)).build()).isEmpty())) {
                result.getPlainAttrs().add(patch);
            }
        });
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(updated.getVirAttrs());
        result.getResources().clear();
        if (!incremental) {
            original.getResources().stream().filter(resource -> !updated.getResources().contains(resource)).forEach(resource -> result.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(resource)).build()));
        }
        updated.getResources().stream().filter(resource -> !original.getResources().contains(resource)).forEach(resource -> result.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(resource)).build()));
    }

    public static AnyObjectUR diff(AnyObjectTO updated, AnyObjectTO original, boolean incremental) {
        AnyObjectUR result = new AnyObjectUR();
        AnyOperations.diff(updated, original, result, incremental);
        result.setName(AnyOperations.replacePatchItem(updated.getName(), original.getName(), new StringReplacePatchItem()));
        Map<Pair<String, String>, RelationshipTO> updatedRels = EntityTOUtils.buildRelationshipMap(updated.getRelationships());
        Map<Pair<String, String>, RelationshipTO> originalRels = EntityTOUtils.buildRelationshipMap(original.getRelationships());
        updatedRels.entrySet().stream().filter(entry -> !originalRels.containsKey(entry.getKey())).forEach(entry -> result.getRelationships().add((RelationshipUR)((RelationshipUR.Builder)new RelationshipUR.Builder((RelationshipTO)entry.getValue()).operation(PatchOperation.ADD_REPLACE)).build()));
        if (!incremental) {
            originalRels.keySet().stream().filter(relationship -> !updatedRels.containsKey(relationship)).forEach(key -> result.getRelationships().add((RelationshipUR)((RelationshipUR.Builder)new RelationshipUR.Builder((RelationshipTO)originalRels.get(key)).operation(PatchOperation.DELETE)).build()));
        }
        Map<String, MembershipTO> updatedMembs = EntityTOUtils.buildMembershipMap(updated.getMemberships());
        Map<String, MembershipTO> originalMembs = EntityTOUtils.buildMembershipMap(original.getMemberships());
        updatedMembs.forEach((key, value) -> {
            MembershipUR membershipPatch = (MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(value.getGroupKey()).operation(PatchOperation.ADD_REPLACE)).build();
            AnyOperations.diff(value, membershipPatch);
            result.getMemberships().add(membershipPatch);
        });
        if (!incremental) {
            originalMembs.keySet().stream().filter(membership -> !updatedMembs.containsKey(membership)).forEach(key -> result.getMemberships().add((MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(((MembershipTO)originalMembs.get(key)).getGroupKey()).operation(PatchOperation.DELETE)).build()));
        }
        return result;
    }

    private static void diff(MembershipTO updated, MembershipUR result) {
        result.getPlainAttrs().addAll(updated.getPlainAttrs().stream().filter(attr -> !AnyOperations.isEmpty(attr)).collect(Collectors.toSet()));
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(updated.getVirAttrs());
    }

    public static UserUR diff(UserTO updated, UserTO original, boolean incremental) {
        UserUR result = new UserUR();
        AnyOperations.diff(updated, original, result, incremental);
        if (!(updated.getPassword() == null || original.getPassword() != null && original.getPassword().equals(updated.getPassword()))) {
            result.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value(updated.getPassword())).resources(updated.getResources()).build());
        }
        result.setUsername(AnyOperations.replacePatchItem(updated.getUsername(), original.getUsername(), new StringReplacePatchItem()));
        if (updated.getSecurityQuestion() == null) {
            result.setSecurityQuestion(null);
            result.setSecurityAnswer(null);
        } else if (!updated.getSecurityQuestion().equals(original.getSecurityQuestion()) || StringUtils.isNotBlank((CharSequence)updated.getSecurityAnswer())) {
            result.setSecurityQuestion((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value(updated.getSecurityQuestion())).build());
            result.setSecurityAnswer((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value(updated.getSecurityAnswer())).build());
        }
        result.setMustChangePassword(AnyOperations.replacePatchItem(updated.isMustChangePassword(), original.isMustChangePassword(), new BooleanReplacePatchItem()));
        if (!incremental) {
            original.getRoles().stream().filter(role -> !updated.getRoles().contains(role)).forEach(toRemove -> result.getRoles().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(toRemove)).build()));
        }
        updated.getRoles().stream().filter(role -> !original.getRoles().contains(role)).forEach(toAdd -> result.getRoles().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(toAdd)).build()));
        Map<Pair<String, String>, RelationshipTO> updatedRels = EntityTOUtils.buildRelationshipMap(updated.getRelationships());
        Map<Pair<String, String>, RelationshipTO> originalRels = EntityTOUtils.buildRelationshipMap(original.getRelationships());
        updatedRels.entrySet().stream().filter(entry -> !originalRels.containsKey(entry.getKey())).forEach(entry -> result.getRelationships().add((RelationshipUR)((RelationshipUR.Builder)new RelationshipUR.Builder((RelationshipTO)entry.getValue()).operation(PatchOperation.ADD_REPLACE)).build()));
        if (!incremental) {
            originalRels.keySet().stream().filter(relationship -> !updatedRels.containsKey(relationship)).forEach(key -> result.getRelationships().add((RelationshipUR)((RelationshipUR.Builder)new RelationshipUR.Builder((RelationshipTO)originalRels.get(key)).operation(PatchOperation.DELETE)).build()));
        }
        Map<String, MembershipTO> updatedMembs = EntityTOUtils.buildMembershipMap(updated.getMemberships());
        Map<String, MembershipTO> originalMembs = EntityTOUtils.buildMembershipMap(original.getMemberships());
        updatedMembs.forEach((key, value) -> {
            MembershipUR membershipPatch = (MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(value.getGroupKey()).operation(PatchOperation.ADD_REPLACE)).build();
            AnyOperations.diff(value, membershipPatch);
            result.getMemberships().add(membershipPatch);
        });
        if (!incremental) {
            originalMembs.keySet().stream().filter(membership -> !updatedMembs.containsKey(membership)).forEach(key -> result.getMemberships().add((MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(((MembershipTO)originalMembs.get(key)).getGroupKey()).operation(PatchOperation.DELETE)).build()));
        }
        Map<Pair<String, String>, LinkedAccountTO> updatedAccounts = EntityTOUtils.buildLinkedAccountMap(updated.getLinkedAccounts());
        Map<Pair<String, String>, LinkedAccountTO> originalAccounts = EntityTOUtils.buildLinkedAccountMap(original.getLinkedAccounts());
        updatedAccounts.entrySet().stream().forEachOrdered(entry -> result.getLinkedAccounts().add((LinkedAccountUR)((LinkedAccountUR.Builder)new LinkedAccountUR.Builder().operation(PatchOperation.ADD_REPLACE)).linkedAccountTO((LinkedAccountTO)entry.getValue()).build()));
        if (!incremental) {
            originalAccounts.keySet().stream().filter(account -> !updatedAccounts.containsKey(account)).forEach(key -> result.getLinkedAccounts().add((LinkedAccountUR)((LinkedAccountUR.Builder)new LinkedAccountUR.Builder().operation(PatchOperation.DELETE)).linkedAccountTO((LinkedAccountTO)originalAccounts.get(key)).build()));
        }
        return result;
    }

    public static GroupUR diff(GroupTO updated, GroupTO original, boolean incremental) {
        GroupUR result = new GroupUR();
        AnyOperations.diff(updated, original, result, incremental);
        result.setName(AnyOperations.replacePatchItem(updated.getName(), original.getName(), new StringReplacePatchItem()));
        result.setUserOwner(AnyOperations.replacePatchItem(updated.getUserOwner(), original.getUserOwner(), new StringReplacePatchItem()));
        result.setGroupOwner(AnyOperations.replacePatchItem(updated.getGroupOwner(), original.getGroupOwner(), new StringReplacePatchItem()));
        result.setUDynMembershipCond(updated.getUDynMembershipCond());
        result.getADynMembershipConds().putAll(updated.getADynMembershipConds());
        result.getTypeExtensions().addAll(updated.getTypeExtensions());
        return result;
    }

    public static <TO extends AnyTO, P extends AnyUR> P diff(TO updated, TO original, boolean incremental) {
        if (updated instanceof UserTO && original instanceof UserTO) {
            return (P)AnyOperations.diff((UserTO)updated, (UserTO)original, incremental);
        }
        if (updated instanceof GroupTO && original instanceof GroupTO) {
            return (P)AnyOperations.diff((GroupTO)updated, (GroupTO)original, incremental);
        }
        if (updated instanceof AnyObjectTO && original instanceof AnyObjectTO) {
            return (P)AnyOperations.diff((AnyObjectTO)updated, (AnyObjectTO)original, incremental);
        }
        throw new IllegalArgumentException("Unsupported: " + updated.getClass().getName());
    }

    private static Collection<Attr> patch(Map<String, Attr> attrs, Set<AttrPatch> attrPatches) {
        HashMap<String, Attr> rwattrs = new HashMap<String, Attr>(attrs);
        attrPatches.forEach(patch -> {
            if (patch.getAttr() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)AttrPatch.class.getName(), patch);
            } else {
                rwattrs.remove(patch.getAttr().getSchema());
                if (patch.getOperation() == PatchOperation.ADD_REPLACE && !patch.getAttr().getValues().isEmpty()) {
                    rwattrs.put(patch.getAttr().getSchema(), patch.getAttr());
                }
            }
        });
        return rwattrs.values();
    }

    private static <T extends AnyTO, K extends AnyUR> void patch(T to, K req, T result) {
        if (to.getKey() == null || !to.getKey().equals(req.getKey())) {
            throw new IllegalArgumentException(to.getClass().getSimpleName() + " and " + req.getClass().getSimpleName() + " keys must be the same");
        }
        if (req.getRealm() != null) {
            result.setRealm((String)req.getRealm().getValue());
        }
        block6: for (StringPatchItem auxClassPatch : req.getAuxClasses()) {
            switch (auxClassPatch.getOperation()) {
                case ADD_REPLACE: {
                    result.getAuxClasses().add((String)auxClassPatch.getValue());
                    continue block6;
                }
            }
            result.getAuxClasses().remove(auxClassPatch.getValue());
        }
        result.getPlainAttrs().clear();
        result.getPlainAttrs().addAll(AnyOperations.patch(EntityTOUtils.buildAttrMap(to.getPlainAttrs()), req.getPlainAttrs()));
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(req.getVirAttrs());
        block7: for (StringPatchItem resourcePatch : req.getResources()) {
            switch (resourcePatch.getOperation()) {
                case ADD_REPLACE: {
                    result.getResources().add((String)resourcePatch.getValue());
                    continue block7;
                }
            }
            result.getResources().remove(resourcePatch.getValue());
        }
    }

    public static AnyTO patch(AnyTO anyTO, AnyUR anyUR) {
        if (anyTO instanceof UserTO) {
            return AnyOperations.patch((UserTO)anyTO, (UserUR)anyUR);
        }
        if (anyTO instanceof GroupTO) {
            return AnyOperations.patch((GroupTO)anyTO, (GroupUR)anyUR);
        }
        if (anyTO instanceof AnyObjectTO) {
            return AnyOperations.patch((AnyObjectTO)anyTO, (AnyObjectUR)anyUR);
        }
        return null;
    }

    public static GroupTO patch(GroupTO groupTO, GroupUR groupUR) {
        GroupTO result = (GroupTO)SerializationUtils.clone((Serializable)groupTO);
        AnyOperations.patch(groupTO, groupUR, result);
        if (groupUR.getName() != null) {
            result.setName((String)groupUR.getName().getValue());
        }
        if (groupUR.getUserOwner() != null) {
            result.setGroupOwner((String)groupUR.getUserOwner().getValue());
        }
        if (groupUR.getGroupOwner() != null) {
            result.setGroupOwner((String)groupUR.getGroupOwner().getValue());
        }
        result.setUDynMembershipCond(groupUR.getUDynMembershipCond());
        result.getADynMembershipConds().clear();
        result.getADynMembershipConds().putAll(groupUR.getADynMembershipConds());
        return result;
    }

    public static AnyObjectTO patch(AnyObjectTO anyObjectTO, AnyObjectUR anyObjectUR) {
        AnyObjectTO result = (AnyObjectTO)SerializationUtils.clone((Serializable)anyObjectTO);
        AnyOperations.patch(anyObjectTO, anyObjectUR, result);
        if (anyObjectUR.getName() != null) {
            result.setName((String)anyObjectUR.getName().getValue());
        }
        anyObjectUR.getRelationships().forEach(relPatch -> {
            if (relPatch.getRelationshipTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)RelationshipUR.class.getName(), relPatch);
            } else {
                result.getRelationships().remove(relPatch.getRelationshipTO());
                if (relPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    result.getRelationships().add(relPatch.getRelationshipTO());
                }
            }
        });
        anyObjectUR.getMemberships().forEach(membPatch -> {
            if (membPatch.getGroup() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)MembershipUR.class.getName(), membPatch);
            } else {
                result.getMemberships().stream().filter(membership -> membPatch.getGroup().equals(membership.getGroupKey())).findFirst().ifPresent(memb -> result.getMemberships().remove(memb));
                if (membPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    MembershipTO newMembershipTO = new MembershipTO.Builder(membPatch.getGroup()).plainAttrs(membPatch.getPlainAttrs()).virAttrs(membPatch.getVirAttrs()).build();
                    result.getMemberships().add(newMembershipTO);
                }
            }
        });
        return result;
    }

    public static UserTO patch(UserTO userTO, UserUR userUR) {
        UserTO result = (UserTO)SerializationUtils.clone((Serializable)userTO);
        AnyOperations.patch(userTO, userUR, result);
        if (userUR.getPassword() != null) {
            result.setPassword((String)userUR.getPassword().getValue());
        }
        if (userUR.getUsername() != null) {
            result.setUsername((String)userUR.getUsername().getValue());
        }
        userUR.getRelationships().forEach(relPatch -> {
            if (relPatch.getRelationshipTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)RelationshipUR.class.getName(), relPatch);
            } else {
                result.getRelationships().remove(relPatch.getRelationshipTO());
                if (relPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    result.getRelationships().add(relPatch.getRelationshipTO());
                }
            }
        });
        userUR.getMemberships().forEach(membPatch -> {
            if (membPatch.getGroup() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)MembershipUR.class.getName(), membPatch);
            } else {
                result.getMemberships().stream().filter(membership -> membPatch.getGroup().equals(membership.getGroupKey())).findFirst().ifPresent(memb -> result.getMemberships().remove(memb));
                if (membPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    MembershipTO newMembershipTO = new MembershipTO.Builder(membPatch.getGroup()).plainAttrs(membPatch.getPlainAttrs()).virAttrs(membPatch.getVirAttrs()).build();
                    result.getMemberships().add(newMembershipTO);
                }
            }
        });
        block3: for (StringPatchItem rolePatch : userUR.getRoles()) {
            switch (rolePatch.getOperation()) {
                case ADD_REPLACE: {
                    result.getRoles().add((String)rolePatch.getValue());
                    continue block3;
                }
            }
            result.getRoles().remove(rolePatch.getValue());
        }
        userUR.getLinkedAccounts().forEach(accountPatch -> {
            if (accountPatch.getLinkedAccountTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)LinkedAccountUR.class.getName(), accountPatch);
            } else {
                result.getLinkedAccounts().remove(accountPatch.getLinkedAccountTO());
                if (accountPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    result.getLinkedAccounts().add(accountPatch.getLinkedAccountTO());
                }
            }
        });
        return result;
    }

    public static void cleanEmptyAttrs(AnyTO anyTO, AnyUR anyUR) {
        anyUR.getPlainAttrs().addAll(anyTO.getPlainAttrs().stream().filter(AnyOperations::isEmpty).map(plainAttr -> (AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder(new Attr.Builder(plainAttr.getSchema()).build()).operation(PatchOperation.DELETE)).build()).collect(Collectors.toSet()));
    }

    private static boolean isEmpty(Attr attr) {
        return attr.getValues().isEmpty() || NULL_SINGLETON_LIST.equals(attr.getValues());
    }
}

