/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractAnyDAO<A extends Any<?>>
extends AbstractDAO<A>
implements AnyDAO<A> {
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final DynRealmDAO dynRealmDAO;
    private AnyUtils anyUtils;

    public AbstractAnyDAO(AnyUtilsFactory anyUtilsFactory, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, DynRealmDAO dynRealmDAO) {
        this.anyUtilsFactory = anyUtilsFactory;
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.dynRealmDAO = dynRealmDAO;
    }

    protected abstract AnyUtils init();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnyUtils anyUtils() {
        AbstractAnyDAO abstractAnyDAO = this;
        synchronized (abstractAnyDAO) {
            if (this.anyUtils == null) {
                this.anyUtils = this.init();
            }
        }
        return this.anyUtils;
    }

    protected List<String> findAllKeys(String table, int page, int itemsPerPage) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM " + table + " ORDER BY id", String.class);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        query.setMaxResults(itemsPerPage);
        ArrayList<String> result = new ArrayList<String>();
        query.getResultList().stream().map(resultKey -> resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey).forEach(actualKey -> result.add(actualKey.toString()));
        return result;
    }

    protected OffsetDateTime findLastChange(String key, String table) {
        OffsetDateTime creationDate = null;
        OffsetDateTime lastChangeDate = null;
        try (Connection conn = (Connection)OpenJPAPersistence.cast((EntityManager)this.entityManager()).getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT creationDate, lastChangeDate FROM " + table + " WHERE id=?");){
            stmt.setString(1, key);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                creationDate = rs.getObject(1, OffsetDateTime.class);
                lastChangeDate = rs.getObject(2, OffsetDateTime.class);
            }
        }
        catch (SQLException e) {
            LOG.error("While reading {} from {}", new Object[]{key, table, e});
        }
        return Optional.ofNullable(lastChangeDate).orElse(creationDate);
    }

    protected abstract void securityChecks(A var1);

    @Transactional(readOnly=true)
    public List<A> findByKeys(List<String> keys) {
        Class entityClass = this.anyUtils().anyClass();
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + entityClass.getSimpleName() + " e WHERE e.id IN (:keys)", entityClass);
        query.setParameter("keys", keys);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public A authFind(String key) {
        if (key == null) {
            throw new NotFoundException("Null key");
        }
        A any = this.find(key);
        if (any == null) {
            throw new NotFoundException(StringUtils.substringBefore((String)StringUtils.substringAfter((String)this.getClass().getSimpleName(), (String)"JPA"), (String)"DAO") + " " + key);
        }
        this.securityChecks(any);
        return any;
    }

    @Transactional(readOnly=true)
    public A find(String key) {
        return (A)((Any)this.entityManager().find(this.anyUtils().anyClass(), (Object)key));
    }

    private Query findByPlainAttrValueQuery(String entityName, boolean ignoreCaseMatch) {
        String query = "SELECT e FROM " + entityName + " e WHERE e.attribute.schema.id = :schemaKey AND ((e.stringValue IS NOT NULL AND " + (ignoreCaseMatch ? "LOWER(" : "") + "e.stringValue" + (ignoreCaseMatch ? ")" : "") + " = " + (ignoreCaseMatch ? "LOWER(" : "") + ":stringValue" + (ignoreCaseMatch ? ")" : "") + ") OR (e.booleanValue IS NOT NULL AND e.booleanValue = :booleanValue) OR (e.dateValue IS NOT NULL AND e.dateValue = :dateValue) OR (e.longValue IS NOT NULL AND e.longValue = :longValue) OR (e.doubleValue IS NOT NULL AND e.doubleValue = :doubleValue))";
        return this.entityManager().createQuery(query);
    }

    public List<A> findByPlainAttrValue(PlainSchema schema, PlainAttrValue attrValue, boolean ignoreCaseMatch) {
        if (schema == null) {
            LOG.error("No PlainSchema");
            return List.of();
        }
        String entityName = schema.isUniqueConstraint() ? this.anyUtils().plainAttrUniqueValueClass().getName() : this.anyUtils().plainAttrValueClass().getName();
        Query query = this.findByPlainAttrValueQuery(entityName, ignoreCaseMatch);
        query.setParameter("schemaKey", (Object)schema.getKey());
        query.setParameter("stringValue", (Object)attrValue.getStringValue());
        query.setParameter("booleanValue", (Object)attrValue.getBooleanValue());
        if (attrValue.getDateValue() == null) {
            query.setParameter("dateValue", null);
        } else {
            query.setParameter("dateValue", (Object)attrValue.getDateValue().toInstant());
        }
        query.setParameter("longValue", (Object)attrValue.getLongValue());
        query.setParameter("doubleValue", (Object)attrValue.getDoubleValue());
        ArrayList result = new ArrayList();
        query.getResultList().stream().forEach(value -> {
            Any any = value.getAttr().getOwner();
            if (!result.contains(any)) {
                result.add(any);
            }
        });
        return result;
    }

    public Optional<A> findByPlainAttrUniqueValue(PlainSchema schema, PlainAttrUniqueValue attrUniqueValue, boolean ignoreCaseMatch) {
        if (schema == null) {
            LOG.error("No PlainSchema");
            return Optional.empty();
        }
        if (!schema.isUniqueConstraint()) {
            LOG.error("This schema has not unique constraint: '{}'", (Object)schema.getKey());
            return Optional.empty();
        }
        List<A> result = this.findByPlainAttrValue(schema, (PlainAttrValue)attrUniqueValue, ignoreCaseMatch);
        return result.isEmpty() ? Optional.empty() : Optional.of((Any)result.get(0));
    }

    private static List<String> split(String attrValue, List<String> literals) {
        ArrayList<String> attrValues = new ArrayList<String>();
        if (literals.isEmpty()) {
            attrValues.add(attrValue);
        } else {
            for (String token : attrValue.split(Pattern.quote(literals.get(0)))) {
                if (token.isEmpty()) continue;
                attrValues.addAll(AbstractAnyDAO.split(token, literals.subList(1, literals.size())));
            }
        }
        return attrValues;
    }

    private Set<String> getWhereClause(String expression, String value, boolean ignoreCaseMatch) {
        Parser parser = new Parser(expression);
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList<String> literals = new ArrayList<String>();
        Token token = parser.getNextToken();
        while (token != null && StringUtils.isNotBlank((CharSequence)token.toString())) {
            if (token.kind == 124) {
                literals.add(token.toString().substring(1, token.toString().length() - 1));
            }
            if (token.kind == 110) {
                identifiers.add(token.toString());
            }
            token = parser.getNextToken();
        }
        literals.sort((l1, l2) -> {
            if (l1 == null && l2 == null) {
                return 0;
            }
            if (l1 != null && l2 == null) {
                return -1;
            }
            if (l1 == null) {
                return 1;
            }
            if (l1.length() == l2.length()) {
                return 0;
            }
            if (l1.length() > l2.length()) {
                return -1;
            }
            return 1;
        });
        List<String> attrValues = AbstractAnyDAO.split(value, literals);
        if (attrValues.size() != identifiers.size()) {
            LOG.error("Ambiguous JEXL expression resolution: literals and values have different size");
            return Set.of();
        }
        HashSet<String> clauses = new HashSet<String>();
        StringBuilder bld = new StringBuilder();
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < identifiers.size(); ++i) {
            if (used.contains(identifiers.get(i))) continue;
            PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find((String)identifiers.get(i));
            if (schema == null) {
                LOG.error("Invalid schema '{}', ignoring", identifiers.get(i));
                continue;
            }
            bld.delete(0, bld.length());
            bld.append('(');
            bld.append("s.id = '").append((String)identifiers.get(i)).append('\'');
            bld.append(" AND ");
            bld.append("s.id = a.schema_id").append(" AND ");
            bld.append("a.id = v.attribute_id");
            bld.append(" AND ");
            switch (schema.getType()) {
                case Boolean: {
                    bld.append("v.booleanValue = '").append(attrValues.get(i)).append('\'');
                    break;
                }
                case Long: {
                    bld.append("v.longValue = ").append(attrValues.get(i));
                    break;
                }
                case Double: {
                    bld.append("v.doubleValue = ").append(attrValues.get(i));
                    break;
                }
                case Date: {
                    bld.append("v.dateValue = '").append(attrValues.get(i)).append('\'');
                    break;
                }
                default: {
                    if (ignoreCaseMatch) {
                        bld.append("LOWER(v.stringValue) = '").append(attrValues.get(i).toLowerCase()).append('\'');
                        break;
                    }
                    bld.append("v.stringValue = '").append(attrValues.get(i)).append('\'');
                }
            }
            bld.append(')');
            used.add((String)identifiers.get(i));
            clauses.add(bld.toString());
        }
        LOG.debug("Generated where clauses {}", clauses);
        return clauses;
    }

    public List<A> findByDerAttrValue(DerSchema schema, String value, boolean ignoreCaseMatch) {
        if (schema == null) {
            LOG.error("No DerSchema");
            return List.of();
        }
        StringBuilder querystring = new StringBuilder();
        boolean subquery = false;
        for (String clause : this.getWhereClause(schema.getExpression(), value, ignoreCaseMatch)) {
            if (querystring.length() > 0) {
                subquery = true;
                querystring.append(" AND a.owner_id IN ( ");
            }
            querystring.append("SELECT a.owner_id ").append("FROM ").append(this.anyUtils().plainAttrClass().getSimpleName().substring(3)).append(" a, ").append(this.anyUtils().plainAttrValueClass().getSimpleName().substring(3)).append(" v, ").append(PlainSchema.class.getSimpleName()).append(" s ").append("WHERE ").append(clause);
            if (!subquery) continue;
            querystring.append(')');
        }
        ArrayList<A> result = new ArrayList<A>();
        if (querystring.length() > 0) {
            Query query = this.entityManager().createNativeQuery(querystring.toString());
            for (Object anyKey : query.getResultList()) {
                A any = this.find(anyKey.toString());
                if (result.contains(any)) continue;
                result.add(any);
            }
        }
        return result;
    }

    public List<A> findByResource(ExternalResource resource) {
        Query query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE :resource MEMBER OF e.resources");
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    public SearchCond getAllMatchingCond() {
        AnyCond idCond = new AnyCond(AttrCond.Type.ISNOTNULL);
        idCond.setSchema("id");
        return SearchCond.getLeaf((AbstractSearchCond)idCond);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public <S extends Schema> AllowedSchemas<S> findAllowedSchemas(A any, Class<S> reference) {
        AllowedSchemas result = new AllowedSchemas();
        HashSet typeOwnClasses = new HashSet();
        typeOwnClasses.addAll(any.getType().getClasses());
        typeOwnClasses.addAll(any.getAuxClasses());
        typeOwnClasses.forEach(typeClass -> {
            if (reference.equals(PlainSchema.class)) {
                result.getForSelf().addAll(typeClass.getPlainSchemas());
            } else if (reference.equals(DerSchema.class)) {
                result.getForSelf().addAll(typeClass.getDerSchemas());
            } else if (reference.equals(VirSchema.class)) {
                result.getForSelf().addAll(typeClass.getVirSchemas());
            }
        });
        HashMap typeExtensionClasses = new HashMap();
        if (any instanceof User) {
            ((User)any).getMemberships().forEach(memb -> ((Group)memb.getRightEnd()).getTypeExtensions().forEach(typeExt -> typeExtensionClasses.put((Group)memb.getRightEnd(), typeExt.getAuxClasses())));
        } else if (any instanceof AnyObject) {
            ((AnyObject)any).getMemberships().forEach(memb -> ((Group)memb.getRightEnd()).getTypeExtensions().stream().filter(typeExt -> any.getType().equals(typeExt.getAnyType())).forEach(typeExt -> typeExtensionClasses.put((Group)memb.getRightEnd(), typeExt.getAuxClasses())));
        }
        typeExtensionClasses.entrySet().stream().map(entry -> {
            result.getForMemberships().put((Group)entry.getKey(), new HashSet());
            return entry;
        }).forEach(entry -> ((List)entry.getValue()).forEach(typeClass -> {
            if (reference.equals(PlainSchema.class)) {
                ((Set)result.getForMemberships().get(entry.getKey())).addAll(typeClass.getPlainSchemas());
            } else if (reference.equals(DerSchema.class)) {
                ((Set)result.getForMemberships().get(entry.getKey())).addAll(typeClass.getDerSchemas());
            } else if (reference.equals(VirSchema.class)) {
                ((Set)result.getForMemberships().get(entry.getKey())).addAll(typeClass.getVirSchemas());
            }
        }));
        return result;
    }

    public A save(A any) {
        return (A)((Any)this.entityManager().merge(any));
    }

    public void delete(String key) {
        A any = this.find(key);
        if (any == null) {
            return;
        }
        this.delete((Any)any);
    }

    @Transactional(readOnly=true)
    public List<String> findDynRealms(String key) {
        Query query = this.entityManager().createNativeQuery("SELECT dynRealm_id FROM DynRealmMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        ArrayList<String> result = new ArrayList<String>();
        query.getResultList().stream().map(resultKey -> resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey).forEach(actualKey -> {
            DynRealm dynRealm = this.dynRealmDAO.find(actualKey.toString());
            if (dynRealm == null) {
                LOG.error("Could not find dynRealm with id {}, even though returned by the native query", actualKey);
            } else if (!result.contains(actualKey.toString())) {
                result.add(actualKey.toString());
            }
        });
        return result;
    }
}

