/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.core.persistence.api.DomainRegistry;
import org.apache.syncope.core.persistence.jpa.openjpa.ConnectorManagerRemoteCommitListener;
import org.apache.syncope.core.persistence.jpa.spring.DomainEntityManagerFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.vendor.OpenJpaVendorAdapter;
import org.springframework.transaction.support.TransactionTemplate;

public class DomainConfFactory
implements DomainRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(DomainConfFactory.class);
    protected final ConfigurableApplicationContext ctx;

    public DomainConfFactory(ConfigurableApplicationContext ctx) {
        this.ctx = ctx;
    }

    protected DefaultListableBeanFactory beanFactory() {
        return (DefaultListableBeanFactory)this.ctx.getBeanFactory();
    }

    protected void unregisterSingleton(String name) {
        if (this.beanFactory().containsSingleton(name)) {
            this.beanFactory().destroySingleton(name);
        }
    }

    protected void registerSingleton(String name, Object bean) {
        this.unregisterSingleton(name);
        this.beanFactory().registerSingleton(name, bean);
    }

    protected void unregisterBeanDefinition(String name) {
        if (this.beanFactory().containsBeanDefinition(name)) {
            this.beanFactory().removeBeanDefinition(name);
        }
    }

    protected void registerBeanDefinition(String name, BeanDefinition beanDefinition) {
        this.unregisterBeanDefinition(name);
        this.beanFactory().registerBeanDefinition(name, beanDefinition);
    }

    public void register(Domain domain) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(domain.getJdbcDriver());
        hikariConfig.setJdbcUrl(domain.getJdbcURL());
        hikariConfig.setUsername(domain.getDbUsername());
        hikariConfig.setPassword(domain.getDbPassword());
        hikariConfig.setSchema(domain.getDbSchema());
        hikariConfig.setTransactionIsolation(domain.getTransactionIsolation().name());
        hikariConfig.setMaximumPoolSize(domain.getPoolMaxActive());
        hikariConfig.setMinimumIdle(domain.getPoolMinIdle());
        this.registerBeanDefinition(domain.getKey() + "DataSource", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(JndiObjectFactoryBean.class).addPropertyValue("jndiName", (Object)("java:comp/env/jdbc/syncope" + domain.getKey() + "DataSource")).addPropertyValue("defaultObject", (Object)new HikariDataSource(hikariConfig)).getBeanDefinition());
        DataSource initedDataSource = (DataSource)this.beanFactory().getBean(domain.getKey() + "DataSource", DataSource.class);
        ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator();
        databasePopulator.setContinueOnError(true);
        databasePopulator.setIgnoreFailedDrops(true);
        databasePopulator.setSqlScriptEncoding(StandardCharsets.UTF_8.name());
        databasePopulator.addScript((Resource)new ClassPathResource("/audit/" + domain.getAuditSql()));
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource(initedDataSource);
        dataSourceInitializer.setEnabled(true);
        dataSourceInitializer.setDatabasePopulator((DatabasePopulator)databasePopulator);
        this.registerSingleton(domain.getKey().toLowerCase() + "DataSourceInitializer", dataSourceInitializer);
        this.beanFactory().initializeBean((Object)dataSourceInitializer, domain.getKey().toLowerCase() + "DataSourceInitializer");
        OpenJpaVendorAdapter vendorAdapter = new OpenJpaVendorAdapter();
        vendorAdapter.setShowSql(false);
        vendorAdapter.setGenerateDdl(true);
        vendorAdapter.setDatabasePlatform(domain.getDatabasePlatform());
        ConnectorManagerRemoteCommitListener connectorManagerRemoteCommitListener = new ConnectorManagerRemoteCommitListener(domain.getKey());
        BeanDefinitionBuilder emf = BeanDefinitionBuilder.rootBeanDefinition(DomainEntityManagerFactoryBean.class).addPropertyValue("mappingResources", (Object)domain.getOrm()).addPropertyValue("persistenceUnitName", (Object)domain.getKey()).addPropertyReference("dataSource", domain.getKey() + "DataSource").addPropertyValue("jpaVendorAdapter", (Object)vendorAdapter).addPropertyReference("commonEntityManagerFactoryConf", "commonEMFConf").addPropertyValue("connectorManagerRemoteCommitListener", (Object)connectorManagerRemoteCommitListener);
        if (this.ctx.getEnvironment().containsProperty("openjpaMetaDataFactory")) {
            emf.addPropertyValue("jpaPropertyMap", Map.of("openjpa.MetaDataFactory", Objects.requireNonNull(this.ctx.getEnvironment().getProperty("openjpaMetaDataFactory")).replace("##orm##", domain.getOrm())));
        }
        this.registerBeanDefinition(domain.getKey() + "EntityManagerFactory", (BeanDefinition)emf.getBeanDefinition());
        this.beanFactory().getBean(domain.getKey() + "EntityManagerFactory");
        AbstractBeanDefinition domainTransactionManager = BeanDefinitionBuilder.rootBeanDefinition(JpaTransactionManager.class).addPropertyReference("entityManagerFactory", domain.getKey() + "EntityManagerFactory").getBeanDefinition();
        domainTransactionManager.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)domain.getKey()));
        this.registerBeanDefinition(domain.getKey() + "TransactionManager", (BeanDefinition)domainTransactionManager);
        AbstractBeanDefinition domainTransactionTemplate = BeanDefinitionBuilder.rootBeanDefinition(TransactionTemplate.class).addPropertyReference("transactionManager", domain.getKey() + "TransactionManager").getBeanDefinition();
        this.registerBeanDefinition(domain.getKey() + "TransactionTemplate", (BeanDefinition)domainTransactionTemplate);
        this.registerBeanDefinition(domain.getKey() + "ContentXML", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ByteArrayInputStream.class).addConstructorArgValue((Object)domain.getContent().getBytes()).getBeanDefinition());
        this.registerBeanDefinition(domain.getKey() + "KeymasterConfParamsJSON", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ByteArrayInputStream.class).addConstructorArgValue((Object)domain.getKeymasterConfParams().getBytes()).getBeanDefinition());
    }

    public void unregister(String domain) {
        this.unregisterSingleton(domain + "KeymasterConfParamsJSON");
        this.unregisterBeanDefinition(domain + "KeymasterConfParamsJSON");
        this.unregisterSingleton(domain + "ContentXML");
        this.unregisterBeanDefinition(domain + "ContentXML");
        try {
            EntityManagerFactory emf = (EntityManagerFactory)this.beanFactory().getBean(domain + "EntityManagerFactory", EntityManagerFactory.class);
            emf.close();
        }
        catch (Exception e) {
            LOG.error("Could not close EntityManagerFactory for Domain {}", (Object)domain, (Object)e);
        }
        this.unregisterSingleton(domain + "EntityManagerFactory");
        this.unregisterBeanDefinition(domain + "EntityManagerFactory");
        this.unregisterSingleton(domain + "TransactionManager");
        this.unregisterBeanDefinition(domain + "TransactionManager");
        this.unregisterSingleton(domain.toLowerCase() + "DataSourceInitializer");
        this.unregisterSingleton(domain.toLowerCase() + "ResourceDatabasePopulator");
        this.unregisterSingleton(domain + "DataSource");
        this.unregisterBeanDefinition(domain + "DataSource");
    }
}

