/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import java.util.List;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.test.AbstractFlowableIdmTestCase;
import org.flowable.idm.engine.test.PluggableFlowableIdmExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;

@Tag(value="pluggable")
@ExtendWith(value={PluggableFlowableIdmExtension.class})
public abstract class PluggableFlowableIdmTestCase
extends AbstractFlowableIdmTestCase {
    protected Group createGroup(String id, String name, String type) {
        Group group = this.idmIdentityService.newGroup(id);
        group.setName(name);
        group.setType(type);
        this.idmIdentityService.saveGroup(group);
        return group;
    }

    protected void clearAllUsersAndGroups() {
        List privileges = this.idmIdentityService.createPrivilegeQuery().list();
        for (Object privilege : privileges) {
            this.idmIdentityService.deletePrivilege(privilege.getId());
        }
        List groups = this.idmIdentityService.createGroupQuery().list();
        for (Group group : groups) {
            List members = ((UserQuery)this.idmIdentityService.createUserQuery().memberOfGroup(group.getId())).list();
            for (User member : members) {
                this.idmIdentityService.deleteMembership(member.getId(), group.getId());
            }
            this.idmIdentityService.deleteGroup(group.getId());
        }
        List users = this.idmIdentityService.createUserQuery().list();
        for (User user : users) {
            this.idmIdentityService.deleteUser(user.getId());
        }
    }
}

