/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Clients;
import com.okta.sdk.resource.api.ApplicationApi;
import com.okta.sdk.resource.api.GroupApi;
import com.okta.sdk.resource.api.SchemaApi;
import com.okta.sdk.resource.api.SystemLogApi;
import com.okta.sdk.resource.api.UserApi;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.common.PagedList;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.ChangePasswordRequest;
import com.okta.sdk.resource.model.Group;
import com.okta.sdk.resource.model.LogEvent;
import com.okta.sdk.resource.model.LogTarget;
import com.okta.sdk.resource.model.PasswordCredential;
import com.okta.sdk.resource.model.UpdateUserRequest;
import com.okta.sdk.resource.model.User;
import com.okta.sdk.resource.model.UserStatus;
import com.okta.sdk.resource.user.UserBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.tirasa.connid.bundles.okta.OktaConfiguration;
import net.tirasa.connid.bundles.okta.OktaFilterTranslator;
import net.tirasa.connid.bundles.okta.schema.OktaSchema;
import net.tirasa.connid.bundles.okta.utils.CipherAlgorithm;
import net.tirasa.connid.bundles.okta.utils.OktaAttribute;
import net.tirasa.connid.bundles.okta.utils.OktaEventType;
import net.tirasa.connid.bundles.okta.utils.OktaFilter;
import net.tirasa.connid.bundles.okta.utils.OktaFilterOp;
import net.tirasa.connid.bundles.okta.utils.OktaUtils;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassUtil;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(configurationClass=OktaConfiguration.class, displayNameKey="okta.connector.display")
public class OktaConnector
implements Connector,
PoolableConnector,
CreateOp,
UpdateOp,
DeleteOp,
SchemaOp,
SyncOp,
TestOp,
SearchOp<OktaFilter> {
    private static final Log LOG = Log.getLog(OktaConnector.class);
    public static final String APPLICATION_NAME = ObjectClassUtil.createSpecialName((String)"APPLICATION");
    public static final ObjectClass APPLICATION = new ObjectClass(APPLICATION_NAME);
    public static final String LIMIT = "50";
    public static final String USER = "USER";
    public static final String FILTER = "filter";
    public static final String CIPHER_ALGORITHM = "cipherAlgorithm";
    public static final String SALT = "salt";
    public static final String SALT_ORDER = "saltOrder";
    public static final String WORK_FACTOR = "workFactor";
    private static final Set<String> NOT_FOR_PROFILE = CollectionUtil.newReadOnlySet((Object[])new String[]{Name.NAME, OperationalAttributes.ENABLE_NAME, OperationalAttributes.PASSWORD_NAME, "id", "status", "oktaSecurityQuestion", "oktaSecurityAnswer", "oktaGroups"});
    private OktaConfiguration configuration;
    private UserApi userApi;
    private GroupApi groupApi;
    private ApplicationApi appApi;
    private SystemLogApi systemLogApi;
    private OktaSchema schema;

    public OktaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void init(Configuration configuration) {
        this.configuration = (OktaConfiguration)configuration;
        try {
            if (this.userApi == null || this.groupApi == null || this.appApi == null || this.systemLogApi == null || this.schema == null) {
                ClientBuilder builder = Clients.builder().setCacheManager(Caches.newDisabledCacheManager()).setOrgUrl(this.configuration.getDomain()).setRetryMaxAttempts(this.configuration.getRateLimitMaxRetries()).setRetryMaxElapsed(this.configuration.getRetryMaxElapsed()).setConnectionTimeout(this.configuration.getRequestTimeout());
                if (this.configuration.getClientId() != null && this.configuration.getPrivateKeyPEM() != null) {
                    builder.setAuthorizationMode(AuthorizationMode.PRIVATE_KEY).setClientId(this.configuration.getClientId()).setScopes(new HashSet<String>(Arrays.asList("okta.schemas.read", "okta.users.manage", "okta.groups.manage", "okta.apps.manage", "okta.logs.read"))).setPrivateKey(this.configuration.getPrivateKeyPEM());
                } else {
                    builder.setClientCredentials((ClientCredentials)new TokenClientCredentials(this.configuration.getOktaApiToken()));
                }
                ApiClient client = builder.build();
                this.userApi = new UserApi(client);
                this.groupApi = new GroupApi(client);
                this.appApi = new ApplicationApi(client);
                this.systemLogApi = new SystemLogApi(client);
                this.schema = new OktaSchema(new SchemaApi(client));
            }
        }
        catch (Exception ex) {
            OktaUtils.wrapGeneralError("Could not create Okta client", ex);
        }
        LOG.ok("Connector {0} successfully inited", new Object[]{this.getClass().getName()});
    }

    public UserApi getUserApi() {
        return this.userApi;
    }

    public GroupApi getGroupApi() {
        return this.groupApi;
    }

    public ApplicationApi getApplicationApi() {
        return this.appApi;
    }

    public SystemLogApi getSystemLogApi() {
        return this.systemLogApi;
    }

    public void checkAlive() {
        LOG.ok("Check Alive", new Object[0]);
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        LOG.ok("Connector CREATE", new Object[0]);
        if (createAttributes == null || createAttributes.isEmpty()) {
            OktaUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(createAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            User result = null;
            Attribute status = accessor.find(OperationalAttributes.ENABLE_NAME);
            Attribute email = accessor.find("email");
            try {
                UserBuilder userBuilder = UserBuilder.instance();
                if (status == null || CollectionUtil.isEmpty((Collection)status.getValue())) {
                    LOG.warn("{0} attribute value not correct or not found, won't handle User status", new Object[]{OperationalAttributes.ENABLE_NAME});
                } else {
                    userBuilder.setActive(AttributeUtil.getBooleanValue((Attribute)status));
                }
                GuardedString password = accessor.getPassword();
                if (password != null) {
                    String securityAnswer;
                    String passwordValue = SecurityUtil.decrypt((GuardedString)password);
                    String passwordHashAlgorithm = accessor.findString(CIPHER_ALGORITHM);
                    if (StringUtil.isNotBlank((String)passwordHashAlgorithm)) {
                        String salt = accessor.findString(SALT);
                        String saltOrder = accessor.findString(SALT_ORDER);
                        switch (CipherAlgorithm.valueOfLabel(passwordHashAlgorithm)) {
                            case SHA: 
                            case SHA1: 
                            case SSHA: 
                            case SSHA1: {
                                userBuilder.setSha1PasswordHash(passwordValue, salt, saltOrder);
                                break;
                            }
                            case SHA256: 
                            case SSHA256: {
                                userBuilder.setSha256PasswordHash(passwordValue, salt, saltOrder);
                                break;
                            }
                            case SHA512: 
                            case SSHA512: {
                                userBuilder.setSha512PasswordHash(passwordValue, salt, saltOrder);
                                break;
                            }
                            case BCRYPT: {
                                userBuilder.setBcryptPasswordHash(passwordValue, salt, accessor.findInteger(WORK_FACTOR).intValue());
                                break;
                            }
                            default: {
                                OktaUtils.handleGeneralError("Hash Algorithm not supported : " + passwordHashAlgorithm);
                                break;
                            }
                        }
                    } else {
                        userBuilder.setPassword(passwordValue.toCharArray());
                    }
                    String securityQuestion = accessor.findString("oktaSecurityQuestion");
                    if (StringUtil.isNotBlank((String)securityQuestion)) {
                        userBuilder.setSecurityQuestion(securityQuestion);
                    }
                    if (StringUtil.isNotBlank((String)(securityAnswer = accessor.findString("oktaSecurityAnswer")))) {
                        userBuilder.setSecurityQuestionAnswer(securityAnswer);
                    }
                }
                this.buildProfile(userBuilder, accessor, objectClass);
                Optional.ofNullable(accessor.findList("oktaGroups")).map(Collection::stream).orElseGet(Stream::empty).map(Object::toString).forEach(arg_0 -> ((UserBuilder)userBuilder).addGroup(arg_0));
                result = userBuilder.buildAndCreate(this.userApi);
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not create User : " + AttributeUtil.getAsStringValue((Attribute)email), e);
            }
            if (result == null || result.getId() == null) {
                OktaUtils.handleGeneralError("Something wrong happened during user create, check logs");
            }
            return new Uid(result.getId());
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            GroupBuilder groupBuilder = GroupBuilder.instance();
            Group result = null;
            try {
                result = groupBuilder.setName(accessor.findString("name")).setDescription(accessor.findString("description")).buildAndCreate(this.groupApi);
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not create Group : " + accessor.findString("name"), e);
            }
            return new Uid(result.getId());
        }
        LOG.warn("Create of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Create of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public Uid update(ObjectClass objectClass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        LOG.ok("Connector UPDATE", new Object[0]);
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            OktaUtils.handleGeneralError("Set of Attributes value is null or empty");
        }
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            Uid returnUid = uid;
            User user = this.userApi.getUser(uid.getUidValue());
            Optional.ofNullable(accessor.getPassword()).map(SecurityUtil::decrypt).filter(StringUtil::isNotBlank).ifPresent(newPassword -> Optional.ofNullable(accessor.find(OperationalAttributes.CURRENT_PASSWORD_NAME)).map(AttributeUtil::getGuardedStringValue).map(SecurityUtil::decrypt).filter(StringUtil::isNotBlank).ifPresent(oldPassword -> this.selfPasswordUpdate(user.getId(), (String)oldPassword, (String)newPassword)));
            try {
                this.updateUserAttributes(user, replaceAttributes);
                UpdateUserRequest req = new UpdateUserRequest();
                req.setProfile(user.getProfile());
                User update = this.userApi.updateUser(user.getId(), req, Boolean.FALSE);
                this.updateUserStatus(update, accessor.find(OperationalAttributes.ENABLE_NAME));
                returnUid = new Uid(update.getId());
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not update User " + uid.getUidValue() + " from attributes ", e);
            }
            if (accessor.hasAttribute("oktaGroups")) {
                try {
                    List groupsToAssign = CollectionUtil.nullAsEmpty((List)accessor.findList("oktaGroups"));
                    Set assignedGroups = this.userApi.listUserGroups(user.getId()).stream().filter(item -> !OktaAttribute.isDefaultEveryoneGroup(item)).map(Group::getId).collect(Collectors.toSet());
                    groupsToAssign.stream().filter(grp -> !assignedGroups.contains(grp.toString())).forEach(grp -> {
                        try {
                            this.groupApi.assignUserToGroup(grp.toString(), user.getId());
                            LOG.ok("User {0} added to Group {1} after update", new Object[]{uid.getUidValue(), grp});
                        }
                        catch (Exception ex) {
                            OktaUtils.handleGeneralError("Could not add User " + uid.getUidValue() + " to Group " + grp, ex);
                        }
                    });
                    assignedGroups.stream().filter(grp -> !groupsToAssign.contains(grp)).forEach(grp -> {
                        try {
                            this.groupApi.unassignUserFromGroup(grp, user.getId());
                            LOG.ok("User {0} removed from Group {1} after update", new Object[]{uid.getUidValue(), grp});
                        }
                        catch (Exception ex) {
                            OktaUtils.handleGeneralError("Could not remove User " + uid.getUidValue() + " from Group " + grp, ex);
                        }
                    });
                }
                catch (ConnectorException groupsToAssign) {
                }
                catch (Exception ex) {
                    OktaUtils.handleGeneralError("Errors while working with groups for User " + uid.getUidValue(), ex);
                }
            }
            return returnUid;
        }
        if (ObjectClass.GROUP.equals((Object)objectClass)) {
            Group group = this.groupApi.getGroup(uid.getUidValue());
            Optional.ofNullable(accessor.getName()).ifPresent(name -> group.getProfile().setName(name.getNameValue()));
            Optional.ofNullable(accessor.find("description")).ifPresent(desc -> group.getProfile().setDescription(AttributeUtil.getStringValue((Attribute)desc)));
            Group update = null;
            try {
                update = this.groupApi.replaceGroup(group.getId(), group);
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not update Group " + uid.getUidValue() + " from attributes ", e);
            }
            return new Uid(update.getId());
        }
        LOG.warn("Update of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Update of type" + objectClass.getObjectClassValue() + " is not supported");
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        LOG.ok("Connector DELETE", new Object[0]);
        if (StringUtil.isBlank((String)uid.getUidValue())) {
            LOG.error("Uid not provided or empty ", new Object[0]);
            throw new InvalidAttributeValueException("Uid value not provided or empty");
        }
        if (objectClass == null) {
            LOG.error("Object value not provided {0} ", new Object[]{objectClass});
            throw new InvalidAttributeValueException("Object value not provided");
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            try {
                this.userApi.deleteUser(uid.getUidValue(), Boolean.FALSE);
                this.userApi.deleteUser(uid.getUidValue(), Boolean.FALSE);
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not delete User " + uid.getUidValue(), e);
            }
        } else if (APPLICATION.equals((Object)objectClass)) {
            try {
                this.appApi.deactivateApplication(uid.getUidValue());
                this.appApi.deleteApplication(uid.getUidValue());
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not delete Application " + uid.getUidValue(), e);
            }
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            try {
                this.groupApi.deleteGroup(uid.getUidValue());
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("Could not delete Group " + uid.getUidValue(), e);
            }
        } else {
            LOG.warn("Delete of type {0} is not supported", new Object[]{objectClass.getObjectClassValue()});
            throw new UnsupportedOperationException("Delete of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        return this.schema.getSchema();
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        LOG.ok("check the ObjectClass", new Object[0]);
        long maxlastUpdate = 0L;
        try {
            maxlastUpdate = this.getLastLogEvent(objectClass);
            LOG.ok("getLatestSyncToken on {0} - {1}", new Object[]{objectClass, maxlastUpdate});
        }
        catch (Exception e) {
            OktaUtils.handleGeneralError("Error during retrieve SyncToken", e);
        }
        return new SyncToken((Object)maxlastUpdate);
    }

    public void sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        if (handler == null) {
            OktaUtils.handleGeneralError("Result handler is null");
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
            attributesToGet.add("lastUpdated");
        }
        Long tokenValue = null;
        if (token == null || token.getValue() == null) {
            LOG.info("Synchronization with empty token.", new Object[0]);
        } else {
            LOG.info("Synchronization with token.", new Object[0]);
            tokenValue = Long.valueOf(token.getValue().toString());
        }
        LOG.info("Execute sync query {0} on {1}", new Object[]{tokenValue, objectClass});
        List<LogEvent> logEvents = this.getEvents(objectClass, tokenValue == null ? null : OktaUtils.convertToDate(tokenValue));
        if (logEvents != null) {
            logEvents.stream().forEach(item -> {
                ConnectorObject connObj = null;
                try {
                    if (this.isDeleteEvent(item.getEventType())) {
                        connObj = this.fromLogEvent(((LogTarget)item.getTarget().get(0)).getId(), item.getPublished().toInstant().toEpochMilli(), objectClass);
                    } else {
                        try {
                            if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
                                User user = this.userApi.getUser(((LogTarget)item.getTarget().get(0)).getId());
                                connObj = this.fromUser(user, attributesToGet);
                            } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
                                Group group = this.groupApi.getGroup(((LogTarget)item.getTarget().get(0)).getId());
                                connObj = this.fromGroup(group, attributesToGet);
                            } else {
                                Application app = this.appApi.getApplication(((LogTarget)item.getTarget().get(0)).getId(), null);
                                connObj = this.fromApplication(app, attributesToGet);
                            }
                        }
                        catch (Exception ex) {
                            LOG.info("{0} not found", new Object[]{((LogTarget)item.getTarget().get(0)).getId()});
                        }
                    }
                    if (connObj != null && !handler.handle(this.buildSyncDelta(connObj, (LogEvent)item).build())) {
                        LOG.ok("Stop processing of the sync result set", new Object[0]);
                        OktaUtils.handleGeneralError("Stop processing of the sync result set");
                    }
                }
                catch (Exception e) {
                    OktaUtils.handleGeneralError("Sync on " + objectClass + " error", e);
                }
            });
        }
    }

    public void test() {
        if (this.configuration != null && this.schema != null) {
            try {
                this.schema.getSchema();
            }
            catch (Exception ex) {
                OktaUtils.handleGeneralError("Test error. Problems with client service", ex);
            }
            LOG.ok("Test was successfull", new Object[0]);
        } else {
            LOG.error("Test error. No instance of the configuration class", new Object[0]);
        }
    }

    public FilterTranslator<OktaFilter> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        LOG.info("check the ObjectClass", new Object[0]);
        if (oclass == null) {
            throw new IllegalArgumentException("Object class not supported");
        }
        LOG.ok("The ObjectClass is ok", new Object[0]);
        return new OktaFilterTranslator(oclass);
    }

    private <T> void doExecuteQuery(ObjectClass objectClass, OktaFilter filter, Integer pageSize, String beforeCookie, ResultsHandler handler, Function<String, T> getFunction, Function<String, PagedList<T>> pagedSearchFunction, Function<String, List<T>> searchFunction, Function<T, ConnectorObject> fromFunction) {
        if (filter != null && filter.getFilters() == null && "id".equals(filter.getAttribute()) && OktaFilterOp.EQUALS.equals((Object)filter.getFilterOp())) {
            try {
                T object = getFunction.apply(filter.getValue());
                handler.handle(fromFunction.apply(object));
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("While getting " + objectClass.getObjectClassValue() + " with filter: " + filter, e);
            }
        } else {
            String theFilter = Optional.ofNullable(filter).map(OktaFilter::toString).orElse(null);
            String afterCookie = beforeCookie;
            List<T> objects = null;
            try {
                if (pageSize != null) {
                    String nextPage;
                    int startIdx;
                    PagedList<T> response = pagedSearchFunction.apply(theFilter);
                    objects = response;
                    if (response.size() >= pageSize && (startIdx = (nextPage = response.getNextPage()).indexOf("after=")) != -1) {
                        int endIdx = nextPage.indexOf(38, startIdx);
                        afterCookie = endIdx == -1 ? nextPage.substring(startIdx + 6) : nextPage.substring(startIdx + 6, endIdx);
                    }
                } else {
                    objects = searchFunction.apply(theFilter);
                }
            }
            catch (Exception e) {
                OktaUtils.wrapGeneralError("While getting " + objectClass.getObjectClassValue() + " with filter: " + filter, e);
            }
            if (objects != null) {
                for (T object : objects) {
                    if (handler.handle(fromFunction.apply(object))) continue;
                    LOG.ok("Stop processing of the result set", new Object[0]);
                    break;
                }
            }
            if (handler instanceof SearchResultsHandler) {
                ((SearchResultsHandler)handler).handleResult(new SearchResult(afterCookie, -1));
            }
        }
    }

    public void executeQuery(ObjectClass objectClass, OktaFilter filter, ResultsHandler handler, OperationOptions options) {
        LOG.ok("Connector READ", new Object[0]);
        if (filter != null && filter.getAttribute() != null && filter.getValue() == null) {
            return;
        }
        HashSet<String> attributesToGet = new HashSet<String>();
        if (options.getAttributesToGet() != null) {
            attributesToGet.addAll(Arrays.asList(options.getAttributesToGet()));
        }
        if (ObjectClass.ACCOUNT.equals((Object)objectClass)) {
            this.doExecuteQuery(objectClass, filter, options.getPageSize(), options.getPagedResultsCookie(), handler, arg_0 -> ((UserApi)this.userApi).getUser(arg_0), f -> (PagedList)this.userApi.listUsers(null, options.getPagedResultsCookie(), options.getPageSize(), f, null, null, null), f -> this.userApi.listUsers(null, null, null, f, null, null, null), o -> this.fromUser((User)o, (Set<String>)attributesToGet));
        } else if (APPLICATION.equals((Object)objectClass)) {
            this.doExecuteQuery(objectClass, filter, options.getPageSize(), options.getPagedResultsCookie(), handler, id -> this.appApi.getApplication(id, null), f -> (PagedList)this.appApi.listApplications(null, options.getPagedResultsCookie(), options.getPageSize(), f, null, null), f -> this.appApi.listApplications(null, null, null, f, null, null), o -> this.fromApplication((Application)o, (Set<String>)attributesToGet));
        } else if (ObjectClass.GROUP.equals((Object)objectClass)) {
            this.doExecuteQuery(objectClass, filter, options.getPageSize(), options.getPagedResultsCookie(), handler, arg_0 -> ((GroupApi)this.groupApi).getGroup(arg_0), f -> (PagedList)this.groupApi.listGroups(null, f, options.getPagedResultsCookie(), options.getPageSize(), null, null, null, null), f -> this.groupApi.listGroups(null, f, null, null, null, null, null, null), o -> this.fromGroup((Group)o, (Set<String>)attributesToGet));
        } else {
            throw new UnsupportedOperationException("Search of type" + objectClass.getObjectClassValue() + " is not supported");
        }
    }

    private long getLastLogEvent(ObjectClass objectClass) {
        List events;
        String filter = this.buildFilterByObjectClass(objectClass);
        if (StringUtil.isBlank((String)filter)) {
            OktaUtils.handleGeneralError("Provide envenType for Sync");
        }
        return CollectionUtil.isEmpty((Collection)(events = this.systemLogApi.listLogEvents(null, null, filter, null, Integer.valueOf(1), "DESCENDING", null))) ? 0L : ((LogEvent)events.get(0)).getPublished().toInstant().toEpochMilli();
    }

    private List<LogEvent> getEvents(ObjectClass objectClass, OffsetDateTime since) {
        String filter = this.buildFilterByObjectClass(objectClass);
        if (StringUtil.isBlank((String)filter)) {
            LOG.info("Provide envenType for Sync {0}", new Object[]{objectClass});
            return null;
        }
        return this.systemLogApi.listLogEvents(since, null, filter, null, null, "ASCENDING", null);
    }

    private String buildFilterByObjectClass(ObjectClass objectClass) {
        return ObjectClass.ACCOUNT.equals((Object)objectClass) ? this.buildLogEventFilter(this.configuration.getUserEvents()) : (ObjectClass.GROUP.equals((Object)objectClass) ? this.buildLogEventFilter(this.configuration.getGroupEvents()) : (APPLICATION.equals((Object)objectClass) ? this.buildLogEventFilter(this.configuration.getApplicationEvents()) : null));
    }

    private String buildLogEventFilter(String[] eventTypes) {
        boolean isFirst = true;
        StringBuilder builder = new StringBuilder();
        for (String type : eventTypes) {
            if (!isFirst) {
                builder.append(" or ");
            }
            builder.append("eventType eq ");
            builder.append("\"");
            builder.append(type);
            builder.append("\"");
            isFirst = false;
        }
        return builder.toString();
    }

    private ConnectorObject fromLogEvent(String id, long lastUpdate, ObjectClass objectClass) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(objectClass);
        builder.setUid(id);
        builder.setName(id);
        builder.addAttribute(new Attribute[]{OktaAttribute.buildAttribute(lastUpdate, "lastUpdated", Long.class).build()});
        return builder.build();
    }

    private ConnectorObject fromUser(User user, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.ACCOUNT);
        builder.setUid(user.getId());
        builder.setName(user.getProfile().getLogin());
        builder.addAttributes(OktaAttribute.buildUserAttributes(this.userApi, user, this.schema.getSchema(), attributesToGet));
        return builder.build();
    }

    private ConnectorObject fromApplication(Application application, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(APPLICATION);
        builder.setUid(application.getId());
        builder.setName(application.getId());
        builder.addAttributes(OktaAttribute.buildApplicationAttributes(this.appApi, application, this.schema.getSchema(), attributesToGet));
        return builder.build();
    }

    private ConnectorObject fromGroup(Group group, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(ObjectClass.GROUP);
        builder.setUid(group.getId());
        builder.setName(group.getProfile().getName());
        builder.addAttributes(OktaAttribute.buildGroupAttributes(this.groupApi, group, this.schema.getSchema(), attributesToGet));
        return builder.build();
    }

    private SyncDeltaBuilder buildSyncDelta(ConnectorObject connectorObject, LogEvent event) {
        long published;
        LOG.info("Build SyncDelta", new Object[0]);
        SyncDeltaBuilder bld = new SyncDeltaBuilder();
        if (this.isMembershipOperationEvent(event.getEventType())) {
            published = event.getPublished().toInstant().toEpochMilli();
        } else {
            Attribute lastUpdate = connectorObject.getAttributeByName("lastUpdated");
            published = Long.parseLong(AttributeUtil.getSingleValue((Attribute)lastUpdate).toString());
        }
        bld.setToken(new SyncToken((Object)published));
        bld.setObject(connectorObject);
        bld.setDeltaType(this.getSyncDeltaTypeByEvent(event.getEventType()));
        LOG.ok("SyncDeltaBuilder is ok", new Object[0]);
        return bld;
    }

    private SyncDeltaType getSyncDeltaTypeByEvent(String event) {
        OktaEventType oktaEventType = OktaEventType.getValueByName(event);
        if (oktaEventType == null) {
            LOG.error("Okta event not found: {0}", new Object[]{event});
            OktaUtils.handleGeneralError("Okta event not defined");
        }
        return OktaEventType.getValueByName(event).getSyncDeltaType();
    }

    private boolean isDeleteEvent(String eventType) {
        return OktaEventType.getDeleteEventType().contains(eventType);
    }

    private boolean isMembershipOperationEvent(String eventType) {
        return OktaEventType.getMembershipOperationEventType().contains(eventType);
    }

    private void buildProfile(UserBuilder userBuilder, AttributesAccessor accessor, ObjectClass objectClass) {
        ObjectClassInfo objectClassInfo = this.schema.getSchema().findObjectClassInfo(objectClass.getObjectClassValue());
        accessor.listAttributeNames().stream().filter(attrName -> !NOT_FOR_PROFILE.contains(attrName)).forEach(attrName -> objectClassInfo.getAttributeInfo().stream().filter(attr -> attr.getName().equals(attrName)).findFirst().ifPresent(attributeInfo -> {
            if (OktaAttribute.BASIC_PROFILE_ATTRIBUTES.contains(attributeInfo.getName())) {
                switch (attributeInfo.getName()) {
                    case "firstName": {
                        userBuilder.setFirstName(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "lastName": {
                        userBuilder.setLastName(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "email": {
                        userBuilder.setEmail(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "login": {
                        userBuilder.setLogin(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "mobilePhone": {
                        userBuilder.setMobilePhone(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                    case "secondEmail": {
                        userBuilder.setSecondEmail(AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
                        break;
                    }
                }
            } else if (Boolean.class.isInstance(attributeInfo.getType())) {
                userBuilder.setCustomProfileProperty(attrName, (Object)AttributeUtil.getBooleanValue((Attribute)accessor.find(attrName)));
            } else if (Integer.class.isInstance(attributeInfo.getType())) {
                userBuilder.setCustomProfileProperty(attrName, (Object)AttributeUtil.getIntegerValue((Attribute)accessor.find(attrName)));
            } else if (Long.class.isInstance(attributeInfo.getType())) {
                userBuilder.setCustomProfileProperty(attrName, (Object)AttributeUtil.getLongValue((Attribute)accessor.find(attrName)));
            } else if (Float.class.isInstance(attributeInfo.getType())) {
                userBuilder.setCustomProfileProperty(attrName, (Object)AttributeUtil.getFloatValue((Attribute)accessor.find(attrName)));
            } else if (Double.class.isInstance(attributeInfo.getType())) {
                userBuilder.setCustomProfileProperty(attrName, (Object)AttributeUtil.getDoubleValue((Attribute)accessor.find(attrName)));
            } else if (Date.class.isInstance(attributeInfo.getType())) {
                userBuilder.setCustomProfileProperty(attrName, (Object)AttributeUtil.getDateValue((Attribute)accessor.find(attrName)));
            } else if (Byte[].class.isInstance(attributeInfo.getType())) {
                userBuilder.setCustomProfileProperty(attrName, (Object)AttributeUtil.getByteArrayValue((Attribute)accessor.find(attrName)));
            } else if (String.class.isInstance(attributeInfo.getType())) {
                userBuilder.setCustomProfileProperty(attrName, (Object)AttributeUtil.getStringValue((Attribute)accessor.find(attrName)));
            } else {
                userBuilder.setCustomProfileProperty(attrName, AttributeUtil.getSingleValue((Attribute)accessor.find(attrName)));
            }
        }));
    }

    private void updateUserAttributes(User user, Set<Attribute> replaceAttributes) {
        ObjectClassInfo objectClassInfo = this.schema.getSchema().findObjectClassInfo(ObjectClass.ACCOUNT_NAME);
        replaceAttributes.stream().filter(attribute -> !NOT_FOR_PROFILE.contains(attribute.getName())).forEach(attr -> objectClassInfo.getAttributeInfo().stream().filter(attrInfo -> attrInfo.getName().equals(attr.getName())).findFirst().ifPresent(attrInfo -> {
            if (OktaAttribute.BASIC_PROFILE_ATTRIBUTES.contains(attr.getName())) {
                String value = CollectionUtil.isEmpty((Collection)attr.getValue()) ? null : AttributeUtil.getStringValue((Attribute)attr);
                switch (attrInfo.getName()) {
                    case "firstName": {
                        user.getProfile().setFirstName(value);
                        break;
                    }
                    case "lastName": {
                        user.getProfile().setLastName(value);
                        break;
                    }
                    case "email": {
                        user.getProfile().setEmail(value);
                        break;
                    }
                    case "login": {
                        user.getProfile().setLogin(value);
                        break;
                    }
                    case "mobilePhone": {
                        user.getProfile().setMobilePhone(value);
                        break;
                    }
                    case "secondEmail": {
                        user.getProfile().setSecondEmail(value);
                        break;
                    }
                }
            } else {
                user.getProfile().getAdditionalProperties().put(attr.getName(), CollectionUtil.isEmpty((Collection)attr.getValue()) ? null : AttributeUtil.getSingleValue((Attribute)attr));
            }
        }));
    }

    private void updateUserStatus(User user, Attribute status) {
        if (status == null || CollectionUtil.isEmpty((Collection)status.getValue())) {
            LOG.warn("{0} attribute value not correct, can't handle User status update", new Object[]{OperationalAttributes.ENABLE_NAME});
        } else {
            boolean enabled = (Boolean)status.getValue().get(0);
            if (user.getStatus() == UserStatus.ACTIVE && !enabled) {
                this.userApi.suspendUser(user.getId());
            } else if (user.getStatus() == UserStatus.SUSPENDED && enabled) {
                this.userApi.unsuspendUser(user.getId());
            } else if (user.getStatus() == UserStatus.STAGED) {
                if (enabled) {
                    this.userApi.activateUser(user.getId(), Boolean.FALSE);
                } else {
                    LOG.ok("not suspending user {0} as in STAGED status", new Object[]{user.getId()});
                }
            } else if (user.getStatus() != UserStatus.DEPROVISIONED && !enabled) {
                this.userApi.deactivateUser(user.getId(), Boolean.FALSE);
            }
        }
    }

    private void selfPasswordUpdate(String userId, String oldPassword, String newPassword) {
        try {
            PasswordCredential oldPwd = new PasswordCredential();
            oldPwd.setValue(oldPassword);
            PasswordCredential newPwd = new PasswordCredential();
            newPwd.setValue(newPassword);
            ChangePasswordRequest req = new ChangePasswordRequest();
            req.setOldPassword(oldPwd);
            req.setNewPassword(newPwd);
            this.userApi.changePassword(userId, req, Boolean.FALSE);
            LOG.ok("Self change passsword user {0}" + userId, new Object[0]);
        }
        catch (ApiException e) {
            LOG.error((Throwable)e, e.getMessage(), new Object[0]);
            if (e.getCause() == null) {
                OktaUtils.handleGeneralError(e.getMessage(), e);
            } else {
                OktaUtils.handleGeneralError(e.getCause().getMessage(), e.getCause());
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, e.getMessage(), new Object[0]);
            OktaUtils.handleGeneralError(e.getMessage(), e);
        }
    }

    public void dispose() {
    }
}

