/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.pac4j.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.apache.syncope.common.lib.to.SAML2SPEntityTO;
import org.apache.syncope.common.rest.api.service.SAML2SPEntityService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.metadata.keystore.BaseSAML2KeystoreGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASAML2ClientKeystoreGenerator
extends BaseSAML2KeystoreGenerator {
    protected static final Logger LOG = LoggerFactory.getLogger(WASAML2ClientKeystoreGenerator.class);
    protected final WARestClient waRestClient;
    protected final SAML2Client saml2Client;

    public WASAML2ClientKeystoreGenerator(WARestClient waRestClient, SAML2Client saml2Client) {
        super(saml2Client.getConfiguration());
        this.waRestClient = waRestClient;
        this.saml2Client = saml2Client;
    }

    public boolean shouldGenerate() {
        return true;
    }

    protected void store(KeyStore ks, X509Certificate certificate, PrivateKey privateKey) throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            SAML2SPEntityTO entityTO;
            char[] password = this.saml2Configuration.getKeystorePassword().toCharArray();
            ks.store(out, password);
            out.flush();
            String encodedKeystore = Base64.getEncoder().encodeToString(out.toByteArray());
            LOG.debug("Encoded keystore {}", (Object)encodedKeystore);
            try {
                entityTO = ((SAML2SPEntityService)this.waRestClient.getService(SAML2SPEntityService.class)).get(this.saml2Client.getName());
                entityTO.setKeystore(encodedKeystore);
            }
            catch (Exception e) {
                LOG.debug("SP Entity {} not found, creating new", (Object)this.saml2Client.getName(), (Object)e);
                entityTO = (SAML2SPEntityTO)((SAML2SPEntityTO.Builder)new SAML2SPEntityTO.Builder().key(this.saml2Client.getName())).keystore(encodedKeystore).build();
            }
            LOG.debug("Storing SP Entity {}", (Object)entityTO);
            ((SAML2SPEntityService)this.waRestClient.getService(SAML2SPEntityService.class)).set(entityTO);
        }
    }

    public InputStream retrieve() throws Exception {
        try {
            SAML2SPEntityTO spEntity = ((SAML2SPEntityService)this.waRestClient.getService(SAML2SPEntityService.class)).get(this.saml2Client.getName());
            LOG.debug("Retrieved keystore {}", (Object)spEntity.getKeystore());
            return new ByteArrayInputStream(Base64.getDecoder().decode(spEntity.getKeystore()));
        }
        catch (Exception e) {
            String message = "Unable to fetch SAML2 SP keystore for " + this.saml2Client.getName();
            LOG.error(message, (Throwable)e);
            throw new Exception(message);
        }
    }
}

