/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.licensing.Licensing;
import com.google.api.services.licensing.model.LicenseAssignment;
import com.google.api.services.licensing.model.LicenseAssignmentInsert;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.Uid;

public final class LicenseAssignmentsHandler {
    private static final Log LOG = Log.getLog(LicenseAssignmentsHandler.class);
    public static final Pattern LICENSE_NAME_PATTERN = Pattern.compile("(?i)(Google-Coordinate|Google-Drive-storage|Google-Vault|Google-Apps)\\/sku\\/(Google-Coordinate|Google-Drive-storage-20GB|Google-Drive-storage-50GB|Google-Drive-storage-200GB|Google-Drive-storage-400GB|Google-Drive-storage-1TB|Google-Drive-storage-2TB|Google-Drive-storage-4TB|Google-Drive-storage-8TB|Google-Drive-storage-16TB|Google-Vault|Google-Vault-Former-Employee|Google-Apps-For-Business|Google-Apps-Unlimited|Google-Apps-Lite|Google-Apps-For-Postini)\\/user\\/(.+)");

    public static ObjectClassInfo getLicenseAssignmentClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(GoogleAppsUtil.LICENSE_ASSIGNMENT.getObjectClassValue());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"productId").setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"skuId").setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"userId").setRequired(true).build());
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"selfLink").setCreateable(false).setUpdateable(false).build());
        return builder.build();
    }

    public static Licensing.LicenseAssignments.Insert createLicenseAssignment(Licensing.LicenseAssignments service, AttributesAccessor attributes) {
        String productId = attributes.findString("productId");
        if (StringUtil.isBlank((String)productId)) {
            throw new InvalidAttributeValueException("Missing required attribute 'productId'. A product's unique identifier. Required when creating a LicenseAssignment.");
        }
        String skuId = attributes.findString("skuId");
        if (StringUtil.isBlank((String)skuId)) {
            throw new InvalidAttributeValueException("Missing required attribute 'skuId'. A product SKU's unique identifier. Required when creating a LicenseAssignment.");
        }
        String userId = attributes.findString("userId");
        if (StringUtil.isBlank((String)userId)) {
            throw new InvalidAttributeValueException("Missing required attribute 'userId'. The user's current primary email address. Required when creating a LicenseAssignment.");
        }
        return LicenseAssignmentsHandler.createLicenseAssignment(service, productId, skuId, userId);
    }

    public static Licensing.LicenseAssignments.Insert createLicenseAssignment(Licensing.LicenseAssignments service, String productId, String skuId, String userId) {
        try {
            LicenseAssignmentInsert resource = new LicenseAssignmentInsert();
            resource.setUserId(userId);
            return service.insert(productId, skuId, resource).setFields("productId,skuId,userId");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize LicenseAssignments#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Licensing.LicenseAssignments.Patch updateLicenseAssignment(Licensing.LicenseAssignments service, String groupKey, AttributesAccessor attributes) {
        LicenseAssignment content = null;
        Matcher name = LICENSE_NAME_PATTERN.matcher(groupKey);
        if (!name.matches()) {
            throw new UnknownUidException("Unrecognised id");
        }
        String productId = name.group(0);
        String oldSkuId = name.group(1);
        String userId = name.group(2);
        Attribute skuId = attributes.find("skuId");
        if (null != skuId) {
            content = new LicenseAssignment();
            content.setSkuId(AttributeUtil.getStringValue((Attribute)skuId));
        }
        if (null == content) {
            return null;
        }
        try {
            if (oldSkuId.equalsIgnoreCase(content.getSkuId())) {
                return null;
            }
            return service.patch(productId, oldSkuId, userId, content);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize LicenseAssignments#Patch", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Licensing.LicenseAssignments.Delete deleteLicenseAssignment(Licensing.LicenseAssignments service, String groupKey) {
        Matcher name = LICENSE_NAME_PATTERN.matcher(groupKey);
        if (!name.matches()) {
            throw new UnknownUidException("Unrecognised id");
        }
        String productId = name.group(1);
        String skuId = name.group(2);
        String userId = name.group(3);
        try {
            return service.delete(productId, skuId, userId);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize LicenseAssignments#Delete", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static ConnectorObject fromLicenseAssignment(LicenseAssignment content) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(GoogleAppsUtil.LICENSE_ASSIGNMENT);
        Uid uid = LicenseAssignmentsHandler.generateLicenseAssignmentId(content);
        builder.setUid(uid);
        builder.setName(uid.getUidValue());
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"selfLink", (Object[])new Object[]{content.getSelfLink()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"userId", (Object[])new Object[]{content.getUserId()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"productId", (Object[])new Object[]{content.getProductId()})});
        builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"skuId", (Object[])new Object[]{content.getSkuId()})});
        return builder.build();
    }

    public static Uid generateLicenseAssignmentId(LicenseAssignment content) {
        String id = content.getProductId() + "/sku/" + content.getSkuId() + "/user/" + content.getUserId();
        if (null != content.getEtags()) {
            return new Uid(id, content.getEtags());
        }
        return new Uid(id);
    }

    private LicenseAssignmentsHandler() {
    }
}

