/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.io.Serializable;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.rest.UserRequestRestClient;
import org.apache.syncope.client.ui.commons.panels.NotificationPanel;
import org.apache.syncope.client.ui.commons.panels.SyncopeFormPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRequestDetails
extends Panel {
    private static final long serialVersionUID = -2447602429647965090L;
    protected static final Logger LOG = LoggerFactory.getLogger(UserRequestDetails.class);
    protected static final String USER_REQUEST_ERROR = "user_request_error";
    @SpringBean
    protected UserRequestRestClient userRequestRestClient;

    public UserRequestDetails(String id, final UserRequest userRequest, final WebMarkupContainer container, final NotificationPanel notificationPanel) {
        super(id);
        UserRequestForm formTO;
        UserRequestForm userRequestForm = formTO = userRequest.getHasForm() ? (UserRequestForm)this.userRequestRestClient.getForm(SyncopeEnduserSession.get().getSelfTO().getUsername(), userRequest.getTaskId()).orElse(null) : null;
        if (formTO == null || formTO.getProperties() == null || formTO.getProperties().isEmpty()) {
            this.add(new Component[]{new Fragment("fragContainer", "formDetails", (MarkupContainer)this).add(new Component[]{new Label("executionId", (Serializable)((Object)userRequest.getExecutionId()))}).add(new Component[]{new Label("startTime", (Serializable)userRequest.getStartTime())})});
        } else {
            Form form = new Form("userRequestWrapForm");
            form.add(new Component[]{new SyncopeFormPanel("userRequestFormPanel", (SyncopeForm)formTO)});
            form.add(new Component[]{new AjaxButton("submit"){
                private static final long serialVersionUID = 4284361595033427185L;

                protected void onSubmit(AjaxRequestTarget target) {
                    try {
                        UserRequestDetails.this.userRequestRestClient.claimForm(formTO.getTaskId());
                        ProvisioningResult<UserTO> result = UserRequestDetails.this.userRequestRestClient.submitForm(formTO);
                        if (result.getPropagationStatuses().stream().anyMatch(p -> ExecStatus.FAILURE == p.getStatus() || ExecStatus.NOT_ATTEMPTED == p.getStatus())) {
                            SyncopeEnduserSession.get().error((Serializable)((Object)this.getString(UserRequestDetails.USER_REQUEST_ERROR)));
                            notificationPanel.refresh((IPartialPageRequestHandler)target);
                        }
                        target.add(new Component[]{container});
                    }
                    catch (SyncopeClientException sce) {
                        LOG.error("Unable to submit user request form for BPMN process [{}]", (Object)formTO.getBpmnProcess(), (Object)sce);
                        SyncopeEnduserSession.get().error((Serializable)((Object)this.getString(UserRequestDetails.USER_REQUEST_ERROR)));
                        notificationPanel.refresh((IPartialPageRequestHandler)target);
                    }
                }
            }.setOutputMarkupId(true)});
            this.add(new Component[]{new Fragment("fragContainer", "formProperties", (MarkupContainer)this).add(new Component[]{form})});
        }
        this.add(new Component[]{new AjaxLink<Void>("delete"){
            private static final long serialVersionUID = 3669569969172391336L;

            public void onClick(AjaxRequestTarget target) {
                UserRequestDetails.this.userRequestRestClient.cancelRequest(userRequest.getExecutionId(), null);
                target.add(new Component[]{container});
            }
        }});
    }
}

