/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.common.rest.api.beans.UserRequestQuery;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.syncope.core.logic.UserRequestLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.stereotype.Service;

@Service
public class UserRequestServiceImpl
extends AbstractService
implements UserRequestService {
    protected final UserRequestLogic logic;
    protected final UserDAO userDAO;

    public UserRequestServiceImpl(UserRequestLogic logic, UserDAO userDAO) {
        this.logic = logic;
        this.userDAO = userDAO;
    }

    public PagedResult<UserRequest> listRequests(UserRequestQuery query) {
        if (query.getUser() != null) {
            query.setUser(Optional.ofNullable(this.findActualKey((AnyDAO)this.userDAO, query.getUser())).orElse(query.getUser()));
        }
        Pair result = this.logic.listRequests(query.getUser(), query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public UserRequest startRequest(String bpmnProcess, String user, WorkflowTaskExecInput inputVariables) {
        return user == null ? this.logic.startRequest(bpmnProcess, inputVariables) : this.logic.startRequest(bpmnProcess, this.findActualKey((AnyDAO)this.userDAO, user), inputVariables);
    }

    public void cancelRequest(String executionId, String reason) {
        this.logic.cancelRequest(executionId, reason);
    }

    public UserRequestForm claimForm(String taskId) {
        return this.logic.claimForm(taskId);
    }

    public UserRequestForm unclaimForm(String taskId) {
        return this.logic.unclaimForm(taskId);
    }

    public UserRequestForm getForm(String username, String taskId) {
        return this.logic.getForm(this.findActualKey((AnyDAO)this.userDAO, username), taskId);
    }

    public PagedResult<UserRequestForm> listForms(UserRequestQuery query) {
        if (query.getUser() != null) {
            query.setUser(Optional.ofNullable(this.findActualKey((AnyDAO)this.userDAO, query.getUser())).orElse(query.getUser()));
        }
        Pair result = this.logic.listForms(query.getUser(), query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public Response submitForm(UserRequestForm form) {
        ProvisioningResult submitted = this.logic.submitForm(form, this.isNullPriorityAsync());
        return this.modificationResponse(submitted);
    }
}

