/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wizards.any.AnyWizardBuilder;
import org.apache.syncope.client.console.wizards.any.Details;
import org.apache.syncope.client.console.wizards.any.UserDetails;
import org.apache.syncope.client.console.wizards.any.UserFormFinalizer;
import org.apache.syncope.client.ui.commons.layout.UserForm;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.PageReference;

public class UserWizardBuilder
extends AnyWizardBuilder<UserTO>
implements UserForm {
    private static final long serialVersionUID = 6716803168859873877L;
    protected final UserRestClient userRestClient;

    public UserWizardBuilder(List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, UserRestClient userRestClient, PageReference pageRef) {
        super(new UserWrapper(null), anyTypeClasses, formLayoutInfo, pageRef);
        this.userRestClient = userRestClient;
    }

    public UserWizardBuilder(UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, UserRestClient userRestClient, PageReference pageRef) {
        super(new UserWrapper(previousUserTO, userTO), anyTypeClasses, formLayoutInfo, pageRef);
        this.userRestClient = userRestClient;
    }

    protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
        ProvisioningResult<UserTO> result;
        UserTO inner = (UserTO)modelObject.getInnerObject();
        if (inner.getKey() == null) {
            UserCR req = new UserCR();
            EntityTOUtils.toAnyCR((AnyTO)inner, (AnyCR)req);
            req.setStorePassword(modelObject instanceof UserWrapper ? ((UserWrapper)UserWrapper.class.cast(modelObject)).isStorePasswordInSyncope() : StringUtils.isNotBlank((CharSequence)inner.getPassword()));
            result = this.userRestClient.create(req);
        } else {
            this.fixPlainAndVirAttrs((AnyTO)inner, ((AnyWrapper)this.getOriginalItem()).getInnerObject());
            UserUR userUR = AnyOperations.diff((UserTO)inner, (UserTO)((UserTO)((AnyWrapper)this.getOriginalItem()).getInnerObject()), (boolean)false);
            if (StringUtils.isNotBlank((CharSequence)inner.getPassword())) {
                PasswordPatch passwordPatch = (PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)inner.getPassword())).onSyncope(true).resources((Collection)inner.getResources()).build();
                userUR.setPassword(passwordPatch);
            }
            if (userUR.isEmpty()) {
                result = new ProvisioningResult<UserTO>();
                result.setEntity((EntityTO)inner);
            } else {
                List<UserFormFinalizer> finalizers = SyncopeWebApplication.get().getFormFinalizers(this.mode);
                finalizers.forEach(finalizer -> finalizer.beforeUpdate(userUR.getKey()));
                result = this.userRestClient.update(((UserTO)((AnyWrapper)this.getOriginalItem()).getInnerObject()).getETagValue(), userUR);
                finalizers.forEach(finalizer -> finalizer.afterUpdate(userUR.getKey()));
            }
        }
        return result;
    }

    @Override
    protected Optional<Details<UserTO>> addOptionalDetailsPanel(AnyWrapper<UserTO> modelObject) {
        return Optional.of(new UserDetails((UserWrapper)UserWrapper.class.cast(modelObject), this.mode == AjaxWizard.Mode.TEMPLATE, ((UserTO)modelObject.getInnerObject()).getKey() != null, ((UserFormLayoutInfo)((Object)UserFormLayoutInfo.class.cast(this.formLayoutInfo))).isPasswordManagement(), this.pageRef));
    }

    public UserWizardBuilder setItem(AnyWrapper<UserTO> item) {
        super.setItem((Serializable)((AnyWrapper)Optional.ofNullable(item).map(userTOAnyWrapper -> new UserWrapper((UserTO)userTOAnyWrapper.getInnerObject())).orElse(null)));
        return this;
    }
}

