/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxGridFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.form.FormPropertyType;
import org.apache.syncope.common.lib.to.FormPropertyDefTO;
import org.apache.syncope.common.lib.to.MacroTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class FormPropertyDefsPanel
extends AbstractModalPanel<MacroTaskTO> {
    private static final long serialVersionUID = 6991001927367507753L;
    @SpringBean
    protected TaskRestClient taskRestClient;
    protected final MacroTaskTO task;
    protected final IModel<List<FormPropertyDefTO>> model;

    public FormPropertyDefsPanel(MacroTaskTO task, BaseModal<MacroTaskTO> modal, PageReference pageRef) {
        super(modal, pageRef);
        this.task = task;
        final WebMarkupContainer propertyDefContainer = new WebMarkupContainer("propertyDefContainer");
        this.add(new Component[]{propertyDefContainer.setOutputMarkupId(true)});
        this.model = new ListModel(new ArrayList());
        ((List)this.model.getObject()).addAll(task.getFormPropertyDefs());
        ListView<FormPropertyDefTO> propertyDefs = new ListView<FormPropertyDefTO>("propertyDefs", this.model){
            private static final long serialVersionUID = 1814616131938968887L;

            protected void populateItem(final ListItem<FormPropertyDefTO> item) {
                final FormPropertyDefTO fpd = (FormPropertyDefTO)item.getModelObject();
                AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)fpd, "key"), true);
                item.add(new Component[]{key.setRequired(true).hideLabel()});
                AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)fpd, "name"), true);
                item.add(new Component[]{name.setRequired(true).hideLabel()});
                AjaxCheckBoxPanel readable = new AjaxCheckBoxPanel("readable", "readable", (IModel)new PropertyModel((Object)fpd, "readable"), true);
                item.add(new Component[]{readable.hideLabel()});
                AjaxCheckBoxPanel writable = new AjaxCheckBoxPanel("writable", "writable", (IModel)new PropertyModel((Object)fpd, "writable"), true);
                item.add(new Component[]{writable.hideLabel()});
                AjaxCheckBoxPanel required = new AjaxCheckBoxPanel("required", "required", (IModel)new PropertyModel((Object)fpd, "required"), true);
                item.add(new Component[]{required.hideLabel()});
                final AjaxDropDownChoicePanel type = new AjaxDropDownChoicePanel("type", "type", (IModel)new PropertyModel((Object)fpd, "type"), true);
                type.setChoices(List.of(FormPropertyType.values())).setNullValid(false);
                item.add(new Component[]{type.setRequired(true).hideLabel()});
                final AjaxTextFieldPanel stringRegEx = new AjaxTextFieldPanel("stringRegEx", "stringRegEx", (IModel)new IModel<String>(){
                    private static final long serialVersionUID = 1015030402166681242L;

                    public String getObject() {
                        return Optional.ofNullable(fpd.getStringRegEx()).map(Pattern::pattern).orElse(null);
                    }

                    public void setObject(String object) {
                        fpd.setStringRegEx((Pattern)Optional.ofNullable(object).map(Pattern::compile).orElse(null));
                    }
                }, true);
                stringRegEx.getField().add((IValidator)new IValidator<String>(){
                    private static final long serialVersionUID = 3978328825079032964L;

                    public void validate(IValidatable<String> validatable) {
                        try {
                            Pattern.compile((String)validatable.getValue());
                        }
                        catch (PatternSyntaxException e) {
                            validatable.error((IValidationError)new ValidationError(fpd.getKey() + ": invalid RegEx"));
                        }
                    }
                });
                stringRegEx.setVisible(fpd.getType() == FormPropertyType.String);
                item.add(new Component[]{stringRegEx.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
                final AjaxTextFieldPanel datePattern = new AjaxTextFieldPanel("datePattern", "datePattern", (IModel)new PropertyModel((Object)fpd, "datePattern"), true);
                datePattern.setVisible(fpd.getType() == FormPropertyType.Date);
                item.add(new Component[]{datePattern.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
                final AjaxGridFieldPanel enumValues = new AjaxGridFieldPanel("enumValues", "enumValues", (IModel)new PropertyModel((Object)fpd, "enumValues"));
                enumValues.setVisible(fpd.getType() == FormPropertyType.Enum);
                item.add(new Component[]{enumValues.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
                final WebMarkupContainer dropdownConf = new WebMarkupContainer("dropdownConf");
                dropdownConf.setVisible(fpd.getType() == FormPropertyType.Dropdown);
                item.add(new Component[]{dropdownConf.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
                AjaxCheckBoxPanel dropdownSingleSelection = new AjaxCheckBoxPanel("dropdownSingleSelection", "dropdownSingleSelection", (IModel)new PropertyModel((Object)fpd, "dropdownSingleSelection"), true);
                dropdownConf.add(new Component[]{dropdownSingleSelection.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
                AjaxCheckBoxPanel dropdownFreeForm = new AjaxCheckBoxPanel("dropdownFreeForm", "dropdownFreeForm", (IModel)new PropertyModel((Object)fpd, "dropdownFreeForm"), true);
                dropdownConf.add(new Component[]{dropdownFreeForm.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
                type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        switch ((FormPropertyType)type.getModelObject()) {
                            case String: {
                                stringRegEx.setVisible(true);
                                datePattern.setVisible(false);
                                enumValues.setVisible(false);
                                fpd.getEnumValues().clear();
                                dropdownConf.setVisible(false);
                                break;
                            }
                            case Date: {
                                stringRegEx.setVisible(false);
                                fpd.setStringRegEx(null);
                                datePattern.setVisible(true);
                                enumValues.setVisible(false);
                                fpd.getEnumValues().clear();
                                dropdownConf.setVisible(false);
                                break;
                            }
                            case Enum: {
                                stringRegEx.setVisible(false);
                                fpd.setStringRegEx(null);
                                datePattern.setVisible(false);
                                enumValues.setVisible(true);
                                dropdownConf.setVisible(false);
                                break;
                            }
                            case Dropdown: {
                                stringRegEx.setVisible(false);
                                fpd.setStringRegEx(null);
                                datePattern.setVisible(false);
                                enumValues.setVisible(false);
                                fpd.getEnumValues().clear();
                                dropdownConf.setVisible(true);
                                break;
                            }
                            default: {
                                stringRegEx.setVisible(false);
                                fpd.setStringRegEx(null);
                                datePattern.setVisible(false);
                                enumValues.setVisible(false);
                                fpd.getEnumValues().clear();
                                dropdownConf.setVisible(false);
                            }
                        }
                        target.add(new Component[]{stringRegEx});
                        target.add(new Component[]{datePattern});
                        target.add(new Component[]{enumValues});
                        target.add(new Component[]{dropdownConf});
                    }
                }});
                ActionsPanel<Serializable> actions = new ActionsPanel<Serializable>("actions", null);
                item.add(new Component[]{actions});
                actions.add(new ActionLink<Serializable>(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target, Serializable ignore) {
                        ((List)FormPropertyDefsPanel.this.model.getObject()).remove(item.getIndex());
                        item.getParent().removeAll();
                        target.add(new Component[]{propertyDefContainer});
                    }
                }, ActionLink.ActionType.DELETE, "", true).hideLabel();
                if (((List)FormPropertyDefsPanel.this.model.getObject()).size() > 1) {
                    if (item.getIndex() > 0) {
                        actions.add(new ActionLink<Serializable>(){
                            private static final long serialVersionUID = 2041211756396714619L;

                            @Override
                            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                                FormPropertyDefTO pre = (FormPropertyDefTO)((List)FormPropertyDefsPanel.this.model.getObject()).get(item.getIndex() - 1);
                                ((List)FormPropertyDefsPanel.this.model.getObject()).set(item.getIndex(), pre);
                                ((List)FormPropertyDefsPanel.this.model.getObject()).set(item.getIndex() - 1, fpd);
                                item.getParent().removeAll();
                                target.add(new Component[]{propertyDefContainer});
                            }
                        }, ActionLink.ActionType.UP, "").hideLabel();
                    }
                    if (item.getIndex() < ((List)FormPropertyDefsPanel.this.model.getObject()).size() - 1) {
                        actions.add(new ActionLink<Serializable>(){
                            private static final long serialVersionUID = 2041211756396714619L;

                            @Override
                            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                                FormPropertyDefTO post = (FormPropertyDefTO)((List)FormPropertyDefsPanel.this.model.getObject()).get(item.getIndex() + 1);
                                ((List)FormPropertyDefsPanel.this.model.getObject()).set(item.getIndex(), post);
                                ((List)FormPropertyDefsPanel.this.model.getObject()).set(item.getIndex() + 1, fpd);
                                item.getParent().removeAll();
                                target.add(new Component[]{propertyDefContainer});
                            }
                        }, ActionLink.ActionType.DOWN, "").hideLabel();
                    }
                }
            }
        };
        propertyDefContainer.add(new Component[]{propertyDefs.setReuseItems(true)});
        IndicatingAjaxButton addPropertyDef = new IndicatingAjaxButton("addPropertyDef"){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target) {
                ((List)FormPropertyDefsPanel.this.model.getObject()).add(new FormPropertyDefTO());
                target.add(new Component[]{propertyDefContainer});
            }
        };
        addPropertyDef.setDefaultFormProcessing(false);
        propertyDefContainer.add(new Component[]{addPropertyDef});
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        this.task.getFormPropertyDefs().clear();
        this.task.getFormPropertyDefs().addAll((Collection)this.model.getObject());
        try {
            this.taskRestClient.update(TaskType.MACRO, (SchedTaskTO)this.task);
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While updating Macro Task {}", (Object)this.task.getKey(), (Object)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

